/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.videoHx.nd;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.ErrorDialog;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.remoteVideo.BRemoteVideoSource;
import com.tridium.remoteVideo.nd.BNiagaraCameraExt;
import com.tridium.remoteVideo.nd.BNiagaraCameraPoint;
import com.tridium.smartTableHx.BCommandEnablePolicy;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.videoDriver.camera.BIVideoCamera;
import com.tridium.videoDriver.ui.playback.BLiveVideo;
import com.tridium.videoDriver.ui.playback.BVideoPlayback;
import com.tridium.videoDriver.ux.BWebLiveVideo;
import com.tridium.videoDriver.ux.BWebVideoPlayback;
import com.tridiumx.entsec.BEnterpriseSecurityService;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsec.securityUtil.query.QueryUtil;
import com.tridiumx.entsec.securityUtil.query.TypeSpecPath;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractDiscoverView;
import com.tridiumx.entsecHx.securityUtilHx.discover.BHxAbstractManagerView;
import com.tridiumx.entsecHx.securityUtilHx.query.BHxQueryTableView;
import com.tridiumx.videoHx.BLiveVideoViewer;
import com.tridiumx.videoHx.BVideoPlaybackViewer;
import com.tridiumx.videoHx.nd.BCameraLearnEntry;
import com.tridiumx.videoHx.nd.BCameraPointsDiscoveryJob;
import com.tridiumx.videoHx.nd.BHxNiagaraCameraExtDiscoverView;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.control.ext.BNullProxyExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.Event;
import javax.baja.hx.HxOp;
import javax.baja.io.ValueDocEncoder;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.BQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;

@NiagaraType(agent={@AgentOn(types={"remoteVideo:NiagaraCameraExt"}, app="entsec", requiredPermissions="r")})
@NiagaraSingleton
public class BHxNiagaraCameraExtTableView
extends BHxAbstractManagerView {
    @Generated
    public static final BHxNiagaraCameraExtTableView INSTANCE = new BHxNiagaraCameraExtTableView();
    @Generated
    public static final Type TYPE = Sys.loadType(BHxNiagaraCameraExtTableView.class);
    SmartCommand manageCameraDevices = new ManageCameraPointsCommand((BHxView)this);
    SmartCommand liveVideo;
    SmartCommand videoPlayback;
    private static Logger log = Logger.getLogger("videoHx.niagaraDriver");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHxNiagaraCameraExtTableView() {
        this.registerEvent((Event)this.manageCameraDevices);
        this.liveVideo = new LiveVideoCommand((BHxView)this);
        this.registerEvent((Event)this.liveVideo);
        this.videoPlayback = new VideoPlaybackCommand((BHxView)this);
        this.registerEvent((Event)this.videoPlayback);
    }

    public void write(HxOp op) throws Exception {
        BComponent[] cameraPoints = op.getComponent().getChildComponents();
        for (int i = 0; i < cameraPoints.length; ++i) {
            cameraPoints[i].lease();
        }
        super.write(op);
    }

    public SmartCommand[] getButtonCommands(HxOp op) {
        boolean videoDriver = BEnterpriseSecurityService.isVideoDriverAvailable();
        boolean remoteVideo = this.remoteVideoLicensed();
        if (!remoteVideo && !videoDriver) {
            return new SmartCommand[]{this.filterCommand, this.refresh, this.exportCommand};
        }
        if (remoteVideo && !videoDriver) {
            return new SmartCommand[]{this.discover, this.manageCameraDevices, this.filterCommand, this.refresh, this.delete, this.renameCommand, this.exportCommand, this.learnMode};
        }
        if (videoDriver && !remoteVideo) {
            return new SmartCommand[]{this.liveVideo, this.videoPlayback, this.refresh, this.filterCommand, this.exportCommand};
        }
        return new SmartCommand[]{this.discover, this.manageCameraDevices, this.liveVideo, this.videoPlayback, this.filterCommand, this.refresh, this.delete, this.renameCommand, this.exportCommand, this.learnMode};
    }

    private boolean remoteVideoLicensed() {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "remoteVideo");
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean supportsAutoRefresh(HxOp op) {
        return true;
    }

    public BHxAbstractDiscoverView getDiscoverView(HxOp op) {
        return BHxNiagaraCameraExtDiscoverView.INSTANCE;
    }

    public String getPageTitle(HxOp op) {
        return this.getLexicon().get("niagaraCameraManager.title");
    }

    public BTypeSpec getDeviceTypeSpec(HxOp op) {
        return BNiagaraCameraPoint.TYPE.getTypeSpec();
    }

    public BTypeSpec getLearnRowTypeSpec(HxOp op) {
        return BCameraLearnEntry.TYPE.getTypeSpec();
    }

    public BJob submitDiscoveryJob(HxOp op) {
        BNiagaraCameraExt ext = (BNiagaraCameraExt)op.getComponent();
        BNiagaraStation station = (BNiagaraStation)ext.getParent();
        BFoxSession session = RemoteUtil.getFoxSession((BNiagaraStation)station);
        BComponent root = RemoteUtil.getRemoteComponent((BFoxSession)session, (String)"slot:/");
        BQuery query = QueryUtil.makeQuery((BTypeSpec)BTypeSpec.make((Type)BIVideoCamera.TYPE));
        query.add("base", (BValue)root.getAbsoluteOrd());
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)TypeSpecPath.DISPLAY_NAME);
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)TypeSpecPath.PARENT_COMPONENT_SLOT_PATH);
        QueryUtil.addColumn((BQuery)query, (TypeSpecPath)new TypeSpecPath(BTypeSpec.TYPE.getTypeSpec(), "type"));
        query = QueryUtil.getWorkingCopy((BQuery)query, (Context)op);
        BFacets queryFacet = null;
        try {
            queryFacet = BFacets.make((String)"query", (String)ValueDocEncoder.marshal((BValue)query));
            op.mergeFacets(queryFacet);
        }
        catch (IOException e) {
            Logger.getLogger("entsec").log(Level.SEVERE, "Failed to prepare query for remote cameras Discovery", e);
        }
        BOrd ord = new BCameraPointsDiscoveryJob().submit((Context)op);
        return (BJob)ord.get((BObject)op.getComponent());
    }

    private static boolean hasAgent(BComponent component, Type agentType, HxOp op) throws Exception {
        if (!component.getType().is(BNiagaraCameraPoint.TYPE)) {
            return false;
        }
        BNiagaraCameraPoint cameraPoint = (BNiagaraCameraPoint)component;
        AgentList agents = BHxNiagaraCameraExtTableView.getCameraAgents(cameraPoint, op);
        if (agents == null) {
            return false;
        }
        return agents.filter(AgentFilter.is((Type)agentType)).size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AgentList getCameraAgents(BNiagaraCameraPoint cameraPoint, HxOp op) throws Exception {
        Type cameraType = null;
        try {
            BRemoteVideoSource rvs = cameraPoint.getRemoteVideoSource();
            if (rvs == null) {
                return null;
            }
            BNiagaraStation remoteStation = cameraPoint.getNiagaraStation();
            BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)remoteStation);
            String interest = TYPE + BUuid.make().toString();
            try {
                foxSession.engageNoRetry(interest);
                BComponent remoteCamera = RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)rvs.getCameraOrd().toString());
                remoteCamera.lease();
                if (remoteCamera != null) {
                    cameraType = remoteCamera.getType();
                }
            }
            finally {
                foxSession.disengage(interest);
            }
        }
        catch (Exception e) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, INSTANCE.getLexicon().getText("cameraAgents.retrievalError.msg"), e);
            }
            throw new Exception(INSTANCE.getLexicon().getText("cameraAgents.retrievalError.msg"), e);
        }
        if (cameraType == null) {
            return null;
        }
        return cameraType.getInstance().getAgents();
    }

    private class VideoPlaybackCommand
    extends SmartCommand {
        public VideoPlaybackCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "videoPlaybackView";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            BNiagaraCameraPoint selectedCamera = (BNiagaraCameraPoint)BHxQueryTableView.getSubject((HxOp)op);
            BNiagaraStation station = selectedCamera.getNiagaraStation();
            String stationName = station.getStationName();
            if (station.isDown() || station.isDisabled() || station.isFault()) {
                throw new Exception("Unable to load Playback View. The remote station " + stationName + " is " + station.getStatus());
            }
            if (BHxNiagaraCameraExtTableView.hasAgent((BComponent)selectedCamera, BVideoPlayback.TYPE, op) || BHxNiagaraCameraExtTableView.hasAgent((BComponent)selectedCamera, BWebVideoPlayback.TYPE, op)) {
                BOrd ord = null;
                boolean isNiagaraWebLauncher = op.getUserAgent() != null && op.getUserAgent().isNiagaraWebLauncher();
                ord = isNiagaraWebLauncher ? BOrd.make((String)(selectedCamera.getOrdInSession() + "|view:" + BVideoPlaybackViewer.TYPE)) : BOrd.make((String)(selectedCamera.getOrdInSession() + "|view:" + BWebVideoPlayback.TYPE));
                this.redirect(op, op.toUri(ord));
            } else {
                new ErrorDialog("Error", (Command)this, (Throwable)new Exception(selectedCamera.getDisplayName((Context)op) + " does not support " + BVideoPlayback.TYPE.getDisplayName((Context)op))).open(op);
            }
        }
    }

    private class LiveVideoCommand
    extends SmartCommand {
        public LiveVideoCommand(BHxView view) {
            super(view);
        }

        public String getName(HxOp op) {
            return "liveCameraView";
        }

        public BCommandEnablePolicy getEnablePolicy() {
            return BCommandEnablePolicy.singleSelection;
        }

        public void handle(HxOp op) throws Exception {
            BNiagaraCameraPoint selectedCamera = (BNiagaraCameraPoint)BHxQueryTableView.getSubject((HxOp)op);
            BNiagaraStation station = selectedCamera.getNiagaraStation();
            String stationName = station.getStationName();
            if (station.isDown() || station.isDisabled() || station.isFault()) {
                throw new Exception("Unable to load Live View. The remote station " + stationName + " is " + station.getStatus());
            }
            if (BHxNiagaraCameraExtTableView.hasAgent((BComponent)selectedCamera, BLiveVideo.TYPE, op) || BHxNiagaraCameraExtTableView.hasAgent((BComponent)selectedCamera, BWebLiveVideo.TYPE, op)) {
                BOrd ord = null;
                boolean isNiagaraWebLauncher = op.getUserAgent() != null && op.getUserAgent().isNiagaraWebLauncher();
                ord = isNiagaraWebLauncher ? BOrd.make((String)(selectedCamera.getOrdInSession() + "|view:" + BLiveVideoViewer.TYPE)) : BOrd.make((String)(selectedCamera.getOrdInSession() + "|view:" + BWebLiveVideo.TYPE));
                this.redirect(op, op.toUri(ord));
            } else {
                new ErrorDialog("Error", (Command)this, (Throwable)new Exception(selectedCamera.getDisplayName((Context)op) + " does not support " + BLiveVideo.TYPE.getDisplayName((Context)op))).open(op);
            }
        }
    }

    private class ManageCameraPointsCommand
    extends BHxAbstractManagerView.ManageDevicesDiscoveryCommand {
        public ManageCameraPointsCommand(BHxView view) {
            super((BHxAbstractManagerView)BHxNiagaraCameraExtTableView.this, view);
        }

        public void added(BValue added, HxOp op) throws Exception {
            BNiagaraCameraExt camerasExt = (BNiagaraCameraExt)op.getComponent();
            Object[] cameraPoints = camerasExt.getChildren(BNiagaraCameraPoint.class);
            for (int i = 0; i < cameraPoints.length; ++i) {
                BNiagaraCameraPoint cameraPoint = (BNiagaraCameraPoint)cameraPoints[i];
                if (!cameraPoint.getProxyExt().getType().is(BNullProxyExt.TYPE)) continue;
                cameraPoint.setProxyExt((BAbstractProxyExt)new BNiagaraProxyExt());
                cameraPoint.doExecute();
            }
            super.added(added, op);
        }
    }
}

