/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.util;

import com.tridium.util.ClassUtil;
import javax.baja.px.editor.event.PxBindingEvent;
import javax.baja.px.editor.event.PxComponentEvent;
import javax.baja.px.editor.event.PxCompoundBindingEvent;
import javax.baja.px.editor.event.PxCompoundWidgetEvent;
import javax.baja.px.editor.event.PxEvent;
import javax.baja.px.editor.event.PxWidgetEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BWidget;
import javax.baja.util.BConverter;

public abstract class EventUtil {
    public static final int UNKNOWN = 0;
    public static final int WIDGET_ADDED = 1;
    public static final int WIDGET_REMOVED = 2;
    public static final int WIDGET_CHANGED = 3;
    public static final int WIDGET_RENAMED = 4;
    public static final int WIDGET_REPLACED = 5;
    public static final int WIDGET_REORDERED = 6;
    public static final int BINDING_ADDED = 7;
    public static final int BINDING_CHANGED = 8;
    public static final int BINDING_REMOVED = 9;
    public static final int CONVERTER_ADDED = 10;
    public static final int CONVERTER_CHANGED = 11;
    public static final int CONVERTER_REMOVED = 12;
    private static String[] ID_STRINGS = new String[]{"UNKNOWN", "WIDGET_ADDED", "WIDGET_REMOVED", "WIDGET_CHANGED", "WIDGET_RENAMED", "WIDGET_REPLACED", "WIDGET_REORDERED", "BINDING_ADDED", "BINDING_CHANGED", "BINDING_REMOVED", "CONVERTER_ADDED", "CONVERTER_CHANGED", "CONVERTER_REMOVED"};

    public static int getEventType(PxComponentEvent event) {
        int id = event.getEventId();
        if (event instanceof PxWidgetEvent) {
            if (id == 4) {
                return 6;
            }
            if (id == 3) {
                return 4;
            }
            Type valueType = ClassUtil.getCommonSuperType((BObject[])event.getValues());
            if (valueType.is(BBinding.TYPE)) {
                switch (id) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 9;
                    }
                }
            } else if (valueType.is(BWidget.TYPE)) {
                switch (id) {
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 5;
                    }
                }
            } else if (id == 2) {
                return 3;
            }
        } else if (event instanceof PxBindingEvent) {
            Type valueType = ClassUtil.getCommonSuperType((BObject[])event.getValues());
            if (valueType.is(BConverter.TYPE)) {
                switch (id) {
                    case 0: {
                        return 10;
                    }
                    case 2: {
                        return 11;
                    }
                    case 1: {
                        return 12;
                    }
                }
            } else if (id == 2) {
                return 8;
            }
        }
        return 0;
    }

    public static PxEvent widgetsChanged(BWidget[] widgets, String propName) {
        String[] props = new String[widgets.length];
        for (int i = 0; i < widgets.length; ++i) {
            props[i] = propName;
        }
        return EventUtil.widgetsChanged(widgets, props);
    }

    public static PxEvent widgetsChanged(BWidget[] widgets, String[] props) {
        if (widgets.length != props.length) {
            throw new IllegalStateException();
        }
        if (widgets.length == 1) {
            return new PxWidgetEvent(2, widgets[0], props[0], widgets[0].get(props[0]));
        }
        PxWidgetEvent[] events = new PxWidgetEvent[widgets.length];
        for (int i = 0; i < events.length; ++i) {
            events[i] = new PxWidgetEvent(2, widgets[i], props[i], widgets[i].get(props[i]));
        }
        return new PxCompoundWidgetEvent(2, events);
    }

    public static PxEvent bindingsChanged(BBinding[] bindings, String[] props) {
        if (bindings.length != props.length) {
            throw new IllegalStateException();
        }
        if (bindings.length == 1) {
            return new PxBindingEvent(2, bindings[0], props[0], bindings[0].get(props[0]));
        }
        PxBindingEvent[] events = new PxBindingEvent[bindings.length];
        for (int i = 0; i < events.length; ++i) {
            events[i] = new PxBindingEvent(2, bindings[i], props[i], bindings[i].get(props[i]));
        }
        return new PxCompoundBindingEvent(2, events);
    }
}

