/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.BStudio;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.commands.MoveWidget;
import com.tridium.px.editor.studio.trackers.HitSelectedTracker;
import com.tridium.px.editor.studio.trackers.MoveTracker;
import com.tridium.px.editor.studio.trackers.PassThroughTracker;
import com.tridium.px.editor.studio.trackers.RubberBandTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.Reflector;
import com.tridium.px.editor.util.SelectedWidgets;
import javax.baja.gx.Point;
import javax.baja.px.editor.event.PxSelectionEvent;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.pane.BTabbedPane;

public class UnpressedTracker
extends Tracker {
    private SelectedWidgets selected;
    private TrackerStudio studio;
    private static final int MIN_SNAP_SIZE_TO_ALLOW_MIDPOINT_SNAP = 8;

    public UnpressedTracker(BPxEditorPane editorPane) {
        this(editorPane, editorPane.getTrackerStudio());
    }

    public UnpressedTracker(BPxEditorPane editorPane, TrackerStudio studio) {
        super(editorPane);
        this.studio = studio;
        this.selected = editorPane.getSelectedWidgets();
        studio.setMouseCursor(MouseCursor.normal);
    }

    @Override
    public Tracker mouseMoved(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        Handle handle = this.editorPane.getSelectedWidgets().getHandle(x, y);
        if (handle == null) {
            BWidget widget = this.studio.rootDescendant(new Point(x, y));
            if (widget != null && widget instanceof BSplitPane) {
                Point p = this.studio.translateFromRoot(widget, new Point(x, y));
                MouseCursor c = (MouseCursor)widget.fw(304, (Object)p, null, null, null);
                this.studio.setMouseCursor(c == null ? MouseCursor.normal : c);
            } else {
                this.studio.setMouseCursor(MouseCursor.normal);
            }
        } else if (this.editorPane.getLayerManager().isNormal(handle.widget)) {
            this.studio.setMouseCursor(handle.cursor);
        }
        return this;
    }

    @Override
    public Tracker mousePressed(BMouseEvent event) {
        double x = event.getX();
        double y = event.getY();
        UnpressedTracker.setAnchorX(x);
        UnpressedTracker.setAnchorY(y);
        switch (event.getClickCount()) {
            case 1: {
                if (event.isButton1Down()) {
                    return this.handleLeftClick(event);
                }
                if (!event.isButton3Down()) break;
                return this.handleRightClick(event);
            }
            case 2: {
                if (!event.isButton1Down()) break;
                return this.handleDoubleClick(event);
            }
        }
        return this;
    }

    @Override
    public Tracker keyPressed(BKeyEvent event) {
        BWidget[] widgets = this.selected.getWidgets();
        if (!this.editorPane.getLayerManager().allNormal(widgets)) {
            return this;
        }
        this.studio.setShiftDown(event.isShiftDown());
        if (this.studio.getCurrentCanvas() == null) {
            return this;
        }
        if (UnpressedTracker.isArrowKey(event)) {
            this.moveWidgetsByArrowKey(event, widgets);
            event.consume();
        }
        return this;
    }

    private Tracker handleLeftClick(BMouseEvent event) {
        double y;
        double x = event.getX();
        Handle handle = this.selected.getHandle(x, y = event.getY());
        if (handle == null) {
            BWidget[] stack = this.studio.rootDescendants(new Point(x, y));
            if (stack == null) {
                this.selected.deselectAll();
                this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
                return this;
            }
            return this.hitLeftSingleWidget(event, stack[0]);
        }
        if (handle.cursor == MouseCursor.doNotEnter) {
            return this;
        }
        if (!this.editorPane.getLayerManager().isNormal(handle.widget)) {
            return this;
        }
        boolean preserveAspectRatio = event.isControlDown();
        return Artisan.instance().makeHandleTracker(this.editorPane, handle, preserveAspectRatio);
    }

    private Tracker hitLeftSingleWidget(BMouseEvent event, BWidget widget) {
        if (widget instanceof BCanvasPane) {
            return new RubberBandTracker(this.editorPane, (BCanvasPane)widget, event.isControlDown());
        }
        if (widget instanceof BTabbedPane) {
            widget.mousePressed(this.makeMouseEvent(this.studio, widget, event));
            this.editorPane.forceRootLayout();
        } else if (widget instanceof BScrollBar || widget instanceof BSplitPane) {
            if (this.editorPane.getLayerManager().isNormal(widget)) {
                return this.passThrough(event, widget);
            }
            return this;
        }
        if (this.selected.isSelected(widget)) {
            return new HitSelectedTracker(this.editorPane, widget);
        }
        return this.hitLeftUnselected(event, widget);
    }

    private Tracker passThrough(BMouseEvent event, BWidget widget) {
        widget.mousePressed(this.makeMouseEvent(this.studio, widget, event));
        if (widget instanceof BSplitPane) {
            double y;
            double x = event.getX();
            Point p = this.studio.translateFromRoot(widget, new Point(x, y = event.getY()));
            MouseCursor c = (MouseCursor)widget.fw(304, (Object)p, null, null, null);
            this.studio.setMouseCursor(c == null ? MouseCursor.normal : c);
        } else {
            this.studio.setMouseCursor(MouseCursor.normal);
        }
        this.selected.deselectAll();
        this.selected.select(widget instanceof BSplitPane ? widget : widget.getParentWidget());
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        return new PassThroughTracker(this.editorPane, widget);
    }

    private Tracker hitLeftUnselected(BMouseEvent event, BWidget widget) {
        if (!event.isControlDown() || !this.selected.canSelect(widget)) {
            this.selected.deselectAll();
        }
        this.selected.select(widget);
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        if (this.editor.isReadonly()) {
            return this;
        }
        if (!this.editorPane.getLayerManager().isNormal(widget)) {
            return this;
        }
        BWidget parent = widget.getParentWidget();
        BCanvasPane canvas = Reflector.canvas(parent);
        if (canvas == null) {
            return this;
        }
        return UnpressedTracker.makeMoveTracker(this.editorPane, canvas, parent);
    }

    static MoveTracker makeMoveTracker(BPxEditorPane editorPane, BCanvasPane canvas, BWidget parent) {
        if (canvas == parent) {
            return new MoveTracker(editorPane, canvas, editorPane.getSelectedWidgets().getWidgets());
        }
        BWidget gp = parent.getParentWidget();
        while (gp != canvas) {
            parent = gp;
            gp = parent.getParentWidget();
        }
        return new MoveTracker(editorPane, canvas, new BWidget[]{parent});
    }

    private Tracker handleRightClick(BMouseEvent event) {
        double y;
        double x = event.getX();
        Handle handle = this.selected.getHandle(x, y = event.getY());
        if (handle == null) {
            BWidget[] stack = this.studio.rootDescendants(new Point(x, y));
            if (stack == null) {
                return this;
            }
            if (stack.length == 1) {
                return this.hitRightSingleWidget(event, stack[0]);
            }
            return this.hitRightWidgetStack(event, stack);
        }
        this.studio.showPopupMenu(event);
        return this;
    }

    private Tracker hitRightSingleWidget(BMouseEvent event, BWidget widget) {
        if (widget == null) {
            return this;
        }
        if (widget instanceof BScrollBar) {
            widget = widget.getParentWidget();
        }
        if (this.selected.isSelected(widget)) {
            this.studio.showPopupMenu(event);
            return this;
        }
        return this.hitRightUnselected(event, widget);
    }

    private Tracker hitRightUnselected(BMouseEvent event, BWidget widget) {
        if (!event.isControlDown() || !this.selected.canSelect(widget)) {
            this.selected.deselectAll();
        }
        this.selected.select(widget);
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        this.studio.showPopupMenu(event);
        return this;
    }

    private Tracker hitRightWidgetStack(BMouseEvent event, BWidget[] stack) {
        for (int i = 0; i < stack.length; ++i) {
            if (!this.selected.isSelected(stack[i])) continue;
            this.studio.showPopupMenu(event);
            return this;
        }
        return this.hitRightUnselected(event, stack[0]);
    }

    private Tracker handleDoubleClick(BMouseEvent event) {
        double y;
        double x = event.getX();
        Handle handle = this.selected.getHandle(x, y = event.getY());
        if (handle == null) {
            BWidget[] stack = this.studio.rootDescendants(new Point(x, y));
            if (stack == null) {
                return this;
            }
            return this.editSingleWidget(stack[0], event);
        }
        return this.editSingleWidget(handle.widget, event);
    }

    private Tracker editSingleWidget(BWidget widget, BMouseEvent event) {
        if (widget == null) {
            return this;
        }
        if (widget instanceof BScrollBar) {
            widget = widget.getParentWidget();
        }
        this.selected.deselectAll();
        this.selected.select(widget);
        this.editor.firePxEvent(new PxSelectionEvent(this.editorPane.getSelectedWidgets().getWidgets()));
        Command cmd = this.editor.getController().getDoubleClickCommand((BStudio)this.studio, event);
        if (cmd != null) {
            cmd.invoke();
        }
        return this;
    }

    private void moveWidgetsByArrowKey(BKeyEvent event, BWidget[] widgets) {
        BCanvasPane pane = this.studio.getCurrentCanvas();
        Artisan artisan = Artisan.instance();
        switch (UnpressedTracker.arrowDirection(event)) {
            case LEFT: {
                double minx = MoveWidget.getMinX(widgets, artisan);
                double move = this.getArrowKeyMoveDistance(event, minx);
                if (!(minx + move >= 0.0)) break;
                this.moveWidgets(widgets, move, 0.0);
                break;
            }
            case RIGHT: {
                double minx = MoveWidget.getMinX(widgets, artisan);
                double maxx = MoveWidget.getMaxX(widgets, artisan);
                double move = this.getArrowKeyMoveDistance(event, minx);
                if (!(maxx + move <= pane.getViewSize().width())) break;
                this.moveWidgets(widgets, move, 0.0);
                break;
            }
            case UP: {
                double miny = MoveWidget.getMinY(widgets, artisan);
                double move = this.getArrowKeyMoveDistance(event, miny);
                if (!(miny + move >= 0.0)) break;
                this.moveWidgets(widgets, 0.0, move);
                break;
            }
            case DOWN: {
                double miny = MoveWidget.getMinY(widgets, artisan);
                double maxy = MoveWidget.getMaxY(widgets, artisan);
                double move = this.getArrowKeyMoveDistance(event, miny);
                if (!(maxy + move <= pane.getViewSize().height())) break;
                this.moveWidgets(widgets, 0.0, move);
                break;
            }
        }
    }

    private int getArrowKeyMoveDistance(BKeyEvent event, double startPosition) {
        int actualTarget;
        int snapSize;
        int startingPoint = (int)startPosition;
        int move = snapSize = this.getSnapSize();
        boolean allowSnappingToMidpoint = snapSize >= 8;
        switch (UnpressedTracker.arrowDirection(event)) {
            case LEFT: 
            case UP: {
                move = -move;
            }
        }
        if (event.isControlDown()) {
            return move > 0 ? 1 : -1;
        }
        if (allowSnappingToMidpoint) {
            move /= 2;
        }
        int moveTarget = startingPoint + move;
        int lowerSnap = this.getLowerSnap(moveTarget);
        int upperSnap = lowerSnap + snapSize;
        if (startingPoint % snapSize != 0 && lowerSnap != this.getLowerSnap(startingPoint)) {
            moveTarget = move < 0 ? upperSnap : lowerSnap;
            lowerSnap = this.getLowerSnap(moveTarget);
            upperSnap = lowerSnap + snapSize;
        }
        if (allowSnappingToMidpoint) {
            int midPoint = (lowerSnap + upperSnap) / 2;
            actualTarget = this.closest(moveTarget, lowerSnap, midPoint, upperSnap);
        } else {
            actualTarget = this.closest(moveTarget, lowerSnap, upperSnap);
        }
        return actualTarget - startingPoint;
    }

    private static boolean isArrowKey(BKeyEvent event) {
        return UnpressedTracker.arrowDirection(event) != Dir.NONE;
    }

    private static Dir arrowDirection(BKeyEvent event) {
        switch (event.getKeyCode()) {
            case 37: 
            case 226: {
                return Dir.LEFT;
            }
            case 39: 
            case 227: {
                return Dir.RIGHT;
            }
            case 38: 
            case 224: {
                return Dir.UP;
            }
            case 40: 
            case 225: {
                return Dir.DOWN;
            }
        }
        return Dir.NONE;
    }

    private int closest(int number, int ... possibilities) {
        int closest = number;
        int minDelta = Integer.MAX_VALUE;
        for (int n : possibilities) {
            int delta = Math.abs(number - n);
            if (delta >= minDelta) continue;
            minDelta = delta;
            closest = n;
        }
        return closest;
    }

    private int getSnapSize() {
        return this.editorPane.getOptions().getSnapSize();
    }

    private int getLowerSnap(int n) {
        return n - n % this.getSnapSize();
    }

    private void moveWidgets(BWidget[] widgets, double x, double y) {
        new MoveWidget(this.editorPane, widgets, x, y).invoke();
    }

    private static enum Dir {
        UP,
        DOWN,
        LEFT,
        RIGHT,
        NONE;

    }
}

