/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.PathArtisan;
import com.tridium.px.editor.studio.artisans.PolygonArtisan;
import com.tridium.px.editor.studio.artisans.path.Role;
import com.tridium.px.editor.studio.commands.MorphWidget;
import com.tridium.px.editor.studio.painters.PointPainter;
import com.tridium.px.editor.studio.trackers.GeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import com.tridium.px.editor.util.Handle;
import com.tridium.px.editor.util.SelectedWidgets;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.BPolygonGeom;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.shape.BPath;
import javax.baja.ui.shape.BPolygon;

public class DeletePointTracker
extends GeometryTracker {
    private SelectedWidgets selected;
    private TrackerStudio studio;

    public DeletePointTracker(BPxEditorPane editorPane, TrackerStudio studio) {
        super(editorPane);
        this.studio = studio;
        this.selected = editorPane.getSelectedWidgets();
        this.selected.deselectAll();
        studio.setPainter(new PointPainter(editorPane.getPainterStudio(), this.selected));
        this.selectShapes(this.selected, (BWidget)editorPane.getRootContainer());
        editorPane.repaint();
    }

    @Override
    public Tracker mousePressed(BMouseEvent event) {
        double y;
        if (event.getClickCount() != 1 || !event.isButton1Down()) {
            return this;
        }
        double x = event.getX();
        Handle handle = this.selected.getHandle(x, y = event.getY());
        if (handle != null) {
            if (!(handle.widget instanceof BPath) && !(handle.widget instanceof BPolygon)) {
                throw new IllegalStateException();
            }
            this.deletePoint(handle);
        }
        this.editorPane.repaint();
        return this;
    }

    private void deletePoint(Handle handle) {
        if (handle.widget instanceof BPath) {
            PathArtisan pa = new PathArtisan();
            BPath path = (BPath)handle.widget;
            BPathGeom geom = path.getGeom();
            if (geom.size() <= 2) {
                return;
            }
            ArrayList<IPathGeom.Segment> arr = new ArrayList<IPathGeom.Segment>(Arrays.asList(geom.segments()));
            Role role = (Role)handle.role;
            arr.remove(role.idx);
            IPathGeom.Segment[] segs = arr.toArray(new IPathGeom.Segment[0]);
            if (role.idx == 0) {
                Point p = pa.artisan.point(null, segs[0]);
                segs[0] = new IPathGeom.MoveTo(true, p.x, p.y);
            }
            geom = BPathGeom.make((IPathGeom.Segment[])segs);
            new MorphWidget(this.editorPane, (BWidget)path, (IGeom)path.getGeom(), (IGeom)geom, pa).invoke();
        } else if (handle.widget instanceof BPolygon) {
            int idx;
            BPolygon poly = (BPolygon)handle.widget;
            BPolygonGeom geom = poly.getGeom();
            if (geom.size() <= 3) {
                return;
            }
            double[] x = geom.x();
            double[] y = geom.y();
            for (int i = idx = ((Integer)handle.role).intValue(); i < geom.size() - 1; ++i) {
                x[i] = x[i + 1];
                y[i] = y[i + 1];
            }
            geom = BPolygonGeom.make((double[])x, (double[])y, (int)(geom.size() - 1));
            new MorphWidget(this.editorPane, (BWidget)poly, (IGeom)poly.getGeom(), (IGeom)geom, new PolygonArtisan()).invoke();
        } else {
            throw new IllegalStateException();
        }
    }
}

