/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.trackers;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.trackers.AddGeometryTracker;
import com.tridium.px.editor.studio.trackers.Tracker;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Geom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.PathGeom;
import javax.baja.gx.Point;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.shape.BPath;

public class AddPathTracker
extends AddGeometryTracker {
    private boolean dragged = false;

    public AddPathTracker(BPxEditorPane editorPane, TrackerStudio studio) {
        super(editorPane, studio);
    }

    @Override
    protected boolean widgetMakeable() {
        return this.handles.size() >= 2;
    }

    @Override
    protected BWidget makeWidget() {
        BPath path = new BPath((IPathGeom)this.pathGeom(false));
        path.setStroke(BBrush.makeSolid((BColor)BColor.black));
        return path;
    }

    @Override
    public Tracker mouseDragged(BMouseEvent event) {
        if (!this.dragged && this.moved(event)) {
            this.dragged = true;
        }
        if (this.dragged) {
            Point pnt = this.studio.toViewbox(event.getX(), event.getY(), this.canvas);
            pnt = this.studio.snap(pnt.x, pnt.y);
            this.bars.set(this.bars.size() - 1, pnt);
        }
        this.editorPane.repaint();
        return this;
    }

    @Override
    public Tracker mouseReleased(BMouseEvent event) {
        if (this.dragged) {
            Point pnt = this.studio.toViewbox(event.getX(), event.getY(), this.canvas);
            pnt = this.studio.snap(pnt.x, pnt.y);
            this.bars.set(this.bars.size() - 1, pnt);
            this.dragged = false;
        }
        this.editorPane.repaint();
        return this;
    }

    @Override
    public Geom[] geoms() {
        if (this.handles.size() == 0) {
            return new Geom[0];
        }
        return new Geom[]{this.pathGeom(true)};
    }

    private PathGeom pathGeom(boolean useMouse) {
        int len = this.handles.size();
        if (len == 0) {
            return null;
        }
        int len2 = useMouse ? len + 1 : len;
        Point[] h = new Point[len2];
        Point[] a = new Point[len2];
        Point[] b = new Point[len2];
        for (int i = 0; i < len; ++i) {
            Point p = (Point)this.handles.get(i);
            h[i] = new Point(p.x, p.y);
            p = (Point)this.bars.get(i);
            if (p == null) continue;
            a[i] = new Point(p.x, p.y);
            double dx = a[i].x - h[i].x;
            double dy = a[i].y - h[i].y;
            b[i] = new Point(h[i].x - dx, h[i].y - dy);
        }
        if (useMouse) {
            h[len] = new Point(this.mouse.x, this.mouse.y);
        }
        IPathGeom.Segment[] segs = new IPathGeom.Segment[len2];
        segs[0] = new IPathGeom.MoveTo(true, h[0].x, h[0].y);
        segs[1] = a[0] == null ? (a[1] == null ? new IPathGeom.LineTo(true, h[1].x, h[1].y) : new IPathGeom.QuadTo(true, b[1].x, b[1].y, h[1].x, h[1].y)) : (a[1] == null ? new IPathGeom.QuadTo(true, a[0].x, a[0].y, h[1].x, h[1].y) : new IPathGeom.CurveTo(true, a[0].x, a[0].y, b[1].x, b[1].y, h[1].x, h[1].y));
        for (int i = 2; i < len2; ++i) {
            if (a[i - 1] == null) {
                if (a[i] == null) {
                    segs[i] = new IPathGeom.LineTo(true, h[i].x, h[i].y);
                    continue;
                }
                segs[i] = new IPathGeom.QuadTo(true, b[i].x, b[i].y, h[i].x, h[i].y);
                continue;
            }
            segs[i] = a[i] == null ? new IPathGeom.SmoothQuadTo(true, h[i].x, h[i].y) : new IPathGeom.SmoothCurveTo(true, b[i].x, b[i].y, h[i].x, h[i].y);
        }
        return new PathGeom(segs, len2);
    }
}

