/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.studio.artisans;

import com.tridium.gx.awt.se.AwtUtil;
import com.tridium.gx.util.PointMap;
import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.studio.TrackerStudio;
import com.tridium.px.editor.studio.artisans.Artisan;
import com.tridium.px.editor.studio.artisans.path.Router;
import com.tridium.px.editor.studio.artisans.path.SegmentArtisan;
import com.tridium.px.editor.studio.trackers.HandleTracker;
import com.tridium.px.editor.studio.trackers.PathHandleTracker;
import com.tridium.px.editor.util.Handle;
import javax.baja.gx.BPathGeom;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPathGeom;
import javax.baja.gx.PathGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.ui.BWidget;
import javax.baja.ui.shape.BPath;

public class PathArtisan
extends Artisan {
    public SegmentArtisan artisan = new Router();

    @Override
    public void paintSelected(TrackerStudio studio, BWidget widget, Graphics g) {
        int i;
        BPath path = (BPath)widget;
        BPathGeom geom = path.getGeom();
        Point pen = this.newPen(geom);
        for (i = 0; i < geom.size(); ++i) {
            pen = this.artisan.paintBars(g, studio, path, pen, geom.segment(i));
        }
        pen = this.newPen(geom);
        for (i = 0; i < geom.size(); ++i) {
            pen = this.artisan.paintHandles(g, studio, path, pen, geom.segment(i));
        }
    }

    @Override
    public RectGeom bounds(BWidget widget) {
        BPath path = (BPath)widget;
        BPathGeom geom = path.getGeom();
        Point[] pnts = AwtUtil.flatten((BPathGeom)geom, (double)3.0);
        RectGeom b = new RectGeom(pnts[0].x, pnts[0].y, 0.0, 0.0);
        for (int i = 1; i < pnts.length; ++i) {
            b = RectGeom.bounds((double)b.x, (double)b.y, (double)b.width, (double)b.height, (double)pnts[i].x, (double)pnts[i].y, (double)0.0, (double)0.0, (RectGeom)b);
        }
        return b;
    }

    @Override
    public String move(BWidget widget, double dx, double dy) {
        BPath path = (BPath)widget;
        BPathGeom geom = path.getGeom();
        IPathGeom.Segment[] segs = geom.segments();
        Point pen = this.newPen(geom);
        for (int i = 0; i < segs.length; ++i) {
            segs[i] = this.artisan.move(pen, segs[i], dx, dy);
            pen = this.artisan.point(pen, segs[i]);
        }
        path.setGeom(BPathGeom.make((IPathGeom.Segment[])segs));
        return "geom";
    }

    @Override
    public String zero(BWidget widget) {
        RectGeom bounds = this.bounds(widget);
        return this.move(widget, -bounds.x, -bounds.y);
    }

    @Override
    public IGeom translateGeom(BWidget widget, double dx, double dy) {
        BPath path = (BPath)widget;
        BPathGeom geom = path.getGeom();
        IPathGeom.Segment[] segs = geom.segments();
        Point pen = this.newPen(geom);
        for (int i = 0; i < segs.length; ++i) {
            segs[i] = this.artisan.move(pen, segs[i], dx, dy);
            pen = this.artisan.point(pen, segs[i]);
        }
        return new PathGeom(segs, segs.length);
    }

    @Override
    public void addHandles(TrackerStudio studio, BWidget widget, PointMap map) {
        BPath path = (BPath)widget;
        BPathGeom geom = path.getGeom();
        IPathGeom.Segment[] segs = geom.segments();
        Point pen = this.newPen(geom);
        for (int i = 0; i < segs.length; ++i) {
            pen = this.artisan.addHandles(studio, path, pen, segs[i], i, map);
        }
    }

    @Override
    public HandleTracker makeHandleTracker(BPxEditorPane editorPane, Handle handle, boolean preserveAspectRatio) {
        return new PathHandleTracker(editorPane, handle, this);
    }

    @Override
    public String setGeom(BWidget widget, IGeom geom) {
        BPath path = (BPath)widget;
        IPathGeom pg = (IPathGeom)geom;
        path.setGeom(BPathGeom.make((IPathGeom.Segment[])pg.segments()));
        return "geom";
    }

    private Point newPen(BPathGeom geom) {
        int len = geom.size();
        if (len < 2) {
            throw new IllegalStateException();
        }
        IPathGeom.Segment s = geom.segment(0);
        if (!(s instanceof IPathGeom.MoveTo)) {
            throw new IllegalStateException();
        }
        if (!s.isAbsolute()) {
            throw new IllegalStateException();
        }
        IPathGeom.MoveTo mv = (IPathGeom.MoveTo)s;
        return new Point(mv.getX(), mv.getY());
    }
}

