/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.tree;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.tree.LeafNode;
import com.tridium.px.editor.sidebars.tree.PxTreeModel;
import com.tridium.px.editor.sidebars.tree.WidgetNode;
import com.tridium.px.editor.util.Reflector;
import java.util.ArrayList;
import java.util.List;
import javax.baja.chart.BChartPane;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BCanvasPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.tree.TreeNode;

class PaneNode
extends WidgetNode {
    private List<WidgetNode> kids = new ArrayList<WidgetNode>();

    PaneNode(BPxEditorPane editorPane, PxTreeModel model, BPane pane) {
        super(editorPane, model, (BWidget)pane);
        this.build();
    }

    PaneNode(BPxEditorPane editorPane, WidgetNode parent, BPane pane) {
        super(editorPane, parent, (BWidget)pane);
        this.build();
    }

    public int getChildCount() {
        return this.kids.size();
    }

    public TreeNode getChild(int index) {
        return this.kids.get(index);
    }

    @Override
    int dragOver() {
        return Reflector.isFreeFormPane(this.getWidget()) ? 16 : 0;
    }

    void deleteNode(WidgetNode node) {
        int idx = this.kids.indexOf((Object)node);
        if (idx == -1) {
            throw new IllegalStateException();
        }
        this.kids.remove(idx);
    }

    void build() {
        this.doBuild(PaneNode.childWidgets(this.getWidget()));
    }

    void updateChildNodes(BWidget compare) {
        int i;
        if (this.getWidget() != compare) {
            throw new IllegalStateException();
        }
        BWidget[] cw = PaneNode.childWidgets(compare);
        if (this.getChildCount() != cw.length) {
            this.doBuild(cw);
            return;
        }
        for (i = 0; i < cw.length; ++i) {
            WidgetNode wn = (WidgetNode)this.getChild(i);
            if (wn.getWidget() == cw[i]) continue;
            this.doBuild(cw);
            return;
        }
        for (i = 0; i < cw.length; ++i) {
            TreeNode tn = this.getChild(i);
            if (!(tn instanceof PaneNode)) continue;
            ((PaneNode)tn).updateChildNodes(cw[i]);
        }
    }

    void doBuild(BWidget[] cw) {
        this.kids.clear();
        for (int i = 0; i < cw.length; ++i) {
            this.kids.add(this.makeNode(cw[i]));
        }
    }

    private WidgetNode makeNode(BWidget w) {
        if (Reflector.isLeaf(w)) {
            return new LeafNode(this.editorPane, this, w);
        }
        return new PaneNode(this.editorPane, (WidgetNode)this, (BPane)w);
    }

    private static BWidget[] childWidgets(BWidget widget) {
        return Reflector.isFreeFormPane(widget) ? PaneNode.freeFormChildren(widget) : PaneNode.cannedChildren(widget);
    }

    private static BWidget[] cannedChildren(BWidget widget) {
        ArrayList<BWidget> arr = new ArrayList<BWidget>();
        Property[] props = widget.getPropertiesArray();
        for (int i = props.length - 1; i >= 0; --i) {
            BValue val;
            Property prop = props[i];
            if (prop.isDynamic() || Flags.isHidden((BComplex)widget, (Slot)prop) || !((val = widget.get(prop)) instanceof BWidget)) continue;
            arr.add((BWidget)val);
        }
        return arr.toArray(new BWidget[0]);
    }

    private static BWidget[] freeFormChildren(BWidget widget) {
        ArrayList<BWidget> arr = new ArrayList<BWidget>();
        Property[] props = widget.getPropertiesArray();
        if (widget instanceof BCanvasPane) {
            for (int i = props.length - 1; i >= 0; --i) {
                BValue val;
                Property prop = props[i];
                if (Flags.isHidden((BComplex)widget, (Slot)prop) || prop.isFrozen() || !((val = widget.get(prop)) instanceof BWidget)) continue;
                arr.add((BWidget)val);
            }
        } else {
            for (int i = 0; i < props.length; ++i) {
                BValue val;
                Property prop = props[i];
                if (Flags.isHidden((BComplex)widget, (Slot)prop) || !(widget instanceof BChartPane) && prop.isFrozen() || !((val = widget.get(prop)) instanceof BWidget)) continue;
                arr.add((BWidget)val);
            }
        }
        return arr.toArray(new BWidget[0]);
    }
}

