/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.layersheet;

import com.tridium.px.editor.sidebars.layersheet.BPxLayerSheet;
import com.tridium.util.ObjectUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BValue;
import javax.baja.ui.BDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.px.PxLayer;
import javax.baja.util.Lexicon;

class AddPxLayer
extends Command
implements ObjectUtil.NameContainer {
    private static final Lexicon lex = Lexicon.make((String)"pxEditor");
    private static String lastName = "newLayer";
    private static final String alreadyExists = lex.getText("pxLayerSheet.alreadyExists");
    private BPxLayerSheet sheet;

    AddPxLayer(BPxLayerSheet sheet) {
        super((BWidget)sheet, Lexicon.make((String)"pxEditor"), "commands.add");
        this.sheet = sheet;
        this.setEnabled(!sheet.readonly);
    }

    public boolean contains(String name) {
        PxLayer[] layers = this.sheet.editor.getPxLayers();
        for (int i = 0; i < layers.length; ++i) {
            if (!layers[i].getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public CommandArtifact doInvoke() throws Exception {
        String newName = ObjectUtil.generateUniqueName((String)lastName, (ObjectUtil.NameContainer)this);
        BTextField nameEditor = new BTextField(newName, 25);
        BGridPane nameInner = new BGridPane();
        nameInner.setHalign(BHalign.left);
        nameInner.add(null, (BValue)nameEditor);
        BBorderPane namePane = new BBorderPane((BWidget)nameInner, "Name");
        BGridPane pane = new BGridPane(1);
        pane.setColumnAlign(BHalign.fill);
        pane.add(null, (BValue)namePane);
        String title = this.getLabel();
        int buttons = 3;
        if (BDialog.open((BWidget)this.sheet, (String)title, (Object)pane, (int)buttons, null) == 2) {
            return null;
        }
        lastName = nameEditor.getText();
        newName = SlotPath.escape((String)nameEditor.getText());
        final PxLayer[] layers = this.sheet.editor.getPxLayers();
        for (int i = 0; i < layers.length; ++i) {
            PxLayer p = layers[i];
            if (!p.getName().equals(newName)) continue;
            BDialog.error((BWidget)this.sheet, (String)title, (Object)alreadyExists);
            return null;
        }
        final PxLayer newLayer = new PxLayer(newName);
        CommandArtifact af = new CommandArtifact(){

            public void redo() throws Exception {
                AddPxLayer.this.sheet.insertLayer(layers.length, newLayer, null);
            }

            public void undo() throws Exception {
                AddPxLayer.this.sheet.removeLayer(layers.length);
            }
        };
        af.redo();
        return af;
    }
}

