/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.ValidationUtil;
import java.util.Map;
import javax.baja.gx.BFont;
import javax.baja.px.editor.BPxEditor;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.style.IStylable;
import javax.baja.util.Lexicon;

public abstract class PxMediaValidationUtil {
    private static BFont bold = BFont.make((String)BFont.DEFAULT.getName(), (double)BFont.DEFAULT.getSize(), (int)1);
    private static Lexicon lexicon = Lexicon.make((String)"pxEditor");

    public static int validateMediaDialog(BPxMedia media, BWidget root, BPxEditor editor, Context cx) {
        Map warnings;
        boolean attemptingChange;
        boolean validateChildren = root == null;
        boolean bl = attemptingChange = media != null;
        if (media == null) {
            media = editor.getMedia();
        }
        if (root == null) {
            root = editor.getWidget();
        }
        if ((warnings = ValidationUtil.getValidationWarnings((BPxMedia)media, (BWidget[])new BWidget[]{root}, (boolean)validateChildren, (Context)cx)).size() > 0) {
            String header = lexicon.getText("validateMedia.header", new Object[]{media});
            if (attemptingChange) {
                header = lexicon.getText("validateMedia.question", new Object[]{media});
            }
            BPane warningPane = PxMediaValidationUtil.getWarningPane(header, warnings);
            if (attemptingChange) {
                return BDialog.confirm((BWidget)editor, (String)lexicon.getText("validateMedia.title", new Object[]{media}), (Object)warningPane);
            }
            return BDialog.warning((BWidget)editor, (String)lexicon.getText("validateMedia.title", new Object[]{media}), (Object)warningPane);
        }
        if (!attemptingChange) {
            return BDialog.info((BWidget)editor, (String)lexicon.getText("validateMedia.title"), (Object)lexicon.getText("validateMedia.success", new Object[]{media}));
        }
        return 4;
    }

    public static BPane getWarningPane(String header, Map<String, String> warnings) {
        BEdgePane warningPane = new BEdgePane();
        BLabel headerWarning = new BLabel(header, BHalign.left);
        headerWarning.setFont(bold);
        warningPane.setTop((BWidget)new BBorderPane((BWidget)headerWarning, 10.0, 10.0, 10.0, 20.0));
        BGridPane warningGrid = new BGridPane(2);
        warningGrid.setColumnGap(10.0);
        warningGrid.setRowAlign(BValign.top);
        warningGrid.add(null, (BValue)new BLabel(lexicon.getText("validateMedia.ord"), bold));
        warningGrid.add(null, (BValue)new BLabel(lexicon.getText("validateMedia.warning"), bold));
        warnings.forEach((ord, message) -> {
            warningGrid.add(null, (BValue)new BLabel(ord));
            warningGrid.add(null, (BValue)new BLabel(message, BHalign.left));
        });
        warningPane.setCenter((BWidget)warningGrid);
        BConstrainedPane constrainedPane = new BConstrainedPane();
        BScrollPane scrollPane = new BScrollPane();
        constrainedPane.setContent((BWidget)scrollPane);
        constrainedPane.setMaxHeight(800.0);
        scrollPane.setVpolicy(BScrollBarPolicy.asNeeded);
        scrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground((IStylable)scrollPane));
        BBorderPane borderPane = new BBorderPane();
        borderPane.setContent((BWidget)warningPane);
        scrollPane.setContent((BWidget)borderPane);
        borderPane.computePreferredSize();
        constrainedPane.setMinWidth(borderPane.getPreferredWidth() + 40.0);
        return constrainedPane;
    }

    public static int confirmNewWarningsDialog(Map<String, String> warnings, BPxEditor editor) {
        BPxMedia media = editor.getMedia();
        if (warnings.size() > 0) {
            String header = lexicon.getText("validateMedia.newWarnings", new Object[]{media});
            BPane warningPane = PxMediaValidationUtil.getWarningPane(header, warnings);
            return BDialog.confirm((BWidget)editor, (String)lexicon.getText("validateMedia.title", new Object[]{media}), (Object)warningPane);
        }
        return 4;
    }

    public static int confirmInsertDialog(BPxMedia media, BWidget[] roots, BPxEditor editor, Context cx) {
        Map warnings = ValidationUtil.getValidationWarnings((BPxMedia)media, (BWidget[])roots, (boolean)true, (Context)cx);
        if (warnings.size() > 0) {
            String header = lexicon.getText("validateMedia.insertWarning", new Object[]{media});
            BPane warningPane = PxMediaValidationUtil.getWarningPane(header, warnings);
            return BDialog.confirm((BWidget)editor, (String)lexicon.getText("validateMedia.title", new Object[]{media}), (Object)warningPane);
        }
        return 4;
    }
}

