/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.LinkedHashMap;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BSimplePairList
extends BSimple {
    public static final BSimplePairList DEFAULT;
    public static final BSimplePairList NULL;
    public static final Type TYPE;
    private int hashCode = -1;
    private BSimple[] sims1;
    private BSimple[] sims2;
    private static final char delim = ';';

    private BSimplePairList(BSimple[] sims1, BSimple[] sims2) {
        this.sims1 = sims1;
        this.sims2 = sims2;
    }

    public static BSimplePairList make(BSimple[] sims1, BSimple[] sims2) {
        BSimplePairList.validate(sims1, sims2);
        BSimple[] sims1Copy = new BSimple[sims1.length];
        System.arraycopy(sims1, 0, sims1Copy, 0, sims1.length);
        BSimple[] sims2Copy = new BSimple[sims2.length];
        System.arraycopy(sims2, 0, sims2Copy, 0, sims2.length);
        return new BSimplePairList(sims1Copy, sims2Copy);
    }

    public static BSimplePairList make(BSimple sim1, BSimple sim2) {
        if (sim1 == null) {
            throw new BajaRuntimeException("Null Simple for Pair List");
        }
        if (sim2 == null) {
            throw new BajaRuntimeException("Null Simple for Pair List");
        }
        return new BSimplePairList(new BSimple[]{sim1}, new BSimple[]{sim2});
    }

    public static BSimplePairList make(Pair[] pairs) {
        BSimple[] sims1 = new BSimple[pairs.length];
        BSimple[] sims2 = new BSimple[pairs.length];
        for (int i = 0; i < pairs.length; ++i) {
            sims1[i] = pairs[i].getSimple1();
            sims2[i] = pairs[i].getSimple2();
        }
        return new BSimplePairList(sims1, sims2);
    }

    public static BSimplePairList union(BSimplePairList list1, BSimplePairList list2) {
        int i;
        if (list1.isNull()) {
            return list2;
        }
        if (list2.isNull()) {
            return list1;
        }
        LinkedHashMap<BSimple, BSimple> map = new LinkedHashMap<BSimple, BSimple>();
        for (i = 0; i < list1.sims1.length; ++i) {
            map.put(list1.sims1[i], list1.sims2[i]);
        }
        for (i = 0; i < list2.sims1.length; ++i) {
            map.put(list2.sims1[i], list2.sims2[i]);
        }
        BSimple[] sims1 = map.keySet().toArray(new BSimple[0]);
        BSimple[] sims2 = new BSimple[sims1.length];
        for (int i2 = 0; i2 < sims1.length; ++i2) {
            sims2[i2] = (BSimple)map.get(sims1[i2]);
        }
        BSimplePairList.validate(sims1, sims2);
        return new BSimplePairList(sims1, sims2);
    }

    public static BSimplePairList difference(BSimplePairList list1, BSimplePairList list2) {
        if (list1.isNull()) {
            return NULL;
        }
        if (list2.isNull()) {
            return list1;
        }
        Array pairsArray = new Array(Pair.class);
        for (int i = 0; i < list1.size(); ++i) {
            pairsArray.add((Object)list1.getPair(i));
        }
        final Pair[] pairs2 = new Pair[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            pairs2[i] = list2.getPair(i);
        }
        pairsArray = pairsArray.filter(new IFilter(){

            public boolean accept(Object obj) {
                Pair p = (Pair)obj;
                for (int i = 0; i < pairs2.length; ++i) {
                    if (!p.getSimple1().equals((Object)pairs2[i].getSimple1()) || !p.getSimple2().equals((Object)pairs2[i].getSimple2())) continue;
                    return false;
                }
                return true;
            }
        });
        return BSimplePairList.make((Pair[])pairsArray.trim());
    }

    private static void validate(BSimple[] sims1, BSimple[] sims2) throws BajaRuntimeException {
        if (sims1 == null) {
            throw new BajaRuntimeException("Null Simple array for Pair List");
        }
        if (sims2 == null) {
            throw new BajaRuntimeException("Null Simple array for Pair List");
        }
        if (sims1.length != sims2.length) {
            throw new BajaRuntimeException("Pair arrays are not equal in length");
        }
        Type sim1Type = null;
        for (int i = 0; i < sims1.length; ++i) {
            if (i == 0) {
                sim1Type = sims1[i].getType();
                continue;
            }
            if (sims1[i].getType().equals(sim1Type)) continue;
            throw new BajaRuntimeException("Simple array must be all be same Type!");
        }
        Type sim2Type = null;
        for (int i = 0; i < sims2.length; ++i) {
            if (i == 0) {
                sim2Type = sims2[i].getType();
                continue;
            }
            if (sims2[i].getType().equals(sim2Type)) continue;
            throw new BajaRuntimeException("Simple array must be all be same Type!");
        }
    }

    public boolean isNull() {
        return this.sims1.length == 0;
    }

    public int size() {
        return this.sims1.length;
    }

    public Pair getPair(int i) {
        return Pair.make(this.sims1[i], this.sims2[i]);
    }

    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.length() == 0) {
            return DEFAULT;
        }
        String[] strs = TextUtil.splitAndTrim((String)s, (char)';');
        if (strs.length % 2 != 0) {
            throw new IOException("Invalid Simple array Length (must be even): " + strs.length);
        }
        BSimple[] sims1 = new BSimple[(strs.length - 2) / 2];
        BSimple[] sims2 = new BSimple[sims1.length];
        BSimple sim1Default = null;
        BSimple sim2Default = null;
        int count = 0;
        for (int i = 0; i < strs.length; ++i) {
            if (i == 0) {
                sim1Default = (BSimple)Sys.getType((String)strs[i]).getInstance();
                continue;
            }
            if (i == 1) {
                sim2Default = (BSimple)Sys.getType((String)strs[i]).getInstance();
                continue;
            }
            if (i == 0 || i % 2 == 0) {
                sims1[count] = (BSimple)sim1Default.decodeFromString(SlotPath.unescape((String)strs[i]));
                continue;
            }
            sims2[count++] = (BSimple)sim2Default.decodeFromString(SlotPath.unescape((String)strs[i]));
        }
        return new BSimplePairList(sims1, sims2);
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    public String encodeToString() throws IOException {
        StringBuilder buff = new StringBuilder();
        if (this.sims1.length > 0) {
            buff.append(this.sims1[0].getType().toString());
            buff.append(';');
            buff.append(this.sims2[0].getType().toString());
            for (int i = 0; i < this.sims1.length; ++i) {
                buff.append(';');
                buff.append(SlotPath.escape((String)this.sims1[i].encodeToString()));
                buff.append(';');
                buff.append(SlotPath.escape((String)this.sims2[i].encodeToString()));
            }
        }
        return buff.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BSimplePairList)) {
            return false;
        }
        BSimplePairList r = (BSimplePairList)((Object)obj);
        if (this.sims1.length != r.sims1.length) {
            return false;
        }
        if (this.sims2.length != r.sims2.length) {
            return false;
        }
        for (int i = 0; i < this.sims1.length; ++i) {
            if (!this.sims1[i].equals((Object)r.sims1[i])) {
                return false;
            }
            if (this.sims2[i].equals((Object)r.sims2[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            try {
                this.hashCode = this.encodeToString().hashCode();
            }
            catch (IOException e) {
                this.hashCode = System.identityHashCode((Object)this);
            }
        }
        return this.hashCode;
    }

    public String toString(Context cx) {
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < this.sims1.length; ++i) {
            if (i > 0) {
                buff.append(", ");
            }
            buff.append(this.sims1[i].toString(cx));
            buff.append(" -> ");
            buff.append(this.sims2[i].toString(cx));
        }
        return buff.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        NULL = DEFAULT = new BSimplePairList(new BSimple[0], new BSimple[0]);
        TYPE = Sys.loadType(BSimplePairList.class);
    }

    public static final class Pair {
        private BSimple sim1;
        private BSimple sim2;

        public static Pair make(BSimple sim1, BSimple sim2) {
            Pair p = new Pair();
            p.sim1 = sim1;
            p.sim2 = sim2;
            return p;
        }

        public BSimple getSimple1() {
            return this.sim1;
        }

        public BSimple getSimple2() {
            return this.sim2;
        }
    }
}

