/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags.tags;

import com.tridium.exporttags.BNiagaraExportTag;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.schedule.BNiagaraScheduleExport;
import com.tridium.nd.schedule.BNiagaraScheduleImportExt;
import com.tridium.nv.NiagaraVirtualUtil;
import javax.baja.category.BCategoryMask;
import javax.baja.control.trigger.BDailyTriggerMode;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.IFilter;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BNameList;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationSlotPath", type="BOrd", defaultValue="BOrd.make(\"slot:schedules\")", facets={@Facet(value="makeStationSlotPathFacets()")}, override=true), @NiagaraProperty(name="overrideSupervisorId", type="boolean", defaultValue="false"), @NiagaraProperty(name="overrideSupervisorIdStationSlotPath", type="BOrd", defaultValue="BOrd.make(\"slot:\")", facets={@Facet(value="makeStationSlotPathFacets()")}), @NiagaraProperty(name="exportExecutionTime", type="BTriggerMode", defaultValue="BDailyTriggerMode.make()")})
public final class BScheduleExportTag
extends BNiagaraExportTag {
    @Generated
    public static final Property stationSlotPath = BScheduleExportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:schedules"), (BFacets)BScheduleExportTag.makeStationSlotPathFacets());
    @Generated
    public static final Property overrideSupervisorId = BScheduleExportTag.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property overrideSupervisorIdStationSlotPath = BScheduleExportTag.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BScheduleExportTag.makeStationSlotPathFacets());
    @Generated
    public static final Property exportExecutionTime = BScheduleExportTag.newProperty((int)0, (BValue)BDailyTriggerMode.make(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduleExportTag.class);

    @Generated
    public boolean getOverrideSupervisorId() {
        return this.getBoolean(overrideSupervisorId);
    }

    @Generated
    public void setOverrideSupervisorId(boolean v) {
        this.setBoolean(overrideSupervisorId, v, null);
    }

    @Generated
    public BOrd getOverrideSupervisorIdStationSlotPath() {
        return (BOrd)this.get(overrideSupervisorIdStationSlotPath);
    }

    @Generated
    public void setOverrideSupervisorIdStationSlotPath(BOrd v) {
        this.set(overrideSupervisorIdStationSlotPath, (BValue)v, null);
    }

    @Generated
    public BTriggerMode getExportExecutionTime() {
        return (BTriggerMode)this.get(exportExecutionTime);
    }

    @Generated
    public void setExportExecutionTime(BTriggerMode v) {
        this.set(exportExecutionTime, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraScheduleImportExt;
    }

    public void started() throws Exception {
        BNiagaraStation station = this.findNiagaraStation(this.getParent());
        if (station == null) {
            throw new Exception("Could not find parent Niagara Station!");
        }
        this.setSupervisorStation(BNameList.make((String)station.getName()));
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (this.isMounted() && slot == overrideSupervisorIdStationSlotPath) {
            return BFacets.make((BFacets)super.getSlotFacets(slot), (String)"handleOrd", (BIDataValue)BString.make((String)this.getHandleOrd().toString()));
        }
        return super.getSlotFacets(slot);
    }

    @Override
    protected void doJoin(BINiagaraStation station, BJob job, Subscriber sub, BCategoryMask mask, Context cx) throws Exception {
        BOrd supervisorOrd;
        BNiagaraScheduleImportExt importExt = (BNiagaraScheduleImportExt)this.getParent();
        sub.subscribe((BComponent)importExt);
        BComponent supervisorBase = (BComponent)station;
        if (this.getOverrideSupervisorId()) {
            BComponent supParent;
            try {
                supParent = (BComponent)this.getOverrideSupervisorIdStationSlotPath().get((BObject)supervisorBase);
            }
            catch (Exception e) {
                throw new ExportTagException("schExportExpTag.noOverrideSup", this.getOverrideSupervisorIdStationSlotPath().toString(), (Throwable)e);
            }
            supervisorOrd = BOrd.make((String)(supParent.getSlotPathOrd() + "/" + importExt.getParent().getName()));
            importExt.setString(BNiagaraScheduleImportExt.supervisorId, supervisorOrd.toString(), cx);
        } else {
            if (importExt.getSupervisorId().length() == 0) {
                throw new ExportTagException("schExportExpTag.noSupervisorId");
            }
            supervisorOrd = BOrd.make((String)("station:|" + importExt.getSupervisorId()));
        }
        BAbstractSchedule supervisorSch = null;
        try {
            supervisorSch = (BAbstractSchedule)supervisorOrd.get((BObject)supervisorBase);
        }
        catch (Exception e) {
            // empty catch block
        }
        BAbstractSchedule sourceSch = (BAbstractSchedule)importExt.getParent();
        sub.subscribe((BComponent)sourceSch);
        if (supervisorSch != null && !supervisorSch.getType().is(sourceSch.getType())) {
            supervisorSch.getParent().asComponent().remove(supervisorSch.getPropertyInParent(), cx);
            supervisorSch = null;
            job.log().success(this.getType().getModule().getModuleName(), "schExportDevExt.removedSupSch");
        }
        if (supervisorSch == null) {
            BComponent parent;
            OrdQuery[] queries = supervisorOrd.parse();
            SlotPath path = (SlotPath)queries[queries.length - 1];
            queries[queries.length - 1] = path.getParent();
            String scheduleName = path.nameAt(path.depth() - 1);
            BOrd parentPathOrd = BOrd.make((OrdQuery[])queries);
            try {
                parent = (BComponent)parentPathOrd.get((BObject)supervisorBase);
            }
            catch (Exception e) {
                throw new ExportTagException("schExportDevExt.invalidPathSupSch", parentPathOrd.toString(), (Throwable)e);
            }
            supervisorSch = (BAbstractSchedule)sourceSch.getType().getInstance();
            if (this.getOverrideSupervisorId()) {
                this.addTarget(parent, scheduleName, (BComplex)supervisorSch, cx);
            } else {
                parent.add(scheduleName, (BValue)supervisorSch, cx);
            }
            job.log().success(this.getType().getModule().getModuleName(), "schExportDevExt.addedSch", supervisorSch.toPathString());
        } else if (this.getOverrideSupervisorId()) {
            this.registerTarget(supervisorSch.getParent().asComponent(), (BComplex)supervisorSch);
        }
        final String supervisorId = importExt.getSupervisorId();
        IFilter filter = new IFilter(){

            public boolean accept(Object obj) {
                BNiagaraScheduleExport export;
                return obj instanceof BNiagaraScheduleExport && (export = (BNiagaraScheduleExport)obj).getSupervisorId().equals(supervisorId);
            }
        };
        BNiagaraScheduleExport supervisorExp = (BNiagaraScheduleExport)NiagaraVirtualUtil.findInstance((BComponent)this.getTargetParent(), (IFilter)filter, (Type)BNiagaraScheduleExport.TYPE);
        supervisorExp.setString(BNiagaraScheduleExport.supervisorId, supervisorId, cx);
        supervisorExp.getExecutionTime().set(BTimeTrigger.triggerMode, (BValue)this.getExportExecutionTime(), cx);
        String name = supervisorExp.getName();
        if (name == null) {
            name = BScheduleExportTag.getUniqueName(this.getTargetParent(), supervisorSch.getName() + "Export");
        }
        this.addTarget(name, (BComplex)supervisorExp, cx);
        importExt.setBoolean(BNiagaraScheduleImportExt.enabled, true, cx);
        importExt.invoke(BNiagaraScheduleImportExt.execute, null, cx);
    }

    private BNiagaraStation findNiagaraStation(BComplex c) {
        if (c == null) {
            return null;
        }
        if (c instanceof BNiagaraStation) {
            return (BNiagaraStation)c;
        }
        return this.findNiagaraStation(c.getParent());
    }
}

