/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.exporttags;

import com.tridium.authn.AuthenticationClient;
import com.tridium.exporttags.BJoinJob;
import com.tridium.exporttags.BJoinProfile;
import com.tridium.exporttags.BSubordinateExportTagNetworkExt;
import com.tridium.exporttags.util.BConnectInfo;
import com.tridium.exporttags.util.ExportTagException;
import com.tridium.fox.session.IncompatibleVersionException;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BPointChannel;
import java.security.AccessController;
import javax.baja.collection.BITable;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIUserCredentials;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.BFormat;

@NiagaraType
public final class BSubordinateJoinJob
extends BJoinJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BSubordinateJoinJob.class);
    private BJoinProfile profile;
    private static final String interest = "subordinateJoinJob";
    private static final String moduleName = TYPE.getModule().getModuleName();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BSubordinateJoinJob() {
    }

    public BSubordinateJoinJob(BSubordinateExportTagNetworkExt ext, BJoinProfile profile) {
        this.setLogLimit(ext.getLogLimit());
        this.profile = profile;
    }

    @Override
    protected void postAsync() {
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        network.getWorkers().process((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Context cx) throws Exception {
        int port;
        BUserService userSrv;
        BUser user;
        if (!this.isAlive()) {
            return;
        }
        if (this.profile.getStatus().isDisabled()) {
            throw new ExportTagException("subordinateJoinJob.profileDisabled");
        }
        this.log().success(moduleName, "subordinateJoinJob.starting");
        BJobService srv = (BJobService)Sys.getService((Type)BJobService.TYPE);
        for (BSubordinateJoinJob job : (BSubordinateJoinJob[])srv.getChildren(BSubordinateJoinJob.class)) {
            if (job == this || !job.getJobState().isComplete()) continue;
            srv.remove((BComplex)job);
        }
        String defaultUserName = "";
        BPassword defaultPassword = BPassword.DEFAULT;
        if (this.profile.getDefaultUser().length() > 0 && (user = (userSrv = (BUserService)Sys.getService((Type)BUserService.TYPE)).getUser(this.profile.getDefaultUser())) != null) {
            defaultUserName = user.getName();
            defaultPassword = BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)this.profile.getDefaultUserPassword()).getValue()));
            this.log().success(moduleName, "subordinateJoinJob.foundDefaultUser", defaultUserName);
        }
        BConnectInfo info = new BConnectInfo();
        info.setStationName(Sys.getStation().getStationName());
        info.setCredentials((BIUserCredentials)new BUsernameAndPassword(defaultUserName, defaultPassword));
        BNiagaraNetwork network = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        String addr = "";
        if (this.profile.getDefaultIpAddress().getFormat().length() > 0) {
            addr = this.profile.getDefaultIpAddress().format((Object)network);
        }
        info.setHostOrd(addr.length() > 0 ? BOrd.make((String)("ip:" + addr)) : BOrd.NULL);
        boolean useFoxs = this.profile.getDefaultUseFoxs();
        info.setUseFoxs(useFoxs);
        if (useFoxs) {
            port = 4911;
            try {
                port = Integer.parseInt(this.profile.getDefaultFoxsPort().format((Object)network));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            port = 1911;
            try {
                port = Integer.parseInt(this.profile.getDefaultPort().format((Object)network));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        info.setPort(port);
        if (!this.isAlive()) {
            return;
        }
        BNiagaraStation supervisorStation = this.profile.getSupervisorStation();
        this.log().success(moduleName, "subordinateJoinJob.foundSupervisorStation", supervisorStation.getDisplayName(null));
        BFoxSession session = (BFoxSession)BFoxSession.make((BHost)((BHost)supervisorStation.getAddress().get()), (int)supervisorStation.getFoxPort(), (boolean)supervisorStation.getClientConnection().getUseFoxs(), (BIUserCredentials)supervisorStation.getClientConnection().getCredentials());
        BPointChannel pointChannel = (BPointChannel)session.getConnection().getChannels().get("point", BPointChannel.TYPE);
        BDataChannel dataChannel = (BDataChannel)session.getConnection().getChannels().get("data", BDataChannel.TYPE);
        String sessionInterest = "subordinateJoinJob_" + this.toPathString();
        try {
            session.getConnection().setAuthenticationClient((AuthenticationClient)session.getConnection());
            session.engageNoRetry(sessionInterest);
            if (session.getConnection().session().isLegacyConnection()) {
                this.log().failed(moduleName, "subordinateJoinJob.incompatibleVersion", new String[]{supervisorStation.getStationName(), supervisorStation.getAddress().toString(), String.valueOf(supervisorStation.getFoxPort())});
                throw new IncompatibleVersionException("Niagara4 station cannot join NiagaraAX station");
            }
            this.log().success(moduleName, "subordinateJoinJob.madeConnection", new String[]{supervisorStation.getStationName(), supervisorStation.getAddress().toString(), String.valueOf(supervisorStation.getFoxPort())});
            if (!this.isAlive()) {
                return;
            }
            this.setCurrentProgress(BFormat.getLexiconPattern((String)this.getType().getModule().getModuleName(), (String)"subordinateJoinJob.connectedToSupervisor", null));
            BOrd superJobOrd = (BOrd)BSubordinateJoinJob.invokeAction(pointChannel, BOrd.make((String)"service:exportTags:SupervisorExportTagNetworkExt"), "joinStation", (BValue)info);
            this.log().success(moduleName, "subordinateJoinJob.launchedSupJoin");
            if (!this.isAlive()) {
                return;
            }
            this.log().success(moduleName, "subordinateJoinJob.trackingSup");
            BJobState jobState = BJobState.running;
            while (!jobState.isComplete()) {
                Thread.sleep(1000L);
                BComponent jobInfo = (BComponent)BSubordinateJoinJob.invokeAction(pointChannel, superJobOrd, "queryJoinJobInfo", null);
                jobState = (BJobState)jobInfo.get("jobState");
                this.setCurrentProgress(jobInfo.get("currentProgress").toString());
                if (this.isAlive()) continue;
                return;
            }
            JobLog log = BJoinJob.createJobLog((BITable)dataChannel.resolve(BJoinJob.createExportJobToTableOrd(superJobOrd), new String[0]));
            for (JobLogItem item : log.getItems()) {
                String msg = BFormat.getLexiconPattern((String)moduleName, (String)"subordinateJoinJob.supervisor", null) + ": " + item.getMessagePattern();
                this.log().add(new JobLogItem(item.getId(), item.getTimestamp(), msg, item.getDetailsPattern()));
            }
            this.log().message(moduleName, "subordinateJoinJob.finishedTracking");
            if (jobState == BJobState.failed) {
                throw new ExportTagException("subordinateJoinJob.supJoinFailed");
            }
            if (jobState == BJobState.canceled) {
                this.cancel();
            }
        }
        finally {
            session.disengage(sessionInterest);
        }
    }

    private static BValue invokeAction(BPointChannel pointChannel, BOrd componentOrd, String actionName, BValue arg) throws Exception {
        return pointChannel.invoke(componentOrd.encodeToString(), actionName, arg);
    }
}

