/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tunnel;

import com.tridium.tunnel.TunnelConst;
import com.tridium.tunnel.TunnelUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Arrays;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tunnelName", type="String", defaultValue="test"), @NiagaraProperty(name="tunnelServer", type="String", defaultValue="127.0.0.1"), @NiagaraProperty(name="tunnelUserName", type="String", defaultValue="admin"), @NiagaraProperty(name="tunnelPassword", type="String", defaultValue=""), @NiagaraProperty(name="lastRead", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="lastWrite", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=3), @NiagaraProperty(name="txData", type="String", defaultValue="do do do de da da da"), @NiagaraProperty(name="rxData", type="String", defaultValue="")})
@NiagaraActions(value={@NiagaraAction(name="connect", flags=16), @NiagaraAction(name="sendData", flags=16), @NiagaraAction(name="disconnect", flags=16), @NiagaraAction(name="pingConnections", flags=20)})
public class BTestClient
extends BComponent
implements TunnelConst {
    @Generated
    public static final Property tunnelName = BTestClient.newProperty((int)0, (String)"test", null);
    @Generated
    public static final Property tunnelServer = BTestClient.newProperty((int)0, (String)"127.0.0.1", null);
    @Generated
    public static final Property tunnelUserName = BTestClient.newProperty((int)0, (String)"admin", null);
    @Generated
    public static final Property tunnelPassword = BTestClient.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property lastRead = BTestClient.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property lastWrite = BTestClient.newProperty((int)3, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property txData = BTestClient.newProperty((int)0, (String)"do do do de da da da", null);
    @Generated
    public static final Property rxData = BTestClient.newProperty((int)0, (String)"", null);
    @Generated
    public static final Action connect = BTestClient.newAction((int)16, null);
    @Generated
    public static final Action sendData = BTestClient.newAction((int)16, null);
    @Generated
    public static final Action disconnect = BTestClient.newAction((int)16, null);
    @Generated
    public static final Action pingConnections = BTestClient.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTestClient.class);
    private Object writeMutex = new Object();
    private Clock.Ticket pingTicket;
    DataInputStream in;
    DataOutputStream out;

    @Generated
    public String getTunnelName() {
        return this.getString(tunnelName);
    }

    @Generated
    public void setTunnelName(String v) {
        this.setString(tunnelName, v, null);
    }

    @Generated
    public String getTunnelServer() {
        return this.getString(tunnelServer);
    }

    @Generated
    public void setTunnelServer(String v) {
        this.setString(tunnelServer, v, null);
    }

    @Generated
    public String getTunnelUserName() {
        return this.getString(tunnelUserName);
    }

    @Generated
    public void setTunnelUserName(String v) {
        this.setString(tunnelUserName, v, null);
    }

    @Generated
    public String getTunnelPassword() {
        return this.getString(tunnelPassword);
    }

    @Generated
    public void setTunnelPassword(String v) {
        this.setString(tunnelPassword, v, null);
    }

    @Generated
    public BAbsTime getLastRead() {
        return (BAbsTime)this.get(lastRead);
    }

    @Generated
    public void setLastRead(BAbsTime v) {
        this.set(lastRead, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastWrite() {
        return (BAbsTime)this.get(lastWrite);
    }

    @Generated
    public void setLastWrite(BAbsTime v) {
        this.set(lastWrite, (BValue)v, null);
    }

    @Generated
    public String getTxData() {
        return this.getString(txData);
    }

    @Generated
    public void setTxData(String v) {
        this.setString(txData, v, null);
    }

    @Generated
    public String getRxData() {
        return this.getString(rxData);
    }

    @Generated
    public void setRxData(String v) {
        this.setString(rxData, v, null);
    }

    @Generated
    public void connect() {
        this.invoke(connect, null, null);
    }

    @Generated
    public void sendData() {
        this.invoke(sendData, null, null);
    }

    @Generated
    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    @Generated
    public void pingConnections() {
        this.invoke(pingConnections, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property property, Context context) {
        if (property == txData && this.out != null) {
            this.doSendData();
        }
    }

    public void doConnect() {
        System.out.println("doConnect()");
        try (Socket s = new Socket(InetAddress.getByName(this.getTunnelServer()), 9973);){
            boolean forceBreak = false;
            this.in = new DataInputStream(s.getInputStream());
            this.out = new DataOutputStream(s.getOutputStream());
            this.out.write(MAGIC);
            this.out.write(13);
            this.out.write(1);
            String str = this.getTunnelUserName();
            byte[] bytes = str.getBytes("UTF-8");
            this.out.writeInt(bytes.length);
            this.out.write(bytes);
            str = this.getTunnelPassword();
            bytes = str.getBytes("UTF-8");
            this.out.writeInt(bytes.length);
            this.out.write(bytes);
            str = this.getTunnelName();
            System.out.println("requesting tunnel: " + str);
            bytes = str.getBytes("UTF-8");
            this.out.writeInt(bytes.length);
            this.out.write(bytes);
            int msgType = 0;
            while (msgType != 23 && msgType != 37 && !forceBreak) {
                msgType = 0;
                msgType = TunnelUtils.readMessage(this.in, "client");
                this.setLastRead(Clock.time());
                System.out.println("doConnect() 9");
                switch (msgType) {
                    case 11: {
                        System.out.println("MSG_DATA");
                        int len = this.in.readInt();
                        System.out.println("rec length=" + len);
                        byte[] buf = new byte[len];
                        this.in.readFully(buf);
                        this.setRxData(new String(buf));
                        System.out.println("***************");
                        System.out.println(new String(buf));
                        break;
                    }
                    case 13: {
                        System.out.println("MSG_HELLO");
                        break;
                    }
                    case 17: {
                        System.out.println("MSG_READY");
                        this.startPing();
                        break;
                    }
                    case 19: {
                        System.out.println("MSG_PING");
                        break;
                    }
                    case 23: {
                        System.out.println("MSG_DISCONNECT");
                        this.stopPing();
                        break;
                    }
                    case 29: {
                        System.out.println("MSG_AUTH_FAIL");
                        break;
                    }
                    case 31: {
                        System.out.println("MSG_UNKNOWN_TUNNEL");
                        break;
                    }
                    case 37: {
                        System.out.println("MSG_TUNNEL_BUSY");
                        break;
                    }
                    case 41: {
                        System.out.println("MSG_UNSUPPORTED_PROTOCOL_VERSION");
                        break;
                    }
                    case 43: {
                        System.out.println("MSG_EXPECTING_HELLO");
                        break;
                    }
                    default: {
                        System.out.println("received message type illegal: " + msgType);
                        byte[] junkBytes = new byte[1024];
                        try {
                            if (this.in.available() > 0) {
                                this.in.readFully(junkBytes);
                                System.out.println("junkBytes:" + ByteArrayUtil.toHexString((byte[])junkBytes));
                            }
                        }
                        catch (SocketException e) {
                            System.out.println("no msgType match 1: " + e);
                            forceBreak = true;
                            break;
                        }
                        catch (Exception e) {
                            System.out.println("n0 msgTypeMatch 2:" + e);
                            e.printStackTrace();
                        }
                        forceBreak = true;
                    }
                }
                try {
                    Thread.sleep(500L);
                }
                catch (Exception e) {
                    System.out.println("thread sleep exception:" + e);
                    break;
                }
            }
            System.out.println("closing socket");
            this.stopPing();
        }
        catch (Exception x) {
            System.out.println("doConnect exception:" + x);
            x.printStackTrace();
            this.stopPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSendData() {
        System.out.println("doSendData()");
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(MAGIC);
                this.out.write(11);
                String dataString = this.getTxData();
                if (!dataString.startsWith("&")) {
                    dataString = dataString + "\n";
                }
                byte[] data = dataString.getBytes();
                this.out.writeInt(data.length);
                this.out.write(data, 0, data.length);
                System.out.println("   length=" + data.length);
                System.out.println("   data  =" + Arrays.toString(data));
                this.setLastWrite(Clock.time());
                this.out.flush();
            }
        }
        catch (IOException x) {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDisconnect() {
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(MAGIC);
                this.out.write(23);
                this.out.flush();
            }
        }
        catch (Exception x) {
            System.out.println(x);
            x.printStackTrace();
        }
        this.stopPing();
    }

    public IFuture post(Action a, BValue arg, Context cx) {
        if (a == connect) {
            new Thread(){

                @Override
                public void run() {
                    BTestClient.this.doConnect();
                }
            }.start();
            return null;
        }
        return super.post(a, arg, cx);
    }

    protected void startPing() {
        System.out.println("startPing()");
        if (this.pingTicket != null) {
            return;
        }
        this.pingTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)15000L), (Action)pingConnections, null);
    }

    protected void stopPing() {
        System.out.println("stopPing()");
        if (this.pingTicket == null) {
            return;
        }
        this.pingTicket.cancel();
        this.pingTicket = null;
    }

    public void doPingConnections() {
        System.out.println("doPingConnections()");
        long now = System.currentTimeMillis();
        if (this.getLastRead().getMillis() + 60000L < now) {
            System.out.println("Disconnecting idle connection ");
            this.disconnect();
        } else if (this.getLastWrite().getMillis() + 15000L < now) {
            this.sendPing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendPing() {
        System.out.println("sendPing()");
        try {
            Object object = this.writeMutex;
            synchronized (object) {
                this.out.write(MAGIC);
                this.out.write(19);
                this.setLastWrite(Clock.time());
                this.out.flush();
            }
        }
        catch (IOException x) {
            this.disconnect();
        }
    }
}

