/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.util;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.nre.security.SecretChars;
import com.tridiumx.nacDriver.BNACHttpCommConfig;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.firmware.BNACFirmwareInstance;
import com.tridiumx.nacDriver.firmware.BNACFirmwareInstanceContainer;
import com.tridiumx.nacDriver.message.NACServerAuthenticateRequest;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BINACIOControlPoint;
import com.tridiumx.nacDriver.replicate.BCardPinTemplate;
import com.tridiumx.nacDriver.util.Utils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.baja.file.BIFile;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.security.BUsernameAndPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class NACRequestUtils {
    public static boolean authenticateToServer(BNACNetwork network) {
        if (network.log().isLoggable(Level.FINE)) {
            network.log().log(Level.FINE, "Starting server authentication");
        }
        BIpAddress ipAddress = network.getHttpConfig().getAddress();
        BUsernameAndPassword usernameAndPassword = network.getNACServerDetails().getCredentials();
        NACServerAuthenticateRequest serverAuthenticateRequest = new NACServerAuthenticateRequest(ipAddress, usernameAndPassword);
        try {
            String response = new String(network.sendHttpRequest(serverAuthenticateRequest).getData());
            JSONObject responseJson = new JSONObject(response);
            if (!responseJson.getBoolean("authenticated")) {
                String ex = responseJson.has("notAuthenticatedReasonText") ? responseJson.getString("notAuthenticatedReasonText") : "Unknown Exception";
                throw new Exception(ex);
            }
            NACRequestUtils.terminateSession(network, network.getSessionToken());
            NACRequestUtils.updateSessionDetails(network, responseJson);
            if (network.log().isLoggable(Level.FINE)) {
                network.log().log(Level.FINE, "Server authentication successful");
            }
            NACRequestUtils.updateTimeoutExempt(network);
            return true;
        }
        catch (Exception e) {
            network.getHttpConfig().setFaultCause(BNACNetwork.LEX.get("server.authentication.failure"));
            Utils.logException(network.log(), e, Level.SEVERE);
            return false;
        }
    }

    public static void setUnidOnCardTemplateFromNACServer(BNACNetwork BNACNetwork2) {
        JSONArray credTemplateInsertArray;
        JSONObject multiDbChangeResultObject;
        BCardPinTemplate credTemplate = BNACNetwork2.getCardPinTemplate();
        AtomicInteger operationIndex = new AtomicInteger();
        StringBuilder credTemplateBody = credTemplate.getUnid() == 0 ? NACRequestUtils.createStringBodyForCredTemplate("Entsec Card Pin Template", operationIndex, "name", "credTemplateInsert", true).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate("UNIQUE_PIN", operationIndex, "tag", "credTemplateInsert", false)).append((CharSequence)NACRequestUtils.createStringBodyForCommonCredTemplateProperties("credTemplateInsert", operationIndex, credTemplate)) : NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getUnid()), operationIndex, "unid", "credTemplateUpdate", true).append((CharSequence)NACRequestUtils.createStringBodyForCommonCredTemplateProperties("credTemplateUpdate", operationIndex, credTemplate));
        JSONObject responseObject = NACRequestUtils.executeMultiDbChange(credTemplateBody.toString(), BNACNetwork2);
        JSONObject credTemplateInstance = null;
        if (responseObject.has("multiDbChangeResult") && (multiDbChangeResultObject = responseObject.getJSONObject("multiDbChangeResult")).has("credTemplateInsert") && !(credTemplateInsertArray = multiDbChangeResultObject.getJSONArray("credTemplateInsert")).isEmpty()) {
            credTemplateInstance = credTemplateInsertArray.getJSONObject(0);
        }
        if (credTemplateInstance != null && credTemplateInstance.has("unid")) {
            credTemplate.setUnid(credTemplateInstance.getInt("unid"));
        }
    }

    private static StringBuilder createStringBodyForCommonCredTemplateProperties(String operationType, AtomicInteger operationIndex, BCardPinTemplate credTemplate) {
        StringBuilder credTemplateBody = NACRequestUtils.createStringBodyForCredTemplate("true", operationIndex, "cardPinTemplate.pinUnique", operationType, false).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getMinPinLength()), operationIndex, "cardPinTemplate.minPinLength", operationType, false)).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getMaxPinLength()), operationIndex, "cardPinTemplate.maxPinLength", operationType, false)).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getAuthorizationCodePresence()), operationIndex, "cardPinTemplate.authorizationCodePresence", operationType, false)).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getCredComponentPresence()), operationIndex, "cardPinTemplate.credComponentPresence", operationType, false)).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getCredNumPresence()), operationIndex, "cardPinTemplate.credNumPresence", operationType, false)).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate(String.valueOf(credTemplate.getPinPresence()), operationIndex, "cardPinTemplate.pinPresence", operationType, false)).append((CharSequence)NACRequestUtils.createStringBodyForCredTemplate("0", operationIndex, "allowedPrivTypes", operationType, false));
        return credTemplateBody;
    }

    private static JSONObject executeMultiDbChange(String body, BNACNetwork BNACNetwork2) {
        return AccessController.doPrivileged(() -> {
            try {
                return NACRequestUtils.executeMultiDbChangePublic(body, BNACNetwork2);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static JSONObject executeMultiDbChangePublic(String body, BNACNetwork BNACNetwork2) throws Exception {
        String uri = "/executeMultiDbChange";
        NACServerTokenRequest request = new NACServerTokenRequest(BNACNetwork2.getHttpConfig().getAddress(), "POST", uri, BNACNetwork2.getSessionToken());
        request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
        request.setData(body);
        String response = new String(BNACNetwork2.sendHttpRequest(request).getData());
        return new JSONObject(response);
    }

    private static StringBuilder createStringBodyForCredTemplate(String value, AtomicInteger operationIndex, String key, String operationType, boolean isFirstRequest) {
        StringBuilder credTemplateBody = new StringBuilder();
        if (!isFirstRequest) {
            credTemplateBody.append("&");
        }
        credTemplateBody.append(operationType).append("[").append(operationIndex).append("].").append(key).append("=").append(value);
        return credTemplateBody;
    }

    private static void updateTimeoutExempt(BNACNetwork network) {
        try {
            ArrayList<Integer> timeoutExemptionPendingIds = NACRequestUtils.getTimeoutNotExemptedForRolesList(network);
            if (timeoutExemptionPendingIds.size() != 0) {
                NACRequestUtils.exemptTimeoutForRoles(network, timeoutExemptionPendingIds);
                NACRequestUtils.authenticateToServer(network);
            }
        }
        catch (Exception e) {
            Utils.logException(network.log(), e, Level.WARNING);
        }
    }

    private static void updateSessionDetails(BNACNetwork network, JSONObject authResponse) throws IOException {
        network.setSessionToken(BPassword.make((String)authResponse.getString("sessionToken")));
        network.getNACServerDetails().setSessionTimeLeft(authResponse.getInt("sessionRemainingSecs"));
        network.getNACServerDetails().setLastAuthenticationTime(BAbsTime.make((String)authResponse.getString("dateTime")));
        network.getNACServerDetails().setVersion(authResponse.getString("softwareVersion"));
        network.getNACServerDetails().setVersionTimestamp(authResponse.getString("softwareVersionTimestamp"));
        network.getHttpConfig().setFaultCause("");
    }

    private static void exemptTimeoutForRoles(BNACNetwork network, ArrayList<Integer> timeoutExemptionPendingIds) throws Exception {
        for (Integer id : timeoutExemptionPendingIds) {
            String uri = "/appPriv/update/" + id;
            NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", uri, network.getSessionToken());
            String body = "appAccessModifiers.timeoutExempt=true";
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body);
            String response = new String(network.sendHttpRequest(request).getData());
            JSONObject responseJson = new JSONObject(response);
            JSONObject appPriv = responseJson.getJSONObject("instance");
            if (appPriv.has("appAccessModifiers")) {
                JSONObject appAccessModifiers = appPriv.getJSONObject("appAccessModifiers");
                if (!appAccessModifiers.has("timeoutExempt") || !appAccessModifiers.getBoolean("timeoutExempt")) {
                    throw new Exception("Unable to update AppPriv with unid " + id);
                }
                if (!network.log().isLoggable(Level.FINE)) continue;
                network.log().log(Level.FINE, "Updated exempt timeout to true for AppPriv with unid " + id);
                continue;
            }
            throw new Exception("Unable to update AppPriv with unid " + id);
        }
    }

    private static ArrayList<Integer> getTimeoutNotExemptedForRolesList(BNACNetwork network) throws Exception {
        NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", "/appPriv/list", network.getSessionToken());
        try {
            ArrayList<Integer> returnVal = new ArrayList<Integer>();
            String response = new String(network.sendHttpRequest(request).getData());
            JSONObject responseJson = new JSONObject(response);
            JSONArray instanceList = responseJson.getJSONArray("instanceList");
            for (Object instance : instanceList) {
                JSONObject appPriv = (JSONObject)instance;
                if (!appPriv.has("appAccessModifiers")) {
                    returnVal.add(appPriv.getInt("unid"));
                    continue;
                }
                JSONObject appAccessModifiers = appPriv.getJSONObject("appAccessModifiers");
                if (appAccessModifiers.has("timeoutExempt") && appAccessModifiers.getBoolean("timeoutExempt")) continue;
                returnVal.add(appPriv.getInt("unid"));
            }
            return returnVal;
        }
        catch (Exception e) {
            throw new Exception("Timeout Exemption check failed");
        }
    }

    public static void terminateSession(BNACNetwork network, BPassword sessionToken) {
        block6: {
            if (sessionToken == null) {
                if (network.log().isLoggable(Level.FINE)) {
                    network.log().log(Level.FINE, "No session to terminate");
                }
                return;
            }
            NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", "/terminate", sessionToken);
            try {
                String response = new String(network.sendHttpRequest(request).getData());
                JSONObject responseJson = new JSONObject(response);
                if (!responseJson.isEmpty()) {
                    throw new Exception();
                }
                if (network.log().isLoggable(Level.FINE)) {
                    network.log().log(Level.FINE, "Session closed successfully");
                }
            }
            catch (Exception e) {
                if (!network.log().isLoggable(Level.FINE)) break block6;
                network.log().log(Level.FINE, "Session does not exist");
            }
        }
    }

    public static void addNewDevice(BNACNetwork network, BNACDevice device) {
        NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "POST", "/dev/saveFromTemplate", network.getSessionToken());
        request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
        try {
            request.setData(NACRequestUtils.getSaveDeviceBody(device));
            String response = new String(network.sendHttpRequest(request).getData());
            JSONObject responseJson = new JSONObject(response);
            JSONObject instance = (JSONObject)responseJson.get("instance");
            device.storeMapping(instance.getInt("unid"));
            device.syncChildren(instance);
            device.syncToServer();
        }
        catch (Exception e) {
            Utils.logException(network.log(), e, Level.SEVERE);
        }
    }

    private static String getSaveDeviceBody(BNACDevice device) throws Exception {
        return "type=" + device.getDevTemplateType() + "&" + "name" + "=" + device.getName() + "&" + "address" + "=" + device.getIpAddress() + "&" + "port" + "=" + device.getPort() + "&" + "devMod" + "=" + device.getDevMod() + "&" + "devInitiatesConnection" + "=" + true + "&" + "devModConfigType" + "=" + 13 + "&" + "devModConfig.takeover" + "=" + true;
    }

    public static void removeDevice(BNACNetwork network, String unid) throws Exception {
        NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", "/dev/delete/" + unid, network.getSessionToken());
        String response = new String(network.sendHttpRequest(request).getData());
        JSONObject responseJson = new JSONObject(response);
        if (!responseJson.isEmpty()) {
            throw new Exception("Device removal from server failed");
        }
    }

    public static JSONObject listResources(BNACNetwork network, String resource, int propertyFilter) throws Exception {
        NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", "/" + resource + "/list?propertyFilter=" + propertyFilter, network.getSessionToken());
        String response = new String(network.sendHttpRequest(request).getData());
        return new JSONObject(response);
    }

    public static JSONObject showResource(BNACNetwork network, String resource, String identity, int propertyFilter) throws Exception {
        String uri = "/" + resource + "/show/" + identity + "?propertyFilter=" + propertyFilter;
        NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", uri, network.getSessionToken());
        String response = new String(network.sendHttpRequest(request).getData());
        return new JSONObject(response);
    }

    public static void syncDeviceName(BNACNetwork network, String unid, String name) {
        Utils.checkNACPermission();
        network.postAsync(() -> {
            if (unid.equals("")) {
                return;
            }
            String uri = "/dev/update/" + unid;
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", uri, network.getSessionToken()));
            String body = "name=" + name;
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body);
            try {
                network.sendHttpRequest(request);
            }
            catch (Exception e) {
                Utils.logException(network.log(), e, Level.WARNING);
            }
        });
    }

    public static JSONObject discoverDevice(BNACNetwork network) throws Exception {
        NACServerTokenRequest request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", "/dev/discovery", network.getSessionToken());
        String response = new String(network.sendHttpRequest(request).getData());
        return new JSONObject(response);
    }

    public static void setDoorManualCommands(BNACNetwork network, String accessModeTypeValue, int durationInMinutes, String unid, Boolean untilCancelled) throws Exception {
        NACServerTokenRequest request;
        String response;
        JSONObject responseJson;
        StringBuilder uri = new StringBuilder("/json/doorModeChange?").append("unid=").append(unid).append("&value=").append(accessModeTypeValue);
        if (!accessModeTypeValue.equals("RESET") && !untilCancelled.booleanValue()) {
            uri.append("&durationSecs=").append(durationInMinutes * 60);
        }
        if (!(responseJson = new JSONObject(response = new String(network.sendHttpRequest(request = new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", uri.toString(), network.getSessionToken())).getData()))).isEmpty()) {
            throw new Exception("Unable to set Door Manual Access Mode");
        }
    }

    public static void addNewReader(BNACNetwork network, BNACReader reader) {
        String body = reader.getAddToServerBody();
        if (body == null || body.isEmpty()) {
            return;
        }
        JSONObject response = NACRequestUtils.executeMultiDbChange(body, network);
        int unid = response.getJSONObject("multiDbChangeResult").getJSONArray("devInsert").getJSONObject(0).getInt("unid");
        reader.storeMapping(unid);
    }

    public static void addNewIOPoint(BNACNetwork network, BINACIOControlPoint point) {
        String body = point.getAddToServerBody();
        if (body == null || body.isEmpty()) {
            return;
        }
        JSONObject response = NACRequestUtils.executeMultiDbChange(body, network);
        int unid = response.getJSONObject("multiDbChangeResult").getJSONArray("devInsert").getJSONObject(0).getInt("unid");
        point.storeMapping(unid);
    }

    public static void addNewDoor(BNACNetwork network, BNACDoor door) {
        String body = door.getAddToServerBody();
        if (body == null || body.isEmpty()) {
            return;
        }
        JSONObject response = NACRequestUtils.executeMultiDbChange(body, network);
        int unid = response.getJSONObject("multiDbChangeResult").getJSONArray("devInsert").getJSONObject(0).getInt("unid");
        door.storeMapping(unid);
    }

    public static JSONObject deleteFirmwareInstanceFromServer(int unid, BNACNetwork nacNetwork) throws Exception {
        String uri = "/softwareUpdate/delete/" + unid;
        return NACRequestUtils.executeMultiDbChangeWithParam(uri, "POST", nacNetwork, "");
    }

    private static JSONObject executeMultiDbChangeWithParam(String uri, String method, BNACNetwork nacNetwork, String body) throws Exception {
        try {
            return AccessController.doPrivileged(() -> NACRequestUtils.executeServerRequestWithParamPublic(uri, method, nacNetwork, body));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    public static JSONObject executeServerRequestWithParamPublic(String uri, String method, BNACNetwork nacNetwork, String body) throws Exception {
        NACServerTokenRequest request = new NACServerTokenRequest(nacNetwork.getHttpConfig().getAddress(), method, uri, nacNetwork.getSessionToken());
        request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
        if (!body.equals("")) {
            request.setData(body);
        }
        String response = new String(nacNetwork.sendHttpRequest(request).getData());
        return new JSONObject(response);
    }

    public static String getFirmwareUpdateInstanceCreationBody(String baseFileName, String fileName) {
        StringBuilder firmwareUpdateBody = new StringBuilder();
        firmwareUpdateBody.append("devMod=155&devPlatform=31&devType=1&").append("filename=").append(fileName).append("&").append("name=").append(baseFileName);
        return firmwareUpdateBody.toString();
    }

    public static JSONObject getFirmwareUpdateInstanceUnid(BNACNetwork nacNetwork, String body) throws Exception {
        String uri = "/softwareUpdate/save/";
        return NACRequestUtils.executeMultiDbChangeWithParam(uri, "POST", nacNetwork, body);
    }

    public static JSONObject storeFirmwareFileOnServer(BNACNetwork nacNetwork, int unid, String fileName, BIFile file) throws Exception {
        return NACRequestUtils.executeServerRequestWithFile("/softwareUpdate/storeFileData/" + unid, "POST", nacNetwork, fileName, file);
    }

    private static JSONObject executeServerRequestWithFile(String uri, String method, BNACNetwork nacNetwork, String fileName, BIFile file) throws Exception {
        try {
            return AccessController.doPrivileged(() -> NACRequestUtils.executeServerRequestWithFilePublic(uri, method, nacNetwork, fileName, file));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject executeServerRequestWithFilePublic(String uri, String method, BNACNetwork nacNetwork, String fileName, BIFile file) throws Exception {
        HttpURLConnection connection = null;
        JSONObject response = new JSONObject();
        try {
            connection = NACRequestUtils.openConnection(nacNetwork, uri);
            connection.setRequestMethod(method);
            connection.setDoOutput(true);
            String boundary = "---------------------------" + System.currentTimeMillis();
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (SecretChars token = new SecretChars(AccessController.doPrivileged(() -> ((BPassword)nacNetwork.getSessionToken()).getValue()).toCharArray(), false);){
                connection.setRequestProperty("sessionToken", token.asString(true));
            }
            StringBuilder formDataBuilder = new StringBuilder();
            formDataBuilder.append("--").append(boundary).append("\r\n");
            formDataBuilder.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + fileName + "\"\r\n");
            formDataBuilder.append("Content-Type: application/octet-stream\r\n\r\n");
            byte[] formDataBytes = formDataBuilder.toString().getBytes();
            try (OutputStream output = connection.getOutputStream();
                 FileInputStream fileInputStream = (FileInputStream)file.getInputStream();){
                int bytesRead;
                output.write(formDataBytes);
                byte[] buffer = new byte[4096];
                while ((bytesRead = fileInputStream.read(buffer)) != -1) {
                    output.write(buffer, 0, bytesRead);
                }
                output.write(("\r\n--" + boundary + "--\r\n").getBytes());
            }
            response = NACRequestUtils.getResponseFromServerRequest(connection, nacNetwork);
        }
        catch (IOException ex) {
            nacNetwork.getLogger().log(Level.SEVERE, "Connection is not secured." + ex.getMessage());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return response;
    }

    public static JSONObject getResponseFromServerRequest(HttpURLConnection connection, BNACNetwork nacNetwork) throws IOException {
        JSONObject response = new JSONObject();
        int responseCode = connection.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String line;
                StringBuilder responseStr = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    responseStr.append(line);
                }
                response = new JSONObject(responseStr.toString());
            }
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
            String line;
            StringBuilder errorResponse = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                errorResponse.append(line);
            }
            nacNetwork.getLogger().log(Level.SEVERE, "Error Response Data: " + errorResponse);
        }
        return response;
    }

    public static HttpURLConnection openConnection(BNACNetwork nacNetwork, String uri) throws IOException {
        HttpURLConnection connection = null;
        BIpAddress ipAdr = nacNetwork.getHttpConfig().getAddress();
        BNACHttpCommConfig httpConn = nacNetwork.getHttpConfig();
        if (httpConn != null) {
            if (httpConn.getUseTls()) {
                URL url = new URL("https://" + ipAdr.getIpAddress() + ":" + ipAdr.getPort() + uri);
                connection = (HttpsURLConnection)url.openConnection();
                SSLSocketFactory defaultFactory = HttpsURLConnection.getDefaultSSLSocketFactory();
                ((HttpsURLConnection)connection).setSSLSocketFactory(defaultFactory);
            } else {
                URL url = new URL("http://" + ipAdr.getIpAddress() + ":" + ipAdr.getPort() + uri);
                connection = (HttpURLConnection)url.openConnection();
            }
        }
        return connection;
    }

    public static BComponent subscribeComponent(BComponent component) {
        if (!component.isSubscribed()) {
            component.lease();
        }
        return component;
    }

    public static JSONObject updateControllerFirmware(BNACDevice nacDevice, int firmwareUnid) throws Exception {
        String uri = nacDevice.getControllerSoftwareUpdateURI(firmwareUnid);
        return NACRequestUtils.executeMultiDbChangeWithParam(uri, "POST", nacDevice.getNACNetwork(), "");
    }

    public static JSONObject rebootController(BNACDevice nacDevice) throws Exception {
        String uri = nacDevice.getControllerRebootURI();
        return NACRequestUtils.executeMultiDbChangeWithParam(uri, "POST", nacDevice.getNACNetwork(), "");
    }

    public static BDynamicEnum loadFirmwareVersionList(BNACNetwork nacNetwork) {
        BNACFirmwareInstanceContainer bnacFirmwareInstanceContainer = (BNACFirmwareInstanceContainer)NACRequestUtils.subscribeComponent((BComponent)nacNetwork.getNACFirmwareInstanceContainer());
        BNACFirmwareInstance[] bnacFirmwareInstances = (BNACFirmwareInstance[])bnacFirmwareInstanceContainer.getChildren(BNACFirmwareInstance.class);
        Comparator<BNACFirmwareInstance> firmwareComparator = Comparator.comparing(BNACFirmwareInstance::getSoftwareUpdateUnid);
        List firmwareInstanceList = Arrays.stream(bnacFirmwareInstances).sorted(firmwareComparator).collect(Collectors.toList());
        String[] tags = new String[firmwareInstanceList.size()];
        int[] ordinals = new int[firmwareInstanceList.size()];
        if (firmwareInstanceList.size() > 0) {
            for (int i = 0; i < firmwareInstanceList.size(); ++i) {
                BNACFirmwareInstance firmwareInstance = (BNACFirmwareInstance)NACRequestUtils.subscribeComponent((BComponent)firmwareInstanceList.get(i));
                if (firmwareInstance.getVersionName().isEmpty() || firmwareInstance.getSoftwareUpdateUnid() == 0) continue;
                String version = firmwareInstance.getVersionName();
                int softwareUpdateUnid = firmwareInstance.getSoftwareUpdateUnid();
                boolean isTagExists = Arrays.asList(tags).contains(version);
                boolean isOrdinalExists = Arrays.asList(new int[][]{ordinals}).contains(softwareUpdateUnid);
                if (!isTagExists && !isOrdinalExists) {
                    tags[i] = SlotPath.escape((String)firmwareInstance.getVersionName());
                    ordinals[i] = firmwareInstance.getSoftwareUpdateUnid();
                    continue;
                }
                nacNetwork.getLogger().log(Level.INFO, "Firmware instance version name " + version + " already exists in the firmware version list");
            }
        }
        return BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((int[])ordinals, (String[])tags));
    }
}

