/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.util;

import com.tridium.nre.security.SecurityInitializer;
import com.tridiumx.nacDriver.util.Utils;
import java.io.File;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.sys.Sys;

public class NACOSDPKeyStoreUtils {
    private static final String TRUST_STORE_NAME = "nacKeyStore";
    public static final Logger LOG = Logger.getLogger("nacDriverKeyStore");

    public static void createBaseDirectory() {
        try {
            AccessController.doPrivileged(() -> {
                if (!NACOSDPKeyStoreUtils.getNACBaseDirectory().exists()) {
                    NACOSDPKeyStoreUtils.getNACBaseDirectory().mkdirs();
                }
                return null;
            });
        }
        catch (Exception e) {
            Utils.logException(LOG, e, Level.SEVERE, "Failed to create nac Base Security Directory");
        }
    }

    public static String getTrustStoreName() {
        return "nacKeyStore." + NACOSDPKeyStoreUtils.getTrustKeysKeyStoreType();
    }

    public static String getTrustKeysKeyStoreType() {
        return SecurityInitializer.getInstance().getCryptoProvider().getDefaultKeyStoreType();
    }

    public static File getNACBaseDirectory() {
        return new File(Sys.getProtectedStationHome(), "nacDriver" + File.separator + "security");
    }

    public static KeyStore createKeyStoreInstance() {
        try {
            return KeyStore.getInstance(NACOSDPKeyStoreUtils.getTrustKeysKeyStoreType());
        }
        catch (Exception e) {
            Utils.logException(LOG, e, Level.SEVERE, "Failed to get required KeyStore Instance");
            return null;
        }
    }

    public static String generateEncryptionKey() {
        byte[] key = new byte[16];
        new SecureRandom().nextBytes(key);
        String hexKey = ByteArrayUtil.toHexString((byte[])key).toUpperCase();
        return Base64.getEncoder().encodeToString(ByteArrayUtil.hexStringToBytes((String)hexKey));
    }
}

