/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.replicate;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.nre.security.SecretChars;
import com.tridium.nre.util.tuple.Pair;
import com.tridium.nre.util.tuple.Triple;
import com.tridium.orion.BAbstractOrionApp;
import com.tridium.orion.BIOrionObject;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridiumx.accessDriver.enums.BEnforcementEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccReaderJoin;
import com.tridiumx.entsec.access.orion.BAccReaderRec;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.access.orion.BAccessZoneRec;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BBadgeStatus;
import com.tridiumx.entsec.access.orion.BEntryReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BExitReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.entsec.access.orion.BPersonAccJoin;
import com.tridiumx.entsec.access.orion.BReaderZoneJoin;
import com.tridiumx.entsec.access.orion.BValidationBits;
import com.tridiumx.entsec.access.orion.BWiegandFormat;
import com.tridiumx.entsec.orionTools.BAppTable;
import com.tridiumx.entsec.orionTools.BEnumScheduleRec;
import com.tridiumx.entsec.orionTools.BMappedEnumScheduleExt;
import com.tridiumx.entsec.orionTools.BScheduleRec;
import com.tridiumx.entsec.orionTools.MappingSupport;
import com.tridiumx.entsec.orionTools.replicate.BDeletion;
import com.tridiumx.entsec.orionTools.replicate.BReplicableObject;
import com.tridiumx.entsec.orionTools.replicate.Replicator;
import com.tridiumx.entsec.securityUtil.BSafeSimpleJob;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelOperationEnum;
import com.tridiumx.entsec.threat.ThreatLevelUtil;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.BNACReplicationNetworkExt;
import com.tridiumx.nacDriver.device.BNACController;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACAccessZone;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACDoorModeSchedule;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BNACPointDeviceExt;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.schedule.BWeekSchedule;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BTime;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.BUuid;
import javax.baja.web.BWebService;

public class NACReplicator<T>
extends Replicator<T> {
    private static final Map<String, Integer> NAC_WEEK_DAYS = new HashMap<String, Integer>(){
        {
            this.put("monday", 0);
            this.put("tuesday", 1);
            this.put("wednesday", 2);
            this.put("thursday", 3);
            this.put("friday", 4);
            this.put("saturday", 5);
            this.put("sunday", 6);
        }
    };
    private BNACNetwork network;
    private static final int MULTI_DB_CHANGE_BATCH_SIZE = 100;
    private static final int SAVE_OBJECT = 0;
    private static final int DELETE_OBJECT = 1;
    private static final OrionType TYPE_W = BWiegandFormat.ORION_TYPE;
    private static final OrionType TYPE_S = BScheduleRec.ORION_TYPE;
    private static final OrionType TYPE_ES = BEnumScheduleRec.ORION_TYPE;
    private static final OrionType TYPE_R = BAccReaderRec.ORION_TYPE;
    private static final OrionType TYPE_A = BAccessRight.ORION_TYPE;
    private static final OrionType TYPE_Z = BAccessZoneRec.ORION_TYPE;
    private static final OrionType TYPE_Z_ENT_R = BEntryReaderZoneJoin.ORION_TYPE;
    private static final OrionType TYPE_Z_EX_R = BExitReaderZoneJoin.ORION_TYPE;
    private static final OrionType TYPE_P = BPerson.ORION_TYPE;
    private static final OrionType TYPE_AR = BAccReaderJoin.ORION_TYPE;
    private static final OrionType TYPE_PA = BPersonAccJoin.ORION_TYPE;
    private static final OrionType TYPE_B = BBadge.ORION_TYPE;
    private static final String APP_TABLE_TYPE_W = BAppTable.getTableName((OrionType)TYPE_W);
    private static final String APP_TABLE_TYPE_S = BAppTable.getTableName((OrionType)TYPE_S);
    private static final String APP_TABLE_TYPE_ES = BAppTable.getTableName((OrionType)TYPE_ES);
    private static final String APP_TABLE_TYPE_R = BAppTable.getTableName((OrionType)TYPE_R);
    private static final String APP_TABLE_TYPE_A = BAppTable.getTableName((OrionType)TYPE_A);
    private static final String APP_TABLE_TYPE_Z = BAppTable.getTableName((OrionType)TYPE_Z);
    private static final String APP_TABLE_TYPE_P = BAppTable.getTableName((OrionType)TYPE_P);
    private static final String APP_TABLE_TYPE_AR = BAppTable.getTableName((OrionType)TYPE_AR);
    private static final String APP_TABLE_TYPE_PA = BAppTable.getTableName((OrionType)TYPE_PA);
    private static final String APP_TABLE_TYPE_Z_ENT_R = BAppTable.getTableName((OrionType)TYPE_Z_ENT_R);
    private static final String APP_TABLE_TYPE_Z_EX_R = BAppTable.getTableName((OrionType)TYPE_Z_EX_R);
    private static final String APP_TABLE_TYPE_B = BAppTable.getTableName((OrionType)TYPE_B);
    private static final String LAST_MODIFIED = BReplicableObject.lastModified.getName();
    private static final String R_UUID = "r." + BAccReaderRec.uuid.getName();
    private static final String Z_UUID = "z." + BAccessZoneRec.uuid.getName();
    private static final String AR_READER = "ar." + BAccReaderJoin.reader.getName();
    private static final String ZR_ZONE = "zr." + BReaderZoneJoin.accessZone.getName();
    private static final String ZR_READER = "zr." + BReaderZoneJoin.reader.getName();
    private static final String AR_ACCESS_RIGHT = "ar." + BAccReaderJoin.accessRight.getName();
    private static final String A_ACCESS_RIGHTID = "a." + BAccessRight.accessRightId.getName();
    private static final String PA_ACCESS_RIGHT = "pa." + BPersonAccJoin.accessRight.getName();
    private static final String PA_PERSON = "pa." + BPersonAccJoin.person.getName();
    private static final String P_PERSON_ID = "p." + BPerson.personId.getName();
    private static final String B_OWNER = "b." + BBadge.owner.getName();
    private static final String S_UUID = "s." + BScheduleRec.uuid.getName();
    private static final String ES_TYPE_SPEC = "es." + BEnumScheduleRec.scheduleTypeSpec.getName();
    private static final String A_SCHED = "a." + BAccessRight.schedule.getName();
    public static final String Z_TYPE_SPEC = "z." + BAccessZoneRec.accessZoneTypeSpec.getName();
    public static final String Z_ZONE_TYPE = "'nacDriver:NACAccessZone'";
    private static final String R_TYPE_SPEC = "r." + BAccReaderRec.readerTypeSpec.getName();
    private static final String R_READER_TYPE = "'nacDriver:NACReader'";
    private static final String ES_NAC_DOOR_MODE_SCHEDULE_TYPE = "'nacDriver:NACDoorModeSchedule'";
    private static final OrionType TYPE_D = BDeletion.ORION_TYPE;
    private static final String APP_TABLE_TYPE_D = BAppTable.getTableName((OrionType)TYPE_D);
    private static final String DEL_TYPE_SPEC = BDeletion.delTypeSpec.getName();
    protected static final String SQL_NAC_D = "select * from " + APP_TABLE_TYPE_D + " where (" + LAST_MODIFIED + " between ? and ?) and " + DEL_TYPE_SPEC + " = ?";
    private static final String SQL_NAC_W = "select * from " + APP_TABLE_TYPE_W + " where " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_NAC_Z = "select * from " + APP_TABLE_TYPE_Z + " z where (" + Z_TYPE_SPEC + "=" + "'nacDriver:NACAccessZone'" + ") and " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_NAC_R = "select * from " + APP_TABLE_TYPE_R + " r where(" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and " + LAST_MODIFIED + " between ? and ?";
    private static final String SQL_NAC_AR_WITH_SPECIFIC_READER_UUID = "select distinct ar.* from " + APP_TABLE_TYPE_AR + " ar inner join " + APP_TABLE_TYPE_R + " r on " + AR_READER + " = " + R_UUID + " where " + R_UUID + "= ?";
    private static final String SQL_NAC_Z_ENT_R_WITH_SPECIFIC_READER_UUID = "select distinct zr.* from " + APP_TABLE_TYPE_Z_ENT_R + " zr inner join " + APP_TABLE_TYPE_R + " r on " + ZR_READER + " = " + R_UUID + " where " + R_UUID + "= ?";
    private static final String SQL_NAC_Z_EX_R_WITH_SPECIFIC_READER_UUID = "select distinct zr.* from " + APP_TABLE_TYPE_Z_EX_R + " zr inner join " + APP_TABLE_TYPE_R + " r on " + ZR_READER + " = " + R_UUID + " where " + R_UUID + "= ?";
    private static final String SQL_NAC_S = "select distinct s.* from " + APP_TABLE_TYPE_S + " s inner join " + APP_TABLE_TYPE_A + " a  on " + S_UUID + " = " + A_SCHED + " inner join " + APP_TABLE_TYPE_AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + APP_TABLE_TYPE_R + " r  on " + AR_READER + " = " + R_UUID + " where (" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and (s." + LAST_MODIFIED + " between ? and ? or  ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) ";
    private static final String SQL_NAC_ES = "select distinct es.* from " + APP_TABLE_TYPE_ES + " es where (" + ES_TYPE_SPEC + "=" + "'nacDriver:NACDoorModeSchedule'" + ") and (es." + LAST_MODIFIED + " between ? and ?)";
    private static final String SQL_NAC_A = "select distinct a.* from " + APP_TABLE_TYPE_A + " a inner join " + APP_TABLE_TYPE_AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + APP_TABLE_TYPE_R + " r  on " + AR_READER + " = " + R_UUID + " where (" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and (ar." + LAST_MODIFIED + " between ? and ? or  a." + LAST_MODIFIED + " between ? and ?) ";
    private static final String SQL_NAC_P = "select distinct p.* from " + APP_TABLE_TYPE_P + " p inner join " + APP_TABLE_TYPE_PA + " pa on " + P_PERSON_ID + " = " + PA_PERSON + " inner join " + APP_TABLE_TYPE_A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + APP_TABLE_TYPE_AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + APP_TABLE_TYPE_R + " r  on " + AR_READER + " = " + R_UUID + " where (" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and (ar." + LAST_MODIFIED + " between ? and ? or  pa." + LAST_MODIFIED + " between ? and ? or  p." + LAST_MODIFIED + " between ? and ?) ";
    private static final String SQL_NAC_B = "select distinct b.* from " + APP_TABLE_TYPE_B + " b inner join " + APP_TABLE_TYPE_P + " p  on " + B_OWNER + " = " + P_PERSON_ID + " inner join " + APP_TABLE_TYPE_PA + " pa on " + P_PERSON_ID + " = " + PA_PERSON + " inner join " + APP_TABLE_TYPE_A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + APP_TABLE_TYPE_AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + APP_TABLE_TYPE_R + " r  on " + AR_READER + " = " + R_UUID + " where (" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and ((ar." + LAST_MODIFIED + " between ? and ? ) or (pa." + LAST_MODIFIED + " between ? and ? ) or (b." + LAST_MODIFIED + " between ? and ? ) ) ";
    private static final String SQL_NAC_AR = "select distinct ar.* from " + APP_TABLE_TYPE_AR + " ar inner join " + APP_TABLE_TYPE_R + " r on " + AR_READER + " = " + R_UUID + " inner join " + APP_TABLE_TYPE_A + " a  on " + AR_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " where (" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and ((ar." + LAST_MODIFIED + " between ? and ?) or (a." + LAST_MODIFIED + " between ? and ?) )";
    private static final String SQL_NAC_Z_ENT_R = "select distinct zr.* from " + APP_TABLE_TYPE_Z_ENT_R + " zr inner join " + APP_TABLE_TYPE_Z + " z on " + ZR_ZONE + " = " + Z_UUID + " where (" + Z_TYPE_SPEC + "=" + "'nacDriver:NACAccessZone'" + ") and (zr." + LAST_MODIFIED + " between ? and ?)";
    private static final String SQL_NAC_Z_EX_R = "select distinct zr.* from " + APP_TABLE_TYPE_Z_EX_R + " zr inner join " + APP_TABLE_TYPE_Z + " z on " + ZR_ZONE + " = " + Z_UUID + " where (" + Z_TYPE_SPEC + "=" + "'nacDriver:NACAccessZone'" + ") and (zr." + LAST_MODIFIED + " between ? and ?)";
    private static final String SQL_NAC_PA = "select distinct pa.* from " + APP_TABLE_TYPE_PA + " pa inner join " + APP_TABLE_TYPE_A + " a  on " + PA_ACCESS_RIGHT + " = " + A_ACCESS_RIGHTID + " inner join " + APP_TABLE_TYPE_AR + " ar on " + A_ACCESS_RIGHTID + " = " + AR_ACCESS_RIGHT + " inner join " + APP_TABLE_TYPE_R + " r  on " + AR_READER + " = " + R_UUID + " where (" + R_TYPE_SPEC + "=" + "'nacDriver:NACReader'" + ") and (ar." + LAST_MODIFIED + " between ? and ? or (a." + LAST_MODIFIED + " between ? and ?) or  pa." + LAST_MODIFIED + " between ? and ?) ";

    protected BAbstractOrionApp getSupervisorOrionApp() {
        return (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
    }

    protected BOrd getJaceOrionAppOrd() {
        return null;
    }

    protected void doReplicate(OrionSession jaceSession, BAbsTime timestamp, String stationName, boolean replicateFromJace, BSafeSimpleJob job, BFacets facets) throws Exception {
        this.logMessage(null, this.getNetwork().getLexicon().get("nacReplicator.startReplicate"));
        OrionSession superSession = this.getSupervisorSession();
        if (superSession == null || !superSession.isOpen()) {
            throw new LocalizableException("nacDriver", "nacReplicator.orionSessionUnavailable");
        }
        this.processDataToServer(timestamp, 1, TYPE_W, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_S, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_ES, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_A, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_Z, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_P, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_B, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_AR, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_PA, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_Z_ENT_R, SQL_NAC_D, 1, superSession);
        this.processDataToServer(timestamp, 1, TYPE_Z_EX_R, SQL_NAC_D, 1, superSession);
        ArrayList<Pair<String, BNACReader>> addItemsToDoorList = this.cleanLastReplicatedDoor(timestamp, superSession);
        this.processDataToServer(timestamp, 1, TYPE_W, SQL_NAC_W, 0, superSession);
        this.processDataToServer(timestamp, 3, TYPE_S, SQL_NAC_S, 0, superSession);
        this.processDataToServer(timestamp, 1, TYPE_ES, SQL_NAC_ES, 0, superSession);
        this.processDataToServer(timestamp, 2, TYPE_A, SQL_NAC_A, 0, superSession);
        this.processDataToServer(timestamp, 1, TYPE_Z, SQL_NAC_Z, 0, superSession);
        this.addItemsToLatestDoorForReader(addItemsToDoorList, superSession);
        this.processDataToServer(timestamp, 3, TYPE_P, SQL_NAC_P, 0, superSession);
        this.processDataToServer(timestamp, 3, TYPE_B, SQL_NAC_B, 0, superSession);
        this.processDataToServer(timestamp, 2, TYPE_AR, SQL_NAC_AR, 0, superSession);
        this.processDataToServer(timestamp, 3, TYPE_PA, SQL_NAC_PA, 0, superSession);
        this.processDataToServer(timestamp, 1, TYPE_Z_ENT_R, SQL_NAC_Z_ENT_R, 0, superSession);
        this.processDataToServer(timestamp, 1, TYPE_Z_EX_R, SQL_NAC_Z_EX_R, 0, superSession);
    }

    private void addItemsToLatestDoorForReader(ArrayList<Pair<String, BNACReader>> addItemsToDoorList, OrionSession session) {
        this.logTrace("NAC - Add Required item(s) to cleaned readers");
        for (Pair<String, BNACReader> uuidReaderPair : addItemsToDoorList) {
            BAccessZoneRec zone;
            StringBuilder body;
            String uuid = (String)uuidReaderPair.getFirst();
            BNACReader reader = (BNACReader)uuidReaderPair.getSecond();
            if (reader.getDoor() == null) continue;
            int doorUnid = reader.getDoor().getUnid();
            try (OrionCursor cursor = session.select(BAccReaderJoin.ORION_TYPE, SQL_NAC_AR_WITH_SPECIFIC_READER_UUID, new BSimple[]{BUuid.make((String)uuid)});){
                body = new StringBuilder();
                int recordIndex = 0;
                while (cursor.next()) {
                    BAccReaderJoin accReaderJoinRec = (BAccReaderJoin)cursor.get();
                    BAccessRight accessRight = (BAccessRight)accReaderJoinRec.getAccessRight().getTarget(session);
                    this.addAccessRightToDoorBody(accessRight, doorUnid, body, recordIndex, 0);
                    if (++recordIndex < 100) continue;
                    this.executeMultiDbChange(body.toString());
                    this.logTrace("NAC - Added" + recordIndex + " access right(s) to reader " + reader.getDisplayName(null));
                    recordIndex = 0;
                    body = new StringBuilder();
                }
                if (recordIndex > 0) {
                    this.executeMultiDbChange(body.toString());
                    this.logTrace("NAC - Added" + recordIndex + " access right(s) to reader " + reader.getDisplayName(null));
                }
            }
            cursor = session.select(BEntryReaderZoneJoin.ORION_TYPE, SQL_NAC_Z_ENT_R_WITH_SPECIFIC_READER_UUID, new BSimple[]{BUuid.make((String)uuid)});
            var9_9 = null;
            try {
                if (cursor.next()) {
                    body = new StringBuilder();
                    BEntryReaderZoneJoin entryReaderZoneJoin = (BEntryReaderZoneJoin)cursor.get();
                    zone = entryReaderZoneJoin.resolveAccessZone(session);
                    this.appendZoneToDoorBody(zone.getUuid().toString(), doorUnid, new AtomicInteger(0), body, true);
                    this.executeMultiDbChange(body.toString());
                }
            }
            catch (Throwable body2) {
                var9_9 = body2;
                throw body2;
            }
            finally {
                if (cursor != null) {
                    if (var9_9 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable body2) {
                            var9_9.addSuppressed(body2);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            cursor = session.select(BExitReaderZoneJoin.ORION_TYPE, SQL_NAC_Z_EX_R_WITH_SPECIFIC_READER_UUID, new BSimple[]{BUuid.make((String)uuid)});
            var9_9 = null;
            try {
                if (cursor.next()) {
                    body = new StringBuilder();
                    BExitReaderZoneJoin entryReaderZoneJoin = (BExitReaderZoneJoin)cursor.get();
                    zone = entryReaderZoneJoin.resolveAccessZone(session);
                    this.appendZoneToDoorBody(zone.getUuid().toString(), doorUnid, new AtomicInteger(0), body, false);
                    this.executeMultiDbChange(body.toString());
                }
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            finally {
                if (cursor != null) {
                    if (var9_9 != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable) {
                            var9_9.addSuppressed(throwable);
                        }
                    } else {
                        cursor.close();
                    }
                }
            }
            reader.setLastReplicatedDoorUnid(doorUnid);
        }
    }

    private void addAccessRightToDoorBody(BAccessRight accessRight, int doorUnid, StringBuilder body, int recordIndex, int elementIndex) {
        if (body.length() > 0) {
            body.append("&");
        }
        body.append("privUpdate[").append(recordIndex).append("]").append(".uuid=").append(accessRight.getAccessRightId()).append("&");
        body.append("privUpdate[").append(recordIndex).append("]").append(".elements[").append(elementIndex).append("].door.unid=").append(doorUnid);
    }

    private ArrayList<Pair<String, BNACReader>> cleanLastReplicatedDoor(BAbsTime timestamp, OrionSession session) {
        this.logTrace("NAC - Clean last replicated door associated to readers");
        ArrayList<Pair<String, BNACReader>> addItemsToDoorList = new ArrayList<Pair<String, BNACReader>>();
        try (OrionCursor cursor = this.getNACCursor(timestamp, 1, TYPE_R, SQL_NAC_R, 0, session);){
            while (cursor.next()) {
                BAccReaderRec readerRec = (BAccReaderRec)cursor.get();
                if (!readerRec.getReaderTypeSpec().equals((Object)BNACReader.TYPE.getTypeSpec())) continue;
                this.updateItemsToRemoveDoors(readerRec, addItemsToDoorList);
            }
        }
        return addItemsToDoorList;
    }

    protected void doCleanSupervisorDeletionTable(BAbsTime timestamp) {
        NACReplicator.cleanDeletionTable((OrionSession)this.getSupervisorSession(), (BAbsTime)timestamp);
    }

    protected void doCleanJaceDeletionTable(OrionSession jaceSession, BAbsTime timestamp) {
    }

    public int compareTo(T o) {
        if (this == o) {
            return 0;
        }
        return 1;
    }

    public boolean isStationIndependentReplicator() {
        return true;
    }

    protected void replicationSuccess(BAbsTime replicationSuccessTime) {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        networkExt.setLastRetentionTime(networkExt.getLastReplication());
        networkExt.setLastReplication(replicationSuccessTime);
        networkExt.setStatus(BStatus.ok);
        networkExt.setFaultCause("");
    }

    protected void replicationFailed(BAbsTime replicationFailureTime, Exception exception) {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        networkExt.setLastFailure(replicationFailureTime);
        networkExt.setStatus(BStatus.fault);
        networkExt.setFaultCause(exception.getMessage());
    }

    protected BAbsTime getLastReplication() {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        return networkExt.getLastReplication();
    }

    protected BAbsTime getLastRetentionTime() {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        return networkExt.getLastRetentionTime();
    }

    protected boolean isSuccess() {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        return networkExt.getStatus().isOk();
    }

    protected void setLastAttempt(BAbsTime lastAttemptTime) {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        networkExt.setLastAttempt(lastAttemptTime);
    }

    protected boolean isEnabled() {
        BNACReplicationNetworkExt networkExt = this.getNetwork().getReplication();
        return networkExt.getEnabled();
    }

    private void processDataToServer(BAbsTime timestamp, int numOfTimestamps, OrionType type, String sql, int operation, OrionSession session) throws Exception {
        String operationWord = operation == 1 ? "delete" : "save";
        this.logTrace("NAC - Begin " + operationWord + " : " + type);
        try (OrionCursor cursor = this.getNACCursor(timestamp, numOfTimestamps, type, sql, operation, session);){
            int totalCount = 0;
            int batchCount = 0;
            StringBuilder body = new StringBuilder();
            Triple operationIndex = new Triple((Object)new AtomicInteger(0), (Object)new AtomicInteger(0), (Object)new AtomicInteger(0));
            while (cursor.next()) {
                BIOrionObject record = (BIOrionObject)cursor.get();
                String recordBody = this.getRequestBodyForRecord(record, type, operation, (Triple<AtomicInteger, AtomicInteger, AtomicInteger>)operationIndex, session);
                if (recordBody != null) {
                    if (body.length() > 0) {
                        body.append("&");
                    }
                    body.append(recordBody);
                    ++batchCount;
                    ++totalCount;
                }
                if (batchCount < 100) continue;
                this.logTrace("NAC - " + operationWord + " " + batchCount + " : " + type);
                this.executeMultiDbChange(body.toString());
                batchCount = 0;
                body = new StringBuilder();
            }
            this.logTrace("NAC - " + operationWord + " " + batchCount + " : " + type);
            this.executeMultiDbChange(body.toString());
            this.logMessage(null, this.getNetwork().getLexicon().getText("nacReplicator." + operationWord + "TotalRecords", new Object[]{totalCount, type}));
            this.logTrace("NAC - End " + operationWord + " : " + type);
        }
    }

    private String getRequestBodyForRecord(BIOrionObject record, OrionType type, int operation, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, OrionSession session) throws Exception {
        if (record != null) {
            if (operation == 1 && record instanceof BDeletion) {
                record = NACReplicator.createRecordFromDeletion((BDeletion)((BDeletion)record), (OrionType)type);
            }
            String body = null;
            if (type.equals(BScheduleRec.ORION_TYPE)) {
                body = this.getScheduleData((BScheduleRec)record, operationIndex, operation);
            }
            if (type.equals(BEnumScheduleRec.ORION_TYPE)) {
                body = this.getEnumScheduleData((BEnumScheduleRec)record, operationIndex, operation);
            } else if (type.equals(BWiegandFormat.ORION_TYPE)) {
                body = this.getWiegandData(record, operationIndex, operation);
            } else if (type.equals(BAccReaderJoin.ORION_TYPE)) {
                body = this.getAccReaderJoinData((BAccReaderJoin)record, operationIndex, operation, session);
            } else if (type.equals(BAccessRight.ORION_TYPE)) {
                body = this.getAccessRightData(record, operationIndex, operation, session);
            } else if (type.equals(BPerson.ORION_TYPE)) {
                body = this.getPersonData((BPerson)record, operationIndex, operation);
            } else if (type.equals(BPersonAccJoin.ORION_TYPE)) {
                body = this.getPersonAccJoinData((BPersonAccJoin)record, operationIndex, operation, session);
            } else if (type.equals(BBadge.ORION_TYPE)) {
                body = this.getBadgeData((BBadge)record, operationIndex, operation);
            } else if (type.equals(BAccessZoneRec.ORION_TYPE)) {
                body = this.getAccessZoneData((BAccessZoneRec)record, operationIndex, operation);
            } else if (type.equals(BEntryReaderZoneJoin.ORION_TYPE) || type.equals(BExitReaderZoneJoin.ORION_TYPE)) {
                body = this.getReaderZoneJoinData((BReaderZoneJoin)record, operationIndex, operation, session);
            }
            if (body == null || body.equals("")) {
                return null;
            }
            return body;
        }
        return null;
    }

    private String getReaderZoneJoinData(BReaderZoneJoin record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation, OrionSession session) throws Exception {
        StringBuilder body = new StringBuilder();
        BAccReaderRec readerRec = record.resolveReader(session);
        if (readerRec == null || !readerRec.getReaderTypeSpec().equals((Object)BNACReader.TYPE.getTypeSpec())) {
            return body.toString();
        }
        String readerDisplayPath = "station:|" + MappingSupport.displayPathToSlotOrd((String)readerRec.getReaderDisplayPath());
        BNACReader reader = (BNACReader)BOrd.make((String)readerDisplayPath).resolve().get();
        if (reader.getDoor() != null) {
            BRef zoneRef = record.getAccessZone();
            boolean isEntry = record instanceof BEntryReaderZoneJoin;
            JSONObject zoneInstance = this.getInstanceFromServer(zoneRef.getId().toString(), "dev");
            if (operation == 1) {
                if (zoneInstance != null) {
                    this.appendZoneToDoorBody("", reader.getDoor().getUnid(), (AtomicInteger)operationIndex.getSecond(), body, isEntry);
                }
            } else {
                if (zoneInstance == null) {
                    throw new Exception("Tried to add zone reader join but the corresponding zone not present on server");
                }
                this.appendZoneToDoorBody(zoneRef.getId().toString(), reader.getDoor().getUnid(), (AtomicInteger)operationIndex.getSecond(), body, isEntry);
            }
        }
        return body.toString();
    }

    private void appendZoneToDoorBody(String zoneUuid, int doorUnid, AtomicInteger index, StringBuilder body, boolean isEntry) {
        body.append("devUpdate[").append(index).append("]").append(".unid=").append(doorUnid).append("&");
        if (isEntry) {
            if (zoneUuid.isEmpty()) {
                body.append("devUpdate[").append(index).append("]").append(".entryArea.unid=").append(zoneUuid);
            } else {
                body.append("devUpdate[").append(index).append("]").append(".entryArea.uuid=").append(zoneUuid);
            }
        } else if (zoneUuid.isEmpty()) {
            body.append("devUpdate[").append(index).append("]").append(".exitArea.unid=").append(zoneUuid);
        } else {
            body.append("devUpdate[").append(index).append("]").append(".exitArea.uuid=").append(zoneUuid);
        }
        index.incrementAndGet();
    }

    private String getAccessZoneData(BAccessZoneRec record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation) throws Exception {
        StringBuilder accessZoneBody = new StringBuilder();
        String uuid = record.getUuid().toString();
        JSONObject instance = this.getInstanceFromServer(uuid, "dev");
        if (operation == 1) {
            if (instance != null) {
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, accessZoneBody, "devDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
            return accessZoneBody.toString();
        }
        if (instance != null) {
            this.createAccessZoneInNACSystem(record, (AtomicInteger)operationIndex.getSecond(), uuid, "devUpdate", accessZoneBody);
        } else {
            this.createAccessZoneInNACSystem(record, (AtomicInteger)operationIndex.getFirst(), uuid, "devInsert", accessZoneBody);
        }
        return accessZoneBody.toString();
    }

    private void createAccessZoneInNACSystem(BAccessZoneRec rec, AtomicInteger index, String uuid, String operation, StringBuilder body) throws Exception {
        String zoneDisplayPath = "station:|" + MappingSupport.displayPathToSlotOrd((String)rec.getZoneDisplayPath());
        BNACAccessZone zone = (BNACAccessZone)BOrd.make((String)zoneDisplayPath).resolve().get();
        if (zone.getLinks(zone.getSlot(BNACAccessZone.controllerLink.getName())).length != 1) {
            return;
        }
        BLink link = zone.getLinks(zone.getSlot(BNACAccessZone.controllerLink.getName()))[0];
        BNACController controller = (BNACController)link.getSourceComponent();
        if (controller.getUnid() == 0) {
            String message = this.getNetwork().getLexicon().getText("replicate.accessZone.controllerNotAdded", new Object[]{zone.getDisplayName(null), controller.getDisplayName(null)});
            throw new Exception(message);
        }
        operation = operation + "[" + index.get() + "]";
        body.append(operation).append(".uuid=").append(uuid).append("&");
        body.append(operation).append(".devType=").append(6).append("&");
        body.append(operation).append(".devUse=").append(45).append("&");
        body.append(operation).append(".enabled=").append(true).append("&");
        body.append(operation).append(".name=").append(SlotPath.escape((String)rec.getZoneName())).append("&");
        body.append(operation).append(".physicalParent.unid=").append(controller.getUnid()).append("&");
        if (!zone.getPassbackMode().equals((Object)BEnforcementEnum.off)) {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.apbConfig.apbMethod=").append(1).append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.apbConfig.apbMode=").append(zone.getPassbackMode().equals((Object)BEnforcementEnum.soft) ? 1 : 0).append("&");
            if (zone.getPassbackTimeout().equals((Object)BRelTime.DEFAULT)) {
                body.append(operation).append(".controlledAreaConfig.accessControlConfig.apbConfig.apbTimed=").append(false).append("&");
            } else {
                body.append(operation).append(".controlledAreaConfig.accessControlConfig.apbConfig.apbTimed=").append(true).append("&");
                body.append(operation).append(".controlledAreaConfig.accessControlConfig.apbConfig.apbTimedDuration=").append(zone.getPassbackTimeout().getSeconds()).append("&");
            }
        } else {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.apbConfig.apbMethod=").append(0).append("&");
        }
        body.append(operation).append(".controlledAreaConfig.accessControlConfig.trackOccupancy=").append(true).append("&");
        BEnforcementEnum highThresholdEnforcement = BEnforcementEnum.off;
        BEnforcementEnum lowThresholdEnforcement = BEnforcementEnum.off;
        if (!zone.getAboveHighThresholdEnforcement().equals((Object)BEnforcementEnum.off)) {
            highThresholdEnforcement = zone.getAboveHighThresholdEnforcement();
        } else if (zone.getAtHighThresholdEnforcement().getOrdinal() != 0) {
            highThresholdEnforcement = BEnforcementEnum.make((int)zone.getAtHighThresholdEnforcement().getOrdinal());
        }
        if (zone.getBelowLowThresholdEnforcement().getOrdinal() != 0) {
            lowThresholdEnforcement = BEnforcementEnum.make((int)zone.getBelowLowThresholdEnforcement().getOrdinal());
        } else if (zone.getAtLowThresholdEnforcement().getOrdinal() != 0) {
            lowThresholdEnforcement = BEnforcementEnum.make((int)zone.getAtLowThresholdEnforcement().getOrdinal());
        }
        if (highThresholdEnforcement.equals((Object)BEnforcementEnum.off)) {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.maxOccupancy=").append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.softMaxOccupancy=").append("&");
        } else if (highThresholdEnforcement.equals((Object)BEnforcementEnum.soft)) {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.maxOccupancy=").append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.softMaxOccupancy=").append(zone.getHighThreshold()).append("&");
        } else {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.maxOccupancy=").append(zone.getHighThreshold()).append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.softMaxOccupancy=").append("&");
        }
        if (lowThresholdEnforcement.equals((Object)BEnforcementEnum.off)) {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.minOccupancy=").append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.softMinOccupancy=");
        } else if (lowThresholdEnforcement.equals((Object)BEnforcementEnum.soft)) {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.minOccupancy=").append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.softMinOccupancy=").append(zone.getLowThreshold());
        } else {
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.minOccupancy=").append(zone.getLowThreshold()).append("&");
            body.append(operation).append(".controlledAreaConfig.accessControlConfig.softMinOccupancy=");
        }
        index.incrementAndGet();
    }

    private String getBadgeData(BBadge record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation) throws Exception {
        StringBuilder badgeBody = new StringBuilder();
        JSONObject badgeInstance = this.lookupCredRestriction(record.getBadgeId());
        if (operation == 1) {
            if (badgeInstance != null && badgeInstance.has("unid")) {
                int unid = badgeInstance.getInt("unid");
                this.appendUnidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), String.valueOf(unid), badgeBody, "credDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
        } else if (badgeInstance != null) {
            this.createStringBodyForBadge(record, (AtomicInteger)operationIndex.getSecond(), badgeBody, badgeInstance, "credUpdate");
        } else {
            this.createStringBodyForBadge(record, (AtomicInteger)operationIndex.getFirst(), badgeBody, null, "credInsert");
        }
        return badgeBody.toString();
    }

    private String getAccReaderJoinData(BAccReaderJoin record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation, OrionSession session) throws Exception {
        StringBuilder body = new StringBuilder();
        BAccReaderRec readerRec = record.resolveReader(session);
        if (readerRec == null || !readerRec.getReaderTypeSpec().equals((Object)BNACReader.TYPE.getTypeSpec())) {
            return body.toString();
        }
        String readerDisplayPath = "station:|" + MappingSupport.displayPathToSlotOrd((String)readerRec.getReaderDisplayPath());
        BNACReader reader = (BNACReader)BOrd.make((String)readerDisplayPath).resolve().get();
        if (reader.getDoor() != null) {
            BAccessRight accessRight = record.resolveAccessRight(session);
            JSONObject privInstance = this.getInstanceFromServer(accessRight.getAccessRightId().toString(), "priv");
            if (operation == 1) {
                if (privInstance != null) {
                    NACReplicator.appendAccReaderJoinDeleteBody(reader.getDoor().getUnid(), (AtomicInteger)operationIndex.getSecond(), body, privInstance);
                }
            } else {
                if (accessRight.getSchedule().getId() == null) {
                    return body.toString();
                }
                if (privInstance == null) {
                    throw new LocalizableException("nacDriver", "nacReplicator.accessRightNotPresent");
                }
                this.appendAccReaderJoinAddBody(accessRight, reader.getDoor().getUnid(), (AtomicInteger)operationIndex.getSecond(), body, privInstance);
            }
        }
        return body.toString();
    }

    private void appendAccReaderJoinAddBody(BAccessRight accessRight, int doorUnid, AtomicInteger recordIndex, StringBuilder body, JSONObject priv) {
        JSONArray privElements = priv.getJSONArray("elements");
        for (Object privElement : privElements) {
            JSONObject privElementJson = (JSONObject)privElement;
            int unid = privElementJson.getJSONObject("door").getInt("unid");
            if (unid != doorUnid) continue;
            return;
        }
        this.addAccessRightToDoorBody(accessRight, doorUnid, body, recordIndex.get(), 0);
        recordIndex.incrementAndGet();
    }

    private List<String> getAssociatedAccessRightsWithSchedule(String uuid) {
        ArrayList<String> accessRightsUuid = new ArrayList<String>();
        JSONObject accessRightsResponse = AccessController.doPrivileged(() -> {
            try {
                return NACRequestUtils.listResources(this.getNetwork(), "priv", 0);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        JSONArray instanceList = accessRightsResponse.getJSONArray("instanceList");
        for (int i = 0; i < instanceList.length(); ++i) {
            JSONObject sched;
            String uuidOfSched;
            JSONObject accessRight = instanceList.getJSONObject(i);
            JSONObject schedRestriction = accessRight.getJSONObject("schedRestriction");
            if (!schedRestriction.has("sched") || !(uuidOfSched = (sched = schedRestriction.getJSONObject("sched")).getString("uuid")).equals(uuid)) continue;
            String instanceUuid = accessRight.getString("uuid");
            accessRightsUuid.add(instanceUuid);
        }
        return accessRightsUuid;
    }

    private String getScheduleData(BScheduleRec record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation) throws Exception {
        StringBuilder scheduleBody = new StringBuilder();
        String uuid = record.getUuid().toString();
        JSONObject instance = this.getInstanceFromServer(uuid, "sched");
        if (operation == 1) {
            if (instance != null) {
                List<String> accessRightsUuid = this.getAssociatedAccessRightsWithSchedule(uuid);
                StringBuilder body = new StringBuilder();
                for (int i = 0; i < accessRightsUuid.size(); ++i) {
                    this.appendUuidToDeleteObject(i, accessRightsUuid.get(i), body, "privDelete");
                }
                this.executeMultiDbChange(body.toString());
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, scheduleBody, "schedDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
            return scheduleBody.toString();
        }
        if (instance == null) {
            JSONArray elementList = new JSONArray();
            scheduleBody = this.createScheduleInNACSystem(record, (AtomicInteger)operationIndex.getFirst(), uuid, "schedInsert", elementList);
            return scheduleBody.toString();
        }
        JSONArray elementList = (JSONArray)instance.get("elements");
        scheduleBody = this.createScheduleInNACSystem(record, (AtomicInteger)operationIndex.getSecond(), uuid, "schedUpdate", elementList);
        return scheduleBody.toString();
    }

    private String getEnumScheduleData(BEnumScheduleRec record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation) {
        StringBuilder scheduleBody = new StringBuilder();
        String uuid = record.getUuid().toString();
        JSONObject instance = this.getInstanceFromServer(uuid, "sched");
        if (operation == 1) {
            if (instance != null) {
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, scheduleBody, "schedDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
            return scheduleBody.toString();
        }
        if (instance == null) {
            JSONArray elementList = new JSONArray();
            scheduleBody = this.createEnumScheduleInNACSystem(record, (AtomicInteger)operationIndex.getFirst(), uuid, "schedInsert", elementList);
            return scheduleBody.toString();
        }
        JSONArray elementList = (JSONArray)instance.get("elements");
        scheduleBody = this.createEnumScheduleInNACSystem(record, (AtomicInteger)operationIndex.getSecond(), uuid, "schedUpdate", elementList);
        return scheduleBody.toString();
    }

    private String getPersonData(BPerson record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation) throws Exception {
        StringBuilder personBody = new StringBuilder();
        String uuid = record.getPersonId().toString();
        JSONObject instance = this.getInstanceFromServer(record.getPersonId().toString(), "credHolder");
        if (operation == 1) {
            if (instance != null) {
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, personBody, "credHolderDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
            return personBody.toString();
        }
        BWebService webService = (BWebService)Sys.getService((Type)BWebService.TYPE);
        if (!this.getNetwork().getHttpConfig().getUseTls() && webService.getRequireHttpsForPasswords()) {
            throw new LocalizableException("nacDriver", "nacReplicator.passwordSharingNotAllowedOverHttp");
        }
        if (instance != null) {
            this.createStringBodyForPeople(record, (AtomicInteger)operationIndex.getSecond(), personBody, uuid, "credHolderUpdate", "credUpdate");
        } else {
            this.createStringBodyForPeople(record, (AtomicInteger)operationIndex.getFirst(), personBody, uuid, "credHolderInsert", "credInsert");
        }
        return personBody.toString();
    }

    private String getPersonAccJoinData(BPersonAccJoin record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation, OrionSession session) throws Exception {
        StringBuilder personAccJoinBody = new StringBuilder();
        String uuid = record.getPerson().getId().toString();
        String accessRightUuid = record.getAccessRight().getId().toString();
        BAccessRight accessRight = record.resolveAccessRight(session);
        JSONObject peopleInstance = this.getInstanceFromServer(uuid, "credHolder");
        if (operation == 1) {
            if (peopleInstance != null) {
                this.deleteExistingAccessRightsFromPeople((AtomicInteger)operationIndex.getSecond(), personAccJoinBody, accessRightUuid, "credHolderUpdate", peopleInstance, uuid);
            }
        } else {
            if (peopleInstance == null) {
                throw new LocalizableException("nacDriver", "nacReplicator.personNotPresent");
            }
            if (accessRight.getSchedule().getId() == null) {
                return personAccJoinBody.toString();
            }
            Integer unid = this.isAccessRightExistsInThePeople(accessRightUuid, peopleInstance);
            if (unid == null) {
                this.createStringBodyForPeopleAccJoin(accessRightUuid, (AtomicInteger)operationIndex.getSecond(), personAccJoinBody, uuid, "credHolderUpdate");
            }
        }
        return personAccJoinBody.toString();
    }

    private void createStringBodyForPeople(BPerson record, AtomicInteger recordIndex, StringBuilder personBody, String uuid, String credHolderOperationType, String credOperationType) {
        NACReplicator.createStringBody(SlotPath.unescape((String)record.getFirstName()), recordIndex, personBody, "first", credHolderOperationType);
        NACReplicator.createStringBody(SlotPath.unescape((String)record.getLastName()), recordIndex, personBody, "last", credHolderOperationType);
        NACReplicator.createStringBody(record.getTraceCard(), recordIndex, personBody, "doorAccessModifiers.watch", credHolderOperationType);
        NACReplicator.createStringBody(uuid, recordIndex, personBody, "uuid", credHolderOperationType);
        this.appendPinInTheStringBody(record.getPinNumber(), recordIndex, personBody, credHolderOperationType);
        if (credHolderOperationType.equals("credHolderInsert")) {
            int credTemplateUnId = this.getNetwork().getCardPinTemplate().getUnid();
            if (credTemplateUnId != 0) {
                NACReplicator.appendCredTemplateInStringBody(recordIndex, personBody, credOperationType, credTemplateUnId, record, credHolderOperationType);
            }
            NACReplicator.createStringBody("en", recordIndex, personBody, "language", credHolderOperationType);
            NACReplicator.createStringBody(true, recordIndex, personBody, "enabled", credHolderOperationType);
            NACReplicator.createStringBody(true, recordIndex, personBody, "pinUnique", credHolderOperationType);
            NACReplicator.createStringBody("true", recordIndex, personBody, "allowedPrivTypes.door", credHolderOperationType);
            String credHolderName = record.getLastName() + ", " + record.getFirstName();
            NACReplicator.createStringBody(credHolderName, recordIndex, personBody, "name", credHolderOperationType);
        }
        recordIndex.incrementAndGet();
    }

    private static void appendCredTemplateInStringBody(AtomicInteger recordIndex, StringBuilder personBody, String credOperationType, int credTemplateId, BPerson person, String credHolderOperationType) {
        int commonIdentifier = -1 - recordIndex.get();
        String name = person.getLastName() + "," + person.getFirstName() + " Unique PIN";
        NACReplicator.createStringBody(name, recordIndex, personBody, "name", credOperationType);
        NACReplicator.createStringBody("true", recordIndex, personBody, "enabled", credOperationType);
        NACReplicator.createStringBody(credTemplateId, recordIndex, personBody, "credTemplate.unid", credOperationType);
        NACReplicator.createStringBody(commonIdentifier, recordIndex, personBody, "unid", credHolderOperationType);
        NACReplicator.createStringBody(commonIdentifier, recordIndex, personBody, "credHolder.id", credOperationType);
    }

    private void appendPinInTheStringBody(BPassword sessionToken, AtomicInteger recordIndex, StringBuilder personBody, String credHolderOperationType) {
        String pin = AccessController.doPrivileged(() -> this.getPinFromPinNumber(sessionToken));
        NACReplicator.createStringBody(pin, recordIndex, personBody, "pin", credHolderOperationType);
    }

    private String getPinFromPinNumber(BPassword sessionToken) {
        try (SecretChars token = new SecretChars(AccessController.doPrivileged(() -> ((BPassword)sessionToken).getValue()).toCharArray(), false);){
            String string = token.asString(false);
            return string;
        }
    }

    private void createStringBodyForBadge(BBadge record, AtomicInteger recordIndex, StringBuilder badgeBody, JSONObject badgeInstance, String credHolderOperationType) throws Exception {
        String personUuid = record.getOwner().getId().toString();
        String wiegandFormatId = record.getWiegandFormat().getId().toString();
        BAbsTime effectiveTime = record.getIssueDate();
        BAbsTime expiresTime = record.getExpirationDate();
        boolean isEnable = true;
        if (credHolderOperationType.equals("credInsert")) {
            NACReplicator.createStringBody(record.getBadgeId(), recordIndex, badgeBody, "name", credHolderOperationType);
            NACReplicator.createStringBody(record.getBadgeId(), recordIndex, badgeBody, "idNum", credHolderOperationType);
        }
        this.validEffectiveAndExpireTime(effectiveTime, expiresTime);
        if (!effectiveTime.isNull()) {
            NACReplicator.createStringBody(String.valueOf(effectiveTime.getDay()), recordIndex, badgeBody, "effective_day", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(effectiveTime.getMonth().getMonthOfYear()), recordIndex, badgeBody, "effective_month", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(effectiveTime.getYear()), recordIndex, badgeBody, "effective_year", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(effectiveTime.getHour()), recordIndex, badgeBody, "effective_hour", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(effectiveTime.getMinute()), recordIndex, badgeBody, "effective_minute", credHolderOperationType);
        } else {
            NACReplicator.createStringBody("", recordIndex, badgeBody, "effective_day", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "effective_month", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "effective_year", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "effective_hour", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "effective_minute", credHolderOperationType);
        }
        if (!expiresTime.isNull()) {
            NACReplicator.createStringBody(String.valueOf(expiresTime.getDay()), recordIndex, badgeBody, "expires_day", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(expiresTime.getMonth().getMonthOfYear()), recordIndex, badgeBody, "expires_month", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(expiresTime.getYear()), recordIndex, badgeBody, "expires_year", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(expiresTime.getHour()), recordIndex, badgeBody, "expires_hour", credHolderOperationType);
            NACReplicator.createStringBody(String.valueOf(expiresTime.getMinute()), recordIndex, badgeBody, "expires_minute", credHolderOperationType);
        } else {
            NACReplicator.createStringBody("", recordIndex, badgeBody, "expires_day", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "expires_month", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "expires_year", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "expires_hour", credHolderOperationType);
            NACReplicator.createStringBody("", recordIndex, badgeBody, "expires_minute", credHolderOperationType);
        }
        if (record.getStatus().equals((Object)BBadgeStatus.disabled) || record.getStatus().equals((Object)BBadgeStatus.lost) || record.getStatus().equals((Object)BBadgeStatus.unknown) || effectiveTime.isNull()) {
            isEnable = false;
        }
        if (record.getStatus().equals((Object)BBadgeStatus.lost)) {
            NACReplicator.createStringBody(String.valueOf(1), recordIndex, badgeBody, "disabledReason", credHolderOperationType);
        } else {
            NACReplicator.createStringBody("", recordIndex, badgeBody, "disabledReason", credHolderOperationType);
        }
        if (credHolderOperationType.equals("credUpdate") && badgeInstance != null) {
            if (badgeInstance.has("unid")) {
                int unid = badgeInstance.getInt("unid");
                NACReplicator.createStringBody(String.valueOf(unid), recordIndex, badgeBody, "unid", credHolderOperationType);
            } else {
                throw new LocalizableException("nacDriver", "nacReplicator.unidUnavailable");
            }
        }
        NACReplicator.createStringBody(String.valueOf(isEnable), recordIndex, badgeBody, "enabled", credHolderOperationType);
        NACReplicator.createStringBody(record.getCredential(), recordIndex, badgeBody, "cardPin.credNum", credHolderOperationType);
        NACReplicator.createStringBody(record.getFacilityCode(), recordIndex, badgeBody, "cardPin.facilityCode", credHolderOperationType);
        if (!personUuid.equals("")) {
            NACReplicator.createStringBody(personUuid, recordIndex, badgeBody, "credHolder.uuid", credHolderOperationType);
        }
        if (!wiegandFormatId.equals("")) {
            NACReplicator.createStringBody(wiegandFormatId, recordIndex, badgeBody, "credTemplate.uuid", credHolderOperationType);
        }
        recordIndex.incrementAndGet();
    }

    public void validEffectiveAndExpireTime(BAbsTime effectiveTime, BAbsTime expiresTime) throws Exception {
        if (!effectiveTime.isNull() && !expiresTime.isNull() && effectiveTime.isAfter(expiresTime)) {
            throw new LocalizableException("nacDriver", "nacReplicator.effectiveTimeExceedingExpirationTime");
        }
    }

    private void createStringBodyForPeopleAccJoin(String accessRightUuid, AtomicInteger recordIndex, StringBuilder personBody, String uuid, String credHolderOperationType) {
        NACReplicator.createStringBody(uuid, recordIndex, personBody, "uuid", credHolderOperationType);
        NACReplicator.createStringBodyForChildElements(accessRightUuid, recordIndex, personBody, "privBindings", credHolderOperationType, 0, "priv.uuid");
        recordIndex.incrementAndGet();
    }

    private void deleteExistingAccessRightsFromPeople(AtomicInteger recordIndex, StringBuilder personBody, String uuid, String credHolderOperationType, JSONObject instance, String peopleUuid) {
        Integer unid = this.isAccessRightExistsInThePeople(uuid, instance);
        if (unid != null) {
            NACReplicator.createStringBody(peopleUuid, recordIndex, personBody, "uuid", "credHolderUpdate");
            NACReplicator.createStringBodyForChildElements(String.valueOf(unid), recordIndex, personBody, "privBindings", credHolderOperationType, 0, "unid");
            NACReplicator.createStringBodyForChildElements("true", recordIndex, personBody, "privBindings", credHolderOperationType, 0, "deleted");
            recordIndex.incrementAndGet();
        }
    }

    private Integer isAccessRightExistsInThePeople(String uuid, JSONObject credHolderInstance) {
        if (credHolderInstance != null && credHolderInstance.has("privBindings")) {
            JSONArray privBindingsArray = credHolderInstance.getJSONArray("privBindings");
            for (Object bindingObject : privBindingsArray) {
                String accessRightUuid;
                JSONObject privObject;
                JSONObject privBindingObject = (JSONObject)bindingObject;
                if (privBindingObject == null || !privBindingObject.has("priv") || !privBindingObject.has("unid") || (privObject = privBindingObject.getJSONObject("priv")) == null || privObject.optString("tag").equals("MUSTER") || !privObject.has("uuid") || !(accessRightUuid = privObject.getString("uuid")).equals(uuid)) continue;
                return privBindingObject.getInt("unid");
            }
        }
        return null;
    }

    private static void createStringBody(String value, AtomicInteger operationIndex, StringBuilder objectBody, String key, String operationType) {
        if (objectBody.length() > 0) {
            objectBody.append("&");
        }
        objectBody.append(operationType).append("[").append(operationIndex).append("].").append(key).append("=").append(value);
    }

    private static void createStringBody(boolean value, AtomicInteger operationIndex, StringBuilder objectBody, String key, String operationType) {
        if (objectBody.length() > 0) {
            objectBody.append("&");
        }
        objectBody.append(operationType).append("[").append(operationIndex).append("].").append(key).append("=").append(value);
    }

    private static void createStringBody(int value, AtomicInteger operationIndex, StringBuilder objectBody, String key, String operationType) {
        if (objectBody.length() > 0) {
            objectBody.append("&");
        }
        objectBody.append(operationType).append("[").append(operationIndex).append("].").append(key).append("=").append(value);
    }

    private static void createStringBodyForChildElements(String value, AtomicInteger operationIndex, StringBuilder personBody, String key, String operationType, int childIndex, String childProperty) {
        personBody.append("&").append(operationType).append("[").append(operationIndex).append("].").append(key).append("[").append(childIndex).append("].").append(childProperty).append("=").append(value);
    }

    private StringBuilder createScheduleInNACSystem(BScheduleRec scheduleRec, AtomicInteger recordIndex, String uuid, String operationType, JSONArray elementList) {
        String scheduleDisplayPath;
        BBooleanSchedule scheduler;
        StringBuilder scheduleData = new StringBuilder();
        if (!scheduleRec.getScheduleDisplayPath().equals("") && (scheduler = (BBooleanSchedule)BOrd.make((String)(scheduleDisplayPath = "station:|" + MappingSupport.displayPathToSlotOrd((String)scheduleRec.getScheduleDisplayPath()))).resolve().get()) != null) {
            if (!scheduler.isSubscribed()) {
                scheduler.lease();
            }
            boolean defaultValue = BBoolean.make((String)scheduler.getDefaultOutput().getValueValue().toString()).getBoolean();
            AtomicInteger scheduleEventIndex = new AtomicInteger(0);
            this.appendIdentities(recordIndex.get(), uuid, scheduleData, scheduler.getName(), operationType);
            BCompositeSchedule schedule = scheduler.getSchedule();
            BAbstractSchedule[] schedulesList = schedule.getSchedules();
            this.deleteExistingScheduleElements(elementList, recordIndex.get(), scheduleData, operationType, scheduleEventIndex);
            for (BAbstractSchedule abstractSchedule : schedulesList) {
                BAbstractSchedule[] weekdayList;
                if (abstractSchedule.getType().equals(BCompositeSchedule.TYPE)) {
                    BAbstractSchedule[] specialEventList;
                    for (BAbstractSchedule specialEvent : specialEventList = ((BCompositeSchedule)abstractSchedule).getSchedules()) {
                        BComponent[] components;
                        for (BComponent component : components = specialEvent.getChildComponents()) {
                            if (!(component instanceof BCalendarSchedule)) continue;
                        }
                    }
                    continue;
                }
                BWeekSchedule weekSchedule = (BWeekSchedule)abstractSchedule;
                for (BAbstractSchedule weekday : weekdayList = weekSchedule.getSchedules()) {
                    int weekdayOrdinal = NAC_WEEK_DAYS.get(weekday.getName());
                    BDailySchedule dailySchedule = (BDailySchedule)weekday;
                    BDaySchedule daySchedule = dailySchedule.getDay();
                    this.appendTimeScheduleData(daySchedule, scheduleData, recordIndex.get(), weekdayOrdinal, operationType, scheduleEventIndex, defaultValue);
                }
            }
        }
        recordIndex.incrementAndGet();
        return scheduleData;
    }

    private StringBuilder createEnumScheduleInNACSystem(BEnumScheduleRec scheduleRec, AtomicInteger recordIndex, String uuid, String operationType, JSONArray elementList) {
        String scheduleDisplayPath;
        BEnumSchedule scheduler;
        StringBuilder scheduleData = new StringBuilder();
        if (!scheduleRec.getScheduleDisplayPath().equals("") && (scheduler = (BEnumSchedule)BOrd.make((String)(scheduleDisplayPath = "station:|" + MappingSupport.displayPathToSlotOrd((String)scheduleRec.getScheduleDisplayPath()))).resolve().get()) != null) {
            if (!scheduler.isSubscribed()) {
                scheduler.lease();
            }
            BStatusValue defaultValue = scheduler.getDefaultOutput();
            AtomicInteger scheduleEventIndex = new AtomicInteger(0);
            this.appendIdentities(recordIndex.get(), uuid, scheduleData, scheduler.getName(), operationType);
            this.appendEnumModeIdentities(recordIndex.get(), scheduleData, operationType);
            BCompositeSchedule schedule = scheduler.getSchedule();
            BAbstractSchedule[] schedulesList = schedule.getSchedules();
            this.deleteExistingScheduleElements(elementList, recordIndex.get(), scheduleData, operationType, scheduleEventIndex);
            for (BAbstractSchedule abstractSchedule : schedulesList) {
                if (abstractSchedule.getType().equals(BCompositeSchedule.TYPE)) {
                    BAbstractSchedule[] specialEventList;
                    for (BAbstractSchedule specialEvent : specialEventList = ((BCompositeSchedule)abstractSchedule).getSchedules()) {
                        BComponent[] components;
                        for (BComponent component : components = specialEvent.getChildComponents()) {
                            if (!(component instanceof BCalendarSchedule)) continue;
                        }
                    }
                    continue;
                }
                BWeekSchedule weekSchedule = (BWeekSchedule)abstractSchedule;
                BAbstractSchedule[] weekdayList = weekSchedule.getSchedules();
                HashSet<Integer> uniqueDoorModeValues = new HashSet<Integer>();
                for (BAbstractSchedule weekday : weekdayList) {
                    int weekdayOrdinal = NAC_WEEK_DAYS.get(weekday.getName());
                    BDailySchedule dailySchedule = (BDailySchedule)weekday;
                    BDaySchedule daySchedule = dailySchedule.getDay();
                    this.appendEnumTimeScheduleData(daySchedule, scheduleData, recordIndex.get(), weekdayOrdinal, operationType, scheduleEventIndex, defaultValue, uniqueDoorModeValues);
                }
                for (Integer doorMode : uniqueDoorModeValues) {
                    if (scheduleData.length() <= 0) continue;
                    scheduleData.append("&").append(operationType).append("[").append(recordIndex).append("].levelMappings").append("[").append(doorMode).append("].doorModeType=").append(doorMode);
                }
                this.appendScheduleMappingToDoor((BNACDoorModeSchedule)scheduler, scheduleData, operationType, recordIndex);
            }
        }
        recordIndex.incrementAndGet();
        return scheduleData;
    }

    public void deleteExistingScheduleElements(JSONArray elementsList, int recordIndex, StringBuilder scheduleData, String operationType, AtomicInteger scheduleEventIndex) {
        for (int i = scheduleEventIndex.get(); i < elementsList.length(); ++i) {
            JSONObject element = (JSONObject)elementsList.get(i);
            this.appendScheduleCommonData(recordIndex, scheduleData, operationType, scheduleEventIndex);
            this.appendKeyAndValue(scheduleData, "unid", element.getInt("unid"));
            this.appendScheduleCommonData(recordIndex, scheduleData, operationType, scheduleEventIndex);
            this.appendKeyAndValue(scheduleData, "id", element.getInt("unid"));
            this.appendScheduleCommonData(recordIndex, scheduleData, operationType, scheduleEventIndex);
            this.appendKeyAndValue(scheduleData, "deleted", "true");
            scheduleEventIndex.incrementAndGet();
        }
    }

    private void appendIdentities(int recordIndex, String uuid, StringBuilder stringBody, String name, String operationType) {
        stringBody.append(operationType).append("[").append(recordIndex).append("].name=").append(SlotPath.unescape((String)name));
        stringBody.append("&").append(operationType).append("[").append(recordIndex).append("].uuid=").append(uuid);
    }

    public void appendScheduleMappingToDoor(BNACDoorModeSchedule schedule, StringBuilder stringBody, String operationType, AtomicInteger recordIndex) {
        BMappedEnumScheduleExt mappedEnumScheduleExt = (BMappedEnumScheduleExt)Arrays.stream(schedule.getChildren(BMappedEnumScheduleExt.class)).findFirst().get();
        if (mappedEnumScheduleExt != null && !mappedEnumScheduleExt.getUuid().toString().isEmpty()) {
            int mappingIndex = 0;
            int commonIdentifier = -1 - recordIndex.get();
            ArrayList<BNACDoor> doorList = this.getScheduleLinkedDoors(schedule);
            if (doorList.size() > 0) {
                if (operationType.equals("schedInsert")) {
                    stringBody.append("&").append(operationType).append("[").append(mappingIndex).append("]").append(".unid=").append(commonIdentifier);
                }
                for (BNACDoor nacDoor : doorList) {
                    if (nacDoor.getUnid() == 0) continue;
                    if (operationType.equals("schedInsert")) {
                        stringBody.append("&").append("devUpdate").append("[").append(mappingIndex).append("]").append(".templatedPolicies[0].sched.id=").append(commonIdentifier);
                    } else {
                        stringBody.append("&").append("devUpdate").append("[").append(mappingIndex).append("]").append(".templatedPolicies[0].sched.unid=").append(mappedEnumScheduleExt.getUuid());
                    }
                    stringBody.append("&").append("devUpdate").append("[").append(mappingIndex).append("]").append(".unid=").append(nacDoor.getUnid());
                    stringBody.append("&").append("devUpdate").append("[").append(mappingIndex).append("]").append(".templatedPolicies[0].type=").append(1);
                    stringBody.append("&").append("devUpdate").append("[").append(mappingIndex).append("]").append(".templatedPolicies[0].ownerDev.unid=").append(nacDoor.getUnid());
                    ++mappingIndex;
                }
            }
        }
    }

    private ArrayList<BNACDoor> getScheduleLinkedDoors(BNACDoorModeSchedule schedule) {
        BNACDevice[] nacDevices;
        ArrayList<BNACDoor> doorList = new ArrayList<BNACDoor>();
        for (BNACDevice nacDevice : nacDevices = (BNACDevice[])this.getNetwork().getChildren(BNACDevice.class)) {
            BNACDoor[] nacDoors;
            BNACPointDeviceExt pointDeviceExt = nacDevice.getPoints();
            for (BNACDoor nacDoor : nacDoors = (BNACDoor[])pointDeviceExt.getChildren(BNACDoor.class)) {
                if (!this.checkIsLinkValid(schedule, nacDoor)) continue;
                doorList.add(nacDoor);
            }
        }
        return doorList;
    }

    private boolean checkIsLinkValid(BNACDoorModeSchedule schedule, BNACDoor nacDoor) {
        BLink[] links;
        for (BLink link : links = nacDoor.getLinks((Slot)BNACDoor.overrideSchedule)) {
            if (!link.isActive()) continue;
            BComponent sourceComponent = link.getSourceComponent();
            BComponent targetComponent = link.getTargetComponent();
            if (!sourceComponent.equals((Object)schedule) || !targetComponent.equals((Object)nacDoor) || !link.getTargetSlot().equals((Object)BNACDoor.overrideSchedule) || !link.getSourceSlot().equals((Object)BNACDoorModeSchedule.out)) continue;
            return true;
        }
        return false;
    }

    private void appendEnumModeIdentities(int recordIndex, StringBuilder stringBody, String operationType) {
        stringBody.append("&").append(operationType).append("[").append(recordIndex).append("].uses.doorMode=").append(true);
        stringBody.append("&").append(operationType).append("[").append(recordIndex).append("].multiLevel=").append(true);
    }

    private void appendUuidToDeleteObject(int recordIndex, String uuid, StringBuilder objectBody, String objectName) {
        if (objectBody.length() > 0) {
            objectBody.append("&");
        }
        objectBody.append(objectName).append("[").append(recordIndex).append("].uuid=").append(uuid);
    }

    private void appendUnidToDeleteObject(int recordIndex, String unid, StringBuilder objectBody, String objectName) {
        if (objectBody.length() > 0) {
            objectBody.append("&");
        }
        objectBody.append(objectName).append("[").append(recordIndex).append("].unid=").append(unid);
    }

    private void appendWeekScheduleDay(int recordIndex, StringBuilder stringBody, int weekOrdinal, String operationType, AtomicInteger scheduleEventIndex) {
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "schedDays", weekOrdinal);
    }

    private void appendEnumModeLevel(int recordIndex, StringBuilder stringBody, String operationType, AtomicInteger scheduleEventIndex, int value) {
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "level", value);
    }

    private void appendScheduleCommonData(int recordIndex, StringBuilder stringBody, String operationType, AtomicInteger scheduleEventIndex) {
        stringBody.append("&").append(operationType).append("[");
        stringBody.append(recordIndex);
        stringBody.append("].elements[");
        stringBody.append(scheduleEventIndex.get());
    }

    private void appendHolidayInSchedule(int recordIndex, StringBuilder stringBody, String operationType, AtomicInteger scheduleEventIndex) {
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "holidays", "false");
    }

    public final BTime getSubtractedTime(BTime endTime, BRelTime duration) {
        if (!endTime.equals((Object)BTime.DEFAULT)) {
            return BTime.make((BRelTime)BRelTime.make((long)(endTime.getTimeOfDayMillis() - duration.getMillis())));
        }
        return BTime.make((int)23, (int)59, (int)59);
    }

    private void appendTimeScheduleData(BDaySchedule scheduleComponent, StringBuilder stringBody, int recordIndex, int weekOrdinal, String operationType, AtomicInteger scheduleEventIndex, boolean defaultValue) {
        BTimeSchedule[] timeScheduleList = scheduleComponent.getTimesInOrder();
        BTime initialTime = BTime.DEFAULT;
        int scheduleIndex = 0;
        BTime startTime = BTime.DEFAULT;
        BTime endTime = BTime.DEFAULT;
        if (timeScheduleList.length > 0) {
            while (timeScheduleList.length > scheduleIndex) {
                BTimeSchedule timeScheduleComponent = timeScheduleList[scheduleIndex];
                if (!timeScheduleComponent.isSubscribed()) {
                    timeScheduleComponent.lease();
                }
                if (!initialTime.equals((Object)(startTime = timeScheduleComponent.getStart()))) {
                    endTime = startTime;
                    if (defaultValue) {
                        this.createScheduleRow(stringBody, recordIndex, weekOrdinal, operationType, scheduleEventIndex, initialTime, endTime);
                    }
                    initialTime = startTime;
                } else {
                    boolean effectiveValue = BBoolean.make((String)timeScheduleComponent.getEffectiveValue().getValueValue().toString()).getBoolean();
                    if (effectiveValue) {
                        this.createScheduleRow(stringBody, recordIndex, weekOrdinal, operationType, scheduleEventIndex, startTime, endTime);
                    }
                    ++scheduleIndex;
                    initialTime = timeScheduleComponent.getFinish();
                }
                endTime = timeScheduleComponent.getFinish();
            }
            if (!endTime.equals((Object)BTime.DEFAULT) && defaultValue) {
                this.createScheduleRow(stringBody, recordIndex, weekOrdinal, operationType, scheduleEventIndex, endTime, BTime.DEFAULT);
            }
        } else if (defaultValue) {
            this.createScheduleRow(stringBody, recordIndex, weekOrdinal, operationType, scheduleEventIndex, startTime, endTime);
        }
    }

    private void appendEnumTimeScheduleData(BDaySchedule scheduleComponent, StringBuilder stringBody, int recordIndex, int weekOrdinal, String operationType, AtomicInteger scheduleEventIndex, BStatusValue defaultValue, Set<Integer> uniqueDoorModeValues) {
        BTimeSchedule[] timeScheduleList = scheduleComponent.getTimesInOrder();
        int actualValueOrdinal = ((BDynamicEnum)defaultValue.getValueValue()).getOrdinal();
        BTime initialTime = BTime.DEFAULT;
        int scheduleIndex = 0;
        BTime startTime = BTime.DEFAULT;
        BTime endTime = BTime.DEFAULT;
        if (timeScheduleList.length > 0) {
            while (timeScheduleList.length > scheduleIndex) {
                BTimeSchedule timeScheduleComponent = timeScheduleList[scheduleIndex];
                if (!timeScheduleComponent.isSubscribed()) {
                    timeScheduleComponent.lease();
                }
                if (!initialTime.equals((Object)(startTime = timeScheduleComponent.getStart()))) {
                    endTime = startTime;
                    if (!defaultValue.getStatus().isNull()) {
                        uniqueDoorModeValues.add(actualValueOrdinal);
                        this.createEnumModeScheduleRow(stringBody, recordIndex, operationType, scheduleEventIndex, initialTime, endTime, actualValueOrdinal, weekOrdinal);
                    }
                    initialTime = startTime;
                } else {
                    if (!timeScheduleComponent.getEffectiveValue().getStatus().isNull()) {
                        int effectiveValue = ((BDynamicEnum)timeScheduleComponent.getEffectiveValue().getValueValue()).getOrdinal();
                        uniqueDoorModeValues.add(effectiveValue);
                        this.createEnumModeScheduleRow(stringBody, recordIndex, operationType, scheduleEventIndex, startTime, endTime, effectiveValue, weekOrdinal);
                    }
                    ++scheduleIndex;
                    initialTime = timeScheduleComponent.getFinish();
                }
                endTime = timeScheduleComponent.getFinish();
            }
            if (!endTime.equals((Object)BTime.DEFAULT) && !defaultValue.getStatus().isNull()) {
                uniqueDoorModeValues.add(actualValueOrdinal);
                this.createEnumModeScheduleRow(stringBody, recordIndex, operationType, scheduleEventIndex, endTime, BTime.DEFAULT, actualValueOrdinal, weekOrdinal);
            }
        } else if (!defaultValue.getStatus().isNull()) {
            uniqueDoorModeValues.add(actualValueOrdinal);
            this.createEnumModeScheduleRow(stringBody, recordIndex, operationType, scheduleEventIndex, startTime, endTime, actualValueOrdinal, weekOrdinal);
        }
    }

    private void createScheduleRow(StringBuilder stringBody, int recordIndex, int weekOrdinal, String operationType, AtomicInteger scheduleEventIndex, BTime startTime, BTime endTime) {
        this.appendTimeScheduleEncodedData(stringBody, startTime, endTime, recordIndex, operationType, scheduleEventIndex);
        this.appendWeekScheduleDay(recordIndex, stringBody, weekOrdinal, operationType, scheduleEventIndex);
        scheduleEventIndex.incrementAndGet();
    }

    private void createEnumModeScheduleRow(StringBuilder stringBody, int recordIndex, String operationType, AtomicInteger scheduleEventIndex, BTime startTime, BTime endTime, int value, int weekOrdinal) {
        this.appendTimeScheduleEncodedData(stringBody, startTime, endTime, recordIndex, operationType, scheduleEventIndex);
        this.appendEnumModeLevel(recordIndex, stringBody, operationType, scheduleEventIndex, value);
        this.appendWeekScheduleDay(recordIndex, stringBody, weekOrdinal, operationType, scheduleEventIndex);
        scheduleEventIndex.incrementAndGet();
    }

    private void appendTimeScheduleEncodedData(StringBuilder stringBody, BTime startTime, BTime endTime, int recordIndex, String operationType, AtomicInteger scheduleEventIndex) {
        endTime = this.getSubtractedTime(endTime, BRelTime.SECOND);
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "start_hour", startTime.getHour());
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "start_minute", startTime.getMinute());
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "start_second", startTime.getSecond());
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "stop_hour", endTime.getHour());
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "stop_minute", endTime.getMinute());
        this.appendScheduleCommonData(recordIndex, stringBody, operationType, scheduleEventIndex);
        this.appendKeyAndValue(stringBody, "stop_second", endTime.getSecond());
    }

    private void appendKeyAndValue(StringBuilder stringBody, String scheduleKey, int scheduleValue) {
        stringBody.append("].");
        stringBody.append(scheduleKey);
        stringBody.append("=");
        stringBody.append(scheduleValue);
    }

    private void appendKeyAndValue(StringBuilder stringBody, String scheduleKey, String scheduleValue) {
        stringBody.append("].");
        stringBody.append(scheduleKey);
        stringBody.append("=");
        stringBody.append(scheduleValue);
    }

    private void updateItemsToRemoveDoors(BAccReaderRec readerRec, ArrayList<Pair<String, BNACReader>> addItemsToDoorList) {
        String readerDisplayPath = "station:|" + MappingSupport.displayPathToSlotOrd((String)readerRec.getReaderDisplayPath());
        BNACReader reader = (BNACReader)BOrd.make((String)readerDisplayPath).resolve().get();
        if (reader.getLastReplicatedDoorUnid() == 0) {
            addItemsToDoorList.add((Pair<String, BNACReader>)new Pair((Object)readerRec.getUuid().toString(), (Object)reader));
            return;
        }
        if (reader.getDoor() != null && reader.getLastReplicatedDoorUnid() == reader.getDoor().getUnid()) {
            return;
        }
        this.accessRightRemoveFromDoor(reader);
        this.accessZoneRemoveFromDoor(reader);
        reader.setLastReplicatedDoorUnid(0);
        addItemsToDoorList.add((Pair<String, BNACReader>)new Pair((Object)readerRec.getUuid().toString(), (Object)reader));
    }

    private void accessZoneRemoveFromDoor(BNACReader reader) {
        if (reader.getLastReplicatedDoorUnid() == 0) {
            return;
        }
        int doorUnid = reader.getLastReplicatedDoorUnid();
        String body = "devUpdate[0].unid=" + doorUnid + "&devUpdate[0].entryArea.unid=&devUpdate[0].exitArea.unid=";
        this.executeMultiDbChange(body);
        this.logTrace("NAC - Cleaned access zones from old door for reader " + reader.getDisplayName(null));
    }

    private void accessRightRemoveFromDoor(BNACReader reader) {
        if (reader.getLastReplicatedDoorUnid() == 0) {
            return;
        }
        int doorUnid = reader.getLastReplicatedDoorUnid();
        JSONObject privs = AccessController.doPrivileged(() -> {
            try {
                NACServerTokenRequest request = new NACServerTokenRequest(this.getNetwork().getHttpConfig().getAddress(), "GET", "/priv/list?privTypeRestriction.privTypes=0", this.network.getSessionToken());
                String response = new String(this.network.sendHttpRequest(request).getData());
                return new JSONObject(response);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        JSONArray privList = privs.getJSONArray("instanceList");
        AtomicInteger recordIndex = new AtomicInteger(0);
        StringBuilder body = new StringBuilder();
        for (Object priv : privList) {
            JSONObject privJson = (JSONObject)priv;
            NACReplicator.appendAccReaderJoinDeleteBody(doorUnid, recordIndex, body, privJson);
            if (recordIndex.get() < 100) continue;
            this.executeMultiDbChange(body.toString());
            this.logTrace("NAC - Cleaned " + recordIndex + " access right from old door for reader " + reader.getDisplayName(null));
            recordIndex.set(0);
            body = new StringBuilder();
        }
        if (recordIndex.get() > 0) {
            this.executeMultiDbChange(body.toString());
            this.logTrace("NAC - Cleaned " + recordIndex + " access right from old door for reader " + reader.getDisplayName(null));
        }
    }

    private static void appendAccReaderJoinDeleteBody(int doorUnid, AtomicInteger recordIndex, StringBuilder body, JSONObject privJson) {
        JSONArray privElements = privJson.getJSONArray("elements");
        for (Object privElement : privElements) {
            JSONObject privElementJson = (JSONObject)privElement;
            int unid = privElementJson.getJSONObject("door").getInt("unid");
            if (unid != doorUnid) continue;
            if (body.length() > 0) {
                body.append("&");
            }
            body.append("privUpdate[").append(recordIndex).append("]").append(".unid=").append(privJson.getInt("unid")).append("&");
            body.append("privUpdate[").append(recordIndex).append("]").append(".elements[0].unid=").append(privElementJson.getInt("unid")).append("&");
            body.append("privUpdate[").append(recordIndex).append("]").append(".elements[0].deleted=true");
            recordIndex.incrementAndGet();
            return;
        }
    }

    private void executeMultiDbChange(String body) {
        if (body.length() == 0) {
            return;
        }
        AccessController.doPrivileged(() -> {
            try {
                this.executeMultiDbChangePublic(body);
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void executeMultiDbChangePublic(String body) throws Exception {
        String uri = "/executeMultiDbChange";
        NACServerTokenRequest request = new NACServerTokenRequest(this.getNetwork().getHttpConfig().getAddress(), "POST", uri, this.getNetwork().getSessionToken());
        request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
        request.setData(body);
        this.getNetwork().sendHttpRequest(request);
    }

    private OrionCursor getNACCursor(BAbsTime timestamp, int numOfTimestamps, OrionType type, String sql, int operation, OrionSession session) {
        BSimple[] params;
        int timeParams = 2 * numOfTimestamps;
        if (operation == 1) {
            params = new BSimple[timeParams + 1];
            params[timeParams] = type.getTypeSpec();
        } else {
            params = new BSimple[timeParams];
        }
        for (int i = 0; i < timeParams; ++i) {
            params[i] = i % 2 == 0 ? timestamp : this.repStartTime;
        }
        return operation == 1 ? session.select(BDeletion.ORION_TYPE, sql, params) : session.select(type, sql, params);
    }

    private JSONObject getInstanceFromServer(String uuid, String objectName) {
        return AccessController.doPrivileged(() -> this.getRecordIfAvailable(uuid, objectName));
    }

    public JSONObject getRecordIfAvailable(String uuid, String resource) {
        try {
            return NACRequestUtils.showResource(this.getNetwork(), resource, uuid, 0).getJSONObject("instance");
        }
        catch (NCommException e) {
            if (e.getMessage().startsWith("Error 404")) {
                return null;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getWiegandData(BIOrionObject record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation) {
        StringBuilder wiegandBody = new StringBuilder();
        BWiegandFormat wiegandRecord = (BWiegandFormat)record;
        String uuid = wiegandRecord.getWiegandFormatId().toString();
        JSONObject instance = this.getInstanceFromServer(uuid, "dataFormat");
        if (operation == 1) {
            if (instance != null) {
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, wiegandBody, "dataFormatDelete");
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, wiegandBody, "dataLayoutDelete");
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, wiegandBody, "credTemplateDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
            return wiegandBody.toString();
        }
        if (instance != null) {
            this.createWiegandInNACSystem(wiegandRecord, (AtomicInteger)operationIndex.getSecond(), uuid, "dataFormatUpdate", "dataLayoutUpdate", wiegandBody);
        } else {
            this.createWiegandInNACSystem(wiegandRecord, (AtomicInteger)operationIndex.getFirst(), uuid, "dataFormatInsert", "dataLayoutInsert", wiegandBody);
        }
        return wiegandBody.toString();
    }

    private String getAccessRightData(BIOrionObject record, Triple<AtomicInteger, AtomicInteger, AtomicInteger> operationIndex, int operation, OrionSession session) {
        StringBuilder accessRightBody = new StringBuilder();
        BAccessRight accessRightRecord = (BAccessRight)record;
        String uuid = ((BAccessRight)record).getAccessRightId().toString();
        JSONObject instance = this.getInstanceFromServer(uuid, "priv");
        if (operation == 1) {
            if (instance != null) {
                this.appendUuidToDeleteObject(((AtomicInteger)operationIndex.getThird()).get(), uuid, accessRightBody, "privDelete");
                ((AtomicInteger)operationIndex.getThird()).incrementAndGet();
            }
            return accessRightBody.toString();
        }
        if (instance != null) {
            this.createAccessRightInNACSystem(accessRightRecord, (AtomicInteger)operationIndex.getSecond(), uuid, "privUpdate", accessRightBody, session);
        } else {
            this.createAccessRightInNACSystem(accessRightRecord, (AtomicInteger)operationIndex.getFirst(), uuid, "privInsert", accessRightBody, session);
        }
        return accessRightBody.toString();
    }

    private void createAccessRightInNACSystem(BAccessRight accessRightRecord, AtomicInteger recordIndex, String uuid, String accessRightOperation, StringBuilder accessRightBody, OrionSession session) {
        boolean enableAccessRight = true;
        BThreatLevelGroupRec threatLevelGroupRec = accessRightRecord.resolveThreatLevelGroup(session);
        if (threatLevelGroupRec != null) {
            enableAccessRight = ThreatLevelUtil.compareThreatOperationLevel((BThreatLevelOperationEnum)accessRightRecord.getThreatLevelOperation(), (int)threatLevelGroupRec.getActiveLevel().getOrdinal(), (int)accessRightRecord.getDefaultAssignedThreatLevel().getOrdinal());
        }
        if (accessRightRecord.getSchedule().getId() != null) {
            accessRightOperation = accessRightOperation + "[" + recordIndex.get() + "]";
            accessRightBody.append(accessRightOperation).append(".uuid=").append(uuid).append("&");
            accessRightBody.append(accessRightOperation).append(".name=").append(accessRightRecord.getAccessRightName()).append("&");
            accessRightBody.append(accessRightOperation).append(".privType=").append(0).append("&");
            accessRightBody.append(accessRightOperation).append(".enabled=").append(enableAccessRight).append("&");
            String scheduleUuid = accessRightRecord.getSchedule().getId().toString();
            accessRightBody.append(accessRightOperation).append(".schedRestriction.sched.uuid=").append(scheduleUuid);
            recordIndex.incrementAndGet();
        }
    }

    private void createWiegandInNACSystem(BWiegandFormat wiegandRecord, AtomicInteger recordIndex, String uuid, String badgeFormatOperation, String badgeLayoutOperation, StringBuilder wiegandBody) {
        AtomicInteger dataFormatElementsIndex = new AtomicInteger(0);
        badgeFormatOperation = badgeFormatOperation + "[" + recordIndex.get() + "]";
        badgeLayoutOperation = badgeLayoutOperation + "[" + recordIndex.get() + "]";
        if (badgeFormatOperation.startsWith("dataFormatInsert")) {
            int commonIdentifier = -1 - recordIndex.get();
            String credTemplateOperation = "credTemplateInsert[" + recordIndex.get() + "]";
            wiegandBody.append(badgeFormatOperation).append(".unid=").append(commonIdentifier).append("&");
            wiegandBody.append(badgeLayoutOperation).append(".dataFormat.id=").append(commonIdentifier).append("&");
            wiegandBody.append(badgeLayoutOperation).append(".unid=").append(commonIdentifier).append("&");
            wiegandBody.append(credTemplateOperation).append(".name=").append(wiegandRecord.getWiegandFormatName()).append("&");
            wiegandBody.append(credTemplateOperation).append(".uuid=").append(uuid).append("&");
            wiegandBody.append(credTemplateOperation).append(".cardPinTemplate.dataLayout.id=").append(commonIdentifier).append("&");
            wiegandBody.append(credTemplateOperation).append(".cardPinTemplate.credNumPresence=").append(1).append("&");
            wiegandBody.append(credTemplateOperation).append(".cardPinTemplate.credComponentPresence=").append(1).append("&");
        }
        wiegandBody.append(badgeFormatOperation).append(".uuid=").append(uuid).append("&");
        wiegandBody.append(badgeFormatOperation).append(".name=").append(wiegandRecord.getWiegandFormatName()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".minBits=").append(wiegandRecord.getBitLength()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".maxBits=").append(wiegandRecord.getBitLength()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".enabled=").append("true").append("&");
        wiegandBody.append(badgeFormatOperation).append(".dataFormatType=").append("1");
        if (!wiegandRecord.getValidationBits().equals((Object)BValidationBits.credentialOnly) && wiegandRecord.getFacilityLength() > 0) {
            NACReplicator.insertFacilityElement(wiegandRecord, badgeFormatOperation, wiegandBody, dataFormatElementsIndex);
        }
        NACReplicator.insertCredentialElement(wiegandRecord, badgeFormatOperation, wiegandBody, dataFormatElementsIndex);
        this.insertStaticAndParityElements(wiegandRecord, badgeFormatOperation, wiegandBody, dataFormatElementsIndex);
        wiegandBody.append("&").append(badgeLayoutOperation).append(".uuid=").append(uuid).append("&");
        wiegandBody.append(badgeLayoutOperation).append(".name=").append(wiegandRecord.getWiegandFormatName()).append("&");
        wiegandBody.append(badgeLayoutOperation).append(".layoutType=").append("0").append("&");
        wiegandBody.append(badgeLayoutOperation).append(".enabled=").append("true");
        recordIndex.incrementAndGet();
    }

    private void insertStaticAndParityElements(BWiegandFormat wiegandRecord, String badgeFormatOperation, StringBuilder wiegandBody, AtomicInteger dataFormatElementsIndex) {
        char[] wiegandFormatArray = wiegandRecord.getFormat().toCharArray();
        String[] parityArray = wiegandRecord.getParity().split("(?<=\\G.{" + wiegandRecord.getBitLength() + "})");
        int parityLocationPos = 0;
        boolean parityValidationNeeded = wiegandRecord.getValidationBits().equals((Object)BValidationBits.all);
        for (int i = 0; i < wiegandFormatArray.length; ++i) {
            int endPos;
            if (wiegandFormatArray[i] == '0' || wiegandFormatArray[i] == '1') {
                wiegandBody.append("&").append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".len=").append("1").append("&");
                wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".num=").append(dataFormatElementsIndex).append("&");
                wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".type=").append(0).append("&");
                wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".start=").append(i).append("&");
                wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".value=").append(wiegandFormatArray[i]).append("&");
                wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".deleted=false");
                dataFormatElementsIndex.incrementAndGet();
                continue;
            }
            if (!parityValidationNeeded || wiegandFormatArray[i] != 'P') continue;
            boolean isOdd = true;
            int startPos = 0;
            int srcLength = 0;
            String wiegandMask = "";
            if (parityArray[parityLocationPos].contains("E")) {
                startPos = parityArray[parityLocationPos].indexOf(69);
                endPos = parityArray[parityLocationPos].lastIndexOf(69);
                srcLength = endPos - startPos + 1;
                isOdd = false;
                wiegandMask = this.getWiegandMask(parityArray[parityLocationPos], 'E', startPos, endPos + 1, i);
            }
            if (parityArray[parityLocationPos].contains("O")) {
                startPos = parityArray[parityLocationPos].indexOf(79);
                endPos = parityArray[parityLocationPos].lastIndexOf(79);
                srcLength = endPos - startPos + 1;
                wiegandMask = this.getWiegandMask(parityArray[parityLocationPos], 'O', startPos, endPos + 1, i);
                isOdd = true;
            }
            wiegandBody.append("&").append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".len=").append("1").append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".num=").append(dataFormatElementsIndex).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".type=").append(1).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".start=").append(i).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".srcStart=").append(startPos).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".srcLen=").append(srcLength).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".mask=").append(wiegandMask).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".odd=").append(isOdd).append("&");
            wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".deleted=false");
            dataFormatElementsIndex.incrementAndGet();
            ++parityLocationPos;
        }
    }

    private static void insertCredentialElement(BWiegandFormat wiegandRecord, String badgeFormatOperation, StringBuilder wiegandBody, AtomicInteger dataFormatElementsIndex) {
        wiegandBody.append("&").append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].start=").append(wiegandRecord.getCredentialStart()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].len=").append(wiegandRecord.getCredentialLength()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].type=").append(2).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].field=").append(0).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].num=").append("1").append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".deleted=false");
        dataFormatElementsIndex.incrementAndGet();
    }

    private static void insertFacilityElement(BWiegandFormat wiegandRecord, String badgeFormatOperation, StringBuilder wiegandBody, AtomicInteger dataFormatElementsIndex) {
        wiegandBody.append("&").append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].start=").append(wiegandRecord.getFacilityStart()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].len=").append(wiegandRecord.getFacilityLength()).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].type=").append(2).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].field=").append(1).append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("].num=").append("0").append("&");
        wiegandBody.append(badgeFormatOperation).append(".elements").append("[").append(dataFormatElementsIndex).append("]").append(".deleted=false");
        dataFormatElementsIndex.incrementAndGet();
    }

    private String getWiegandMask(String wiegandParityText, char parityElement, int parityStartPos, int parityEndPos, int parityIndex) {
        StringBuilder sb = new StringBuilder(wiegandParityText);
        sb.setCharAt(parityIndex, '0');
        return sb.substring(parityStartPos, parityEndPos).replace(parityElement, '1').replace('-', '0');
    }

    private BNACNetwork getNetwork() {
        if (this.network == null) {
            this.network = (BNACNetwork)Sys.getService((Type)BTypeSpec.make((String)"nacDriver:NACNetwork").getResolvedType());
        }
        return this.network;
    }

    private JSONObject lookupCredRestriction(String idNum) {
        return AccessController.doPrivileged(() -> {
            try {
                return this.lookupCredRestrictionPublic(idNum);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public JSONObject lookupCredRestrictionPublic(String idNum) throws Exception {
        String uri = "/cred/list?lookupCredRestriction.idNum=" + idNum;
        NACServerTokenRequest request = new NACServerTokenRequest(this.network.getHttpConfig().getAddress(), "GET", uri, this.network.getSessionToken());
        String response = new String(this.network.sendHttpRequest(request).getData());
        JSONObject responseJSON = new JSONObject(response);
        JSONArray instanceList = responseJSON.getJSONArray("instanceList");
        if (instanceList.isEmpty()) {
            return null;
        }
        return instanceList.getJSONObject(0);
    }
}

