/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.replicate;

import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="minPinLength", type="int", defaultValue="BInteger.make(1)", flags=5), @NiagaraProperty(name="maxPinLength", type="int", defaultValue="BInteger.make(8)", flags=5), @NiagaraProperty(name="authorizationCodePresence", type="int", defaultValue="BInteger.make(0)", flags=5), @NiagaraProperty(name="credComponentPresence", type="int", defaultValue="BInteger.make(1)", flags=5), @NiagaraProperty(name="pinPresence", type="int", defaultValue="BInteger.make(1)", flags=5), @NiagaraProperty(name="credNumPresence", type="int", defaultValue="BInteger.make(0)", flags=5), @NiagaraProperty(name="unid", type="int", defaultValue="0", flags=5)})
public class BCardPinTemplate
extends BComponent
implements BINACMappable {
    @Generated
    public static final Property minPinLength = BCardPinTemplate.newProperty((int)5, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Property maxPinLength = BCardPinTemplate.newProperty((int)5, (BValue)BInteger.make((int)8), null);
    @Generated
    public static final Property authorizationCodePresence = BCardPinTemplate.newProperty((int)5, (BValue)BInteger.make((int)0), null);
    @Generated
    public static final Property credComponentPresence = BCardPinTemplate.newProperty((int)5, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Property pinPresence = BCardPinTemplate.newProperty((int)5, (BValue)BInteger.make((int)1), null);
    @Generated
    public static final Property credNumPresence = BCardPinTemplate.newProperty((int)5, (BValue)BInteger.make((int)0), null);
    @Generated
    public static final Property unid = BCardPinTemplate.newProperty((int)5, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCardPinTemplate.class);
    private final AtomicBoolean taskInQueue = new AtomicBoolean(false);

    @Generated
    public int getMinPinLength() {
        return this.getInt(minPinLength);
    }

    @Generated
    public void setMinPinLength(int v) {
        this.setInt(minPinLength, v, null);
    }

    @Generated
    public int getMaxPinLength() {
        return this.getInt(maxPinLength);
    }

    @Generated
    public void setMaxPinLength(int v) {
        this.setInt(maxPinLength, v, null);
    }

    @Generated
    public int getAuthorizationCodePresence() {
        return this.getInt(authorizationCodePresence);
    }

    @Generated
    public void setAuthorizationCodePresence(int v) {
        this.setInt(authorizationCodePresence, v, null);
    }

    @Generated
    public int getCredComponentPresence() {
        return this.getInt(credComponentPresence);
    }

    @Generated
    public void setCredComponentPresence(int v) {
        this.setInt(credComponentPresence, v, null);
    }

    @Generated
    public int getPinPresence() {
        return this.getInt(pinPresence);
    }

    @Generated
    public void setPinPresence(int v) {
        this.setInt(pinPresence, v, null);
    }

    @Generated
    public int getCredNumPresence() {
        return this.getInt(credNumPresence);
    }

    @Generated
    public void setCredNumPresence(int v) {
        this.setInt(credNumPresence, v, null);
    }

    @Override
    @Generated
    public int getUnid() {
        return this.getInt(unid);
    }

    @Generated
    public void setUnid(int v) {
        this.setInt(unid, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void storeMapping(int unid) {
    }

    @Override
    public void addToServer(boolean partOfSync) {
        Utils.checkNACPermission();
        if (this.getUnid() == 0) {
            this.getNACNetwork().postAsync(() -> {
                if (!partOfSync && this.getNACNetwork().getSyncingToServer()) {
                    this.getNACNetwork().getLogger().log(Level.WARNING, "Cannot add card template to the server when syncing is in progress");
                    return;
                }
                try {
                    this.syncCardTemplate();
                }
                catch (PrivilegedActionException e) {
                    this.getNACNetwork().log().log(Level.SEVERE, "Cred template creation failed");
                    throw new RuntimeException(e);
                }
            });
        }
    }

    @Override
    public void syncToServer() {
        Runnable r = () -> {
            try {
                this.syncCardTemplate();
            }
            catch (PrivilegedActionException e) {
                this.getNACNetwork().log().log(Level.SEVERE, "Cred template creation failed");
                throw new RuntimeException(e);
            }
        };
        Utils.runSyncToServer(this.getNACNetwork(), this.taskInQueue, r, 1000L);
    }

    private void syncCardTemplate() throws PrivilegedActionException {
        AccessController.doPrivileged(() -> {
            NACRequestUtils.setUnidOnCardTemplateFromNACServer(this.getNACNetwork());
            return null;
        });
    }

    @Override
    public boolean getEnabled() {
        return false;
    }

    public void changed(Property property, Context cx) {
        super.changed(property, cx);
        if (!this.isRunning() || cx != null && cx.equals(Context.decoding)) {
            return;
        }
        if (!property.equals(unid)) {
            this.syncToServer();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNACNetwork;
    }

    @Override
    public void updateState(JSONObject devState) {
    }

    @Override
    public void cleanDeviceUnids() {
        this.setUnid(0);
    }

    private BNACNetwork getNACNetwork() {
        return (BNACNetwork)this.getParent();
    }
}

