/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.learn;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.learn.BNACAccessLearnDeviceEntry;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.util.logging.Level;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BFolder;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperty(name="learnedDevices", type="BFolder", defaultValue="new BFolder()", flags=7)
public class BNACLearnDevicesJob
extends BSimpleJob {
    @Generated
    public static final Property learnedDevices = BNACLearnDevicesJob.newProperty((int)7, (BValue)new BFolder(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNACLearnDevicesJob.class);
    private BNACNetwork network;

    @Generated
    public BFolder getLearnedDevices() {
        return (BFolder)this.get(learnedDevices);
    }

    @Generated
    public void setLearnedDevices(BFolder v) {
        this.set(learnedDevices, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    void addLearnedDevice(JSONObject object) {
        JSONArray addresses = object.getJSONArray("hostAddresses");
        for (Object address : addresses) {
            String learnName = "d-" + address;
            if (this.getLearnedDevices().get(SlotPath.escape((String)learnName)) != null) continue;
            try {
                this.getLearnedDevices().add(SlotPath.escape((String)learnName), (BValue)new BNACAccessLearnDeviceEntry(object, (String)address));
                this.logMessage("found device " + learnName);
            }
            catch (Exception e) {
                this.log().failed(learnName + " : " + e.getMessage());
            }
        }
    }

    public void run(Context cx) {
        this.network = (BNACNetwork)Sys.getService((Type)BTypeSpec.make((String)"nacDriver:NACNetwork").getResolvedType());
        this.logMessage("Starting");
        this.getLearnedDevices().removeAll();
        JSONObject response = AccessController.doPrivileged(() -> {
            try {
                return NACRequestUtils.discoverDevice(this.network);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        JSONArray instances = response.getJSONArray("instanceList");
        for (int i = 0; i < instances.length(); ++i) {
            this.addLearnedDevice((JSONObject)instances.get(i));
        }
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null && this.network.log().isLoggable(Level.FINE)) {
            this.network.log().log(Level.FINE, "Learn Access Devices Job:" + message);
        }
    }
}

