/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.job;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.comm.NCommException;
import com.tridiumx.entsec.orionTools.BMappedEnumScheduleExt;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACDoorModeSchedule;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BDeleteScheduleLinkFromDoorJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BDeleteScheduleLinkFromDoorJob.class);
    private BNACDoorModeSchedule nacDoorModeSchedule;
    private BNACDoor nacDoor;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDeleteScheduleLinkFromDoorJob() {
    }

    public BDeleteScheduleLinkFromDoorJob(BNACDoorModeSchedule nacDoorModeSchedule, BNACDoor nacDoor) {
        this.nacDoorModeSchedule = nacDoorModeSchedule;
        this.nacDoor = nacDoor;
    }

    public void run(Context context) throws Exception {
        this.deleteScheduleLinkFromDoor();
    }

    private void deleteScheduleLinkFromDoor() throws Exception {
        AtomicBoolean isSuccess = new AtomicBoolean(true);
        try {
            this.progress(10);
            BNACNetwork nacNetwork = this.nacDoor.getNACNetwork();
            if (nacNetwork != null && nacNetwork.getStatus().isValid()) {
                if (nacNetwork.getSessionToken() != null) {
                    this.appendDeleteScheduleMappingToDoor((BCompositeSchedule)this.nacDoorModeSchedule, nacNetwork, isSuccess);
                    this.progress(80);
                } else {
                    isSuccess.set(false);
                    this.log().failed("Not connected to the server.");
                }
            } else {
                isSuccess.set(false);
                this.log().failed("Delete door mapping from " + this.nacDoorModeSchedule.getDisplayName(null) + " schedule not initiated. Network status is " + nacNetwork.getStatus());
            }
        }
        catch (Exception ex) {
            this.failed(ex);
        }
        this.progress(100);
        if (!isSuccess.get()) {
            this.failed(new Exception("Delete door mapping with schedule could not be completed. Please sync to update the server."));
            throw new Exception("Delete door mapping with schedule could not be completed. Please sync to update the server.");
        }
        this.log().success("Delete door mapping with schedule completed successfully.");
    }

    public final void appendDeleteScheduleMappingToDoor(BCompositeSchedule schedule, BNACNetwork nacNetwork, AtomicBoolean isSuccess) throws Exception {
        BMappedEnumScheduleExt mappedEnumScheduleExt = (BMappedEnumScheduleExt)Arrays.stream(schedule.getChildren(BMappedEnumScheduleExt.class)).findFirst().get();
        if (mappedEnumScheduleExt != null && !mappedEnumScheduleExt.getUuid().toString().isEmpty()) {
            if (this.nacDoor.getUnid() != 0) {
                JSONObject scheduleInstance = this.getInstanceFromServer(mappedEnumScheduleExt.getUuid().toString(), "sched");
                if (scheduleInstance != null) {
                    JSONObject doorInstance = this.getInstanceFromServer(String.valueOf(this.nacDoor.getUnid()), "dev");
                    if (!doorInstance.isEmpty()) {
                        JSONArray templatedPolicies;
                        if (doorInstance.has("templatedPolicies") && (templatedPolicies = doorInstance.getJSONArray("templatedPolicies")).length() > 0) {
                            for (int i = 0; i < templatedPolicies.length(); ++i) {
                                JSONObject templatePolicy = templatedPolicies.getJSONObject(i);
                                StringBuilder stringBody = new StringBuilder();
                                this.appendDeleteDoorMappedWithScheduleStringBody(stringBody, templatePolicy, mappedEnumScheduleExt);
                                try {
                                    BDeleteScheduleLinkFromDoorJob.deleteDoorMappingFromSchedule(stringBody.toString(), nacNetwork);
                                    continue;
                                }
                                catch (NCommException e) {
                                    if (e.getMessage().startsWith("Error 503")) {
                                        isSuccess.set(false);
                                    }
                                    throw new RuntimeException(e);
                                }
                                catch (Exception e) {
                                    throw new RuntimeException(e);
                                }
                            }
                        }
                    } else {
                        this.log().failed("Door name " + this.nacDoor.getDisplayName(null) + " does not exists on the server");
                    }
                } else {
                    this.log().failed("Schedule name " + schedule.getDisplayName(null) + " does not exists on the server");
                }
            } else {
                this.log().failed("Door name " + this.nacDoor.getDisplayName(null) + " status is offline");
            }
        } else {
            this.log().failed("Schedule name " + schedule.getDisplayName(null) + " does not contain the UUID");
        }
    }

    private void appendDeleteDoorMappedWithScheduleStringBody(StringBuilder stringBody, JSONObject templatePolicy, BMappedEnumScheduleExt mappedEnumScheduleExt) {
        if (templatePolicy.has("ownerDev") && templatePolicy.has("sched")) {
            JSONObject owner = templatePolicy.getJSONObject("ownerDev");
            JSONObject schedule = templatePolicy.getJSONObject("sched");
            if (owner.getInt("unid") == this.nacDoor.getUnid() && schedule.getString("uuid").equals(mappedEnumScheduleExt.getUuid().toString())) {
                stringBody.append("devUpdate").append("[").append(0).append("]").append(".id=").append(this.nacDoor.getUnid());
                stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".unid=").append(this.nacDoor.getUnid());
                stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[").append(0).append("].id=").append(templatePolicy.getInt("unid"));
                stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[").append(0).append("].unid=").append(templatePolicy.getInt("unid"));
                stringBody.append("&").append("devUpdate").append("[").append(0).append("]").append(".templatedPolicies[").append(0).append("].deleted=").append(true);
            }
        }
    }

    private JSONObject getInstanceFromServer(String uuid, String objectName) throws Exception {
        try {
            return NACRequestUtils.showResource(this.nacDoor.getNACNetwork(), objectName, uuid, 0).getJSONObject("instance");
        }
        catch (NCommException e) {
            if (e.getMessage().startsWith("Error 404")) {
                return null;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static JSONObject deleteDoorMappingFromSchedule(String body, BNACNetwork nacNetwork) throws Exception {
        try {
            return AccessController.doPrivileged(() -> NACRequestUtils.executeMultiDbChangePublic(body, nacNetwork));
        }
        catch (PrivilegedActionException pae) {
            throw pae.getException();
        }
    }
}

