/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.event;

import com.tridium.json.JSONArray;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.event.BNACDataWorker;
import com.tridiumx.nacDriver.event.EventRunnable;
import com.tridiumx.nacDriver.event.NACPoller;

public class NACEventPoller
extends NACPoller {
    private static final int[] EVENT_CODES = new int[]{48, 49, 52, 53, 54, 55, 56, 57, 86, 248, 249};
    private static String eventCodeRestriction;

    public NACEventPoller(BNACDataWorker worker, BNACNetwork network) {
        super(worker, network, "NACNetwork:EventPoller");
    }

    public NACEventPoller() {
    }

    @Override
    protected String getLongPollUri() {
        return "/json/getAllNewEvtWithTimeout?token=" + this.dynamicSessionToken + "&" + this.getEventCodeRestrictionUri() + "timeout=" + this.getTimeout();
    }

    private String getEventCodeRestrictionUri() {
        if (eventCodeRestriction == null) {
            StringBuilder builder = new StringBuilder();
            for (int eventCode : EVENT_CODES) {
                builder.append("evtCodeRestriction.evtCodes=").append(eventCode).append("&");
            }
            eventCodeRestriction = builder.toString();
        }
        return eventCodeRestriction;
    }

    @Override
    protected void postAsyncToWorker(JSONArray dataList) {
        int dataListSize = dataList.length();
        for (int i = 0; i < dataListSize; ++i) {
            this.worker.postAsync(new EventRunnable(dataList.getJSONObject(i), this.network));
        }
    }
}

