/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.event;

import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACNetwork;
import java.util.logging.Level;
import javax.baja.sys.BComponent;

public class DevChangeRunnable
implements Runnable {
    JSONObject devChangeRecord;
    BNACNetwork network;

    public DevChangeRunnable(JSONObject devChangeRecord, BNACNetwork network) {
        this.devChangeRecord = devChangeRecord;
        this.network = network;
    }

    @Override
    public void run() {
        if (this.devChangeRecord != null) {
            int unid = this.devChangeRecord.getInt("key");
            try {
                BComponent dev = this.network.getComponentByUnid(unid, true);
                if (dev != null) {
                    if (this.network.log().isLoggable(Level.FINE)) {
                        this.network.log().log(Level.FINE, "Dev state changed for : " + dev.getNavName());
                    }
                    if (dev instanceof BINACMappable) {
                        ((BINACMappable)dev).updateState(this.devChangeRecord.getJSONObject("value"));
                    }
                }
            }
            catch (Exception e) {
                this.network.log().log(Level.WARNING, "Dev Change Record cannot be processed for unid " + unid + " due to " + e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

