/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.doors;

import com.tridium.entsecDriver.BIAccessReader;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.nre.security.SecretBytes;
import com.tridiumx.accessDriver.BReaderProperty;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.accessDriver.enums.activity.BTimeAttendEnum;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.BMappedReaderExt;
import com.tridiumx.entsec.access.orion.BBadge;
import com.tridiumx.entsec.access.orion.BPerson;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACDevice;
import com.tridiumx.nacDriver.doors.BNACActivityAlertExt;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.enums.BLedTypeEnum;
import com.tridiumx.nacDriver.enums.BNACActivityStateEnum;
import com.tridiumx.nacDriver.enums.BNACReaderEncryptionEnum;
import com.tridiumx.nacDriver.enums.BNACReaderEncryptionStatusEnum;
import com.tridiumx.nacDriver.enums.BNACReaderTypeEnum;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BNACBeeper;
import com.tridiumx.nacDriver.point.BNACCrudActuatorPoint;
import com.tridiumx.nacDriver.point.BNACDevicePoint;
import com.tridiumx.nacDriver.point.BNACGreenLed;
import com.tridiumx.nacDriver.point.BNACPointDeviceExt;
import com.tridiumx.nacDriver.point.BNACProxyExt;
import com.tridiumx.nacDriver.point.BNACRedLed;
import com.tridiumx.nacDriver.util.NACOSDPKeyStoreUtils;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.alarm.BAlarmSourceInfo;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BNumericWritable;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;
import javax.baja.util.BNameList;
import javax.baja.util.BUuid;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="unid", type="int", defaultValue="0", flags=69), @NiagaraProperty(name="readerType", type="BNACReaderTypeEnum", defaultValue="BNACReaderTypeEnum.osdp", facets={@Facet(value="BFacets.make(BFacets.FIELD_EDITOR, \"workbench:LimitedFrozenEnumFE\")")}), @NiagaraProperty(name="attendance", type="BTimeAttendEnum", defaultValue="BTimeAttendEnum.DEFAULT"), @NiagaraProperty(name="address", type="int", defaultValue="0", flags=64, facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)")}), @NiagaraProperty(name="OSDPAddress", type="int", defaultValue="0", flags=64, facets={@Facet(name="BFacets.MIN", value="BInteger.make(0)"), @Facet(name="BFacets.MAX", value="BInteger.make(15)")}), @NiagaraProperty(name="firmwareVersion", type="String", defaultValue="", flags=65), @NiagaraProperty(name="ledType", type="BLedTypeEnum", defaultValue="BLedTypeEnum.DEFAULT"), @NiagaraProperty(name="greenLed", type="BNACGreenLed", defaultValue="new BNACGreenLed()", flags=2), @NiagaraProperty(name="redLed", type="BNACRedLed", defaultValue="new BNACRedLed()", flags=2), @NiagaraProperty(name="beeper", type="BNACBeeper", defaultValue="new BNACBeeper()", flags=2), @NiagaraProperty(name="assignment", type="BString", defaultValue="BString.DEFAULT", flags=9), @NiagaraProperty(name="lastReplicatedDoorUnid", type="int", defaultValue="0", flags=69), @NiagaraProperty(name="lastLocationId", type="BNumericWritable", defaultValue="new BNumericWritable()", flags=5, override=true), @NiagaraProperty(name="validateTime", type="BStatusNumeric", defaultValue="new BStatusNumeric()", flags=5, facets={@Facet(value="BFacets.makeNumeric(UnitDatabase.getUnit(\"second\"), 3)")}, override=true), @NiagaraProperty(name="validBadge", type="BBooleanWritable", defaultValue="new BBooleanWritable()", flags=5, override=true), @NiagaraProperty(name="invalidBadge", type="BBooleanWritable", defaultValue="new BBooleanWritable()", flags=5, override=true), @NiagaraProperty(name="readerTamper", type="BNACDevicePoint", defaultValue="new BNACDevicePoint()", flags=64), @NiagaraProperty(name="encryptionKeyIdentifier", type="BString", defaultValue="BString.DEFAULT", flags=69), @NiagaraProperty(name="encryptionKeyRef", type="BString", defaultValue="BString.DEFAULT", flags=69), @NiagaraProperty(name="encryptionKeyNextIdentifier", type="BString", defaultValue="BString.DEFAULT", flags=69), @NiagaraProperty(name="encryptionKeyRefNext", type="BString", defaultValue="BString.DEFAULT", flags=69), @NiagaraProperty(name="preventRemove", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="alarmInfo", type="BAlarmSourceInfo", defaultValue="new BAlarmSourceInfo()", flags=8), @NiagaraProperty(name="badgeDoesNotExistAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.badgeDoesNotExist)"), @NiagaraProperty(name="unknownWiegandFormatAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.unknownWiegandFormat)"), @NiagaraProperty(name="badgeIsLostAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.badgeIsLost)"), @NiagaraProperty(name="badgeIsDisabledAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.badgeIsDisabled)"), @NiagaraProperty(name="badgeNotAssignedAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.badgeNotAssigned)"), @NiagaraProperty(name="noActiveScheduleAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.noActiveSchedule)"), @NiagaraProperty(name="noAccessRightAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.noAccessRight)"), @NiagaraProperty(name="grantedButNotUsedAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButNotUsed)"), @NiagaraProperty(name="grantedButPinDuressAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButPinDuress)"), @NiagaraProperty(name="invalidPinNumberAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.invalidPinNumber)"), @NiagaraProperty(name="traceCardAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.grantedButTrace)"), @NiagaraProperty(name="doorModeDoesNotMatchAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.doorModeDoesNotMatch)"), @NiagaraProperty(name="encryptionKeyTransferFailedAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BNACReaderEncryptionEnum.encryptionKeyTransferFailed, false)"), @NiagaraProperty(name="inactiveThreatLevelGroupAlert", type="BNACActivityAlertExt", defaultValue="new BNACActivityAlertExt(BBadgeActivity.inactiveThreatLevelGroup)")})
@NiagaraActions(value={@NiagaraAction(name="refreshEncryptionKey", flags=64), @NiagaraAction(name="allowDelete", flags=128)})
public class BNACReader
extends BReaderProperty
implements BINACMappable,
IPropertyValidator,
BIAccessReader {
    @Generated
    public static final Property unid = BNACReader.newProperty((int)69, (int)0, null);
    @Generated
    public static final Property readerType = BNACReader.newProperty((int)0, (BValue)BNACReaderTypeEnum.osdp, (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:LimitedFrozenEnumFE"));
    @Generated
    public static final Property attendance = BNACReader.newProperty((int)0, (BValue)BTimeAttendEnum.DEFAULT, null);
    @Generated
    public static final Property address = BNACReader.newProperty((int)64, (int)0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    @Generated
    public static final Property OSDPAddress = BNACReader.newProperty((int)64, (int)0, (BFacets)BFacets.make((BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)), (BFacets)BFacets.make((String)"max", (BIDataValue)BInteger.make((int)15))));
    @Generated
    public static final Property firmwareVersion = BNACReader.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property ledType = BNACReader.newProperty((int)0, (BValue)BLedTypeEnum.DEFAULT, null);
    @Generated
    public static final Property greenLed = BNACReader.newProperty((int)2, (BValue)new BNACGreenLed(), null);
    @Generated
    public static final Property redLed = BNACReader.newProperty((int)2, (BValue)new BNACRedLed(), null);
    @Generated
    public static final Property beeper = BNACReader.newProperty((int)2, (BValue)new BNACBeeper(), null);
    @Generated
    public static final Property assignment = BNACReader.newProperty((int)9, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property lastReplicatedDoorUnid = BNACReader.newProperty((int)69, (int)0, null);
    @Generated
    public static final Property lastLocationId = BNACReader.newProperty((int)5, (BValue)new BNumericWritable(), null);
    @Generated
    public static final Property validateTime = BNACReader.newProperty((int)5, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"second"), (int)3));
    @Generated
    public static final Property validBadge = BNACReader.newProperty((int)5, (BValue)new BBooleanWritable(), null);
    @Generated
    public static final Property invalidBadge = BNACReader.newProperty((int)5, (BValue)new BBooleanWritable(), null);
    @Generated
    public static final Property readerTamper = BNACReader.newProperty((int)64, (BValue)new BNACDevicePoint(), null);
    @Generated
    public static final Property encryptionKeyIdentifier = BNACReader.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property encryptionKeyRef = BNACReader.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property encryptionKeyNextIdentifier = BNACReader.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property encryptionKeyRefNext = BNACReader.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Property preventRemove = BNACReader.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property alarmInfo = BNACReader.newProperty((int)8, (BValue)new BAlarmSourceInfo(), null);
    @Generated
    public static final Property badgeDoesNotExistAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.badgeDoesNotExist), null);
    @Generated
    public static final Property unknownWiegandFormatAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.unknownWiegandFormat), null);
    @Generated
    public static final Property badgeIsLostAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.badgeIsLost), null);
    @Generated
    public static final Property badgeIsDisabledAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.badgeIsDisabled), null);
    @Generated
    public static final Property badgeNotAssignedAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.badgeNotAssigned), null);
    @Generated
    public static final Property noActiveScheduleAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.noActiveSchedule), null);
    @Generated
    public static final Property noAccessRightAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.noAccessRight), null);
    @Generated
    public static final Property grantedButNotUsedAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButNotUsed), null);
    @Generated
    public static final Property grantedButPinDuressAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButPinDuress), null);
    @Generated
    public static final Property invalidPinNumberAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.invalidPinNumber), null);
    @Generated
    public static final Property traceCardAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.grantedButTrace), null);
    @Generated
    public static final Property doorModeDoesNotMatchAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.doorModeDoesNotMatch), null);
    @Generated
    public static final Property encryptionKeyTransferFailedAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BNACReaderEncryptionEnum.encryptionKeyTransferFailed, false), null);
    @Generated
    public static final Property inactiveThreatLevelGroupAlert = BNACReader.newProperty((int)0, (BValue)new BNACActivityAlertExt((BActivity)BBadgeActivity.inactiveThreatLevelGroup), null);
    @Generated
    public static final Action refreshEncryptionKey = BNACReader.newAction((int)64, null);
    @Generated
    public static final Action allowDelete = BNACReader.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNACReader.class);
    private BNACNetwork network;
    private boolean isOsdpAddressInUse = false;
    private boolean fatalFault;
    private final AtomicBoolean taskInQueue = new AtomicBoolean(false);
    public static final BRelTime GRANTED_BEEP_TIME = BRelTime.make((long)1000L);
    public static final BRelTime DENIED_BEEP_TIME = BRelTime.make((long)2000L);

    @Override
    @Generated
    public int getUnid() {
        return this.getInt(unid);
    }

    @Generated
    public void setUnid(int v) {
        this.setInt(unid, v, null);
    }

    @Generated
    public BNACReaderTypeEnum getReaderType() {
        return (BNACReaderTypeEnum)this.get(readerType);
    }

    @Generated
    public void setReaderType(BNACReaderTypeEnum v) {
        this.set(readerType, (BValue)v, null);
    }

    @Generated
    public BTimeAttendEnum getAttendance() {
        return (BTimeAttendEnum)this.get(attendance);
    }

    @Generated
    public void setAttendance(BTimeAttendEnum v) {
        this.set(attendance, (BValue)v, null);
    }

    @Generated
    public int getAddress() {
        return this.getInt(address);
    }

    @Generated
    public void setAddress(int v) {
        this.setInt(address, v, null);
    }

    @Generated
    public int getOSDPAddress() {
        return this.getInt(OSDPAddress);
    }

    @Generated
    public void setOSDPAddress(int v) {
        this.setInt(OSDPAddress, v, null);
    }

    @Generated
    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    @Generated
    public void setFirmwareVersion(String v) {
        this.setString(firmwareVersion, v, null);
    }

    @Generated
    public BLedTypeEnum getLedType() {
        return (BLedTypeEnum)this.get(ledType);
    }

    @Generated
    public void setLedType(BLedTypeEnum v) {
        this.set(ledType, (BValue)v, null);
    }

    @Generated
    public BNACGreenLed getGreenLed() {
        return (BNACGreenLed)this.get(greenLed);
    }

    @Generated
    public void setGreenLed(BNACGreenLed v) {
        this.set(greenLed, (BValue)v, null);
    }

    @Generated
    public BNACRedLed getRedLed() {
        return (BNACRedLed)this.get(redLed);
    }

    @Generated
    public void setRedLed(BNACRedLed v) {
        this.set(redLed, (BValue)v, null);
    }

    @Generated
    public BNACBeeper getBeeper() {
        return (BNACBeeper)this.get(beeper);
    }

    @Generated
    public void setBeeper(BNACBeeper v) {
        this.set(beeper, (BValue)v, null);
    }

    @Generated
    public String getAssignment() {
        return this.getString(assignment);
    }

    @Generated
    public void setAssignment(String v) {
        this.setString(assignment, v, null);
    }

    @Generated
    public int getLastReplicatedDoorUnid() {
        return this.getInt(lastReplicatedDoorUnid);
    }

    @Generated
    public void setLastReplicatedDoorUnid(int v) {
        this.setInt(lastReplicatedDoorUnid, v, null);
    }

    @Generated
    public BNACDevicePoint getReaderTamper() {
        return (BNACDevicePoint)this.get(readerTamper);
    }

    @Generated
    public void setReaderTamper(BNACDevicePoint v) {
        this.set(readerTamper, (BValue)v, null);
    }

    @Generated
    public String getEncryptionKeyIdentifier() {
        return this.getString(encryptionKeyIdentifier);
    }

    @Generated
    public void setEncryptionKeyIdentifier(String v) {
        this.setString(encryptionKeyIdentifier, v, null);
    }

    @Generated
    public String getEncryptionKeyRef() {
        return this.getString(encryptionKeyRef);
    }

    @Generated
    public void setEncryptionKeyRef(String v) {
        this.setString(encryptionKeyRef, v, null);
    }

    @Generated
    public String getEncryptionKeyNextIdentifier() {
        return this.getString(encryptionKeyNextIdentifier);
    }

    @Generated
    public void setEncryptionKeyNextIdentifier(String v) {
        this.setString(encryptionKeyNextIdentifier, v, null);
    }

    @Generated
    public String getEncryptionKeyRefNext() {
        return this.getString(encryptionKeyRefNext);
    }

    @Generated
    public void setEncryptionKeyRefNext(String v) {
        this.setString(encryptionKeyRefNext, v, null);
    }

    @Generated
    public boolean getPreventRemove() {
        return this.getBoolean(preventRemove);
    }

    @Generated
    public void setPreventRemove(boolean v) {
        this.setBoolean(preventRemove, v, null);
    }

    @Generated
    public BAlarmSourceInfo getAlarmInfo() {
        return (BAlarmSourceInfo)this.get(alarmInfo);
    }

    @Generated
    public void setAlarmInfo(BAlarmSourceInfo v) {
        this.set(alarmInfo, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getBadgeDoesNotExistAlert() {
        return (BNACActivityAlertExt)this.get(badgeDoesNotExistAlert);
    }

    @Generated
    public void setBadgeDoesNotExistAlert(BNACActivityAlertExt v) {
        this.set(badgeDoesNotExistAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getUnknownWiegandFormatAlert() {
        return (BNACActivityAlertExt)this.get(unknownWiegandFormatAlert);
    }

    @Generated
    public void setUnknownWiegandFormatAlert(BNACActivityAlertExt v) {
        this.set(unknownWiegandFormatAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getBadgeIsLostAlert() {
        return (BNACActivityAlertExt)this.get(badgeIsLostAlert);
    }

    @Generated
    public void setBadgeIsLostAlert(BNACActivityAlertExt v) {
        this.set(badgeIsLostAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getBadgeIsDisabledAlert() {
        return (BNACActivityAlertExt)this.get(badgeIsDisabledAlert);
    }

    @Generated
    public void setBadgeIsDisabledAlert(BNACActivityAlertExt v) {
        this.set(badgeIsDisabledAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getBadgeNotAssignedAlert() {
        return (BNACActivityAlertExt)this.get(badgeNotAssignedAlert);
    }

    @Generated
    public void setBadgeNotAssignedAlert(BNACActivityAlertExt v) {
        this.set(badgeNotAssignedAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getNoActiveScheduleAlert() {
        return (BNACActivityAlertExt)this.get(noActiveScheduleAlert);
    }

    @Generated
    public void setNoActiveScheduleAlert(BNACActivityAlertExt v) {
        this.set(noActiveScheduleAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getNoAccessRightAlert() {
        return (BNACActivityAlertExt)this.get(noAccessRightAlert);
    }

    @Generated
    public void setNoAccessRightAlert(BNACActivityAlertExt v) {
        this.set(noAccessRightAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getGrantedButNotUsedAlert() {
        return (BNACActivityAlertExt)this.get(grantedButNotUsedAlert);
    }

    @Generated
    public void setGrantedButNotUsedAlert(BNACActivityAlertExt v) {
        this.set(grantedButNotUsedAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getGrantedButPinDuressAlert() {
        return (BNACActivityAlertExt)this.get(grantedButPinDuressAlert);
    }

    @Generated
    public void setGrantedButPinDuressAlert(BNACActivityAlertExt v) {
        this.set(grantedButPinDuressAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getInvalidPinNumberAlert() {
        return (BNACActivityAlertExt)this.get(invalidPinNumberAlert);
    }

    @Generated
    public void setInvalidPinNumberAlert(BNACActivityAlertExt v) {
        this.set(invalidPinNumberAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getTraceCardAlert() {
        return (BNACActivityAlertExt)this.get(traceCardAlert);
    }

    @Generated
    public void setTraceCardAlert(BNACActivityAlertExt v) {
        this.set(traceCardAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getDoorModeDoesNotMatchAlert() {
        return (BNACActivityAlertExt)this.get(doorModeDoesNotMatchAlert);
    }

    @Generated
    public void setDoorModeDoesNotMatchAlert(BNACActivityAlertExt v) {
        this.set(doorModeDoesNotMatchAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getEncryptionKeyTransferFailedAlert() {
        return (BNACActivityAlertExt)this.get(encryptionKeyTransferFailedAlert);
    }

    @Generated
    public void setEncryptionKeyTransferFailedAlert(BNACActivityAlertExt v) {
        this.set(encryptionKeyTransferFailedAlert, (BValue)v, null);
    }

    @Generated
    public BNACActivityAlertExt getInactiveThreatLevelGroupAlert() {
        return (BNACActivityAlertExt)this.get(inactiveThreatLevelGroupAlert);
    }

    @Generated
    public void setInactiveThreatLevelGroupAlert(BNACActivityAlertExt v) {
        this.set(inactiveThreatLevelGroupAlert, (BValue)v, null);
    }

    @Generated
    public void refreshEncryptionKey() {
        this.invoke(refreshEncryptionKey, null, null);
    }

    @Generated
    public void allowDelete() {
        this.invoke(allowDelete, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNACReader(int address, int osdpAddress) {
        this.setAddress(address);
        this.setOSDPAddress(osdpAddress);
    }

    public void started() throws Exception {
        this.updateFlags();
        this.updateAddressList();
        this.fixAssignment();
        super.started();
    }

    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 11) {
            this.fwStarted();
        }
        return super.fw(x, a, b, c, d);
    }

    private void fwStarted() {
        BNACNetwork nacNetwork = this.getNACNetwork();
        Object licenseFault = nacNetwork.fw(501, "reader.limit", null, null, null);
        if (licenseFault != null) {
            this.configFatal(this.getLexicon().get("reader.license.fault"));
        }
    }

    private void updateAddressList() {
        if (this.getEnabled() && !this.getReaderType().equals((Object)BNACReaderTypeEnum.wiegand)) {
            this.getPointDeviceExt().addOsdpAddress(this.getOSDPAddress());
            this.isOsdpAddressInUse = true;
        }
        this.getPointDeviceExt().addAddress(this.getAddress());
    }

    private void updateFlags() {
        if (this.getReaderType().equals((Object)BNACReaderTypeEnum.wiegand)) {
            this.setFlags((Slot)OSDPAddress, 5);
            this.setFlags((Slot)refreshEncryptionKey, 4);
            this.setFlags((Slot)firmwareVersion, 4);
            this.setFlags((Slot)readerTamper, 4);
            this.setFlags((Slot)greenLed, this.getFlags((Slot)greenLed) & 0xFFFFFFFB);
            if (this.getLedType().equals((Object)BLedTypeEnum.redAndGreen)) {
                this.setFlags((Slot)redLed, this.getFlags((Slot)redLed) & 0xFFFFFFFB);
            } else {
                this.setFlags((Slot)redLed, this.getFlags((Slot)redLed) | 4);
            }
            this.setFlags((Slot)beeper, this.getFlags((Slot)beeper) & 0xFFFFFFFB);
        } else {
            this.setFlags((Slot)OSDPAddress, this.getFlags((Slot)OSDPAddress) & 0xFFFFFFFE & 0xFFFFFFFB);
            if (this.getStatus().toString().equals("{ok} Encrypted")) {
                this.setFlags((Slot)OSDPAddress, 1);
            }
            this.setFlags((Slot)refreshEncryptionKey, this.getFlags((Slot)refreshEncryptionKey) & 0xFFFFFFFB);
            this.setFlags((Slot)firmwareVersion, this.getFlags((Slot)firmwareVersion) & 0xFFFFFFFB);
            this.setFlags((Slot)readerTamper, this.getFlags((Slot)readerTamper) & 0xFFFFFFFB);
            this.setFlags((Slot)greenLed, this.getFlags((Slot)greenLed) | 4);
            this.setFlags((Slot)redLed, this.getFlags((Slot)redLed) | 4);
            this.setFlags((Slot)beeper, this.getFlags((Slot)beeper) | 4);
        }
    }

    public BNACReader() {
    }

    public Property[] getSubscribedProperties() {
        return new Property[]{assignment, unid};
    }

    public void fixAssignment() {
        if (this.getDoor() != null) {
            this.setAssignment(this.getDoor().getServerDisplayName(null));
        } else {
            this.setAssignment(this.getLexicon().get("accessReader.noDoorAttached"));
        }
    }

    @Override
    public void storeMapping(int unid) {
        this.setUnid(unid);
        this.getNACNetwork().storeMapping(unid, this.getHandle());
    }

    @Override
    public void addToServer(boolean partOfSync) {
        Utils.checkNACPermission();
        this.getNACNetwork().postAsync(() -> {
            if (!partOfSync && this.getNACNetwork().getSyncingToServer()) {
                this.getNACNetwork().getLogger().log(Level.WARNING, "Cannot add to server when syncing is in progress");
                return;
            }
            if (this.getUnid() == 0) {
                BNACReader reader = this;
                AccessController.doPrivileged(() -> {
                    NACRequestUtils.addNewReader(this.getNACNetwork(), reader);
                    this.syncToServer();
                    return null;
                });
            }
        });
    }

    public String getAddToServerBody() {
        if (((BNACDoor)this.getParent()).getUnid() == 0) {
            return null;
        }
        return "devInsert[0].devType=4&devInsert[0].devMod=162&devInsert[0].devPlatform=31&devInsert[0].devModConfig.id=-1&devInsert[0].enabled=false&devInsert[0].devUse=38&devInsert[0].credReaderConfig.commType=" + this.getReaderType().getOrdinal() + "&" + "devInsert" + "[0].credReaderConfig.allDataLayouts=" + true + "&" + "devInsert" + "[0].credReaderConfig.keyMap.unid=" + 1 + "&" + "devInsert" + "[0].credReaderConfig.ledType=" + this.getLedType().getOrdinal() + "&" + "devInsert" + "[0].autoSetName=" + true + "&" + "devInsert" + "[0].physicalParent.unid=" + this.getNACDevice().getPoints().getUnid() + "&" + "devInsert" + "[0].logicalParent.unid=" + this.getDoor().getUnid() + "&" + "devModConfigInsert" + "[0].type=" + 11 + "&" + "devModConfigInsert" + "[0].unid=" + -1;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        AccessController.doPrivileged(() -> {
            this.addToServer(false);
            return null;
        });
    }

    @Override
    public void syncToServer() {
        Runnable r = () -> {
            this.syncReaderParameters();
            this.updateBeeperAndLeds();
        };
        Utils.runSyncToServer(this.getNACNetwork(), this.taskInQueue, r, 1000L);
    }

    private void syncReaderParameters() {
        this.getNACNetwork().postAsync(() -> {
            if (this.getUnid() == 0) {
                return;
            }
            String uri = "/dev/update/" + this.getUnid();
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "POST", uri, this.getNACNetwork().getSessionToken()));
            String body = this.getCredReaderConfigBody();
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body);
            try {
                this.getNACNetwork().sendHttpRequest(request);
            }
            catch (Exception e) {
                Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
            }
        });
    }

    private String getCredReaderConfigBody() {
        StringBuilder body = new StringBuilder("enabled=").append(!this.fatalFault && this.getEnabled()).append("&");
        body.append("credReaderConfig.commType=").append(this.getReaderType().getOrdinal()).append("&").append("port=");
        int ledType = this.getLedType().getOrdinal();
        if (!this.getReaderType().equals((Object)BNACReaderTypeEnum.wiegand)) {
            body.append(this.getOSDPAddress());
            ledType = 2;
        }
        body.append("&").append("address=").append(this.getAddress()).append("&");
        body.append("credReaderConfig.ledType=").append(ledType).append("&");
        body.append("logicalParent.unid=").append(this.getDoor().getUnid());
        return body.toString();
    }

    public void doRefreshEncryptionKey() {
        BUuid keyIdentifier = BUuid.make();
        if (this.getStatus().isOk()) {
            if (this.getEncryptionKeyNextIdentifier().equals("")) {
                this.setEncryptionKeyNextIdentifier(this.generateEncryptionKeyAndUpdate(keyIdentifier.toString()));
                this.setEncryptionKeyRefNext(this.saveEncryptionKeyRefToNACServer(keyIdentifier.toString()));
            }
        } else {
            throw new LocalizableRuntimeException("nacDriver", "accessReader.updateNewEncryptionKeyFailed");
        }
        this.updateEncryptionKeyResourceToCredReader(String.valueOf(this.getUnid()), this.getEncryptionKeyRefNext(), "encryptionKeyRefNext", this.getNACNetwork());
        this.transferNewEncryptionKeysToCredReader(String.valueOf(this.getUnid()));
    }

    public void doAllowDelete() {
        this.setPreventRemove(false);
    }

    public void updateEncryptionKeyState(String keyIdentifier) {
        Utils.checkNACPermission();
        if (keyIdentifier.equals(this.getEncryptionKeyNextIdentifier())) {
            this.deleteEncryptionReferenceForReaders(this.getNACNetwork());
            this.setEncryptionKeyRef(this.getEncryptionKeyRefNext());
            this.setEncryptionKeyIdentifier(keyIdentifier);
            this.setEncryptionKeyNextIdentifier("");
            this.setEncryptionKeyRefNext("");
        }
    }

    private void updateReaderStatus(JSONObject jsonObject) {
        if (this.getReaderType().equals((Object)BNACReaderTypeEnum.make(6))) {
            JSONArray responseArray = jsonObject.getJSONArray("devAspectStates");
            for (Object elem : responseArray) {
                if (((JSONObject)elem).getInt("key") == 0) {
                    JSONObject devStateValue = ((JSONObject)elem).getJSONObject("value");
                    if (devStateValue.has("tamperStateStale")) {
                        if (devStateValue.getBoolean("tamperStateStale")) {
                            ((BNACProxyExt)this.getReaderTamper().getProxyExt()).setStale(true, null);
                        } else if (devStateValue.getInt("tamperState") == 0) {
                            ((BNACProxyExt)this.getReaderTamper().getProxyExt()).readOk((BStatusValue)new BStatusBoolean(false, BStatus.ok));
                        } else {
                            ((BNACProxyExt)this.getReaderTamper().getProxyExt()).readOk((BStatusValue)new BStatusBoolean(true, BStatus.ok));
                        }
                    }
                    if (devStateValue.getBoolean("commStateStale") || ((JSONObject)elem).getJSONObject("value").getInt("commState") == 0) {
                        this.updateStatus(BStatus.down, this.getLexicon().getText("reader.offline"));
                    } else if (devStateValue.getBoolean("commEncryptionStateStale")) {
                        this.updateStatus(BStatus.down, this.getLexicon().getText("reader.offline"));
                    } else {
                        int commEncryptionState = devStateValue.getInt("commEncryptionState");
                        this.updateStatus(BStatus.make((int)0, (BFacets)BFacets.make((String)this.getEncryptionCommState(commEncryptionState), (BIDataValue)BBoolean.TRUE)), "");
                        if (commEncryptionState == 1) {
                            this.setPreventRemove(true);
                        }
                    }
                }
                if (((JSONObject)elem).getInt("key") != 14) continue;
                this.setFirmwareVersion(((JSONObject)elem).getJSONObject("value").getString("data"));
            }
        } else {
            this.updateStatus(BStatus.make((int)0, (BFacets)BFacets.make((String)BNACReaderEncryptionStatusEnum.unencrypted.getTag(), (BIDataValue)BBoolean.TRUE)), "");
        }
    }

    private String getEncryptionCommState(int commState) {
        switch (commState) {
            case 0: {
                return BNACReaderEncryptionStatusEnum.unencrypted.getTag();
            }
            case 1: {
                return BNACReaderEncryptionStatusEnum.encrypted.getTag();
            }
            case 2: {
                return BNACReaderEncryptionStatusEnum.encryptedDefaultKey.getTag();
            }
        }
        return "";
    }

    private String generateEncryptionKeyAndUpdate(String keyIdentifier) {
        String key = NACOSDPKeyStoreUtils.generateEncryptionKey();
        assert (key != null);
        byte[] decodedKey = Base64.getDecoder().decode(key);
        SecretKeySpec originalSecretKey = new SecretKeySpec(decodedKey, 0, decodedKey.length, "AES");
        AccessController.doPrivileged(() -> {
            this.setKeyToKeyStore(keyIdentifier.toString(), originalSecretKey);
            return null;
        });
        return this.saveEncryptionKeyToNACServer(keyIdentifier.toString(), key);
    }

    private String saveEncryptionKeyToNACServer(String encryptionKeyIdentifier, String key) {
        JSONObject response = this.saveEncryptionKeyResourcesToNACServer(encryptionKeyIdentifier, key, encryptionKeyIdentifier, "encryptionKey");
        if (response != null) {
            return response.getJSONObject("instance").getString("keyIdentifier");
        }
        return "";
    }

    private String saveEncryptionKeyRefToNACServer(String encryptionKeyIdentifier) {
        JSONObject response = this.saveEncryptionKeyResourcesToNACServer(encryptionKeyIdentifier, null, encryptionKeyIdentifier, "encryptionKeyRef");
        if (response != null) {
            return Integer.toString(response.getJSONObject("instance").getInt("unid"));
        }
        return "";
    }

    private JSONObject saveEncryptionKeyResourcesToNACServer(String keyIdentifier, String key, String uuid, String resource) {
        String uri = "/" + resource + "/save";
        JSONObject response = null;
        StringBuilder body = new StringBuilder("algorithm=AES").append("&");
        body.append("keyIdentifier=").append(keyIdentifier).append("&");
        body.append("size=128").append("&");
        body.append("uuid=").append(uuid).append("&");
        if (resource.equals("encryptionKey")) {
            body.append("bytes=").append(key);
        }
        if (resource.equals("encryptionKeyRef")) {
            body.append("keystoreIdentifier=DB");
        }
        try {
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken()));
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body.toString());
            response = new JSONObject(new String(this.getNACNetwork().sendHttpRequest(request).getData()));
        }
        catch (Exception e) {
            Utils.logException(this.network.log(), e, Level.SEVERE, "Failed to save Encryption Key Resource");
        }
        return response;
    }

    private void deleteEncryptionKeyResourcesFromNACServer(String resourceId, String resource, BNACNetwork network) {
        try {
            String uri = "/" + resource + "/delete/" + resourceId;
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", uri, network.getSessionToken()));
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            network.sendHttpRequest(request);
        }
        catch (Exception e) {
            Utils.logException(network.log(), e, Level.SEVERE, "Deletion of EncryptionKey Resource Failed");
        }
    }

    public void updateEncryptionKeyResourceToCredReader(String credReaderUnid, String encryptionKeyResourceId, String resource, BNACNetwork network) {
        String uri = "/credReader/update/" + credReaderUnid;
        StringBuilder body = new StringBuilder("credReaderConfig." + resource + ".id=").append(encryptionKeyResourceId);
        try {
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(network.getHttpConfig().getAddress(), "GET", uri, network.getSessionToken()));
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body.toString());
            network.sendHttpRequest(request);
        }
        catch (Exception e) {
            Utils.logException(network.log(), e, Level.FINE, "Unable to update Encryption Key resource to cred Reader");
        }
    }

    private void transferNewEncryptionKeysToCredReader(String unid) {
        try {
            String uri = "/json/credReaderTransferEncryptionKeys?unid=" + unid;
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken()));
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            this.getNACNetwork().sendHttpRequest(request);
        }
        catch (Exception e) {
            Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE, "Transfer new Encryption Key failed to Cred Reader");
        }
    }

    private void setKeyToKeyStore(String keyIdentifier, SecretKey key) {
        BNACNetwork nw = this.getNACNetwork();
        try {
            KeyStore ks = nw.getKeyStoreInstance();
            SecretBytes trustStorePassword = AccessController.doPrivileged(nw::getTrustStorePassword);
            nw.loadKeyStore(ks, trustStorePassword);
            ks.setKeyEntry(keyIdentifier, key, ByteArrayUtil.toHexString((byte[])trustStorePassword.get()).toCharArray(), new Certificate[0]);
            nw.saveKeyStore(ks, trustStorePassword);
        }
        catch (Exception e) {
            Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE);
        }
    }

    private void deleteKeyFromKeyStore(String keyIdentifier, BNACNetwork network) {
        try {
            SecretBytes trustStorePassword = AccessController.doPrivileged(network::getTrustStorePassword);
            KeyStore ks = network.getKeyStoreInstance();
            network.loadKeyStore(ks, trustStorePassword);
            ks.deleteEntry(keyIdentifier);
        }
        catch (Exception e) {
            Utils.logException(network.log(), e, Level.SEVERE);
        }
    }

    private void deleteEncryptionReferenceForReaders(BNACNetwork network) {
        if (!this.getEncryptionKeyIdentifier().isEmpty()) {
            this.deleteEncryptionKeyResourcesFromNACServer(this.getEncryptionKeyIdentifier(), "encryptionKey", network);
            this.deleteKeyFromKeyStore(this.getEncryptionKeyIdentifier(), network);
        }
        if (!this.getEncryptionKeyRef().isEmpty()) {
            this.deleteEncryptionKeyResourcesFromNACServer(this.getEncryptionKeyRef(), "encryptionKeyRef", network);
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        if (property.equals(enabled) || property.equals(readerType) || property.equals(OSDPAddress) || property.equals(address) || property.equals(ledType) || property.equals(status)) {
            this.updateFlags();
            this.syncToServer();
        }
    }

    private void updateBeeperAndLeds() {
        ArrayList<BNACCrudActuatorPoint> actuators = new ArrayList<BNACCrudActuatorPoint>();
        actuators.add(this.getGreenLed());
        actuators.add(this.getRedLed());
        actuators.add(this.getBeeper());
        for (BNACCrudActuatorPoint actuator : actuators) {
            if (this.getAddress() > 0 && this.getAddress() <= 4) {
                if (actuator.getUnid() == 0) {
                    AccessController.doPrivileged(() -> {
                        actuator.addToServer(false);
                        return null;
                    });
                    continue;
                }
                actuator.syncToServer();
                continue;
            }
            AccessController.doPrivileged(() -> {
                actuator.deleteFromServer(this.getNACNetwork());
                return null;
            });
        }
    }

    public BNACNetwork getNACNetwork() {
        return Utils.getNACNetwork((BComponent)this);
    }

    public BNACDevice getNACDevice() {
        return Utils.getNACDevice((BComponent)this);
    }

    public BNACPointDeviceExt getPointDeviceExt() {
        for (BComplex parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BNACPointDeviceExt)) continue;
            return (BNACPointDeviceExt)parent;
        }
        return null;
    }

    public BNACDoor getDoor() {
        if (this.getParent() != null && this.getParent() instanceof BNACDoor) {
            return (BNACDoor)this.getParent();
        }
        return null;
    }

    public String getRemoteDeviceName() {
        return this.getNACDevice() != null && this.getNACDevice().getParent() != null ? this.getNACDevice().getDisplayName(null) : "";
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        return this;
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        return this;
    }

    public void validateSet(Validatable validatable, Context context) {
        int proposedAddress;
        int proposedOsdpAddress = ((BInteger)validatable.getProposedValue(OSDPAddress)).getInt();
        boolean proposedEnabled = ((BBoolean)validatable.getProposedValue(enabled)).getBoolean();
        BNACReaderTypeEnum proposedReaderType = (BNACReaderTypeEnum)validatable.getProposedValue(readerType);
        String proposedEncryptionKeyIdentifier = String.valueOf(validatable.getProposedValue(encryptionKeyIdentifier));
        if (proposedOsdpAddress != this.getOSDPAddress() && !proposedEncryptionKeyIdentifier.isEmpty()) {
            throw new LocalizableRuntimeException("nacDriver", "accessReader.osdpAddressUpdateFailed");
        }
        if ((!this.isOsdpAddressInUse || proposedOsdpAddress != this.getOSDPAddress()) && proposedEnabled && !proposedReaderType.equals((Object)BNACReaderTypeEnum.wiegand) && this.getPointDeviceExt().isOsdpAddressInUse(proposedOsdpAddress)) {
            throw new LocalizableRuntimeException("nacDriver", "accessReader.osdpAddressAlreadyInUse", new Object[]{proposedOsdpAddress});
        }
        if (this.isOsdpAddressInUse) {
            this.getPointDeviceExt().removeOsdpAddress(this.getOSDPAddress());
            this.isOsdpAddressInUse = false;
        }
        if (proposedEnabled && !proposedReaderType.equals((Object)BNACReaderTypeEnum.wiegand)) {
            this.getPointDeviceExt().addOsdpAddress(proposedOsdpAddress);
            this.isOsdpAddressInUse = true;
        }
        if ((proposedAddress = ((BInteger)validatable.getProposedValue(address)).getInt()) != this.getAddress() && this.getPointDeviceExt().isAddressInUse(proposedAddress)) {
            throw new LocalizableRuntimeException("nacDriver", "accessReader.addressAlreadyInUse", new Object[]{proposedAddress});
        }
        this.getPointDeviceExt().removeAddress(this.getAddress());
        this.getPointDeviceExt().addAddress(proposedAddress);
    }

    public boolean makeAlarm(BBadgeActivity activity, String owner, String badge, String activityInfo, BUuid personId) {
        boolean alarm = false;
        try {
            BNACActivityAlertExt[] alerts = (BNACActivityAlertExt[])this.getChildren(BNACActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity) || !alerts[i].getEnableAlert()) continue;
                alarm = alerts[i].generateAlert(badge, owner, activityInfo, personId);
            }
        }
        catch (Exception e) {
            Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE);
        }
        return alarm;
    }

    public boolean makeAlarm(BActivity activity, String activityInfo) {
        boolean alarm = false;
        try {
            BNACActivityAlertExt[] alerts = (BNACActivityAlertExt[])this.getChildren(BNACActivityAlertExt.class);
            for (int i = 0; i < alerts.length; ++i) {
                if (!alerts[i].getActivityType().equals((Object)activity) || !alerts[i].getEnableAlert()) continue;
                alarm = alerts[i].generateAlert(activityInfo);
            }
        }
        catch (Exception e) {
            Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE);
        }
        return alarm;
    }

    public void makeBadgeRecord(String details) {
        this.makeBadgeRecord((BComponent)this, this.getValidateTimestamp(), this.getLastBadgeActivity(), this.getLastPersonName(), this.getLastBadgeRead(), details, this.getLastBadgeActivity().isGranted(), this.getLastPersonId());
    }

    public void makeBadgeRecord(BBadge badge, String details) {
        String badgeDisplayString = badge != null ? badge.toDisplayString(null) : "";
        this.makeBadgeRecord((BComponent)this, this.getValidateTimestamp(), this.getLastBadgeActivity(), this.getLastPersonName(), badgeDisplayString, details, this.getLastBadgeActivity().isGranted(), this.getLastPersonId());
    }

    public void makeBadgeRecord(BComponent device, BAbsTime timestamp, BBadgeActivity activity, String owner, String badge, String activityInfo, boolean granted, BUuid personId) {
        try {
            if (activity.isAlarm()) {
                BNACActivityAlertExt[] alerts;
                for (BNACActivityAlertExt alert : alerts = (BNACActivityAlertExt[])this.getChildren(BNACActivityAlertExt.class)) {
                    if (!alert.getActivityType().equals((Object)activity) || !alert.getEnableLogging()) continue;
                    alert.record(device, timestamp, badge, owner, activity, activityInfo, granted, personId);
                }
            } else {
                BAccessControlService service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
                service.addBadgeSwipeOrionRec(device, timestamp, activity, owner, badge, activityInfo, granted, personId);
            }
        }
        catch (Exception e) {
            Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE);
        }
    }

    public void updateNACAlertActivity(BBadgeActivity activity, BAbsTime timestamp, String owner, BBadge badge, BNameList badgeFormats, String activityInfo, BUuid personId, boolean granted) {
        String badgeString = badge != null ? badge.getBadgeId() : "";
        this.setLastRecord(badgeString, badgeFormats, owner, personId, activity, timestamp);
        String badgeDisplayString = badge != null ? badge.toDisplayString(null) : "";
        this.makeBadgeRecord((BComponent)this, timestamp, activity, owner, badgeDisplayString, activityInfo, granted, personId);
        this.makeAlarm(activity, owner, badgeDisplayString, activityInfo, personId);
    }

    public void setLastRecord(BBadge badge, BNameList badgeFormats, BPerson person, BBadgeActivity activity, BAbsTime timestamp) {
        String badgeString = badge != null ? badge.getBadgeId() : "";
        this.setLastRecord(badgeString, badgeFormats, person.toDisplayString(null), person.getPersonId(), activity, timestamp);
    }

    public void setLastRecord(String badge, BNameList badgeFormats, String owner, BUuid personId, BBadgeActivity activity, BAbsTime timestamp) {
        this.setLastBadgeRead(badge);
        this.setLastBadgePossibleFormats(badgeFormats);
        this.setLastBadgeActivity(activity);
        this.setLastPersonName(owner);
        this.setLastPersonId(personId);
        this.setValidateTimestamp(timestamp);
    }

    public String getRecordDisplayName(Context cx) {
        if (this.getAssignment() != null) {
            return this.getAssignment() + "." + this.getDisplayName(cx);
        }
        return this.getLexicon().getText("accessReader.noDoorAttached");
    }

    public void purge() {
        BMappedReaderExt readerExt = (BMappedReaderExt)this.getMixIn(BMappedReaderExt.TYPE);
        this.network = (BNACNetwork)Sys.getService((Type)BNACNetwork.TYPE);
        BNACReader reader = (BNACReader)readerExt.getParent();
        if (!reader.getEncryptionKeyRef().isEmpty()) {
            reader.updateEncryptionKeyResourceToCredReader(String.valueOf(reader.getUnid()), null, "encryptionKeyRef", this.network);
        }
        reader.deleteEncryptionReferenceForReaders(this.network);
    }

    public void readerMoved() {
        BMappedReaderExt readerExt = (BMappedReaderExt)this.getMixIn(BMappedReaderExt.TYPE);
        this.network = (BNACNetwork)Sys.getService((Type)BNACNetwork.TYPE);
        BNACReader reader = (BNACReader)readerExt.getParent();
        if (!reader.getEncryptionKeyRef().isEmpty()) {
            reader.updateEncryptionKeyResourceToCredReader(String.valueOf(reader.getUnid()), reader.getEncryptionKeyRef(), "encryptionKeyRef", this.network);
        }
    }

    @Override
    public void updateState(JSONObject devState) {
        this.updateReaderStatus(devState);
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNACDoor;
    }

    public void deleteFromServer(BNACNetwork network) {
        Utils.checkNACPermission();
        network.postAsync(() -> {
            if (this.getUnid() != 0) {
                try {
                    AccessController.doPrivileged(() -> {
                        try {
                            NACRequestUtils.removeDevice(network, String.valueOf(this.getUnid()));
                            return null;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE, "Reader was not removed from server. Please sync to update the server");
                }
                finally {
                    network.removeMapping(this.getUnid());
                    this.cleanDeviceUnids();
                }
            }
        });
    }

    @Override
    public void cleanDeviceUnids() {
        this.setUnid(0);
        this.setLastReplicatedDoorUnid(0);
    }

    public void updateLEDs(BStatusEnum strikeState) {
        if (this.getReaderType().equals((Object)BNACReaderTypeEnum.wiegand)) {
            if (this.getGreenLed().getEnabled()) {
                ((BNACProxyExt)this.getGreenLed().getProxyExt()).readOk((BStatusValue)strikeState);
            } else if (this.getLedType().equals((Object)BLedTypeEnum.redAndGreen) && this.getRedLed().getEnabled()) {
                BNACActivityStateEnum activityState = (BNACActivityStateEnum)strikeState.getEnum();
                if (activityState.equals((Object)BNACActivityStateEnum.inactive)) {
                    ((BNACProxyExt)this.getRedLed().getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BNACActivityStateEnum.active, BStatus.ok));
                } else {
                    ((BNACProxyExt)this.getRedLed().getProxyExt()).readOk((BStatusValue)new BStatusEnum((BEnum)BNACActivityStateEnum.inactive, BStatus.ok));
                }
            }
        }
    }

    public BNACDevice getDevice() {
        return Utils.getNACDevice((BComponent)this);
    }

    public BObject getFunction() {
        return this.getReaderType();
    }

    public final void configFatal(String cause) {
        this.fatalFault = true;
        this.setStatus(BStatus.fault);
        this.setFaultCause(cause);
    }

    public final void updateStatus(BStatus status, String faultCause) {
        if (this.fatalFault) {
            return;
        }
        this.setStatus(status);
        this.setFaultCause(faultCause);
    }
}

