/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.doors;

import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.doors.BNACAccessDoor;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNACExitDoor
extends BNACDoor {
    @Generated
    public static final Type TYPE = Sys.loadType(BNACExitDoor.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected ArrayList<Integer> getDoorModeOrdinalsToRemove() {
        ArrayList<Integer> ordinalsToRemove = new ArrayList<Integer>();
        ordinalsToRemove.add(8);
        ordinalsToRemove.add(9);
        ordinalsToRemove.add(26);
        return ordinalsToRemove;
    }

    @Override
    public String getServerDisplayName(Context cx) {
        return this.getNACDevice().getDisplayName(cx) + " " + this.getParent().getDisplayName(cx) + " - " + this.getDisplayName(cx);
    }

    public void syncChildren(JSONObject instance) throws Exception {
        if (instance == null) {
            instance = NACRequestUtils.showResource(this.getNACNetwork(), "dev", String.valueOf(this.getUnid()), 3).getJSONObject("instance");
        }
        JSONArray logicalChildren = instance.getJSONArray("logicalChildren");
        for (Object child : logicalChildren) {
            JSONObject childJson = (JSONObject)child;
            if (childJson.getString("type").equals("CredReader")) {
                BNACReader reader = ((BNACReader[])this.getChildren(BNACReader.class))[0];
                reader.storeMapping(childJson.getInt("unid"));
                reader.syncToServer();
                continue;
            }
            if (!childJson.getString("type").equals("Actuator")) continue;
            this.syncActuatorChild(childJson);
        }
    }

    private void syncActuatorChild(JSONObject child) {
        if (child.getString("name").endsWith("Reader LED (Green)")) {
            this.getReader().getGreenLed().storeMapping(child.getInt("unid"));
            this.getReader().getGreenLed().syncToServer();
        } else if (child.getString("name").endsWith("Reader LED (Red)")) {
            this.getReader().getRedLed().storeMapping(child.getInt("unid"));
            this.getReader().getRedLed().syncToServer();
        } else if (child.getString("name").endsWith("Reader Beeper")) {
            this.getReader().getBeeper().storeMapping(child.getInt("unid"));
            this.getReader().getBeeper().syncToServer();
        }
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNACAccessDoor;
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        AccessController.doPrivileged(() -> {
            this.addToServer(false);
            return null;
        });
    }

    @Override
    public void addToServer(boolean partOfSync) {
        Utils.checkNACPermission();
        this.getNACNetwork().postAsync(() -> {
            if (!partOfSync && this.getNACNetwork().getSyncingToServer()) {
                this.getNACNetwork().getLogger().log(Level.WARNING, "Cannot add to server when syncing is in progress");
                return;
            }
            if (this.getUnid() == 0) {
                BNACExitDoor door = this;
                AccessController.doPrivileged(() -> {
                    NACRequestUtils.addNewDoor(this.getNACNetwork(), door);
                    this.syncToServer();
                    if (this.getReader() != null) {
                        this.getReader().addToServer(false);
                    }
                    return null;
                });
            }
        });
    }

    @Override
    public String getAddToServerBody() {
        if (((BNACAccessDoor)this.getParent()).getUnid() == 0) {
            return null;
        }
        return "devInsert[0].devType=5&devInsert[0].devMod=247&devInsert[0].devPlatform=31&devInsert[0].enabled=" + this.getEnabled() + "&" + "devInsert" + "[0].devUse=" + 39 + "&" + "devInsert" + "[0].autoSetName=" + true + "&" + "devInsert" + "[0].physicalParent.unid=" + this.getNACDevice().getUnid() + "&" + "devInsert" + "[0].logicalParent.unid=" + ((BNACAccessDoor)this.getParent()).getUnid();
    }

    public void deleteFromServer(BNACNetwork network) {
        Utils.checkNACPermission();
        network.postAsync(() -> {
            if (this.getUnid() != 0) {
                try {
                    AccessController.doPrivileged(() -> {
                        try {
                            NACRequestUtils.removeDevice(network, String.valueOf(this.getUnid()));
                            return null;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE, "Exit Door was not removed from server. Please sync to update the server");
                }
                finally {
                    network.removeMapping(this.getUnid());
                    this.cleanDeviceUnids();
                }
            }
        });
    }

    @Override
    public void updatePendingUse(int pendingUse) {
        super.updatePendingUse(pendingUse);
        ((BNACAccessDoor)this.getParent()).setPendingUse(0);
    }
}

