/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.doors;

import com.tridiumx.accessDriver.BActivityAlertExt;
import com.tridiumx.accessDriver.BSecAlarmSourceInfo;
import com.tridiumx.accessDriver.enums.activity.BActivity;
import com.tridiumx.accessDriver.enums.activity.BBadgeActivity;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.doors.BNACAlarmSourceInfo;
import com.tridiumx.nacDriver.util.Utils;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BUuid;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="activityType", type="BActivity", defaultValue="BBadgeActivity.unknown", flags=1, override=true), @NiagaraProperty(name="alarmInfo", type="BNACAlarmSourceInfo", defaultValue="new BNACAlarmSourceInfo()", override=true), @NiagaraProperty(name="enableAlert", type="boolean", defaultValue="true")})
public class BNACActivityAlertExt
extends BActivityAlertExt {
    @Generated
    public static final Property activityType = BNACActivityAlertExt.newProperty((int)1, (BValue)BBadgeActivity.unknown, null);
    @Generated
    public static final Property alarmInfo = BNACActivityAlertExt.newProperty((int)0, (BValue)new BNACAlarmSourceInfo(), null);
    @Generated
    public static final Property enableAlert = BNACActivityAlertExt.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNACActivityAlertExt.class);
    BAccessControlService service;

    @Generated
    public boolean getEnableAlert() {
        return this.getBoolean(enableAlert);
    }

    @Generated
    public void setEnableAlert(boolean v) {
        this.setBoolean(enableAlert, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNACActivityAlertExt() {
    }

    public BNACActivityAlertExt(BActivity activityType) {
        this.setActivityType(activityType);
    }

    public BNACActivityAlertExt(BActivity activityType, boolean displayLogging) {
        super(activityType, displayLogging);
    }

    public BNACActivityAlertExt(BActivity activityType, BSecAlarmSourceInfo info) {
        super(activityType, info);
    }

    public void started() {
        super.started();
        try {
            this.service = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        }
        catch (Exception e) {
            Utils.logException(this.getNACNetwork().log(), e, Level.SEVERE);
        }
    }

    public BNACNetwork getNACNetwork() {
        return Utils.getNACNetwork((BComponent)this);
    }

    public boolean generateAlert(String badge, String owner, String activityInfo, BUuid personId) throws Exception {
        if (this.getActivityType().equals((Object)BBadgeActivity.unknownWiegandFormat) && !this.service.getDisplayUnknownWiegandFormats()) {
            return false;
        }
        return super.generateAlert(badge, owner, activityInfo, personId);
    }

    public void record(BComponent device, BAbsTime timestamp, String badge, String owner, BBadgeActivity activity, String details, boolean granted, BUuid personId) {
        if (this.getActivityType().equals((Object)BBadgeActivity.unknownWiegandFormat) && !this.service.getDisplayUnknownWiegandFormats()) {
            return;
        }
        this.service.addBadgeSwipeOrionRec(device, timestamp, activity, owner, badge, details, granted, personId);
    }
}

