/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.device;

import com.tridium.entsecDriver.BIAbstractDevice;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.util.SfUtil;
import com.tridiumx.nacDriver.BINACMappable;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.device.BNACRefreshAllEncryptionKeyJob;
import com.tridiumx.nacDriver.doors.BNACAccessDoor;
import com.tridiumx.nacDriver.doors.BNACDoor;
import com.tridiumx.nacDriver.doors.BNACReader;
import com.tridiumx.nacDriver.enums.BDevCreationTemplateTypeEnum;
import com.tridiumx.nacDriver.enums.BNACDoorModeTypeEnum;
import com.tridiumx.nacDriver.job.BUpgradeNACFirmwareJob;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.point.BNACPointDeviceExt;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import com.tridiumx.nacDriver.util.Utils;
import java.security.AccessController;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="points", type="BNACPointDeviceExt", defaultValue="new BNACPointDeviceExt()"), @NiagaraProperty(name="ipAddress", type="String", defaultValue="127.0.0.1", flags=65), @NiagaraProperty(name="port", type="int", defaultValue="0", flags=65), @NiagaraProperty(name="macAddress", type="String", defaultValue="", flags=65), @NiagaraProperty(name="numOfDoors", type="BInteger", defaultValue="BInteger.DEFAULT", flags=1), @NiagaraProperty(name="firmwareVersion", type="String", defaultValue="", flags=65), @NiagaraProperty(name="unid", type="int", defaultValue="0", flags=69), @NiagaraProperty(name="zoneLink", type="BString", defaultValue="BString.DEFAULT", flags=69)})
@NiagaraActions(value={@NiagaraAction(name="refreshAllEncryptionKeys"), @NiagaraAction(name="controllerFirmwareUpdate", parameterType="BDynamicEnum", defaultValue="BDynamicEnum.DEFAULT", flags=128), @NiagaraAction(name="loadFirmwareVersionList", returnType="BDynamicEnum", flags=4)})
public class BNACDevice
extends BNDevice
implements BINPollable,
BINACMappable,
BIAbstractDevice {
    @Generated
    public static final Property pollFrequency = BNACDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property status = BNACDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Property points = BNACDevice.newProperty((int)0, (BValue)new BNACPointDeviceExt(), null);
    @Generated
    public static final Property ipAddress = BNACDevice.newProperty((int)65, (String)"127.0.0.1", null);
    @Generated
    public static final Property port = BNACDevice.newProperty((int)65, (int)0, null);
    @Generated
    public static final Property macAddress = BNACDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property numOfDoors = BNACDevice.newProperty((int)1, (int)((BInteger)BInteger.DEFAULT.as(BInteger.class)).getInt(), null);
    @Generated
    public static final Property firmwareVersion = BNACDevice.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property unid = BNACDevice.newProperty((int)69, (int)0, null);
    @Generated
    public static final Property zoneLink = BNACDevice.newProperty((int)69, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action refreshAllEncryptionKeys = BNACDevice.newAction((int)0, null);
    @Generated
    public static final Action controllerFirmwareUpdate = BNACDevice.newAction((int)128, (BValue)BDynamicEnum.DEFAULT, null);
    @Generated
    public static final Action loadFirmwareVersionList = BNACDevice.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNACDevice.class);
    private final AtomicBoolean ipPortTaskInQueue = new AtomicBoolean(false);
    private final AtomicBoolean taskInQueue = new AtomicBoolean(false);

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BNACPointDeviceExt getPoints() {
        return (BNACPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BNACPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    @Generated
    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public String getMacAddress() {
        return this.getString(macAddress);
    }

    @Generated
    public void setMacAddress(String v) {
        this.setString(macAddress, v, null);
    }

    @Generated
    public int getNumOfDoors() {
        return this.getInt(numOfDoors);
    }

    @Generated
    public void setNumOfDoors(int v) {
        this.setInt(numOfDoors, v, null);
    }

    @Generated
    public String getFirmwareVersion() {
        return this.getString(firmwareVersion);
    }

    @Generated
    public void setFirmwareVersion(String v) {
        this.setString(firmwareVersion, v, null);
    }

    @Override
    @Generated
    public int getUnid() {
        return this.getInt(unid);
    }

    @Generated
    public void setUnid(int v) {
        this.setInt(unid, v, null);
    }

    @Generated
    public String getZoneLink() {
        return this.getString(zoneLink);
    }

    @Generated
    public void setZoneLink(String v) {
        this.setString(zoneLink, v, null);
    }

    @Generated
    public void refreshAllEncryptionKeys() {
        this.invoke(refreshAllEncryptionKeys, null, null);
    }

    @Generated
    public void controllerFirmwareUpdate(BDynamicEnum parameter) {
        this.invoke(controllerFirmwareUpdate, (BValue)parameter, null);
    }

    @Generated
    public BDynamicEnum loadFirmwareVersionList() {
        return (BDynamicEnum)this.invoke(loadFirmwareVersionList, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BNACNetwork.TYPE;
    }

    public void started() throws Exception {
        this.addComponents();
        this.setZoneLink(this.getDisplayName(null));
        super.started();
        this.getNACNetwork().getPollScheduler().subscribe((BIPollable)this);
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        AccessController.doPrivileged(() -> {
            this.addToServer(false);
            return null;
        });
    }

    private void addComponents() {
        BNACPointDeviceExt points = this.getPoints();
        int doorsAdded = ((BNACDoor[])points.getChildren(BNACDoor.class)).length;
        while (doorsAdded < this.getNumOfDoors()) {
            BNACAccessDoor accessDoor = new BNACAccessDoor();
            points.add(SlotPath.escape((String)this.getNACNetwork().getLexicon().getText("door.name", new Object[]{String.valueOf(++doorsAdded)})), (BValue)accessDoor);
            accessDoor.add(SlotPath.escape((String)this.getNACNetwork().getLexicon().getText("reader.name", new Object[]{String.valueOf(doorsAdded)})), (BValue)new BNACReader(doorsAdded, 2 * doorsAdded - 1));
        }
    }

    @Override
    public void addToServer(boolean partOfSync) {
        Utils.checkNACPermission();
        this.getNACNetwork().postAsync(() -> {
            if (!partOfSync && this.getNACNetwork().getSyncingToServer()) {
                this.getNetwork().getLogger().log(Level.WARNING, "Cannot add to server when syncing is in progress");
                return;
            }
            if (this.getUnid() == 0) {
                BNACDevice device = this;
                AccessController.doPrivileged(() -> {
                    NACRequestUtils.addNewDevice(this.getNACNetwork(), device);
                    return null;
                });
            }
        });
    }

    @Override
    public void syncToServer() {
        Runnable r = () -> {
            this.syncServerName();
            this.syncDeviceParameters();
        };
        Utils.runSyncToServer(this.getNACNetwork(), this.taskInQueue, r, 1000L);
    }

    private void syncDeviceParameters() {
        this.getNACNetwork().postAsync(() -> {
            if (this.getUnid() == 0) {
                return;
            }
            String uri = "/dev/update/" + this.getUnid();
            NACServerTokenRequest request = AccessController.doPrivileged(() -> new NACServerTokenRequest(this.getNACNetwork().getHttpConfig().getAddress(), "GET", uri, this.getNACNetwork().getSessionToken()));
            String body = "enabled=" + this.getEnabled();
            request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
            request.setData(body);
            try {
                this.getNACNetwork().sendHttpRequest(request);
            }
            catch (Exception e) {
                Utils.logException(this.getNACNetwork().log(), e, Level.WARNING);
            }
        });
    }

    public void stopped() throws Exception {
        this.getNACNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        super.stopped();
    }

    public void doPing() {
        if (this.getUnid() == 0) {
            this.pingFail(this.getLexicon().get("device.not.added"));
            return;
        }
        try {
            JSONObject response = AccessController.doPrivileged(() -> {
                try {
                    return NACRequestUtils.showResource(this.getNACNetwork(), "devStateRecord", String.valueOf(this.getUnid()), 1);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            JSONObject instance = response.getJSONObject("instance");
            JSONObject devState = instance.getJSONObject("devState");
            this.updateState(devState);
        }
        catch (Exception e) {
            Utils.logException(this.getLogger(), e, Level.WARNING);
            this.pingFail(this.getLexicon().get("server.disconnect.probably"));
        }
    }

    @Override
    public void updateState(JSONObject devState) {
        JSONArray array = devState.getJSONArray("devAspectStates");
        int status = 0;
        for (Object elem : array) {
            if (((JSONObject)elem).getInt("key") == 0) {
                status = ((JSONObject)elem).getJSONObject("value").getInt("commState");
                continue;
            }
            if (((JSONObject)elem).getInt("key") == 25) {
                this.setMacAddress(((JSONObject)elem).getJSONObject("value").getString("data"));
                continue;
            }
            if (((JSONObject)elem).getInt("key") != 14) continue;
            this.setFirmwareVersion(((JSONObject)elem).getJSONObject("value").getString("data"));
        }
        if (status == 1) {
            this.pingOk();
        } else {
            this.pingFail(this.getLexicon().get("device.currently.offline"));
        }
    }

    public void doPoll() {
    }

    public final BNACNetwork getNACNetwork() {
        return (BNACNetwork)this.getNetwork();
    }

    public void validateDoors(int numOfDoors) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Must override validateDoors()");
    }

    public int getDevTemplateType() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Must override getDevTemplateType()");
    }

    public int getDevMod() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Must override getDevMod()");
    }

    public void deleteFromServer(BNACNetwork network) {
        Utils.checkNACPermission();
        network.postAsync(() -> {
            if (this.getUnid() != 0) {
                try {
                    AccessController.doPrivileged(() -> {
                        try {
                            NACRequestUtils.removeDevice(network, String.valueOf(this.getUnid()));
                            return null;
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    Utils.logException(this.getLogger(), e, Level.SEVERE, "Device was not removed from server. Please sync to update the server");
                }
                finally {
                    this.clearDeviceUnid(network, (BComponent)this);
                    this.getPoints().getAux().removeAll();
                }
            }
        });
    }

    private void clearDeviceUnid(BNACNetwork network, BComponent component) {
        BComponent[] children;
        if (component instanceof BINACMappable) {
            network.removeMapping(((BINACMappable)component).getUnid());
            ((BINACMappable)component).cleanDeviceUnids();
        }
        for (BComponent child : children = component.getChildComponents()) {
            this.clearDeviceUnid(network, child);
        }
    }

    @Override
    public void cleanDeviceUnids() {
        this.setUnid(0);
    }

    @Override
    public void storeMapping(int unid) {
        this.setUnid(unid);
        this.getNACNetwork().storeMapping(unid, this.getHandle());
    }

    public void syncChildren(JSONObject instance) throws Exception {
        if (instance == null) {
            instance = NACRequestUtils.showResource(this.getNACNetwork(), "dev", String.valueOf(this.getUnid()), 3).getJSONObject("instance");
        }
        JSONArray physicalChildren = instance.getJSONArray("physicalChildren");
        Iterator doorIterator = Arrays.stream(this.getPoints().getChildren(BNACAccessDoor.class)).iterator();
        for (Object child : physicalChildren) {
            JSONObject childJson = (JSONObject)child;
            if (childJson.getString("type").equals("Controller")) {
                this.getPoints().storeMapping(childJson.getInt("unid"));
                this.getPoints().syncChildren(null);
                this.getPoints().syncToServer();
                continue;
            }
            if (!childJson.getString("type").equals("Door") || childJson.getString("name").endsWith("Exit") || !doorIterator.hasNext()) continue;
            BNACAccessDoor accessDoor = (BNACAccessDoor)doorIterator.next();
            accessDoor.storeMapping(childJson.getInt("unid"));
            accessDoor.syncChildren(null);
            accessDoor.syncToServer();
        }
        if (doorIterator.hasNext()) {
            this.getNACNetwork().log().log(Level.WARNING, "Extra doors in Niagara were not synced to server");
        }
    }

    public void syncServerName() {
        BNACAccessDoor[] doors;
        AccessController.doPrivileged(() -> {
            NACRequestUtils.syncDeviceName(this.getNACNetwork(), String.valueOf(this.getUnid()), this.getDisplayName(null));
            return null;
        });
        for (BNACAccessDoor door : doors = (BNACAccessDoor[])this.getPoints().getChildren(BNACAccessDoor.class)) {
            door.syncServerName();
        }
    }

    public BEnumRange getDoorModeRange() {
        BEnumRange range = BNACDoorModeTypeEnum.DEFAULT.getRange();
        String[] tags = (String[])Arrays.stream(this.getDoorModeOrdinals()).mapToObj(ordinal -> SlotPath.escape((String)range.getDisplayTag(ordinal, null))).toArray(String[]::new);
        return BEnumRange.make((int[])this.getDoorModeOrdinals(), (String[])tags);
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(controllerFirmwareUpdate)) {
            return this.invoke(loadFirmwareVersionList, null);
        }
        return super.getActionParameterDefault(action);
    }

    public void doRefreshAllEncryptionKeys(Context cx) {
        new BNACRefreshAllEncryptionKeyJob(this).submit(cx);
    }

    public BDynamicEnum doLoadFirmwareVersionList(Context cx) {
        return NACRequestUtils.loadFirmwareVersionList(this.getNACNetwork());
    }

    public void doControllerFirmwareUpdate(BDynamicEnum firmwareList, Context cx) throws LocalizableException {
        if (firmwareList.isActive()) {
            if (this.getNACNetwork().getSessionToken() != null) {
                AccessController.doPrivileged(() -> {
                    int firmwareUnid = firmwareList.getOrdinal();
                    BNACDevice[] bnacDevices = new BNACDevice[]{this};
                    String firmwareName = SlotPath.unescape((String)firmwareList.getTag());
                    String formattedFirmwareName = firmwareName.substring(0, firmwareName.lastIndexOf("-"));
                    BUpgradeNACFirmwareJob job = new BUpgradeNACFirmwareJob(bnacDevices, firmwareUnid, formattedFirmwareName);
                    return job.submit(cx);
                });
            } else {
                this.getLogger().log(Level.SEVERE, "Server authentication failed");
            }
        } else {
            throw new LocalizableException(this.getLexicon(), "device.controller.firmware.required.error");
        }
    }

    protected int[] getDoorModeOrdinals() {
        return new int[0];
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!this.isRunning() || context != null && context.equals(Context.decoding)) {
            return;
        }
        if (property.equals(enabled)) {
            this.syncToServer();
        }
        if (property.equals(ipAddress) || property.equals(port)) {
            this.getNACNetwork().postAsync(() -> {
                AtomicBoolean atomicBoolean = this.ipPortTaskInQueue;
                synchronized (atomicBoolean) {
                    if (!this.ipPortTaskInQueue.get()) {
                        this.ipPortTaskInQueue.set(true);
                        new Timer().schedule(new TimerTask(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                AtomicBoolean atomicBoolean = BNACDevice.this.ipPortTaskInQueue;
                                synchronized (atomicBoolean) {
                                    BNACDevice.this.ipPortTaskInQueue.set(false);
                                }
                                AccessController.doPrivileged(() -> {
                                    BNACDevice.this.deleteFromServer(BNACDevice.this.getNACNetwork());
                                    BNACDevice.this.addToServer(false);
                                    return null;
                                });
                            }
                        }, 1000L);
                    }
                }
            });
        }
    }

    public final String getControllerSoftwareUpdateURI(int softwareUpdateUnid) {
        return "/json/controllerSoftwareUpdate?unid=" + this.getUnid() + "&softwareUpdateUnid=" + softwareUpdateUnid;
    }

    public final String getControllerRebootURI() {
        return "/json/controllerReboot?unid=" + this.getUnid();
    }

    public String getDescription(Context cx) {
        return this.getDisplayName(cx);
    }

    public String getAddress() {
        return this.getIpAddress();
    }

    public String getDeviceType(Context cx) {
        switch (this.getNumOfDoors()) {
            case 1: {
                return BDevCreationTemplateTypeEnum.nacController100.getDisplayTag(cx);
            }
            case 2: {
                return BDevCreationTemplateTypeEnum.nacController200.getDisplayTag(cx);
            }
            case 4: {
                return BDevCreationTemplateTypeEnum.nacController400.getDisplayTag(cx);
            }
        }
        return this.getLexicon().getText("device.defaultType");
    }

    public String getStatusString(Context cx) {
        return this.getStatus().toString(cx);
    }
}

