/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver.device;

import com.tridiumx.nacDriver.device.BNACDevice;
import java.util.Arrays;
import java.util.List;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNACController
extends BNACDevice {
    @Generated
    public static final Type TYPE = Sys.loadType(BNACController.class);
    private static final List<Integer> VALID_DOORS = Arrays.asList(1, 2, 4);
    private static final int[] MANUAL_COMMANDS = new int[]{0, 1, 2, 3, 4, 5, 6, 8, 9, 11, 12, 13, 14, 15, 17, 18, 19, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38};
    private static final int[] SUPPORTED_READER_TYPES = new int[]{0, 6};

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void validateDoors(int numOfDoors) throws UnsupportedOperationException {
        if (!VALID_DOORS.contains(numOfDoors)) {
            throw new UnsupportedOperationException(this.getLexicon().getText("nacController.invalidNumberOfDoors", new Object[]{numOfDoors}));
        }
    }

    @Override
    public int getDevTemplateType() throws UnsupportedOperationException {
        switch (this.getNumOfDoors()) {
            case 1: {
                return 51;
            }
            case 2: {
                return 53;
            }
            case 4: {
                return 55;
            }
        }
        throw new UnsupportedOperationException("No dev template for device configuration");
    }

    @Override
    public int getDevMod() throws UnsupportedOperationException {
        switch (this.getNumOfDoors()) {
            case 1: {
                return 180;
            }
            case 2: {
                return 181;
            }
            case 4: {
                return 182;
            }
        }
        throw new UnsupportedOperationException("No dev mod for device configuration");
    }

    @Override
    protected int[] getDoorModeOrdinals() {
        return MANUAL_COMMANDS;
    }
}

