/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.nacDriver;

import com.tridium.json.JSONObject;
import com.tridium.ndriver.comm.NCommException;
import com.tridium.orion.BRef;
import com.tridium.orion.OrionCursor;
import com.tridium.orion.OrionSession;
import com.tridium.orion.OrionType;
import com.tridium.orion.sql.BSqlQuery;
import com.tridiumx.entsec.access.BAccessControlService;
import com.tridiumx.entsec.access.orion.BAccessRight;
import com.tridiumx.entsec.threat.BThreatLevelGroupRec;
import com.tridiumx.entsec.threat.BThreatLevelOperationEnum;
import com.tridiumx.entsec.threat.ThreatLevelUtil;
import com.tridiumx.nacDriver.BNACNetwork;
import com.tridiumx.nacDriver.message.NACServerTokenRequest;
import com.tridiumx.nacDriver.util.NACRequestUtils;
import java.security.AccessController;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.query.util.Predicates;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BNACThreatLevelReplicationJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BNACThreatLevelReplicationJob.class);
    private BNACNetwork network;
    private BThreatLevelGroupRec threatLevelGroupRecord;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BNACThreatLevelReplicationJob() {
    }

    public BNACThreatLevelReplicationJob(BThreatLevelGroupRec threatLevelGroupRec) {
        this.threatLevelGroupRecord = threatLevelGroupRec;
    }

    public void run(Context context) throws Exception {
        block25: {
            this.network = (BNACNetwork)Sys.getService((Type)BNACNetwork.TYPE);
            this.logMessage(this.getLexicon().getText("nacReplicateThreatLevel.startJob", new Object[]{this.threatLevelGroupRecord.getThreatLevelGroupName()}));
            try (OrionSession session = this.getOrionSession(context);){
                int totalAccessRightsUpdated = 0;
                if (session == null) break block25;
                AtomicInteger recordIndex = new AtomicInteger(0);
                StringBuilder accessRightBody = new StringBuilder();
                try (OrionCursor accessRightCursor = session.select(BSqlQuery.make((OrionType)BAccessRight.ORION_TYPE).where(Predicates.eq((Property)BAccessRight.threatLevelGroup, (BSimple)BRef.make((BTypeSpec)BThreatLevelGroupRec.TYPE.getTypeSpec(), (BSimple)this.threatLevelGroupRecord.getUuid()))));){
                    while (accessRightCursor.next()) {
                        BAccessRight accessRightRecord = (BAccessRight)accessRightCursor.get();
                        String uuid = accessRightRecord.getAccessRightId().toString();
                        JSONObject instance = this.getInstanceFromServer(uuid, "priv");
                        if (instance == null) continue;
                        boolean enableAccessRight = ThreatLevelUtil.compareThreatOperationLevel((BThreatLevelOperationEnum)accessRightRecord.getThreatLevelOperation(), (int)this.threatLevelGroupRecord.getActiveLevel().getOrdinal(), (int)accessRightRecord.getDefaultAssignedThreatLevel().getOrdinal());
                        this.updateAccessRightRequestBody(accessRightBody, uuid, enableAccessRight, recordIndex);
                        ++totalAccessRightsUpdated;
                    }
                }
                this.updateThreatLevelToNACServer(accessRightBody.toString());
                this.log().success(this.getLexicon().getText("nacReplicateThreatLevel.totalAccessRightUpdate", new Object[]{totalAccessRightsUpdated}));
                this.logMessage(this.getLexicon().getText("nacReplicateThreatLevel.endJob"));
            }
        }
    }

    private void logMessage(String message) {
        this.log().message(message);
        if (this.network != null && this.network.log().isLoggable(Level.FINE)) {
            this.network.log().log(Level.FINE, "NAC Replicate Threat Level Job:" + message);
        }
    }

    private void updateThreatLevelToNACServer(String accessRightBody) {
        AccessController.doPrivileged(() -> {
            try {
                this.updateThreatLevelToNACServerPublic(accessRightBody);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        });
    }

    public void updateThreatLevelToNACServerPublic(String accessRightBody) throws Exception {
        if (accessRightBody.length() == 0) {
            return;
        }
        String uri = "/executeMultiDbChange";
        NACServerTokenRequest request = new NACServerTokenRequest(this.network.getHttpConfig().getAddress(), "POST", uri, this.network.getSessionToken());
        request.addHeader("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8", true);
        request.setData(accessRightBody);
        this.network.sendHttpRequest(request);
    }

    private void updateAccessRightRequestBody(StringBuilder accessRightBody, String uuid, boolean enableAccessRight, AtomicInteger recordIndex) {
        if (accessRightBody.length() != 0) {
            accessRightBody.append("&");
        }
        String accessRightOperation = "privUpdate[" + recordIndex.get() + "]";
        accessRightBody.append(accessRightOperation).append(".uuid=").append(uuid).append("&");
        accessRightBody.append(accessRightOperation).append(".enabled=").append(enableAccessRight);
        recordIndex.incrementAndGet();
    }

    private JSONObject getInstanceFromServer(String uuid, String objectName) {
        return AccessController.doPrivileged(() -> this.getRecordIfAvailable(uuid, objectName));
    }

    public JSONObject getRecordIfAvailable(String uuid, String resource) {
        try {
            return NACRequestUtils.showResource(this.network, resource, uuid, 0).getJSONObject("instance");
        }
        catch (NCommException e) {
            if (e.getMessage().startsWith("Error 404")) {
                return null;
            }
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private OrionSession getOrionSession(Context cx) {
        BAccessControlService acs = (BAccessControlService)Sys.getService((Type)BAccessControlService.TYPE);
        OrionSession orionSession = acs.getOrionDatabase().createSession(cx);
        return orionSession;
    }
}

