/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ccn.ui;

import com.tridium.ccn.BCcnNetwork;
import com.tridium.workbench.propsheet.BFieldEditorSheet;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BFrame;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"ccn:CcnNetwork"}, requiredPermissions="r")})
public class BCcnNetworkView
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BCcnNetworkView.class);
    BFieldEditorSheet sheet;
    BCcnNetwork objNetwork;
    final BFrame frameObj = new BFrame();
    private static final Lexicon lex = Lexicon.make(BCcnNetworkView.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void build() {
        this.sheet = new BFieldEditorSheet();
        this.linkTo((BComponent)this.sheet, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo((BComponent)this.sheet, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed);
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            BGridPane buttons = new BGridPane(2);
            buttons.setColumnAlign(BHalign.fill);
            buttons.setUniformColumnWidth(true);
            buttons.add(null, (BValue)new BButton(shell.getRefreshCommand()));
            buttons.add(null, (BValue)new BButton(shell.getSaveCommand()));
            BEdgePane edge = new BEdgePane();
            edge.setCenter((BWidget)this.sheet);
            edge.setBottom((BWidget)buttons);
            this.setContent((BWidget)new BTitlePane("Property Sheet", (BWidget)edge));
        } else {
            this.setContent((BWidget)this.sheet);
        }
    }

    public void doLoadValue(BObject value, Context cx) {
        this.build();
        this.sheet.loadValue(value, cx);
        this.objNetwork = (BCcnNetwork)value;
    }

    public BObject doSaveValue(BObject value, Context cx) throws Exception {
        int prevFirstBusNum = ((BCcnNetwork)value).getFirstBusNo();
        int prevLastBusNum = ((BCcnNetwork)value).getLastBusNo();
        int prevLowElemNum = ((BCcnNetwork)value).getLowElemNo();
        int prevHighElemNum = ((BCcnNetwork)value).getHighElemNo();
        BObject newValue = this.sheet.saveValue(cx);
        if (newValue instanceof BCcnNetwork) {
            BCcnNetwork newValueNetwork = (BCcnNetwork)newValue;
            int newFirstBusNum = newValueNetwork.getFirstBusNo();
            int newLastBusNum = newValueNetwork.getLastBusNo();
            int newLowElemNum = newValueNetwork.getLowElemNo();
            int newHighElemNum = newValueNetwork.getHighElemNo();
            int newDeviceBusAddr = newValueNetwork.getBusAddress();
            boolean newAlarmAck = newValueNetwork.getAlarmAcknowledger();
            String warningTitle = lex.getText("CcnNetworkView.configurationWarningTitle");
            if (prevFirstBusNum != newFirstBusNum && newFirstBusNum > newLastBusNum) {
                BDialog.warning((BWidget)this, (String)warningTitle, (Object)lex.getText("CcnNetworkView.warningFirstBus"));
                newFirstBusNum = prevFirstBusNum;
                newValueNetwork.setFirstBusNo(newFirstBusNum);
            }
            if (prevLastBusNum != newLastBusNum && newLastBusNum < newFirstBusNum) {
                BDialog.warning((BWidget)this, (String)warningTitle, (Object)lex.getText("CcnNetworkView.warningLastBus"));
                newLastBusNum = prevLastBusNum;
                newValueNetwork.setLastBusNo(newLastBusNum);
            }
            if (prevLowElemNum != newLowElemNum && newLowElemNum > newHighElemNum) {
                BDialog.warning((BWidget)this, (String)warningTitle, (Object)lex.getText("CcnNetworkView.warningLowElement"));
                newLowElemNum = prevLowElemNum;
                newValueNetwork.setLowElemNo(newLowElemNum);
            }
            if (prevHighElemNum != newHighElemNum && newHighElemNum < newLowElemNum) {
                BDialog.warning((BWidget)this, (String)warningTitle, (Object)lex.getText("CcnNetworkView.warningHighElement"));
                newHighElemNum = prevHighElemNum;
                newValueNetwork.setHighElemNo(newHighElemNum);
            }
            if (newAlarmAck && newDeviceBusAddr != 0) {
                BDialog.warning((BWidget)this, (String)warningTitle, (Object)lex.getText("CcnNetworkView.warningAlarmAcknowledger"));
                newValueNetwork.setAlarmAcknowledger(false);
            }
        }
        this.sheet.loadValue(newValue, cx);
        if (newValue instanceof BCcnNetwork) {
            this.objNetwork = (BCcnNetwork)newValue;
        }
        return newValue;
    }
}

