/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro.awt;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.GZIPOutputStream;

public class MicroFontWriter {
    public void generateFontFiles(Path outDir, String fontName, int[] fontSizes, boolean plain, boolean bold, boolean italic, boolean boldItalic, int maxCodePoint) {
        for (int i = 0; i < fontSizes.length; ++i) {
            if (plain) {
                this.generateFontFile(new Font(fontName, 0, fontSizes[i]), outDir, maxCodePoint);
            }
            if (bold) {
                this.generateFontFile(new Font(fontName, 1, fontSizes[i]), outDir, maxCodePoint);
            }
            if (italic) {
                this.generateFontFile(new Font(fontName, 2, fontSizes[i]), outDir, maxCodePoint);
            }
            if (!boldItalic) continue;
            this.generateFontFile(new Font(fontName, 3, fontSizes[i]), outDir, maxCodePoint);
        }
    }

    private void generateFontFile(Font font, Path outDir, int maxCodePoint) {
        try {
            FontInfo fontInfo = this.makeFontInfo(font, outDir);
            this.header(fontInfo);
            this.characters(fontInfo, maxCodePoint);
            this.pdf(fontInfo, maxCodePoint);
            fontInfo.out.flush();
            fontInfo.out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private FontInfo makeFontInfo(Font font, Path outDir) throws Exception {
        FontInfo info = new FontInfo();
        info.name = this.toStr(font);
        info.font = font;
        info.fm = Toolkit.getDefaultToolkit().getFontMetrics(info.font);
        Files.createDirectories(outDir, new FileAttribute[0]);
        info.out = new OutStream(new GZIPOutputStream(new FileOutputStream(outDir.resolve(info.name + ".font").toFile())));
        return info;
    }

    private void header(FontInfo info) throws Exception {
        int fl = info.fm.getLeading();
        int fh = info.fm.getHeight();
        int fa = info.fm.getAscent();
        int fd = info.fm.getDescent();
        info.out.u1(fl);
        info.out.u1(fh);
        info.out.u1(fa);
        info.out.u1(fd);
    }

    private void characters(FontInfo info, int maxCodePoint) throws Exception {
        int characterWidth;
        ArrayList<Integer> displayableCodePoints = new ArrayList<Integer>();
        ArrayList<Integer> displayableCharacterWidths = new ArrayList<Integer>();
        for (int character = 0; character <= maxCodePoint; ++character) {
            if (!info.font.canDisplay(character)) continue;
            characterWidth = info.fm.charWidth(character);
            if (characterWidth < 0) {
                characterWidth *= -1;
            }
            displayableCodePoints.add(character);
            displayableCharacterWidths.add(characterWidth);
        }
        info.out.character((char)maxCodePoint);
        info.out.character((char)displayableCodePoints.size());
        Iterator iterator = displayableCodePoints.iterator();
        while (iterator.hasNext()) {
            int codePoint = (Integer)iterator.next();
            info.out.character((char)codePoint);
        }
        iterator = displayableCharacterWidths.iterator();
        while (iterator.hasNext()) {
            characterWidth = (Integer)iterator.next();
            info.out.u1(characterWidth);
        }
    }

    private void pdf(FontInfo info, int maxCodePoint) throws Exception {
        int characterWidth;
        Font f = new Font(info.font.getName(), info.font.getStyle(), 72);
        FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(f);
        String ps = f.getPSName();
        int fl = fm.getLeading();
        int fh = fm.getHeight();
        int fa = fm.getAscent();
        int fd = fm.getDescent();
        ArrayList<Integer> displayableCodePoints = new ArrayList<Integer>();
        ArrayList<Integer> displayableCharacterWidths = new ArrayList<Integer>();
        for (int character = 0; character <= maxCodePoint; ++character) {
            if (!f.canDisplay(character)) continue;
            characterWidth = fm.charWidth(character);
            if (characterWidth < 0) {
                characterWidth *= -1;
            }
            displayableCodePoints.add(character);
            displayableCharacterWidths.add(characterWidth);
        }
        info.out.utf(ps);
        info.out.u1(fl);
        info.out.u1(fh);
        info.out.u1(fa);
        info.out.u1(fd);
        info.out.character((char)maxCodePoint);
        info.out.character((char)displayableCodePoints.size());
        Iterator iterator = displayableCodePoints.iterator();
        while (iterator.hasNext()) {
            int codePoint = (Integer)iterator.next();
            info.out.character((char)codePoint);
        }
        iterator = displayableCharacterWidths.iterator();
        while (iterator.hasNext()) {
            characterWidth = (Integer)iterator.next();
            info.out.u1(characterWidth);
        }
    }

    private String toStr(Font font) {
        return this.getStyle(font) + font.getSize() + "pt " + font.getName();
    }

    private String getStyle(Font font) {
        int s = font.getStyle();
        if ((s & 3) == 3) {
            return "bold italic ";
        }
        if ((s & 2) == 2) {
            return "italic ";
        }
        if ((s & 1) == 1) {
            return "bold ";
        }
        return "";
    }

    private class OutStream
    extends DataOutputStream {
        public OutStream(OutputStream stream) {
            super(stream);
        }

        public void u1(int b) throws IOException {
            this.write(0xFF & b);
        }

        public void u2(int b) throws IOException {
            this.write(0xFF & b >> 8);
            this.write(0xFF & b);
        }

        public void character(char c) throws IOException {
            this.writeChar(c);
        }

        public void utf(String s) throws IOException {
            this.writeUTF(s);
        }
    }

    private class FontInfo {
        public String name;
        public Font font;
        public FontMetrics fm;
        public OutStream out;

        private FontInfo() {
        }
    }
}

