/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.ImagePeer;
import com.tridium.gx.micro.MicroEnv;
import com.tridium.gx.micro.MicroImageData;
import com.tridium.gx.micro.MicroImageManager;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.RGB;

public class MicroImagePeer
implements ImagePeer {
    double width = 0.0;
    double height = 0.0;
    int[] data = null;
    BImage image;
    boolean dimensionLoaded = false;

    private MicroImagePeer() throws Exception {
    }

    public MicroImagePeer(BImage image) {
        this.image = image;
    }

    public Graphics getGraphics() {
        return null;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public boolean animate() {
        return false;
    }

    public void dispose() {
        this.data = null;
        this.height = 0.0;
        this.width = 0.0;
    }

    public boolean isDimensionsLoaded() {
        return this.dimensionLoaded;
    }

    public void syncDimensions() {
        block4: {
            if (this.image.getOrdList().isNull() || this.image.getOrdList().size() == 0) {
                return;
            }
            BOrd ord = this.image.getOrdList().get(0);
            try {
                MicroImageData info = MicroImageManager.fetchDimensions(this.image);
                if (info != null) {
                    this.height = info.dimensions.height();
                    this.width = info.dimensions.width();
                    this.dimensionLoaded = true;
                }
            }
            catch (Throwable e) {
                if (!MicroEnv.logger.isLoggable(Level.FINE)) break block4;
                MicroEnv.logger.log(Level.FINE, "MicroEnv: Cannot load image dimensions\"" + ord + "\"", e);
            }
        }
    }

    public boolean isLoaded() {
        return this.data != null;
    }

    public void sync() {
        if (this.image.getOrdList().isNull() || this.image.getOrdList().size() == 0) {
            return;
        }
        BOrd ord = this.image.getOrdList().get(0);
        try {
            BIFile file = (BIFile)ord.resolve().get();
            ImageLoader loader = new ImageLoader();
            ImageData imageData = loader.load(file.getInputStream())[0];
            this.height = imageData.height;
            this.width = imageData.width;
            this.data = new int[(int)(this.width * this.height)];
            int[] scanline = new int[imageData.width];
            for (int y = 0; y < imageData.height; ++y) {
                imageData.getPixels(0, y, imageData.width, scanline, 0);
                for (int x = 0; x < scanline.length; ++x) {
                    int blue;
                    int green;
                    int red;
                    int alpha = imageData.alpha != -1 ? imageData.alpha : (imageData.alphaData != null ? imageData.alphaData[x + y * imageData.width] : 255);
                    if (imageData.palette.isDirect) {
                        int pixel = scanline[x];
                        red = pixel & imageData.palette.redMask;
                        red = imageData.palette.redShift < 0 ? red >>> -imageData.palette.redShift : red << imageData.palette.redShift;
                        green = pixel & imageData.palette.greenMask;
                        green = imageData.palette.greenShift < 0 ? green >>> -imageData.palette.greenShift : green << imageData.palette.greenShift;
                        blue = pixel & imageData.palette.blueMask;
                        blue = imageData.palette.blueShift < 0 ? blue >>> -imageData.palette.blueShift : blue << imageData.palette.blueShift;
                    } else {
                        RGB rgb = imageData.palette.getRGBs()[scanline[x]];
                        red = rgb.red;
                        green = rgb.green;
                        blue = rgb.blue;
                    }
                    this.data[x + y * imageData.width] = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
                }
            }
        }
        catch (UnresolvedException e) {
            if (MicroEnv.logger.isLoggable(Level.WARNING)) {
                MicroEnv.logger.log(Level.WARNING, "MicroEnv: Cannot resolve image \"" + ord + "\"", e);
            }
            e.printStackTrace();
        }
        catch (Throwable e) {
            if (MicroEnv.logger.isLoggable(Level.FINE)) {
                MicroEnv.logger.log(Level.FINE, "MicroEnv: Cannot load image \"" + ord + "\"", e);
            }
            e.printStackTrace();
        }
    }

    public int[] getPixels() {
        if (this.data == null) {
            return new int[0];
        }
        int[] copy = new int[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    public void setPixels(int[] pixels) {
        if ((double)pixels.length != this.width * this.height) {
            throw new IllegalStateException("MicroImagePeer: pixels.length != width x height");
        }
        this.data = pixels;
    }
}

