/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.util.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BIFile;
import javax.baja.file.types.image.BSvgFile;
import javax.baja.gx.Size;
import javax.baja.nre.util.TextUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class MicroImageInfo {
    private Size dimensions;
    private static final Logger LOG = Logger.getLogger("gx.image");

    public MicroImageInfo(BIFile file) throws IOException {
        try {
            this.processFile(file);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
    }

    public Size getDimensions() {
        return this.dimensions;
    }

    private void processFile(BIFile file) throws IOException, XMLStreamException {
        try (InputStream is = null;){
            is = file.getStore().getInputStream();
            this.dimensions = file instanceof BSvgFile ? this.readDimensionsSvg(is) : this.readDimensions(is);
        }
    }

    private Size readDimensions(InputStream is) throws IOException {
        double height;
        double width;
        block11: {
            int c3;
            int c2;
            int c1;
            block12: {
                block10: {
                    c1 = is.read();
                    c2 = is.read();
                    c3 = is.read();
                    width = -1.0;
                    height = -1.0;
                    if (c1 != 71 || c2 != 73 || c3 != 70) break block10;
                    is.skip(3L);
                    width = this.readInt(is, 2, false);
                    height = this.readInt(is, 2, false);
                    break block11;
                }
                if (c1 != 255 || c2 != 216) break block12;
                while (c3 == 255) {
                    int marker = is.read();
                    int len = this.readInt(is, 2, true);
                    if (marker == 192 || marker == 193 || marker == 194) {
                        is.skip(1L);
                        height = this.readInt(is, 2, true);
                        width = this.readInt(is, 2, true);
                        return new Size(width, height);
                    }
                    is.skip(len - 2);
                    c3 = is.read();
                }
                break block11;
            }
            if (c1 == 137 && c2 == 80 && c3 == 78) {
                is.skip(15L);
                width = this.readInt(is, 2, true);
                is.skip(2L);
                height = this.readInt(is, 2, true);
                return new Size(width, height);
            }
            if (c1 == 66 && c2 == 77) {
                is.skip(15L);
                width = this.readInt(is, 2, false);
                is.skip(2L);
                height = this.readInt(is, 2, false);
                return new Size(width, height);
            }
            int c4 = is.read();
            if ((c1 != 77 || c2 != 77 || c3 != 0 || c4 != 42) && (c1 != 73 || c2 != 73 || c3 != 42 || c4 != 0)) break block11;
            boolean bigEndian = c1 == 77;
            int ifd = 0;
            ifd = this.readInt(is, 4, bigEndian);
            is.skip(ifd - 8);
            int entries = this.readInt(is, 2, bigEndian);
            for (int i = 1; i <= entries; ++i) {
                int valOffset;
                int tag = this.readInt(is, 2, bigEndian);
                int fieldType = this.readInt(is, 2, bigEndian);
                long count = this.readInt(is, 4, bigEndian);
                if (fieldType == 3 || fieldType == 8) {
                    valOffset = this.readInt(is, 2, bigEndian);
                    is.skip(2L);
                } else {
                    valOffset = this.readInt(is, 4, bigEndian);
                }
                if (tag == 256) {
                    width = valOffset;
                } else if (tag == 257) {
                    height = valOffset;
                }
                if (width == -1.0 || height == -1.0) continue;
                return new Size(width, height);
            }
        }
        return new Size(width, height);
    }

    private int readInt(InputStream is, int noOfBytes, boolean bigEndian) throws IOException {
        int ret = 0;
        int sv = bigEndian ? (noOfBytes - 1) * 8 : 0;
        int cnt = bigEndian ? -8 : 8;
        for (int i = 0; i < noOfBytes; ++i) {
            ret |= is.read() << sv;
            sv += cnt;
        }
        return ret;
    }

    public String toString() {
        return "" + this.dimensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Size readDimensionsSvg(InputStream in) throws XMLStreamException, IOException {
        try (XMLStreamReader parser = StreamUtil.getFactory().createXMLStreamReader(in);){
            double width = 1.0;
            double height = 1.0;
            boolean widthFound = false;
            boolean heightFound = false;
            while (!widthFound && !heightFound) {
                int event = 0;
                event = parser.next();
                if (event == 8) break;
                if (event != 1 || !parser.getLocalName().toLowerCase().equals("svg")) continue;
                String widthString = parser.getAttributeValue(null, "width");
                String heightString = parser.getAttributeValue(null, "height");
                if (widthString != null) {
                    width = this.parseSvgDimensionAttribute(widthString);
                    widthFound = true;
                }
                if (heightString == null) continue;
                height = this.parseSvgDimensionAttribute(heightString);
                heightFound = true;
            }
            Size size = new Size(width, height);
            return size;
        }
    }

    private int parseSvgDimensionAttribute(String attrStr) {
        try {
            return (int)(MicroImageInfo.toPixels(attrStr) + 0.5);
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cannot parse double", e);
            }
            return 1;
        }
    }

    public static double toPixels(String attrStr) {
        String withUnits = attrStr.toLowerCase();
        if (withUnits.endsWith("px")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'p')[0]);
        }
        if (withUnits.endsWith("pt")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'p')[0]) * 4.0 / 3.0;
        }
        if (withUnits.endsWith("pc")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'p')[0]) * 16.0;
        }
        if (withUnits.endsWith("em")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'e')[0]) * 12.0;
        }
        if (withUnits.endsWith("ex")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'e')[0]) * 6.0;
        }
        if (withUnits.endsWith("in")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'i')[0]) * 96.0;
        }
        if (withUnits.endsWith("cm")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'c')[0]) * 96.0 / 2.54;
        }
        if (withUnits.endsWith("mm")) {
            return Double.parseDouble(TextUtil.split((String)withUnits, (char)'m')[0]) * 96.0 / 25.4;
        }
        return Double.parseDouble(withUnits);
    }
}

