/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.micro.MicroEnv;
import com.tridium.gx.micro.MicroFont;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.zip.GZIPInputStream;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.gx.BFont;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.Sys;

public class MicroFontReader {
    private static ConcurrentHashMap<BFont, MicroFont> cache = new ConcurrentHashMap();
    private static HashMap<String, BIFile> sharedUserHomeFontFiles = new HashMap();
    private static HashMap<String, BIFile> moduleFontFiles = new HashMap();
    private static HashMap<String, BIFile> defaultFontFiles = new HashMap();
    private static Integer[] plainArialSizes;
    private static List<String> fontNames;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MicroFont read(BFont font) {
        String fileName = MicroFontReader.createFileName(font);
        MicroFont mfont = cache.get(font);
        if (mfont == null) {
            int size = (int)font.getSize();
            int style = font.getStyle();
            mfont = new MicroFont(font.getName(), style, size, fileName);
            BOrd ord = MicroFontReader.findFontFile(fileName);
            if (ord == null) {
                if (!MicroEnv.logger.isLoggable(Level.FINE)) return null;
                MicroEnv.logger.log(Level.FINE, fileName + " not found");
                return null;
            }
            if (MicroEnv.logger.isLoggable(Level.FINE)) {
                MicroEnv.logger.log(Level.FINE, "Found " + ord.toString());
            }
            BIFile file = (BIFile)ord.get();
            try (InStream in = new InStream(new BufferedInputStream(new GZIPInputStream(file.getInputStream())));){
                mfont.leading = in.u1();
                mfont.height = in.u1();
                mfont.ascent = in.u1();
                mfont.descent = in.u1();
                int totalCodePointCount = in.character() + '\u0001';
                int displayableCodePointCount = in.character();
                int[] displayableCodePoints = new int[displayableCodePointCount];
                for (int i = 0; i < displayableCodePointCount; ++i) {
                    displayableCodePoints[i] = in.character();
                }
                int averageDisplayableCharacterWidth = 0;
                mfont.characterWidths = new byte[totalCodePointCount];
                for (int i = 0; i < displayableCodePoints.length; ++i) {
                    byte width = (byte)in.u1();
                    averageDisplayableCharacterWidth += width;
                    mfont.characterWidths[displayableCodePoints[i]] = width;
                }
                mfont.averageDisplayableCharacterWidth = averageDisplayableCharacterWidth / displayableCodePoints.length;
                mfont.psName = in.utf();
                mfont.pdfLeading = in.u1();
                mfont.pdfHeight = in.u1();
                mfont.pdfAscent = in.u1();
                mfont.pdfDescent = in.u1();
                int totalPDFCodePointCount = in.character() + '\u0001';
                int displayablePDFCodePointCount = in.character();
                int[] displayablePDFCodePoints = new int[displayablePDFCodePointCount];
                for (int i = 0; i < displayablePDFCodePointCount; ++i) {
                    displayablePDFCodePoints[i] = in.character();
                }
                int averageDisplayablePDFCharacterWidth = 0;
                mfont.pdfCharacterWidths = new byte[totalPDFCodePointCount];
                for (int i = 0; i < displayablePDFCodePoints.length; ++i) {
                    byte width = (byte)in.u1();
                    averageDisplayablePDFCharacterWidth += width;
                    mfont.pdfCharacterWidths[displayablePDFCodePoints[i]] = width;
                }
                mfont.averageDisplayablePDFCharacterWidth = averageDisplayablePDFCharacterWidth / displayablePDFCodePoints.length;
                cache.put(font, mfont);
                if (!MicroEnv.logger.isLoggable(Level.FINER)) return mfont;
                MicroEnv.logger.log(Level.FINER, fileName + " added to cache");
                return mfont;
            }
            catch (IOException e) {
                MicroEnv.logger.log(Level.WARNING, "Failed to read " + fileName, e);
                return null;
            }
        } else {
            if (!MicroEnv.logger.isLoggable(Level.FINER)) return mfont;
            MicroEnv.logger.log(Level.FINER, fileName + " loaded from cache");
        }
        return mfont;
    }

    private static BOrd findFontFile(String fileName) {
        BIFile fontFile = sharedUserHomeFontFiles.get(fileName);
        if (fontFile != null) {
            return fontFile.getAbsoluteOrd();
        }
        fontFile = moduleFontFiles.get(fileName);
        if (fontFile != null) {
            return fontFile.getAbsoluteOrd();
        }
        fontFile = defaultFontFiles.get(fileName);
        if (fontFile != null) {
            return fontFile.getAbsoluteOrd();
        }
        return null;
    }

    private static void getAvailableFontFiles() {
        HashSet<Integer> tempPlainArialSizes = new HashSet<Integer>();
        File microFontFolder = Sys.getNiagaraSharedUserHome().toPath().resolve("microFont/").toFile();
        FilePath microFontFilePath = BFileSystem.INSTANCE.localFileToPath(microFontFolder);
        if (BFileSystem.INSTANCE.findFile(microFontFilePath) != null) {
            String[] sharedUserHomeOrd = BFileSystem.INSTANCE.localFileToOrd(microFontFolder);
            BIFile[] bIFileArray = ((BIDirectory)sharedUserHomeOrd.get()).listFiles();
            int n = bIFileArray.length;
            for (int i = 0; i < n; ++i) {
                BIFile file = bIFileArray[i];
                if (!file.getExtension().equals("font")) continue;
                sharedUserHomeFontFiles.put(file.getFileName(), file);
                MicroFontReader.addFontName(file.getFileName());
                if (!file.getFileName().endsWith("Arial.font") || file.getFileName().contains("bold") || file.getFileName().contains("italic")) continue;
                tempPlainArialSizes.add(Integer.parseInt(file.getFileName().split("pt")[0]));
            }
        }
        for (String moduleName : Sys.getRegistry().getDefs("microFont")) {
            if (moduleName.equals("fonts")) continue;
            try {
                BOrd ord = BOrd.make((String)("module://" + moduleName + "/microFont"));
                for (BIFile file : ((BIDirectory)ord.get()).listFiles()) {
                    if (!file.getExtension().equals("font")) continue;
                    String key = file.getFileName();
                    if (moduleFontFiles.get(key) != null) {
                        MicroEnv.logger.log(Level.INFO, "Ignoring duplicate " + key + " found in module://" + moduleName + "/microFont");
                        continue;
                    }
                    moduleFontFiles.put(key, file);
                    MicroFontReader.addFontName(key);
                    if (!file.getFileName().endsWith("Arial.font") || file.getFileName().contains("bold") || file.getFileName().contains("italic")) continue;
                    tempPlainArialSizes.add(Integer.parseInt(file.getFileName().split("pt")[0]));
                }
            }
            catch (UnresolvedException e) {
                MicroEnv.logger.log(Level.INFO, "microFont folder missing from module://" + moduleName, e);
            }
        }
        try {
            BOrd defaultFontsOrd = BOrd.make((String)"module://fonts/microFont");
            for (BIFile file : ((BIDirectory)defaultFontsOrd.get()).listFiles()) {
                defaultFontFiles.put(file.getFileName(), file);
                MicroFontReader.addFontName(file.getFileName());
                if (!file.getFileName().endsWith("Arial.font") || file.getFileName().contains("bold") || file.getFileName().contains("italic")) continue;
                tempPlainArialSizes.add(Integer.parseInt(file.getFileName().split("pt")[0]));
            }
        }
        catch (UnresolvedException e) {
            MicroEnv.logger.log(Level.SEVERE, "Default fonts module not found (module://fonts)", e);
        }
        plainArialSizes = tempPlainArialSizes.toArray(new Integer[0]);
        Arrays.sort((Object[])plainArialSizes);
    }

    private static String createFileName(BFont font) {
        String fileName = (int)font.getSize() + "pt " + font.getName();
        if (font.isItalic()) {
            fileName = "italic " + fileName;
        }
        if (font.isBold()) {
            fileName = "bold " + fileName;
        }
        return fileName + ".font";
    }

    public static BFont getSubstitute(BFont font) {
        BFont substitute;
        if ((font.getName().equals("monospaced") || font.getName().equals("Courier")) && MicroFontReader.findFontFile(MicroFontReader.createFileName(substitute = BFont.make((String)"Courier New", (double)font.getSize(), (int)font.getStyle()))) != null) {
            return substitute;
        }
        if ((font.isBold() || font.isItalic()) && MicroFontReader.findFontFile(MicroFontReader.createFileName(substitute = BFont.make((String)font.getName(), (double)font.getSize(), (int)0))) != null) {
            return substitute;
        }
        for (int i = 0; i < plainArialSizes.length; ++i) {
            if (plainArialSizes[i] < (int)font.getSize()) continue;
            return BFont.make((String)"Arial", (double)plainArialSizes[i].intValue(), (int)0);
        }
        return BFont.make((String)"Arial", (double)plainArialSizes[plainArialSizes.length - 1].intValue(), (int)0);
    }

    public static List<String> getFontList() {
        return fontNames;
    }

    private static void addFontName(String fileName) {
        if (fileName != null) {
            String fontName = "";
            String[] parts = fileName.split("\\.")[0].split("\\s");
            boolean atStart = false;
            for (int i = 0; i < parts.length; ++i) {
                String part = parts[i];
                if (!atStart && part.equalsIgnoreCase("bold") || part.equalsIgnoreCase("italic") || part.matches("\\d+(?i)pt")) continue;
                atStart = true;
                fontName = fontName + part + " ";
            }
            if (!fontNames.contains(fontName)) {
                fontNames.add(fontName);
            }
        }
    }

    static {
        fontNames = new ArrayList<String>();
        MicroFontReader.getAvailableFontFiles();
    }

    private static class InStream
    extends DataInputStream {
        public InStream(InputStream stream) {
            super(stream);
        }

        public int u1() throws IOException {
            return 0xFF & this.read();
        }

        public int u2() throws IOException {
            return (0xFF & this.read()) << 8 | 0xFF & this.read();
        }

        public char character() throws IOException {
            return this.readChar();
        }

        public String utf() throws IOException {
            return this.readUTF();
        }
    }
}

