/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.micro;

import com.tridium.gx.FontPeer;
import com.tridium.gx.micro.MicroEnv;
import com.tridium.gx.micro.MicroFont;
import java.util.Arrays;
import java.util.logging.Level;

public class MicroFontPeer
implements FontPeer {
    public MicroFont font;
    double targetSize;
    double factor;
    private static boolean warned = false;
    private static boolean pdfWarned = false;

    public MicroFontPeer(MicroFont font, double targetSize) {
        this.font = font;
        this.targetSize = targetSize;
        this.factor = (double)font.size == targetSize ? 0.0 : targetSize / 72.0;
    }

    public double getLeading() {
        return this.factor == 0.0 ? (double)this.font.leading : (double)this.font.pdfLeading * this.factor;
    }

    public double getAscent() {
        return this.factor == 0.0 ? (double)this.font.ascent : (double)this.font.pdfAscent * this.factor;
    }

    public double getDescent() {
        return this.factor == 0.0 ? (double)this.font.descent : (double)this.font.pdfDescent * this.factor;
    }

    public double getHeight() {
        return this.factor == 0.0 ? (double)this.font.height : (double)this.font.pdfHeight * this.factor;
    }

    public double getMaxAscent() {
        return this.getAscent();
    }

    public double getMaxDescent() {
        return this.getDescent();
    }

    public double width(int c) {
        if (this.factor == 0.0) {
            if (c >= this.font.characterWidths.length) {
                if (!warned) {
                    MicroEnv.logger.log(Level.WARNING, "At least one requested MicroFont character width was not found. Set this log's level to FINER for more details.");
                    warned = true;
                }
                if (MicroEnv.logger.isLoggable(Level.FINER)) {
                    MicroEnv.logger.log(Level.FINER, this.font.fileName + " missing width for character with code point " + c + ". Using average character width of " + this.font.averageDisplayableCharacterWidth + " instead. You may need to use the Embedded Device Font Tool to regenerate " + this.font.fileName + " to add missing characters.");
                }
                return this.font.averageDisplayableCharacterWidth;
            }
            return this.font.characterWidths[c];
        }
        if (c >= this.font.pdfCharacterWidths.length) {
            if (!pdfWarned) {
                MicroEnv.logger.log(Level.WARNING, "At least one requested MicroFont PDF character width was not found. Set this log's level to FINER for more details.");
                pdfWarned = true;
            }
            if (MicroEnv.logger.isLoggable(Level.FINER)) {
                MicroEnv.logger.log(Level.FINER, this.font.fileName + " missing width for PDF character with code point " + c + " . Using average PDF character width of " + (double)this.font.averageDisplayablePDFCharacterWidth * this.factor + " instead. You may need to use the Embedded Device Font Tool to regenerate " + this.font.fileName + " to add missing PDF characters.");
            }
            return (double)this.font.averageDisplayablePDFCharacterWidth * this.factor;
        }
        return (double)this.font.pdfCharacterWidths[c] * this.factor;
    }

    public double width(String s) {
        return this.width(s.toCharArray(), 0, s.length());
    }

    public double width(char[] data, int off, int len) {
        double w = 0.0;
        for (int i = 0; i < len; ++i) {
            w += this.width(data[i + off]);
        }
        return w;
    }

    public String getName() {
        return this.font.name;
    }

    public String getPostScriptName() {
        return this.font.psName;
    }

    public double getSize() {
        return this.factor == 0.0 ? (double)this.font.size : this.targetSize;
    }

    public int getPdfLeading() {
        return this.font.pdfLeading;
    }

    public int getPdfHeight() {
        return this.font.pdfHeight;
    }

    public int getPdfAscent() {
        return this.font.pdfAscent;
    }

    public int getPdfDescent() {
        return this.font.pdfDescent;
    }

    public byte[] getPdfWidths() {
        return Arrays.copyOf(this.font.pdfCharacterWidths, this.font.pdfCharacterWidths.length);
    }
}

