/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.se.AwtImagePaint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.baja.gx.BBrush;

abstract class UntexturedImagePaint
extends AwtImagePaint {
    protected Rectangle2D userBounds;
    protected AffineTransform trans;
    protected Raster bufRaster;
    protected Rectangle bufRect;
    protected int dataW = 0;
    protected int dataH = 0;
    protected WritableRaster dataRaster;
    protected WritableRaster blankRaster;

    UntexturedImagePaint(BBrush.Image brush) {
        super(brush);
    }

    @Override
    void finishLoading() {
        this.bufRaster = this.buffer.getRaster();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform trans, RenderingHints hints) {
        this.trans = trans;
        this.userBounds = userBounds;
        if (!this.isLoaded()) {
            this.unloadedContext = AwtEnv.TRANSPARENT.createContext(cm, deviceBounds, userBounds, trans, hints);
        }
        return this;
    }

    protected double halign(double userWidth) {
        switch (this.brush.getHalign()) {
            case 3: {
                return 0.0;
            }
            case 0: {
                return (userWidth - (double)this.bufW) / 2.0;
            }
            case 4: {
                return userWidth - (double)this.bufW;
            }
        }
        throw new IllegalStateException();
    }

    protected double valign(double userHeight) {
        switch (this.brush.getValign()) {
            case 1: {
                return 0.0;
            }
            case 0: {
                return (userHeight - (double)this.bufH) / 2.0;
            }
            case 2: {
                return userHeight - (double)this.bufH;
            }
        }
        throw new IllegalStateException();
    }

    protected void initData(int w, int h) {
        if (w > this.dataW || h > this.dataH) {
            this.dataW = w;
            this.dataH = h;
            this.blankRaster = this.getColorModel().createCompatibleWritableRaster(this.dataW, this.dataH);
            this.dataRaster = this.getColorModel().createCompatibleWritableRaster(this.dataW, this.dataH);
        }
    }

    protected static void loadPixels(int x, int y, int w, int h, Rectangle rect, Raster in, WritableRaster out) {
        int[] pixel = new int[4];
        int a0 = x < 0 ? -x : 0;
        int a1 = w + x > rect.width ? rect.width - x : w;
        for (int a = a0; a < a1; ++a) {
            int c = a + x;
            int b0 = y < 0 ? -y : 0;
            int b1 = h + y > rect.height ? rect.height - y : h;
            for (int b = b0; b < b1; ++b) {
                int d = b + y;
                out.setPixel(a, b, in.getPixel(c, d, pixel));
            }
        }
    }
}

