/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.ImageData;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.logging.Logger;
import javax.baja.gx.Graphics;

public final class AwtImagePeer
implements ImagePeer {
    public final ImageData data;
    private static final Logger LOG = Logger.getLogger("gx");

    public AwtImagePeer(ImageData data) {
        this.data = data;
    }

    AwtImagePeer(Image image) {
        this(new ImageData(image));
    }

    public Image image() {
        return this.data.getAnimatedImage();
    }

    public Graphics getGraphics() {
        return this.data.getGraphics();
    }

    public double getWidth() {
        return this.data.getWidth();
    }

    public double getHeight() {
        return this.data.getHeight();
    }

    public int[] getPixels() {
        int w = (int)this.data.getWidth();
        int h = (int)this.data.getHeight();
        int[] pixels = new int[w * h];
        try {
            PixelGrabber pg = new PixelGrabber(this.data.image, 0, 0, w, h, pixels, 0, w);
            pg.grabPixels();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pixels;
    }

    public void setPixels(int[] pixels) {
        if (this.data.image instanceof BufferedImage) {
            int h;
            int w = (int)this.data.getWidth();
            if (pixels.length != w * (h = (int)this.data.getHeight())) {
                throw new IllegalStateException("AwtImagePeer.setPixels: pixels.length != width x height");
            }
            BufferedImage bi = (BufferedImage)this.data.image;
            bi.setRGB(0, 0, w, h, pixels, 0, w);
        } else {
            LOG.severe("AwtImagePeer.setPixels: Can not set pixels for non-memory images.");
        }
    }

    public void dispose() {
        this.data.dispose();
    }

    public boolean isDimensionsLoaded() {
        return this.isLoaded();
    }

    public void syncDimensions() {
        this.sync();
    }

    public boolean isLoaded() {
        return this.data.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() {
        if (this.data.loaded) {
            return;
        }
        ImageData imageData = this.data;
        synchronized (imageData) {
            while (!this.data.loaded) {
                try {
                    this.data.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean animate() {
        return this.data.animate();
    }
}

