/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.FontPeer;
import com.tridium.gx.GxEnv;
import com.tridium.gx.ImagePeer;
import com.tridium.gx.awt.AwtFontPeer;
import com.tridium.gx.awt.AwtImagePeer;
import com.tridium.gx.awt.DisabledImageFactory;
import com.tridium.gx.awt.HighlightedImageFactory;
import com.tridium.gx.awt.ImageData;
import com.tridium.gx.awt.ImageManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.security.AccessController;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;

public abstract class AwtEnv
extends GxEnv {
    public static Color TRANSPARENT = new Color(255, 255, 255, 0);
    private static final RenderingHints HIGH_QUALITY = new RenderingHints(null);
    private static final boolean DISABLE_HIGH_QUALITY_GRAPHICS;

    public static GxEnv get() {
        return (AwtEnv)GxEnv.get();
    }

    public abstract Graphics makeGraphics(Graphics2D var1);

    public abstract Image makeBufferedImage(double var1, double var3);

    public FontPeer makeFontPeer(BFont font) {
        return AwtEnv.peer(font);
    }

    public FontPeer makeFontPeer(BFont font, boolean useAntialiasing, boolean useFractionalFontMetrics) {
        return AwtEnv.peer(font, useAntialiasing, useFractionalFontMetrics);
    }

    public ImagePeer makeImagePeer(BImage image) {
        return AwtEnv.peer(image);
    }

    public BImage makeImage(byte[] buf) {
        return this.makeImage(Toolkit.getDefaultToolkit().createImage(buf), true);
    }

    public BImage makeImage(Image awt, boolean sync) {
        if (sync) {
            ImageManager.sync(awt);
        }
        BImage image = BImage.make((String)"new");
        image.fw(202, (Object)new AwtImagePeer(awt), null, null, null);
        return image;
    }

    public BImage makeImage(double width, double height) {
        Image awt = ((AwtEnv)AwtEnv.get()).makeBufferedImage(width, height);
        BImage image = BImage.make((String)"new");
        image.fw(202, (Object)new AwtImagePeer(awt), null, null, null);
        return image;
    }

    public BImage makeDisabled(BImage orig) {
        Image awt = AwtEnv.peer(orig).image();
        if (awt == null) {
            return orig;
        }
        BImage disabled = BImage.make((String)"new");
        disabled.fw(202, (Object)new AwtImagePeer(DisabledImageFactory.convert(awt)), null, null, null);
        return disabled;
    }

    public BImage makeHighlighted(BImage orig) {
        Image awt = AwtEnv.peer(orig).image();
        if (awt == null) {
            return orig;
        }
        BImage high = BImage.make((String)"new");
        high.fw(202, (Object)new AwtImagePeer(HighlightedImageFactory.convert(awt)), null, null, null);
        return high;
    }

    public static Color peer(BColor color) {
        Color peer = (Color)color.fw(201, null, null, null, null);
        if (peer == null) {
            peer = AwtEnv.makePeer(color);
            color.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    public static AwtFontPeer peer(BFont font) {
        return AwtEnv.peer(font, font.isAntiAliased(), false);
    }

    public static AwtFontPeer peer(BFont font, boolean useAntialiasing, boolean useFractionalFontMetrics) {
        AwtFontPeer peer = (AwtFontPeer)font.fw(201, null, null, null, null);
        if (peer == null) {
            String fontName = AwtEnv.get().getValidFontName(font.getName());
            if (fontName == null) {
                fontName = font.getName();
            }
            peer = new AwtFontPeer(font, fontName, useAntialiasing, useFractionalFontMetrics);
            font.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    public static AwtImagePeer peer(BImage image) {
        AwtImagePeer peer = (AwtImagePeer)image.fw(201, null, null, null, null);
        if (peer == null) {
            ImageData data = ImageManager.fetchImageData(image);
            peer = new AwtImagePeer(data);
            image.fw(202, (Object)peer, null, null, null);
        }
        return peer;
    }

    private static Color makePeer(BColor color) {
        if (color.isNull()) {
            return TRANSPARENT;
        }
        return new Color(color.getRGB(), true);
    }

    public static void makeHighQuality(Graphics2D g) {
        if (!DISABLE_HIGH_QUALITY_GRAPHICS) {
            g.addRenderingHints(HIGH_QUALITY);
        }
    }

    static {
        HIGH_QUALITY.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        HIGH_QUALITY.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        DISABLE_HIGH_QUALITY_GRAPHICS = AccessController.doPrivileged(() -> Boolean.getBoolean("bajaui.disableHighQualityGraphics"));
    }
}

