/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.virtual;

import com.tridium.alarm.BIAlarmRecordDecorator;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.file.BFileOverwritePolicy;
import com.tridium.nv.BNiagaraVirtualPolicies;
import javax.baja.agent.BPxView;
import javax.baja.alarm.BAlarmRecord;
import javax.baja.control.trigger.BManualTriggerMode;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.data.BIDataValue;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="importVirtualPxFilesOnDemand", type="boolean", defaultValue="false"), @NiagaraProperty(name="pxFileImportOverwritePolicy", type="BFileOverwritePolicy", defaultValue="BFileOverwritePolicy.checksum"), @NiagaraProperty(name="pxFileImportExecutionTime", type="BTriggerMode", defaultValue="BManualTriggerMode.make()"), @NiagaraProperty(name="virtualPxFileDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^nstations\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:IDirectory\")")}), @NiagaraProperty(name="virtualPxFileMediaDirectory", type="BOrd", defaultValue="BOrd.make(\"file:^nstations\")", facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"baja:IDirectory\")")}), @NiagaraProperty(name="convertAlarmHyperlinksToVirtualForm", type="boolean", defaultValue="false")})
public final class BNiagaraVirtualNetworkExt
extends BNiagaraVirtualPolicies
implements BIAlarmRecordDecorator {
    @Generated
    public static final Property importVirtualPxFilesOnDemand = BNiagaraVirtualNetworkExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property pxFileImportOverwritePolicy = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BFileOverwritePolicy.checksum, null);
    @Generated
    public static final Property pxFileImportExecutionTime = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BManualTriggerMode.make(), null);
    @Generated
    public static final Property virtualPxFileDirectory = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    @Generated
    public static final Property virtualPxFileMediaDirectory = BNiagaraVirtualNetworkExt.newProperty((int)0, (BValue)BOrd.make((String)"file:^nstations"), (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"baja:IDirectory")));
    @Generated
    public static final Property convertAlarmHyperlinksToVirtualForm = BNiagaraVirtualNetworkExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraVirtualNetworkExt.class);
    public static final Context ROUTE_ALARM_TO_ANOTHER_STATION_CX = new BasicContext(){

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            return "Context.routeAlarmToAnotherStation";
        }
    };
    public static final String UNCONVERTED_HYPERLINK_ORD = "unconvertedHyperlinkOrd";
    private static TypeInfo abstractSubPxViewType = TYPE.getTypeInfo();
    private static TypeInfo reloadVirtualPxType = null;

    @Generated
    public boolean getImportVirtualPxFilesOnDemand() {
        return this.getBoolean(importVirtualPxFilesOnDemand);
    }

    @Generated
    public void setImportVirtualPxFilesOnDemand(boolean v) {
        this.setBoolean(importVirtualPxFilesOnDemand, v, null);
    }

    @Generated
    public BFileOverwritePolicy getPxFileImportOverwritePolicy() {
        return (BFileOverwritePolicy)this.get(pxFileImportOverwritePolicy);
    }

    @Generated
    public void setPxFileImportOverwritePolicy(BFileOverwritePolicy v) {
        this.set(pxFileImportOverwritePolicy, (BValue)v, null);
    }

    @Generated
    public BTriggerMode getPxFileImportExecutionTime() {
        return (BTriggerMode)this.get(pxFileImportExecutionTime);
    }

    @Generated
    public void setPxFileImportExecutionTime(BTriggerMode v) {
        this.set(pxFileImportExecutionTime, (BValue)v, null);
    }

    @Generated
    public BOrd getVirtualPxFileDirectory() {
        return (BOrd)this.get(virtualPxFileDirectory);
    }

    @Generated
    public void setVirtualPxFileDirectory(BOrd v) {
        this.set(virtualPxFileDirectory, (BValue)v, null);
    }

    @Generated
    public BOrd getVirtualPxFileMediaDirectory() {
        return (BOrd)this.get(virtualPxFileMediaDirectory);
    }

    @Generated
    public void setVirtualPxFileMediaDirectory(BOrd v) {
        this.set(virtualPxFileMediaDirectory, (BValue)v, null);
    }

    @Generated
    public boolean getConvertAlarmHyperlinksToVirtualForm() {
        return this.getBoolean(convertAlarmHyperlinksToVirtualForm);
    }

    @Generated
    public void setConvertAlarmHyperlinksToVirtualForm(boolean v) {
        this.setBoolean(convertAlarmHyperlinksToVirtualForm, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNiagaraNetwork;
    }

    public void started() {
        BIAlarmRecordDecorator.registerAlarmRecordDecorator((BIAlarmRecordDecorator)this);
    }

    public void stopped() {
        BIAlarmRecordDecorator.unregisterAlarmRecordDecorator((BIAlarmRecordDecorator)this);
    }

    protected final boolean checkLicense() {
        try {
            Feature f = Sys.getLicenseManager().checkFeature("tridium", "niagaraDriver");
            return f.getb("virtual", false);
        }
        catch (Exception e) {
            System.out.println("niagaraDriver for Niagara Virtuals not licensed...");
            e.printStackTrace();
            return false;
        }
    }

    public BStatus getStatus() {
        return this.getNiagaraNetwork().getStatus();
    }

    public void postAsync(Runnable runnable) {
        this.getNiagaraNetwork().getWorkers().process(runnable);
    }

    public String[] getStationNames() {
        Array nameArray = new Array(String.class);
        this.findStationNames((BComponent)this.getNiagaraNetwork(), (Array<String>)nameArray);
        return (String[])nameArray.trim();
    }

    private void findStationNames(BComponent comp, Array<String> nameArray) {
        if (comp == null) {
            return;
        }
        if (comp instanceof BNiagaraStation) {
            nameArray.add((Object)((BNiagaraStation)comp).getStationName());
            return;
        }
        BComponent[] kids = comp.getChildComponents();
        for (int i = 0; i < kids.length; ++i) {
            this.findStationNames(kids[i], nameArray);
        }
    }

    public boolean supportsRemoteType(Type type) {
        return !type.is(BRelation.TYPE);
    }

    public boolean supportsRemoteAgentType(TypeInfo agentTypeInfo, BComponent target) {
        if (TYPE.getTypeInfo() == abstractSubPxViewType) {
            try {
                abstractSubPxViewType = BTypeSpec.make((String)"niagaraDriver", (String)"AbstractSubstitutePxView").getTypeInfo();
                reloadVirtualPxType = BTypeSpec.make((String)"niagaraDriver", (String)"ReloadVirtualPxAction").getTypeInfo();
            }
            catch (Exception e) {
                abstractSubPxViewType = null;
            }
        }
        if (!this.getImportVirtualPxFilesOnDemand() && (agentTypeInfo.is(BPxView.TYPE) || abstractSubPxViewType != null && agentTypeInfo.is(abstractSubPxViewType))) {
            try {
                BValue val = target.get("reloadNiagaraVirtualPxViews");
                if (val != null && val.getType().is(reloadVirtualPxType)) {
                    target.remove("reloadNiagaraVirtualPxViews");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    private BNiagaraNetwork getNiagaraNetwork() {
        return (BNiagaraNetwork)this.getParent();
    }

    public void decorateOnReadEnd(BAlarmRecord alarmRecord, Context context) {
        if (BNiagaraVirtualNetworkExt.needsHyperlinkConversion(context) && this.getConvertAlarmHyperlinksToVirtualForm()) {
            BNiagaraVirtualNetworkExt.convertHyperlinkOrd(alarmRecord);
        }
    }

    public BAlarmRecord undecorateOnWriteStart(BAlarmRecord alarmRecord, Context context) {
        BFacets alarmData;
        BObject unconvertedHyperlinkOrd;
        if (BNiagaraVirtualNetworkExt.needsHyperlinkConversion(context) && (unconvertedHyperlinkOrd = (alarmData = alarmRecord.getAlarmData()).get(UNCONVERTED_HYPERLINK_ORD)) != null) {
            alarmData = BFacets.makeRemove((BFacets)alarmData, (String)UNCONVERTED_HYPERLINK_ORD);
            alarmData = BFacets.make((BFacets)alarmData, (String)"hyperlinkOrd", (BIDataValue)((BIDataValue)unconvertedHyperlinkOrd));
            alarmRecord.setAlarmData(alarmData);
        }
        return alarmRecord;
    }

    public void redecorateOnWriteEnd(BAlarmRecord alarmRecord, Context context) {
        this.decorateOnReadEnd(alarmRecord, context);
    }

    private static boolean needsHyperlinkConversion(Context context) {
        return context == BAlarmRecord.ALARM_STORE_CX || context == BAlarmRecord.DATA_RECOVERY_CX || context == ROUTE_ALARM_TO_ANOTHER_STATION_CX;
    }

    private static void convertHyperlinkOrd(BAlarmRecord alarmRecord) {
        String newHyperlinkOrd;
        BOrdList alarmSource = alarmRecord.getSource();
        if (alarmSource.size() <= 1) {
            return;
        }
        BFacets alarmData = alarmRecord.getAlarmData();
        BObject origHyperlinkOrdFacet = alarmData.get("hyperlinkOrd");
        if (origHyperlinkOrdFacet == null) {
            return;
        }
        String origHyperlinkOrd = origHyperlinkOrdFacet.toString();
        if (origHyperlinkOrd.isEmpty()) {
            return;
        }
        String sourceOrd = alarmSource.get(1).toString();
        if (!sourceOrd.endsWith("/alarms")) {
            return;
        }
        int idxOfFoxSession = origHyperlinkOrd.lastIndexOf("|fox");
        if (idxOfFoxSession < 0) {
            return;
        }
        int idxAfterFoxSession = origHyperlinkOrd.indexOf(124, idxOfFoxSession += 4);
        if (idxAfterFoxSession < 0 && (idxAfterFoxSession = origHyperlinkOrd.indexOf(58, idxOfFoxSession)) < 0) {
            return;
        }
        ++idxAfterFoxSession;
        String strEndingWithStationName = sourceOrd.substring(0, sourceOrd.length() - 7);
        int lastSlashIdx = strEndingWithStationName.lastIndexOf(47);
        if (lastSlashIdx < 0) {
            return;
        }
        int stationNameStartIdx = lastSlashIdx + 1;
        if (stationNameStartIdx >= strEndingWithStationName.length()) {
            return;
        }
        if (idxAfterFoxSession < origHyperlinkOrd.length()) {
            int idxOfSlotScheme = origHyperlinkOrd.indexOf("|slot:", idxAfterFoxSession - 1);
            if (idxOfSlotScheme < 0) {
                return;
            }
            String stationName = strEndingWithStationName.substring(stationNameStartIdx);
            newHyperlinkOrd = "nspace:" + stationName + origHyperlinkOrd.substring(idxOfSlotScheme);
        } else {
            String stationName = strEndingWithStationName.substring(stationNameStartIdx);
            newHyperlinkOrd = "nspace:" + stationName;
        }
        alarmData = BFacets.make((BFacets)alarmData, (String)"hyperlinkOrd", (BIDataValue)BString.make((String)newHyperlinkOrd));
        alarmData = BFacets.make((BFacets)alarmData, (String)UNCONVERTED_HYPERLINK_ORD, (BIDataValue)((BIDataValue)origHyperlinkOrdFacet));
        alarmRecord.setAlarmData(alarmData);
    }
}

