/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.baja.naming.SlotPath;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.tag.Id;
import javax.baja.tag.Tags;

public final class NiagaraDriverUtil {
    private static final Logger LOGGER = Logger.getLogger("niagaraDriver");
    private static final Pattern Q_NAME_STRING_SPLITTER = Pattern.compile("\\s*;\\s*");
    private static final double HASH_SET_LOAD_FACTOR = 0.75;
    private static final Pattern SEMI_COLON_SPLIT_AND_TRIM_PATTERN = Pattern.compile("\\s*;\\s*");

    private NiagaraDriverUtil() {
    }

    public static Set<Id> parseIds(String value) {
        if (value == null) {
            return Collections.emptySet();
        }
        if ((value = value.trim()).isEmpty()) {
            return Collections.emptySet();
        }
        String[] qNames = Q_NAME_STRING_SPLITTER.split(value);
        HashSet<Id> ids = new HashSet<Id>((int)Math.ceil((double)qNames.length / 0.75));
        for (String qName : qNames) {
            if (qName.isEmpty()) continue;
            try {
                ids.add(Id.newId((String)qName));
            }
            catch (IllegalArgumentException e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting qName \"" + qName + "\" to an Id");
            }
        }
        return ids;
    }

    public static boolean hasAnyMatchingTagId(Tags tags, Set<Id> ids) {
        if (tags == null || ids == null) {
            return false;
        }
        for (Id id : ids) {
            if (!tags.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static String[] parseRouteToStation(String routeToStation, boolean validateRoute) {
        String delimitedStationRouteStr = routeToStation.trim();
        String[] parsedRoute = null;
        if (!delimitedStationRouteStr.isEmpty()) {
            parsedRoute = SEMI_COLON_SPLIT_AND_TRIM_PATTERN.split(delimitedStationRouteStr);
            if (validateRoute) {
                ArrayList<String> invalidStationNames = null;
                if (parsedRoute.length == 0) {
                    invalidStationNames = new ArrayList<String>();
                    invalidStationNames.add(delimitedStationRouteStr);
                } else {
                    for (String stationName : parsedRoute) {
                        if (SlotPath.isValidName((String)stationName)) continue;
                        if (invalidStationNames == null) {
                            invalidStationNames = new ArrayList();
                        }
                        invalidStationNames.add(stationName);
                    }
                }
                if (invalidStationNames != null) {
                    throw new LocalizableRuntimeException("niagaraDriver", "routeToStation.invalid", new Object[]{String.join((CharSequence)" \n", invalidStationNames)});
                }
            } else if (parsedRoute.length == 0) {
                parsedRoute = null;
            }
        }
        return parsedRoute;
    }
}

