/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BSimpleMap
extends BSimple {
    public static final BSimpleMap NULL;
    public static final BSimpleMap DEFAULT;
    public static final Type TYPE;
    private LinkedHashMap<BSimple, BSimple> map;
    private int hashCode = -1;
    private static final char delim = ';';

    public static BSimpleMap make(Map<? extends BSimple, ? extends BSimple> map) {
        if (map.size() == 0) {
            return NULL;
        }
        Type keyType = null;
        Type valType = null;
        LinkedHashMap<BSimple, BSimple> newMap = new LinkedHashMap<BSimple, BSimple>();
        for (BSimple bSimple : map.keySet()) {
            BSimple val = map.get(bSimple);
            if (keyType == null) {
                keyType = bSimple.getType();
                valType = val.getType();
            } else {
                if (!bSimple.getType().equals(keyType)) {
                    throw new BajaRuntimeException("SimpleMap keys must all be of the same Type!");
                }
                if (!val.getType().equals(valType)) {
                    throw new BajaRuntimeException("SimpleMap values must all be of the same Type!");
                }
            }
            newMap.put(bSimple, val);
        }
        return (BSimpleMap)new BSimpleMap(newMap).intern();
    }

    public static BSimpleMap make(BSimpleMap orig, BSimple key, BSimple val) {
        if (orig.map.size() > 0) {
            BSimple k = orig.map.keySet().iterator().next();
            BSimple v = orig.map.get(k);
            if (!k.getType().equals(key.getType())) {
                throw new BajaRuntimeException("SimpleMap keys must all be of the same Type!");
            }
            if (!v.getType().equals(val.getType())) {
                throw new BajaRuntimeException("SimpleMap values must all be of the same Type!");
            }
        }
        LinkedHashMap map = (LinkedHashMap)orig.map.clone();
        map.put(key, val);
        return (BSimpleMap)new BSimpleMap(map).intern();
    }

    public static BSimpleMap make(BSimpleMap orig, BSimpleMap other) {
        LinkedHashMap map = (LinkedHashMap)orig.map.clone();
        Type keyType = null;
        Type valType = null;
        if (map.size() > 0) {
            BSimple key = (BSimple)map.keySet().iterator().next();
            keyType = key.getType();
            valType = ((BSimple)map.get(key)).getType();
        }
        BSimple[] otherKeys = other.list();
        for (int i = 0; i < otherKeys.length; ++i) {
            BSimple otherVal = other.get(otherKeys[i]);
            if (i == 0 && keyType != null) {
                if (!otherKeys[i].getType().equals(keyType)) {
                    throw new BajaRuntimeException("SimpleMap keys must all be of the same Type!");
                }
                if (!otherVal.getType().equals(valType)) {
                    throw new BajaRuntimeException("SimpleMap values must all be of the same Type!");
                }
            }
            map.put(otherKeys[i], otherVal);
        }
        return (BSimpleMap)new BSimpleMap(map).intern();
    }

    public static BSimpleMap remove(BSimpleMap orig, BSimple key) {
        LinkedHashMap map = (LinkedHashMap)orig.map.clone();
        map.remove(key);
        return (BSimpleMap)new BSimpleMap(map).intern();
    }

    private BSimpleMap(LinkedHashMap<BSimple, BSimple> map) {
        this.map = map;
    }

    public BSimple[] list() {
        return this.map.keySet().toArray(new BSimple[0]);
    }

    public BSimple get(BSimple key) {
        return this.map.get(key);
    }

    public boolean isNull() {
        return this.map.size() == 0;
    }

    public int size() {
        return this.map.size();
    }

    public Map<BSimple, BSimple> getMap() {
        Map clone = (Map)this.map.clone();
        return clone;
    }

    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode((Object)this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BSimpleMap)) {
            return false;
        }
        BSimpleMap s = (BSimpleMap)((Object)obj);
        if (this.map.size() != s.map.size()) {
            return false;
        }
        Iterator<BSimple> it = this.map.keySet().iterator();
        Iterator<BSimple> it2 = s.map.keySet().iterator();
        while (it.hasNext() && it2.hasNext()) {
            BSimple key1 = it.next();
            BSimple val1 = this.map.get(key1);
            BSimple key2 = it2.next();
            BSimple val2 = s.map.get(key2);
            if (!key1.equals((Object)key2)) {
                return false;
            }
            if (val1.equals((Object)val2)) continue;
            return false;
        }
        return true;
    }

    public String toString(Context cx) {
        StringBuilder buff = new StringBuilder();
        Iterator<BSimple> it = this.map.keySet().iterator();
        BSimple key = null;
        BSimple val = null;
        while (it.hasNext()) {
            if (key != null) {
                buff.append(", ");
            }
            key = it.next();
            val = this.map.get(key);
            buff.append(key.toString(cx));
            buff.append(" -> ");
            buff.append(val.toString(cx));
        }
        return buff.toString();
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        StringBuilder buff = new StringBuilder();
        for (BSimple key : this.map.keySet()) {
            BSimple val = this.map.get(key);
            if (buff.length() == 0) {
                buff.append(key.getType().toString());
                buff.append(';');
                buff.append(val.getType().toString());
            }
            buff.append(';');
            buff.append(SlotPath.escape((String)key.encodeToString()));
            buff.append(';');
            buff.append(SlotPath.escape((String)val.encodeToString()));
        }
        return buff.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        if (s.length() == 0) {
            return DEFAULT;
        }
        String[] strs = TextUtil.splitAndTrim((String)s, (char)';');
        if (strs.length % 2 != 0) {
            throw new IOException("Invalid Simple array Length (must be even): " + strs.length);
        }
        LinkedHashMap<BSimple, BSimple> newMap = new LinkedHashMap<BSimple, BSimple>();
        BSimple sim1Default = null;
        BSimple sim2Default = null;
        BSimple key = null;
        BSimple lastKey = null;
        BSimple val = null;
        BSimple lastVal = null;
        for (int i = 0; i < strs.length; ++i) {
            if (i == 0) {
                sim1Default = (BSimple)Sys.getType((String)strs[i]).getInstance();
                continue;
            }
            if (i == 1) {
                sim2Default = (BSimple)Sys.getType((String)strs[i]).getInstance();
                continue;
            }
            if (i == 0 || i % 2 == 0) {
                key = (BSimple)sim1Default.decodeFromString(SlotPath.unescape((String)strs[i]));
                if (lastKey != null && !key.getType().equals(lastKey.getType())) {
                    throw new BajaRuntimeException("SimpleMap keys must all be of the same Type!");
                }
                lastKey = key;
                continue;
            }
            val = (BSimple)sim2Default.decodeFromString(SlotPath.unescape((String)strs[i]));
            if (lastVal != null && !val.getType().equals(lastVal.getType())) {
                throw new BajaRuntimeException("SimpleMap values must all be of the same Type!");
            }
            lastVal = val;
            newMap.put(key, val);
        }
        return new BSimpleMap(newMap);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BSimpleMap(new LinkedHashMap<BSimple, BSimple>());
        TYPE = Sys.loadType(BSimpleMap.class);
    }
}

