/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.user;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BSysChannel;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.user.BUserSyncChannel;
import com.tridium.nd.user.BUserSyncExt;
import com.tridium.nd.user.BUserSyncStrategy;
import com.tridium.nd.user.UserStatus;
import com.tridium.nd.user.UserSyncException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDeviceExt;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserEvent;
import javax.baja.user.BUserPrototypes;
import javax.baja.user.BUserService;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="syncInEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="syncOutEnabled", type="boolean", defaultValue="false"), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="syncStrategy", type="BUserSyncStrategy", defaultValue="BUserSyncStrategy.prototypeRequired"), @NiagaraProperty(name="syncRequired", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="syncDelay", type="BRelTime", defaultValue="BRelTime.makeSeconds(30)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(1))")}), @NiagaraProperty(name="syncRetry", type="BRelTime", defaultValue="BRelTime.makeMinutes(5)", facets={@Facet(value="BFacets.make(BFacets.MIN, BRelTime.makeSeconds(15))")}), @NiagaraProperty(name="lastSyncAttempt", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, true)")}), @NiagaraProperty(name="lastSyncSuccess", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=1, facets={@Facet(value="BFacets.make(BFacets.SHOW_SECONDS, true)")})})
@NiagaraActions(value={@NiagaraAction(name="handleUserEvent", parameterType="BUserEvent", defaultValue="new BUserEvent()", flags=4), @NiagaraAction(name="sync", flags=16)})
public class BNiagaraUserDeviceExt
extends BDeviceExt
implements BIStatus,
BINiagaraDeviceExt,
BFoxClientConnection.Interest {
    @Generated
    public static final Property syncInEnabled = BNiagaraUserDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property syncOutEnabled = BNiagaraUserDeviceExt.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property status = BNiagaraUserDeviceExt.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BNiagaraUserDeviceExt.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property syncStrategy = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BUserSyncStrategy.prototypeRequired, null);
    @Generated
    public static final Property syncRequired = BNiagaraUserDeviceExt.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property syncDelay = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BRelTime.makeSeconds((int)30), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)1)));
    @Generated
    public static final Property syncRetry = BNiagaraUserDeviceExt.newProperty((int)0, (BValue)BRelTime.makeMinutes((int)5), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)15)));
    @Generated
    public static final Property lastSyncAttempt = BNiagaraUserDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Property lastSyncSuccess = BNiagaraUserDeviceExt.newProperty((int)1, (BValue)BAbsTime.NULL, (BFacets)BFacets.make((String)"showSeconds", (boolean)true));
    @Generated
    public static final Action handleUserEvent = BNiagaraUserDeviceExt.newAction((int)4, (BValue)new BUserEvent(), null);
    @Generated
    public static final Action sync = BNiagaraUserDeviceExt.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraUserDeviceExt.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/users.png");
    private Clock.Ticket ticket;
    public static Logger log = Logger.getLogger("niagara.users");
    public static final int LOCAL_OVERRIDE = 0x10000000;

    @Generated
    public boolean getSyncInEnabled() {
        return this.getBoolean(syncInEnabled);
    }

    @Generated
    public void setSyncInEnabled(boolean v) {
        this.setBoolean(syncInEnabled, v, null);
    }

    @Generated
    public boolean getSyncOutEnabled() {
        return this.getBoolean(syncOutEnabled);
    }

    @Generated
    public void setSyncOutEnabled(boolean v) {
        this.setBoolean(syncOutEnabled, v, null);
    }

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public BUserSyncStrategy getSyncStrategy() {
        return (BUserSyncStrategy)this.get(syncStrategy);
    }

    @Generated
    public void setSyncStrategy(BUserSyncStrategy v) {
        this.set(syncStrategy, (BValue)v, null);
    }

    @Generated
    public boolean getSyncRequired() {
        return this.getBoolean(syncRequired);
    }

    @Generated
    public void setSyncRequired(boolean v) {
        this.setBoolean(syncRequired, v, null);
    }

    @Generated
    public BRelTime getSyncDelay() {
        return (BRelTime)this.get(syncDelay);
    }

    @Generated
    public void setSyncDelay(BRelTime v) {
        this.set(syncDelay, (BValue)v, null);
    }

    @Generated
    public BRelTime getSyncRetry() {
        return (BRelTime)this.get(syncRetry);
    }

    @Generated
    public void setSyncRetry(BRelTime v) {
        this.set(syncRetry, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSyncAttempt() {
        return (BAbsTime)this.get(lastSyncAttempt);
    }

    @Generated
    public void setLastSyncAttempt(BAbsTime v) {
        this.set(lastSyncAttempt, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastSyncSuccess() {
        return (BAbsTime)this.get(lastSyncSuccess);
    }

    @Generated
    public void setLastSyncSuccess(BAbsTime v) {
        this.set(lastSyncSuccess, (BValue)v, null);
    }

    @Generated
    public void handleUserEvent(BUserEvent parameter) {
        this.invoke(handleUserEvent, (BValue)parameter, null);
    }

    @Generated
    public void sync() {
        this.invoke(sync, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BNiagaraUserDeviceExt getForStation(BNiagaraStation station) {
        SlotCursor c = station.getProperties();
        if (c.next(BNiagaraUserDeviceExt.class)) {
            return (BNiagaraUserDeviceExt)c.get();
        }
        return null;
    }

    public static void setReadonly(BComplex root) {
        Property p;
        int flags;
        BComplex parent = root.getParent();
        if (parent != null && ((flags = parent.getFlags((Slot)(p = root.getPropertyInParent()))) & 1) != 0) {
            parent.setFlags((Slot)p, flags | 1);
        }
        BNiagaraUserDeviceExt.setChildrenReadonly(root);
    }

    private static void setChildrenReadonly(BComplex root) {
        SlotCursor c = root.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!Flags.isReadonly((BComplex)root, (Slot)p)) {
                root.setFlags((Slot)p, root.getFlags((Slot)p) | 1);
            }
            if (!p.getType().is(BComponent.TYPE)) continue;
            BNiagaraUserDeviceExt.setChildrenReadonly((BComplex)c.get());
        }
    }

    @Override
    public void clientOpened() {
    }

    @Override
    public void clientClosed() {
    }

    @Override
    public void serverOpened() {
    }

    @Override
    public void serverClosed() {
    }

    public void updateStatus() {
        this.checkConfig();
        if (!(this.getNiagaraStation().getStatus().isDown() || this.getNiagaraStation().getStatus().isDisabled() || this.getStatus().isDisabled())) {
            this.setSyncRequired(true);
        }
        if (this.isRunning() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public final BFoxClientConnection getClientConnection() {
        return this.getNiagaraStation().getClientConnection();
    }

    public final BUserSyncChannel getClientUserChannel() {
        return (BUserSyncChannel)this.getNiagaraStation().getClientConnection().getChannels().get("usersync", BUserSyncChannel.TYPE);
    }

    public final BSysChannel getSysChannel() {
        return (BSysChannel)this.getNiagaraStation().getClientConnection().getChannels().get("sys", BSysChannel.TYPE);
    }

    public void checkConfig() {
        BNiagaraStation station;
        BUserService userService = null;
        try {
            userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            // empty catch block
        }
        if (userService == null) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("UserService not found.");
            return;
        }
        if (!userService.isDistributable()) {
            this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause(userService.getType().getTypeName() + " does not support distribution of user accounts.");
            return;
        }
        boolean fault = false;
        this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (!this.getSyncInEnabled() && !this.getSyncOutEnabled() ? 1 : 0) != 0));
        if (this.getSyncInEnabled() && this.getSyncOutEnabled()) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            this.setFaultCause("syncIn and syncOut cannot be enabled for the same station.");
            fault = true;
        }
        if (!fault) {
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)false));
            this.setFaultCause("");
        }
        if ((station = this.getNiagaraStation()) != null) {
            this.setStatus(BStatus.makeDown((BStatus)this.getStatus(), (boolean)station.isDown()));
        }
    }

    public BUser getPrototype(String prototypeName) {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        if (prototypeName.length() == 0 && this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            return userService.getUserPrototypes().getDefaultPrototype();
        }
        BUser proto = (BUser)userService.getUserPrototypes().get(prototypeName);
        if (proto == null && this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            proto = userService.getUserPrototypes().getDefaultPrototype();
        }
        return proto;
    }

    public UserStatus[] getUserStatus(String[] protoNames) {
        boolean allNetUsers = false;
        for (int i = 0; i < protoNames.length; ++i) {
            if (!protoNames[i].equals("*")) continue;
            allNetUsers = true;
            break;
        }
        Array users = new Array(UserStatus.class);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        SlotCursor c = userService.getProperties();
        block1: while (c.next(BUser.class)) {
            BUser user = (BUser)c.get();
            if (!user.getNetworkUser()) continue;
            if (allNetUsers) {
                users.add((Object)new UserStatus(user));
                continue;
            }
            String userProto = user.getPrototypeName();
            if (userProto.length() == 0) continue;
            for (int i = 0; i < protoNames.length; ++i) {
                if (!protoNames[i].equals(userProto)) continue;
                users.add((Object)new UserStatus(user));
                continue block1;
            }
        }
        return (UserStatus[])users.trim();
    }

    public UserStatus[] getOutOfSync(UserStatus[] remoteStatus) {
        if (!this.getSyncInEnabled()) {
            throw new UserSyncException(BUserSyncChannel.lex.getText("userSync.error.syncInDisabled"));
        }
        HashMap<String, UserStatus> userMap = new HashMap<String, UserStatus>();
        for (int i = 0; i < remoteStatus.length; ++i) {
            userMap.put(remoteStatus[i].getUserName(), remoteStatus[i]);
        }
        ArrayList<Property> toRemove = new ArrayList<Property>(16);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        SlotCursor c = userService.getProperties();
        while (c.next(BUser.class)) {
            BUser proto;
            BUser localUser;
            if (c.property().isFrozen() || !(localUser = (BUser)c.get()).getNetworkUser()) continue;
            UserStatus remoteUser = (UserStatus)userMap.get(localUser.getName());
            if (remoteUser == null) {
                toRemove.add(c.property());
                continue;
            }
            if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired && (proto = this.getPrototype(remoteUser.getPrototypeName())) == null) {
                toRemove.add(c.property());
                continue;
            }
            if (remoteUser.getPrototypeName().equals(localUser.getPrototypeName())) continue;
            toRemove.add(c.property());
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            userService.remove((Property)i.next());
        }
        Array outOfSync = new Array(UserStatus.class);
        for (UserStatus status : userMap.values()) {
            BUser existing = (BUser)userService.get(status.getUserName());
            BUser proto = this.getPrototype(status.getPrototypeName());
            if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired && proto == null || existing != null && existing.getVersion().equals(status.getVersion()) && (proto == null || existing.getPrototypeVersion().equals(proto.getVersion()))) continue;
            outOfSync.add((Object)status);
        }
        return (UserStatus[])outOfSync.trim();
    }

    public void syncUser(String userName, BUser incomingUser) {
        if (!this.getSyncInEnabled()) {
            return;
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUser localUser = (BUser)userService.get(userName);
        if (localUser == null) {
            this.addUser(userName, incomingUser);
        } else {
            this.updateUser(localUser, incomingUser);
        }
    }

    private void addUser(String userName, BUser newUser) {
        this.applyPrototype(newUser);
        BUserSyncExt ext = new BUserSyncExt();
        ext.setSourceStation(this.getDevice().getSlotPathOrd());
        Property extProp = newUser.getProperty("syncExt");
        if (extProp == null) {
            newUser.add("syncExt", (BValue)ext, 1);
        } else {
            newUser.set(extProp, (BValue)ext);
        }
        BNiagaraUserDeviceExt.setReadonly((BComplex)newUser);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        userService.add(userName, (BValue)newUser, 1);
    }

    private void updateUser(BUser existing, BUser sync) {
        this.applyPrototype(sync);
        BUserSyncExt ext = new BUserSyncExt();
        ext.setSourceStation(this.getDevice().getSlotPathOrd());
        Property extProp = sync.getProperty("syncExt");
        if (extProp == null) {
            sync.add("syncExt", (BValue)ext, 1);
        } else {
            sync.set(extProp, (BValue)ext);
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Property prop = userService.getProperty(existing.getName());
        if (!prop.isFrozen()) {
            BNiagaraUserDeviceExt.setReadonly((BComplex)sync);
        }
        userService.set(prop, (BValue)sync);
    }

    public void applyPrototype(BUser user) {
        BUser proto = this.getPrototype(user.getPrototypeName());
        if (proto == null) {
            return;
        }
        SlotCursor c = proto.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!this.isLocalOverride((BComponent)proto, (Slot)p)) continue;
            this.setFrom(proto, user, p);
        }
        c = user.getProperties();
        ArrayList<Property> delMixIns = new ArrayList<Property>();
        while (c.next()) {
            Property fromProto;
            Property p = c.property();
            if (p.isFrozen() || !p.getType().is(BIMixIn.TYPE) || (fromProto = proto.getProperty(p.getName())) != null) continue;
            delMixIns.add(p);
        }
        for (int i = 0; i < delMixIns.size(); ++i) {
            user.remove((Property)delMixIns.get(i));
        }
        user.setPrototypeVersion(proto.getVersion());
    }

    private boolean isLocalOverride(BComponent parent, Slot slot) {
        return (parent.getFlags(slot) & 0x10000000) != 0;
    }

    private void setFrom(BUser fromUser, BUser toUser, Property p) {
        Property fp = p;
        Property tp = p;
        if (!fp.isFrozen()) {
            tp = toUser.getProperty(fp.getName());
        }
        switch (p.getTypeAccess()) {
            case 0: {
                toUser.setBoolean(tp, fromUser.getBoolean(fp));
                break;
            }
            case 2: {
                toUser.setInt(tp, fromUser.getInt(fp));
                break;
            }
            case 3: {
                toUser.setLong(tp, fromUser.getLong(fp));
                break;
            }
            case 4: {
                toUser.setFloat(tp, fromUser.getFloat(fp));
                break;
            }
            case 5: {
                toUser.setDouble(tp, fromUser.getDouble(fp));
                break;
            }
            case 6: {
                toUser.setString(tp, fromUser.getString(fp));
                break;
            }
            case 7: {
                BValue fv = fromUser.get(fp);
                BValue tv = toUser.get(tp);
                if (tv.getClass() == fv.getClass() && !tv.isSimple()) {
                    tv.asComplex().copyFrom(fv.asComplex());
                    break;
                }
                toUser.set(tp, fv.newCopy());
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        toUser.setFlags((Slot)tp, toUser.getFlags((Slot)p) & 0xEFFFFFFF);
    }

    public void started() {
        this.checkConfig();
        if (!this.getStatus().isDisabled()) {
            this.linkToService();
        }
        if (this.getSyncOutEnabled() && this.getSyncRequired() && Sys.atSteadyState()) {
            this.scheduleSync(false);
        }
    }

    public void atSteadyState() {
        if (this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        }
    }

    public void stopped() {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = null;
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (!Flags.isReadonly((BComplex)this, (Slot)p)) {
            this.checkConfig();
        }
        if (p == status) {
            if (this.getStatus().isDisabled()) {
                this.unlinkFromService();
            } else {
                this.linkToService();
            }
        }
        if (this.getStatus().isFault()) {
            return;
        }
        if (p == syncRequired) {
            if (this.getSyncRequired()) {
                this.scheduleSync(false);
            } else {
                this.cancelSync();
            }
        } else if (p == syncOutEnabled && this.getSyncOutEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (p == syncInEnabled && this.getSyncInEnabled() && this.getSyncRequired()) {
            this.scheduleSync(false);
        } else if (p == syncDelay) {
            if (this.ticket != null) {
                this.scheduleSync(false);
            }
        } else if (p == syncStrategy) {
            this.setSyncRequired(true);
        }
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        if (action == sync) {
            BNiagaraStation station = (BNiagaraStation)this.getDevice();
            if (station != null) {
                station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
            }
            return null;
        }
        return super.post(action, arg, cx);
    }

    public void doHandleUserEvent(BUserEvent event) {
        this.setSyncRequired(true);
    }

    private void linkToService() {
        if (this.get("serviceLink") != null) {
            return;
        }
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        BUserPrototypes prototypes = userService.getUserPrototypes();
        this.linkTo("serviceLink", (BComponent)userService, (Slot)BUserService.userEvent, (Slot)handleUserEvent);
        this.linkTo("serviceProtoLink", (BComponent)prototypes, (Slot)BUserPrototypes.userEvent, (Slot)handleUserEvent);
    }

    private void unlinkFromService() {
        Property p = this.getProperty("serviceLink");
        if (p != null) {
            this.remove(p);
        }
    }

    public void doSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if (!this.getSyncInEnabled() && !this.getSyncOutEnabled()) {
            return;
        }
        BNiagaraStation station = this.getNiagaraStation();
        if (station.getStatus().isDisabled()) {
            return;
        }
        if (station.getStatus().isDown()) {
            return;
        }
        this.setLastSyncAttempt(BAbsTime.now());
        BFoxClientConnection conn = this.getClientConnection();
        try {
            conn.engageNoRetry((BFoxClientConnection.Interest)this);
            if (this.getSyncOutEnabled()) {
                this.syncToRemote();
            } else if (this.getSyncInEnabled()) {
                this.syncFromRemote();
            }
            this.syncComplete();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "Cannot sync users with remote station.", ex);
            this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
            String message = ex.getMessage();
            if (message == null) {
                message = ex.toString();
            }
            this.setFaultCause(message);
            this.scheduleSync(true);
        }
        if (conn.isEngaged((BFoxClientConnection.Interest)this)) {
            conn.disengage((BFoxClientConnection.Interest)this);
        }
    }

    public void scheduleSync(boolean retry) {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)(retry ? this.getSyncRetry() : this.getSyncDelay()), (Action)sync, null);
        log.fine("sync scheduled for " + this.getDevice().getName());
    }

    public void cancelSync() {
        if (this.ticket != null) {
            this.ticket.cancel();
            log.fine("sync cancelled for " + this.getDevice().getName());
        }
    }

    private void syncToRemote() throws Exception {
        log.fine("sync users to " + this.getDevice().getName());
        BUserSyncChannel channel = this.getClientUserChannel();
        channel.startSync(true);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        Array temp = new Array(UserStatus.class, userService.getSlotCount());
        SlotCursor c = userService.getProperties();
        while (c.next(BUser.class)) {
            BUser user = (BUser)c.get();
            if (!user.getNetworkUser()) continue;
            temp.add((Object)new UserStatus((BUser)c.get()));
        }
        UserStatus[] outOfSync = channel.getOutOfSync((UserStatus[])temp.trim());
        for (int i = 0; i < outOfSync.length; ++i) {
            Array batch = new Array(BUser.class);
            for (int j = 0; j < 10 && i < outOfSync.length; ++j) {
                BUser user = (BUser)userService.get(outOfSync[i].getUserName());
                if (user == null) continue;
                batch.add((Object)user);
                if (j + 1 >= 10) continue;
                ++i;
            }
            channel.updateUsers((BUser[])batch.trim());
        }
        channel.endSync();
    }

    private void syncFromRemote() throws Exception {
        log.fine("sync users from " + this.getDevice().getName());
        BUserSyncChannel channel = this.getClientUserChannel();
        channel.startSync(false);
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        String[] protoNames = null;
        if (this.getSyncStrategy() == BUserSyncStrategy.prototypeRequired) {
            protoNames = userService.getUserPrototypes().getPrototypeNames();
        } else if (this.getSyncStrategy() == BUserSyncStrategy.useDefaultPrototype) {
            protoNames = new String[]{"*"};
        } else {
            throw new UserSyncException(BUserSyncChannel.lex.getText("userSync.error.unsupportedStrategy", new Object[]{this.getSyncStrategy().toString()}));
        }
        UserStatus[] remoteUsers = channel.getUserStatus(protoNames);
        UserStatus[] outOfSync = this.getOutOfSync(remoteUsers);
        if (outOfSync.length != 0) {
            for (int i = 0; i < outOfSync.length; ++i) {
                Array batch = new Array(UserStatus.class);
                for (int j = 0; j < 10 && i < outOfSync.length; ++j) {
                    batch.add((Object)outOfSync[i]);
                    if (j + 1 >= 10) continue;
                    ++i;
                }
                channel.updateUsersFromServer((UserStatus[])batch.trim());
            }
        }
        channel.endSync();
    }

    public void syncComplete() {
        this.setSyncRequired(false);
        this.setLastSyncSuccess(BAbsTime.now());
        this.checkConfig();
    }

    private BNiagaraStation getNiagaraStation() {
        return (BNiagaraStation)this.getParent();
    }

    public BIcon getIcon() {
        return icon;
    }
}

