/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BProviderEvent;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.sysdef.SysDefException;
import java.util.Comparator;
import javax.baja.naming.BHost;
import javax.baja.naming.BLocalHost;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nd.SysDefSession;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BICredentials;
import javax.baja.security.BIUserCredentials;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.user.BUser;
import javax.baja.util.BNameList;
import javax.baja.util.BTypeSpec;

public abstract class ProviderSession
implements SysDefSession {
    public static final String SESSION_NAME = "sessionName_";
    private final Context base;
    private final BSysDefProvider provider;
    private final BAbsTime creation;

    public ProviderSession(BSysDefProvider provider) {
        this(provider, null);
    }

    public ProviderSession(BSysDefProvider provider, Context base) {
        this.base = base;
        this.provider = provider;
        this.creation = BAbsTime.now();
    }

    public final String getSessionName() {
        return this.getFacets().gets(SESSION_NAME, "<anonymous>");
    }

    public final BAbsTime getCreation() {
        return this.creation;
    }

    protected void checkClosed() throws SysDefException {
        if (!this.isOpen()) {
            throw new SysDefException("SysDefSession is closed.");
        }
    }

    private BINiagaraStation[] resolveStations(String[] stationNames) {
        Array batch = new Array(BINiagaraStation.class);
        for (int i = 0; i < stationNames.length; ++i) {
            BINiagaraStation s = this.getStation(stationNames[i]);
            if (s == null) continue;
            batch.add((Object)s);
        }
        return (BINiagaraStation[])batch.trim();
    }

    @Override
    public final void close() {
        this.provider.sessionClosed(this);
        this.doClose();
    }

    public abstract void doClose();

    @Override
    public BINiagaraStation getLocalStation() {
        return this.getStation(Sys.getStation().getStationName());
    }

    @Override
    public final BINiagaraStation getStation(String stationName) {
        this.checkClosed();
        return this.doGetStation(stationName);
    }

    public abstract BProviderStation doGetStation(String var1);

    @Override
    public BINiagaraStation[] getSubordinates(BINiagaraStation station) {
        this.checkClosed();
        return this.resolveStations(this.getRoleRefs(station, BStationRole.subordinate));
    }

    @Override
    public BINiagaraStation[] getSupervisors(BINiagaraStation station) {
        this.checkClosed();
        return this.resolveStations(this.getRoleRefs(station, BStationRole.supervisor));
    }

    public BFoxSession getFoxSession(BINiagaraStation ns) {
        BFoxSession result;
        BProviderStation station = (BProviderStation)ns;
        Object host = BHost.getHost((String)station.getIpHost().getHostname());
        if (host == null) {
            host = Sys.getLocalHost(null).getHostAddress().equals(station.getIpHost().getHostname()) ? BLocalHost.INSTANCE : station.getIpHost();
        }
        int port = station.getFoxPort();
        boolean useFoxs = false;
        if (station.getFoxsPort() > 0) {
            port = station.getFoxsPort();
            useFoxs = true;
        }
        if ((result = BFoxSession.make(null, (BHost)host, (int)port, (boolean)useFoxs)).getCredentials() == null) {
            try {
                BNiagaraStation nStation = (BNiagaraStation)this.provider.getNiagaraNetwork().getNiagaraStation(station.getStationName());
                BIUserCredentials credentials = nStation.getClientConnection().getCredentials();
                result.setCredentials((BICredentials)credentials);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[][] getRoutes(String startStation, String targetStation) {
        if (startStation == null) {
            BINiagaraStation local = this.getLocalStation();
            if (local == null) return new String[0][0];
            startStation = local.getStationName();
        } else if (this.getStation(startStation) == null) {
            return new String[0][0];
        }
        BINiagaraStation target = null;
        target = this.getStation(targetStation);
        if (target == null) {
            return new String[0][0];
        }
        Array solutions = new Array(String[].class);
        Array path = new Array(String.class);
        path.push((Object)targetStation);
        this.getRoutes((Array<String>)path, (Array<String[]>)solutions, this.getRoleRefs(target, BStationRole.supervisor), startStation);
        String[][] result = (String[][])solutions.trim();
        SortUtil.sort((Object[])result, (Object[])result, (Comparator)new Comparator<String[]>(){

            @Override
            public int compare(String[] o1, String[] o2) {
                int s1 = o1.length;
                int s2 = o2.length;
                return s1 - s2;
            }
        });
        return result;
    }

    private void getRoutes(Array<String> path, Array<String[]> solutions, String[] supervisors, String start) {
        for (int i = 0; i < supervisors.length; ++i) {
            path.push((Object)supervisors[i]);
            if (supervisors[i].equals(start)) {
                solutions.add((Object)path.reverse().trim());
            } else {
                BProviderStation supervisor = new BProviderStation(supervisors[i]);
                this.getRoutes(path, solutions, this.getRoleRefs(supervisor, BStationRole.supervisor), start);
            }
            path.pop();
        }
    }

    public final String[] getRoleRefs(BINiagaraStation station, BStationRole role) {
        this.checkClosed();
        return this.doGetRoleRefs(station, role);
    }

    protected abstract String[] doGetRoleRefs(BINiagaraStation var1, BStationRole var2);

    public final BProviderStation read(String stationName) {
        this.checkClosed();
        return this.doRead(stationName);
    }

    protected BProviderStation doRead(String stationName) {
        BProviderStation station = (BProviderStation)this.getStation(stationName);
        if (station != null && !station.getResolved().equals((Object)BResolveBits.ALL)) {
            if (!station.getResolved().getBit(1)) {
                throw new IllegalStateException("HOST should have been resolved.");
            }
            if (!station.getResolved().getBit(2)) {
                Array<BTypeSpec> services = this.getServices(station);
                station.setServiceTypes(services);
            }
            if (!station.getResolved().isBits(4)) {
                station.setSubordinates(BNameList.make((String[])this.getRoleRefs(station, BStationRole.subordinate)));
                station.setSupervisors(BNameList.make((String[])this.getRoleRefs(station, BStationRole.supervisor)));
            }
            station.setResolved(BResolveBits.ALL);
        }
        return station;
    }

    public final void insert(BProviderStation station) throws SysDefException {
        this.checkClosed();
        try {
            this.doInsert(station);
        }
        catch (SysDefException x) {
            throw x;
        }
        catch (Exception x) {
            throw new SysDefException("insert failed.", x);
        }
        this.provider.fireProviderEvent(BProviderEvent.makeInsert(station.getStationName()));
    }

    protected abstract void doInsert(BProviderStation var1);

    public final BResolveBits update(BProviderStation station, BResolveBits toUpdate) throws SysDefException {
        return this.update(station, toUpdate, true);
    }

    public final BResolveBits update(BProviderStation station, BResolveBits toUpdate, boolean commit) throws SysDefException {
        this.checkClosed();
        BResolveBits bits = BResolveBits.NONE;
        if (!toUpdate.isBits(BResolveBits.STATION) && (toUpdate.getBit(1) || toUpdate.getBit(2))) {
            throw new SysDefException("toUpdate bits must be one of ALL, NONE, STATION, or NETWORK: " + (Object)((Object)toUpdate));
        }
        try {
            bits = this.doUpdate(station, toUpdate, commit);
        }
        catch (SysDefException x) {
            throw x;
        }
        catch (Exception x) {
            throw new SysDefException("update failed.", x);
        }
        this.provider.fireProviderEvent(BProviderEvent.makeUpdate(station.getStationName(), bits));
        return bits;
    }

    protected abstract BResolveBits doUpdate(BProviderStation var1, BResolveBits var2, boolean var3);

    public final boolean delete(BProviderStation station) {
        return this.delete(station.getStationName());
    }

    public final boolean delete(String stationName) {
        this.checkClosed();
        boolean deleted = false;
        try {
            deleted = this.doDelete(stationName);
            this.provider.fireProviderEvent(BProviderEvent.makeDelete(stationName));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return deleted;
    }

    protected abstract boolean doDelete(String var1);

    public final BResolveBits persist(BProviderStation station) {
        return this.persist(station, true);
    }

    public BResolveBits persist(BProviderStation station, boolean commit) {
        this.checkClosed();
        if (this.getStation(station.getStationName()) == null) {
            if (commit) {
                this.insert(station);
            }
            return BResolveBits.ALL;
        }
        return this.update(station, BResolveBits.ALL, commit);
    }

    public Context getBase() {
        return this.base;
    }

    public BObject getFacet(String name) {
        return this.base == null ? null : this.base.getFacet(name);
    }

    public BFacets getFacets() {
        return this.base == null ? BFacets.DEFAULT : this.base.getFacets();
    }

    public String getLanguage() {
        return this.base == null ? Sys.getLanguage() : this.base.getLanguage();
    }

    public BUser getUser() {
        return this.base == null ? null : this.base.getUser();
    }
}

