/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefChannel;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.util.Array;
import javax.baja.sys.Context;
import javax.baja.util.BTypeSpec;

public class FoxProviderSession
extends ProviderSession {
    public static final int SESSION_INIT = -1;
    private static final int SESSION_CLOSED = -2;
    private int sessionId = -1;
    BNiagaraNetwork network;
    private BProviderStation local;

    public FoxProviderSession(BNiagaraNetwork network, BSysDefProvider p, Context cx) {
        super(p, cx);
        this.network = network;
        network.loadSlots();
        this.local = network.getLocalStation();
        this.local.loadSlots();
        this.sessionId = -1;
    }

    protected BSysDefChannel getChannel() {
        BFoxSession fox = (BFoxSession)this.network.getSession();
        BFoxClientConnection conn = fox.getConnection();
        return (BSysDefChannel)conn.getChannels().get("sysdef", BSysDefChannel.TYPE);
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public void setOpen(int sessionId) {
        this.checkClosed();
        if (this.sessionId != -1) {
            throw new SysDefException("Session id changed from " + this.sessionId + " to " + sessionId);
        }
        this.sessionId = sessionId;
    }

    public void setClosed() {
        this.sessionId = -2;
    }

    @Override
    public BINiagaraStation getLocalStation() {
        return this.getStation(this.local.getStationName());
    }

    @Override
    public BProviderStation doGetStation(String stationName) {
        this.checkClosed();
        try {
            return this.getChannel().getStation(this, stationName);
        }
        catch (SysDefException sde) {
            throw sde;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    @Override
    protected void checkClosed() throws SysDefException {
        if (this.sessionId == -2) {
            throw new SysDefException("SysDefSession has been closed.");
        }
    }

    @Override
    public boolean isOpen() {
        return this.sessionId != -2;
    }

    @Override
    public void doClose() {
        if (this.sessionId == -1) {
            this.sessionId = -2;
        }
        if (!this.isOpen()) {
            return;
        }
        try {
            this.getChannel().closeSession(this);
        }
        catch (SysDefException sde) {
            throw sde;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    @Override
    public Array<BTypeSpec> getServices(BINiagaraStation station) {
        this.checkClosed();
        try {
            return this.getChannel().getServiceTypes(this, station);
        }
        catch (SysDefException sde) {
            throw sde;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    @Override
    public BINiagaraStation[] getSubordinates(BINiagaraStation station) {
        return this.getStations(station, BStationRole.subordinate);
    }

    @Override
    public BINiagaraStation[] getSupervisors(BINiagaraStation station) {
        return this.getStations(station, BStationRole.supervisor);
    }

    private BINiagaraStation[] getStations(BINiagaraStation station, BStationRole role) {
        this.checkClosed();
        try {
            return this.getChannel().getStations(this, station, role);
        }
        catch (SysDefException sde) {
            throw sde;
        }
        catch (Exception x) {
            throw new SysDefException("Operation failed.", x);
        }
    }

    @Override
    public String[] doGetRoleRefs(BINiagaraStation station, BStationRole role) {
        BINiagaraStation[] stations = null;
        switch (role.getOrdinal()) {
            case 2: {
                stations = this.getSupervisors(station);
                break;
            }
            case 1: {
                stations = this.getSubordinates(station);
                break;
            }
            default: {
                return new String[0];
            }
        }
        String[] names = new String[stations.length];
        for (int i = 0; i < stations.length; ++i) {
            names[i] = stations[i].getStationName();
        }
        return names;
    }

    @Override
    public BProviderStation doRead(String stationName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected void doInsert(BProviderStation station) throws SysDefException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected BResolveBits doUpdate(BProviderStation station, BResolveBits toUpdate, boolean commit) throws SysDefException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    protected boolean doDelete(String stationName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

