/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BSysDefVersion
extends BSimple
implements BIComparable {
    public static final BSysDefVersion DEFAULT = new BSysDefVersion(0L, 0L);
    public static final BSysDefVersion IDENTITY = (BSysDefVersion)new BSysDefVersion(-1L, -1L).intern();
    private long creation;
    private long version;
    public static final Type TYPE = Sys.loadType(BSysDefVersion.class);

    private BSysDefVersion(long creation, long version) {
        this.creation = creation;
        this.version = version;
    }

    public static BSysDefVersion make() {
        return new BSysDefVersion(System.currentTimeMillis(), 0L);
    }

    public BSysDefVersion increment() {
        return this.isIdentity() ? IDENTITY : new BSysDefVersion(this.creation, this.version + 1L);
    }

    public boolean newerThan(BSysDefVersion other) {
        return this.compareTo((Object)other) > 0;
    }

    public boolean isIdentity() {
        return this.creation == BSysDefVersion.IDENTITY.creation && this.version == BSysDefVersion.IDENTITY.version;
    }

    public BObject decode(DataInput decoder) throws IOException {
        return this.decodeFromString(decoder.readUTF());
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            int index = s.indexOf(59);
            if (index == -1) {
                throw new IOException("Invalid SysDefVersion: " + s);
            }
            long c = Long.valueOf(s.substring(0, index));
            long v = Long.valueOf(s.substring(index + 1));
            return new BSysDefVersion(c, v);
        }
        catch (NumberFormatException x) {
            throw new IOException("Invalid SysDefVersion: " + s);
        }
    }

    public void encode(DataOutput encoder) throws IOException {
        encoder.writeUTF(this.encodeToString());
    }

    public String encodeToString() throws IOException {
        return this.creation + ";" + this.version;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BSysDefVersion) {
            BSysDefVersion other = (BSysDefVersion)((Object)obj);
            return this.creation == other.creation && this.version == other.version;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + (int)(this.creation ^ this.creation >>> 32);
        hash = 83 * hash + (int)(this.version ^ this.version >>> 32);
        return hash;
    }

    public int compareTo(Object o) {
        BSysDefVersion other = (BSysDefVersion)((Object)o);
        if (this.isIdentity() || other.isIdentity()) {
            return 0;
        }
        int ct = Long.valueOf(this.creation).compareTo(other.creation);
        return ct != 0 ? ct : Long.valueOf(this.version).compareTo(other.version);
    }

    public Type getType() {
        return TYPE;
    }
}

