/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.data.BDataChannel;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.sysdef.BReachableStations;
import com.tridium.nd.util.NiagaraDriverUtil;
import java.net.URI;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.collection.TableCursor;
import javax.baja.driver.BDeviceExt;
import javax.baja.naming.BHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.IPropertyValidator;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.Validatable;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="stationName", type="String", defaultValue="", flags=65), @NiagaraProperty(name="stationVersion", type="String", defaultValue="", flags=65), @NiagaraProperty(name="routeToStation", type="String", defaultValue="", flags=65, facets={@Facet(name="BFacets.MULTI_LINE", value="true")}), @NiagaraProperty(name="minVersionAlongRoute", type="String", defaultValue="", flags=65), @NiagaraProperty(name="virtualSpaceOrd", type="BOrd", defaultValue="BOrd.NULL", flags=65), @NiagaraProperty(name="timeToReach", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=65601, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true")}), @NiagaraProperty(name="routeEnabled", type="boolean", defaultValue="true")})
public final class BReachableStationInfo
extends BComponent
implements IPropertyValidator,
BFoxClientConnection.Interest {
    @Generated
    public static final Property stationName = BReachableStationInfo.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property stationVersion = BReachableStationInfo.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property routeToStation = BReachableStationInfo.newProperty((int)65, (String)"", (BFacets)BFacets.make((String)"multiLine", (boolean)true));
    @Generated
    public static final Property minVersionAlongRoute = BReachableStationInfo.newProperty((int)65, (String)"", null);
    @Generated
    public static final Property virtualSpaceOrd = BReachableStationInfo.newProperty((int)65, (BValue)BOrd.NULL, null);
    @Generated
    public static final Property timeToReach = BReachableStationInfo.newProperty((int)65601, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((String)"showMilliseconds", (boolean)true));
    @Generated
    public static final Property routeEnabled = BReachableStationInfo.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BReachableStationInfo.class);
    private static final BIcon ICON = BIcon.make((BIcon)BIcon.std((String)"device.png"), (BIcon)BIcon.std((String)"badges/tunnel.png"));
    private static final BFacets SHOW_MILLIS_FACET = BFacets.make((String)"showMilliseconds", (boolean)true);
    private static final Logger LOG = Logger.getLogger("reachableStations");
    private URI reachableStationFoxUri = null;

    @Generated
    public String getStationName() {
        return this.getString(stationName);
    }

    @Generated
    public void setStationName(String v) {
        this.setString(stationName, v, null);
    }

    @Generated
    public String getStationVersion() {
        return this.getString(stationVersion);
    }

    @Generated
    public void setStationVersion(String v) {
        this.setString(stationVersion, v, null);
    }

    @Generated
    public String getRouteToStation() {
        return this.getString(routeToStation);
    }

    @Generated
    public void setRouteToStation(String v) {
        this.setString(routeToStation, v, null);
    }

    @Generated
    public String getMinVersionAlongRoute() {
        return this.getString(minVersionAlongRoute);
    }

    @Generated
    public void setMinVersionAlongRoute(String v) {
        this.setString(minVersionAlongRoute, v, null);
    }

    @Generated
    public BOrd getVirtualSpaceOrd() {
        return (BOrd)this.get(virtualSpaceOrd);
    }

    @Generated
    public void setVirtualSpaceOrd(BOrd v) {
        this.set(virtualSpaceOrd, (BValue)v, null);
    }

    @Generated
    public BRelTime getTimeToReach() {
        return (BRelTime)this.get(timeToReach);
    }

    @Generated
    public void setTimeToReach(BRelTime v) {
        this.set(timeToReach, (BValue)v, null);
    }

    @Generated
    public boolean getRouteEnabled() {
        return this.getBoolean(routeEnabled);
    }

    @Generated
    public void setRouteEnabled(boolean v) {
        this.setBoolean(routeEnabled, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BReachableStations getReachableStationsContainer() {
        return (BReachableStations)this.getParent();
    }

    public BNiagaraStation getNiagaraStation() {
        return this.getReachableStationsContainer().getNiagaraStation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getReachableStationURI() {
        BReachableStations reachableStations;
        if (this.reachableStationFoxUri == null && !(reachableStations = this.getReachableStationsContainer()).isDown() && !reachableStations.isDisabled() && !reachableStations.isFault() && this.getRouteEnabled()) {
            BFoxClientConnection clientConnection = this.getNiagaraStation().getClientConnection();
            try {
                clientConnection.engageNoRetry((BFoxClientConnection.Interest)this);
                BDataChannel dataChannel = (BDataChannel)clientConnection.getChannels().get("data", BDataChannel.TYPE);
                String[] stationRoute = NiagaraDriverUtil.parseRouteToStation(this.getRouteToStation(), false);
                BOrd query = BOrd.make((String)("service:niagaraDriver:NiagaraNetwork|bql:select address, foxPort, clientConnection.useFoxs from niagaraDriver:NiagaraStation stop where name = '" + this.getStationName() + "'"));
                BITable table = (BITable)dataChannel.resolve(query, Arrays.copyOf(stationRoute, stationRoute.length - 1));
                ColumnList columns = table.getColumns();
                try (TableCursor cursor = table.cursor();){
                    if (cursor.next()) {
                        int foxPort = ((BInteger)cursor.cell(columns.get("foxPort")).as(BInteger.class)).getInt();
                        boolean useFoxs = ((BBoolean)cursor.cell(columns.get("clientConnection.useFoxs")).as(BBoolean.class)).getBoolean();
                        String hostname = ((BHost)((BOrd)cursor.cell(columns.get("address")).as(BOrd.class)).get()).getHostname();
                        this.reachableStationFoxUri = URI.create(String.format("%s://%s:%s", useFoxs ? "foxs" : "fox", hostname, foxPort));
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Could not find reachable station URI: " + e.getMessage(), LOG.isLoggable(Level.FINE) ? e : null);
            }
            finally {
                clientConnection.disengage((BFoxClientConnection.Interest)this);
            }
        }
        return this.reachableStationFoxUri;
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BReachableStations;
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && routeEnabled.equals(property)) {
            BDeviceExt[] exts;
            for (BDeviceExt ext : exts = (BDeviceExt[])DrUtil.getDecendantsByClass((BComponent)this, BDeviceExt.class)) {
                ext.updateStatus();
            }
        }
        super.changed(property, context);
    }

    public String toDebugString() {
        return "Reachable Station Name: " + this.getStationName() + "\nReachable Station Version: " + this.getStationVersion() + "\nRoute to Station: " + this.getRouteToStation() + "\nMin Version Along Route: " + this.getMinVersionAlongRoute() + "\nVirtual Space Ord (null means virtuals not enabled along route): " + this.getVirtualSpaceOrd() + "\nTime to Reach: " + this.getTimeToReach().toString((Context)SHOW_MILLIS_FACET) + "\nRoute Enabled: " + this.getRouteEnabled();
    }

    public IPropertyValidator getPropertyValidator(Property property, Context context) {
        if (routeToStation.equals(property)) {
            return this;
        }
        return null;
    }

    public IPropertyValidator getPropertyValidator(Property[] properties, Context context) {
        for (Property prop : properties) {
            if (!routeToStation.equals(prop)) continue;
            return this;
        }
        return null;
    }

    public void validateSet(Validatable validatable, Context context) {
        String proposedRouteToStation = ((BString)validatable.getProposedValue(routeToStation)).getString();
        NiagaraDriverUtil.parseRouteToStation(proposedRouteToStation, true);
    }

    public BIcon getIcon() {
        BValue dynamic = this.get("icon");
        if (dynamic instanceof BIcon) {
            return (BIcon)dynamic;
        }
        return ICON;
    }
}

