/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.sysdef;

import com.tridium.nd.sysdef.BProviderStation;
import com.tridium.nd.sysdef.BResolveBits;
import com.tridium.nd.sysdef.BSysDefProvider;
import com.tridium.nd.sysdef.ProviderSession;
import com.tridium.nd.sysdef.SysDefException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import javax.baja.nd.BINiagaraStation;
import javax.baja.nd.BStationRole;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BComplex;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.DuplicateSlotException;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

@NiagaraType
public class BBogProvider
extends BSysDefProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BBogProvider.class);
    final LockManager stationLocks = new LockManager();

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void started() throws Exception {
        super.started();
        this.startup();
    }

    @Override
    public ProviderSession makeSession(Context base) {
        return new BogSession(this, base);
    }

    @Override
    protected void loadStationNames(HashSet<String> inProvider) {
        SlotCursor slots = this.getProperties();
        while (slots.next(BProviderStation.class)) {
            inProvider.add(slots.property().getName());
        }
    }

    private static class BogSession
    extends ProviderSession {
        private boolean isClosed = false;
        private final BBogProvider bog;

        public BogSession(BBogProvider bog, Context base) {
            super(bog, base);
            this.bog = bog;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BProviderStation doGetStation(String stationName) {
            this.bog.stationLocks.lock(stationName);
            try {
                BProviderStation fromBog = (BProviderStation)this.bog.get(stationName);
                BProviderStation ps = null;
                if (fromBog != null) {
                    ps = new BProviderStation();
                    ps.copyFrom((BComplex)fromBog);
                    ps.setResolved(BResolveBits.ALL);
                }
                BProviderStation bProviderStation = ps;
                return bProviderStation;
            }
            finally {
                this.bog.stationLocks.unlock(stationName);
            }
        }

        @Override
        public boolean isOpen() {
            return !this.isClosed;
        }

        @Override
        public void doClose() {
            this.isClosed = true;
        }

        @Override
        public Array<BTypeSpec> getServices(BINiagaraStation station) {
            this.checkClosed();
            BProviderStation ps = this.doGetStation(station.getStationName());
            return ps == null ? new Array(BTypeSpec.class) : ps.getServiceTypes();
        }

        @Override
        public String[] doGetRoleRefs(BINiagaraStation station, BStationRole role) {
            BProviderStation ps = this.doGetStation(station.getStationName());
            return ps == null ? new String[]{} : ps.getStationRefs(role);
        }

        @Override
        protected BProviderStation doRead(String stationName) {
            this.bog.stationLocks.lock(stationName);
            try {
                BProviderStation bProviderStation = super.doRead(stationName);
                return bProviderStation;
            }
            finally {
                this.bog.stationLocks.unlock(stationName);
            }
        }

        @Override
        protected void doInsert(BProviderStation station) throws SysDefException {
            this.bog.stationLocks.lock(station.getStationName());
            try {
                BProviderStation toInsert = new BProviderStation();
                toInsert.copyFrom((BComplex)station);
                this.bog.add(toInsert.getStationName(), (BValue)toInsert, 4);
            }
            catch (DuplicateSlotException dse) {
                throw new SysDefException("Cannot insert station: station already exists (key violation) - " + station);
            }
            catch (Exception x) {
                x.printStackTrace();
                throw new SysDefException("Cannot insert station: " + station, x);
            }
            finally {
                this.bog.stationLocks.unlock(station.getStationName());
            }
        }

        @Override
        protected BResolveBits doUpdate(BProviderStation station, BResolveBits toUpdate, boolean commit) throws SysDefException {
            BProviderStation ps = null;
            this.bog.stationLocks.lock(station.getStationName());
            try {
                if (toUpdate.equals((Object)BResolveBits.NONE)) {
                    BResolveBits bResolveBits = BResolveBits.NONE;
                    return bResolveBits;
                }
                ps = this.read(station.getStationName());
                if (ps == null) {
                    throw new NoSuchSlotException("");
                }
                boolean stationStale = station.getStationVersion().newerThan(ps.getStationVersion());
                boolean networkStale = station.getNetworkVersion().newerThan(ps.getNetworkVersion());
                if (!stationStale && !networkStale) {
                    BResolveBits bResolveBits = BResolveBits.NONE;
                    return bResolveBits;
                }
                BResolveBits updatedBits = BResolveBits.NONE;
                if (stationStale && toUpdate.isBits(BResolveBits.STATION)) {
                    if (commit) {
                        ps.setAlias(station.getAlias());
                        ps.setAddress(station.getAddress());
                        ps.setFoxPort(station.getFoxPort());
                        ps.setFoxsPort(station.getFoxsPort());
                        ps.setHttpPort(station.getHttpPort());
                        ps.setHttpsPort(station.getHttpsPort());
                        ps.setNiagaraDaemonPort(station.getNiagaraDaemonPort());
                        ps.setNiagaraDaemonSslPort(station.getNiagaraDaemonSslPort());
                        ps.setServices(station.getServices());
                        ps.setStationVersion(station.getStationVersion());
                    }
                    updatedBits = updatedBits.turnOn(BResolveBits.STATION);
                }
                if (networkStale && toUpdate.getBit(4)) {
                    if (commit) {
                        ps.setSubordinates(station.getSubordinates());
                        ps.setSupervisors(station.getSupervisors());
                        ps.setNetworkVersion(station.getNetworkVersion());
                    }
                    updatedBits = updatedBits.turnOn(BResolveBits.network);
                }
                if (!toUpdate.isBits(updatedBits)) {
                    throw new IllegalStateException("updated bits should be subset of toUpdate.");
                }
                if (commit) {
                    ps.removeResolved();
                    this.bog.set(ps.getStationName(), (BValue)ps);
                }
                BResolveBits bResolveBits = updatedBits;
                return bResolveBits;
            }
            catch (NoSuchSlotException nss) {
                throw new SysDefException("Cannot update: station not in provider: " + station);
            }
            catch (Exception x) {
                x.printStackTrace();
                throw new SysDefException("Cannot update station: " + station, x);
            }
            finally {
                this.bog.stationLocks.unlock(station.getStationName());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean doDelete(String stationName) {
            this.bog.stationLocks.lock(stationName);
            try {
                BProviderStation ps = this.doGetStation(stationName);
                if (ps != null) {
                    this.bog.remove(stationName);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            finally {
                this.bog.stationLocks.unlock(stationName);
            }
            return false;
        }
    }

    private static class LockManager {
        private final HashMap<String, ReentrantLock> locks = new HashMap(19);

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void lock(String stationName) {
            ReentrantLock sLock = null;
            boolean wasInterrupted = false;
            try {
                HashMap<String, ReentrantLock> hashMap = this.locks;
                // MONITORENTER : hashMap
                while (true) {
                    if ((sLock = this.locks.get(stationName)) == null) {
                        sLock = new ReentrantLock();
                        this.locks.put(stationName, sLock);
                        sLock.lock();
                        // MONITOREXIT : hashMap
                        if (!wasInterrupted) return;
                        Thread.currentThread().interrupt();
                        return;
                    }
                    if (!sLock.tryLock()) break block11;
                    break;
                }
            }
            catch (Throwable throwable) {
                if (!wasInterrupted) throw throwable;
                Thread.currentThread().interrupt();
                throw throwable;
            }
            {
                block11: {
                    // MONITOREXIT : hashMap
                    if (!wasInterrupted) return;
                    Thread.currentThread().interrupt();
                    return;
                }
                try {
                    this.locks.wait();
                }
                catch (InterruptedException x) {
                    wasInterrupted = true;
                }
                continue;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unlock(String stationName) {
            ReentrantLock sLock = null;
            HashMap<String, ReentrantLock> hashMap = this.locks;
            synchronized (hashMap) {
                try {
                    sLock = this.locks.get(stationName);
                    if (sLock == null) {
                        throw new NullPointerException();
                    }
                    sLock.unlock();
                    if (sLock.getHoldCount() == 0) {
                        this.locks.remove(stationName);
                    }
                }
                finally {
                    this.locks.notifyAll();
                }
            }
        }
    }
}

