/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.spy;

import com.tridium.fox.session.FoxSession;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.spy.SpyConnection;
import com.tridium.nd.spy.SpyNiagaraVirtualsClient;
import com.tridium.nd.spy.SpyPointsClient;
import com.tridium.nd.spy.SpyPointsServer;
import com.tridium.nd.spy.SpyStations;
import com.tridium.nd.virtual.BNiagaraVirtualDeviceExt;
import java.io.IOException;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Clock;

public class SpyStation
extends SpyDir {
    public final BNiagaraStation station;

    public SpyStation(BNiagaraStation station) {
        this.station = station;
        String name = station.getName();
        this.add("client", new SpyConnection(name + " Client Connection", (BFoxConnection)station.getClientConnection()));
        this.add("server", new SpyConnection(name + " Server Connection", (BFoxConnection)station.getServerConnection()));
        this.add("pointsClient", (Spy)new SpyPointsClient(station.getPoints()));
        this.add("niagaraVirtuals", (Spy)new SpyNiagaraVirtualsClient(station.getVirtual()));
        this.add("pointsServer", (Spy)new SpyPointsServer(station.getPoints()));
    }

    public void write(SpyWriter out) throws IOException {
        String base = "";
        out.startProps();
        out.trTitle((Object)("Station " + this.station.getName()), 2);
        out.prop((Object)"path", (Object)this.station.toPathString());
        out.prop((Object)"handle", this.station.getHandle());
        out.prop((Object)"currentTime", (Object)Clock.time());
        out.prop((Object)"health", (Object)this.station.getHealth());
        out.prop((Object)"health.lastOkTime", (Object)this.station.getHealth().getLastOkTime());
        out.prop((Object)"health.lastFailTime", (Object)this.station.getHealth().getLastFailTime());
        out.prop((Object)"health.lastFailCause", (Object)this.station.getHealth().getLastFailCause());
        out.unsafe().trTitle((Object)out.createLink(base + "client", (Object)"Client Connection"), 2);
        BFoxClientConnection client = this.station.getClientConnection();
        this.writeCommonConn(out, (BFoxConnection)client);
        out.prop((Object)"username", (Object)client.getCredentials().getUsername());
        out.prop((Object)"connect", (Object)client.getLastConnectTime());
        out.prop((Object)"disconnect", (Object)(client.getLastDisconnectTime() + ": " + client.getLastDisconnectCause()));
        out.prop((Object)"failure", (Object)(client.getLastFailureTime() + ": " + client.getLastFailureCause()));
        out.prop((Object)"nextAttempt", (Object)client.getNextAttemptTime());
        out.prop((Object)"interests", client.getInterests().length);
        out.unsafe().trTitle((Object)out.createLink(base + "server", (Object)"Server Connection"), 2);
        BFoxServerConnection server = this.station.getServerConnection();
        this.writeCommonConn(out, (BFoxConnection)server);
        out.prop((Object)"connect", (Object)server.getLastConnectTime());
        out.prop((Object)"lastLogin", (Object)(server.getLastLoginTime() + ": " + server.getLastLoginUsername() + " from " + server.getLastLoginAddress()));
        out.prop((Object)"disconnect", (Object)(server.getLastDisconnectTime() + ": " + server.getLastDisconnectCause()));
        out.unsafe().trTitle((Object)out.createLink(base + "pointsClient", (Object)"Client Points"), 2);
        BNiagaraPointDeviceExt points = this.station.getPoints();
        out.prop((Object)"count", (Object)SpyStations.toPointsClient(points));
        out.unsafe().trTitle((Object)out.createLink(base + "niagaraVirtuals", (Object)"Client Niagara Virtuals"), 2);
        BNiagaraVirtualDeviceExt gateway = this.station.getVirtual();
        out.prop((Object)"count", (Object)SpyStations.toNiagaraVirtuals(gateway));
        out.unsafe().trTitle((Object)out.createLink(base + "pointsServer", (Object)"Server Points/Virtuals"), 2);
        out.prop((Object)"count", (Object)SpyStations.toPointsServer(points));
        out.endProps();
    }

    private void writeCommonConn(SpyWriter out, BFoxConnection conn) {
        out.prop((Object)"state", (Object)conn.getState());
        FoxSession session = conn.session();
        if (session == null) {
            out.prop((Object)"session", (Object)"null");
        } else {
            String id = session.getId();
            String appName = session.getRemoteHello().getString("app.name", "unknown");
            String appVersion = session.getRemoteHello().getString("app.version", "unknown");
            out.prop((Object)"session", (Object)("id=" + id + " (" + appName + "  " + appVersion + ")"));
        }
    }
}

