/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.fox.message.FoxTuple;
import com.tridium.fox.session.FoxRequest;
import com.tridium.fox.sys.BFoxServerConnection;
import com.tridium.fox.sys.spy.FoxLog;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraPointDeviceExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.point.ServerEntry;
import java.util.HashMap;
import java.util.Map;
import javax.baja.net.NotConnectedException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.util.ICoalesceable;

public class ServerWorker
extends Subscriber
implements Runnable,
ICoalesceable {
    public static final int WORKER_SLEEP = 1000;
    public static final ServerEntry[] NO_ENTRIES = new ServerEntry[0];
    private final BNiagaraStation station;
    private FoxLog log = null;
    private BFoxServerConnection connection = null;
    private BPointChannel channel = null;
    private final Map<Integer, ServerEntry> byMessageId = new HashMap<Integer, ServerEntry>();
    private final Map<BComponent, ServerEntry[]> byComponent = new HashMap<BComponent, ServerEntry[]>();

    ServerWorker(BNiagaraPointDeviceExt points) {
        this.station = (BNiagaraStation)points.getDevice();
    }

    private BFoxServerConnection getConnection() {
        if (this.connection == null) {
            this.connection = this.station.getServerConnection();
        }
        return this.connection;
    }

    private BPointChannel getChannel() {
        if (this.channel == null && this.getConnection() != null) {
            this.channel = (BPointChannel)this.getConnection().getChannels().get("point", BPointChannel.TYPE);
        }
        return this.channel;
    }

    private FoxLog getLog() {
        if (this.log == null && this.getChannel() != null) {
            this.log = this.getChannel().log;
        }
        return this.log;
    }

    public void start() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().register(this, 1000L);
        }
    }

    public void kill() {
        BNiagaraNetwork net = this.station.getNiagaraNetwork();
        if (net != null) {
            net.getWorkers().unregister(this);
        }
        this.unsubAll();
    }

    @Override
    public void run() {
        block4: {
            try {
                FoxRequest req = this.getSubscriptionChanges();
                if (req != null && this.getChannel() != null) {
                    this.getChannel().sendChange(req);
                }
            }
            catch (InterruptedException | NotConnectedException req) {
            }
            catch (Throwable e) {
                if (this.getLog() == null) break block4;
                this.getLog().error("Error sendChange()", e);
            }
        }
    }

    private synchronized FoxRequest getSubscriptionChanges() {
        long ticksNow = Clock.ticks();
        FoxRequest msg = null;
        if (this.getChannel() != null && this.getLog() != null) {
            for (ServerEntry entry : this.byMessageId.values()) {
                if (!entry.sendUpdate(ticksNow)) continue;
                if (msg == null) {
                    msg = this.getChannel().makeRequest("change");
                }
                msg.add((FoxTuple)entry.update(this.getLog()));
                entry.changed = false;
                entry.lastSent = ticksNow;
            }
        }
        return msg;
    }

    public ServerEntry getEntry(int messageId) {
        return this.byMessageId.get(messageId);
    }

    public ServerEntry[] getEntries(BComponent component) {
        ServerEntry[] entries = this.byComponent.get(component);
        if (entries == null) {
            return NO_ENTRIES;
        }
        return entries;
    }

    public ServerEntry[] getAllEntries() {
        return this.byMessageId.values().toArray(new ServerEntry[0]);
    }

    public synchronized void sub(ServerEntry entry) {
        this.byMessageId.put(entry.messageId, entry);
        ServerEntry[] oldEntries = this.getEntries(entry.component);
        ServerEntry[] newEntries = new ServerEntry[oldEntries.length + 1];
        System.arraycopy(oldEntries, 0, newEntries, 0, oldEntries.length);
        newEntries[oldEntries.length] = entry;
        this.byComponent.put(entry.component, newEntries);
        try {
            super.subscribe(entry.component);
        }
        catch (Throwable e) {
            this.byMessageId.remove(entry.messageId);
            this.byComponent.remove(entry.component);
        }
    }

    public synchronized void unsub(int messageId) {
        ServerEntry entry = this.byMessageId.get(messageId);
        if (entry == null) {
            return;
        }
        this.byMessageId.remove(entry.messageId);
        BComponent component = entry.component;
        ServerEntry[] oldEntries = this.getEntries(component);
        if (oldEntries.length == 1) {
            if (oldEntries[0] != entry) {
                throw new IllegalStateException();
            }
            this.byComponent.remove(component);
            super.unsubscribe(component);
        } else {
            ServerEntry[] newEntries = new ServerEntry[oldEntries.length - 1];
            int n = 0;
            for (int i = 0; i < oldEntries.length; ++i) {
                if (oldEntries[i] == entry) continue;
                newEntries[n++] = oldEntries[i];
            }
            this.byComponent.put(component, newEntries);
        }
    }

    public synchronized void unsubAll() {
        super.unsubscribeAll();
        this.byMessageId.clear();
        this.byComponent.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void event(BComponentEvent event) {
        if (event.getId() != 0) {
            return;
        }
        for (ServerEntry entry : this.getEntries(event.getSourceComponent())) {
            Slot slot;
            if (entry.path != null && entry.path.length > 0 && ((slot = event.getSlot()) == null || !slot.equals((Object)entry.path[0]))) continue;
            ServerWorker serverWorker = this;
            synchronized (serverWorker) {
                entry.changed = true;
            }
        }
    }

    public String toString() {
        return this.station.getName() + ":Server Worker";
    }

    public Object getCoalesceKey() {
        return this;
    }

    public ICoalesceable coalesce(ICoalesceable c) {
        return c;
    }
}

