/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.box.BOrdChannel;
import com.tridium.fox.sys.BFoxConnection;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import com.tridium.nav.BINavSupport;
import com.tridium.nd.BINiagaraDeviceExt;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.discover.NiagaraLearnUtil;
import com.tridium.nd.discover.PointLearnNodeInfo;
import com.tridium.nd.point.BForceUpdateNiagaraPointsJob;
import com.tridium.nd.point.BINiagaraPointContainer;
import com.tridium.nd.point.BNiagaraPointFolder;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.nd.point.BPointChannel;
import com.tridium.nd.point.ClientWorker;
import com.tridium.nd.point.ServerWorker;
import com.tridium.nv.point.INiagaraProxyExt;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.collection.BITable;
import javax.baja.control.BControlPoint;
import javax.baja.control.ext.BAbstractProxyExt;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.point.BPointDeviceExt;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="forceUpdateNiagaraProxyPoints", returnType="BOrd", flags=128)
public class BNiagaraPointDeviceExt
extends BPointDeviceExt
implements BINiagaraDeviceExt,
BINiagaraPointContainer {
    @Generated
    public static final Action forceUpdateNiagaraProxyPoints = BNiagaraPointDeviceExt.newAction((int)128, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraPointDeviceExt.class);
    private static final Logger log = Logger.getLogger("niagara.points");
    public final Object stateLock = new Object();
    public ClientWorker clientWorker;
    public ServerWorker serverWorker;
    private boolean descendantsStarted = false;
    private final Array<INiagaraProxyExt> proxyExtArray = new Array(INiagaraProxyExt.class);
    private final Object serverLock = new Object();
    private final Object clientLock = new Object();

    @Generated
    public BOrd forceUpdateNiagaraProxyPoints() {
        return (BOrd)this.invoke(forceUpdateNiagaraProxyPoints, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getDeviceType() {
        return BNiagaraStation.TYPE;
    }

    public Type getProxyExtType() {
        return BNiagaraProxyExt.TYPE;
    }

    public Type getPointFolderType() {
        return BNiagaraPointFolder.TYPE;
    }

    public boolean isChildLegal(BComponent child) {
        return true;
    }

    public final BFoxConnection getClientConnection() {
        return ((BNiagaraStation)this.getParent()).getClientConnection();
    }

    public final BPointChannel getClientChannel() {
        return (BPointChannel)((BNiagaraStation)this.getParent()).getClientConnection().getChannels().get("point", BPointChannel.TYPE);
    }

    public void updateStatus() {
        super.updateStatus();
        this.checkClientWorker();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.descendantsStarted = true;
        this.checkClientWorker();
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.checkClientWorker();
    }

    public void stopped() throws Exception {
        super.stopped();
        this.descendantsStarted = false;
        this.stopClientWorker();
        this.stopServerWorker();
    }

    private void checkClientWorker() {
        BDevice device = this.getDevice();
        if (device.isFault() || device.isDown() || device.isDisabled() || !this.descendantsStarted || !Sys.isStationStarted()) {
            this.stopClientWorker();
        } else {
            this.startClientWorker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startClientWorker() {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                if (this.clientWorker != null) {
                    return;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getParent().getName() + ".startClientWorker");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.clientWorker = new ClientWorker(this);
            this.clientWorker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerWorker() {
        Object object = this.serverLock;
        synchronized (object) {
            try {
                if (this.serverWorker != null) {
                    return;
                }
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getParent().getName() + ".startServerWorker");
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.serverWorker = new ServerWorker(this);
            this.serverWorker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopClientWorker() {
        Object object = this.clientLock;
        synchronized (object) {
            try {
                BNiagaraStation s = (BNiagaraStation)this.getParent();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(s.getName() + ".stopClientWorker");
                }
                if (s.getClientConnection().isConnected()) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                if (this.clientWorker != null) {
                    this.clientWorker.kill();
                }
            }
            finally {
                this.clientWorker = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopServerWorker() {
        Object object = this.serverLock;
        synchronized (object) {
            try {
                BNiagaraStation s = (BNiagaraStation)this.getParent();
                if (log.isLoggable(Level.FINE)) {
                    log.fine(s.getName() + ".stopServerWorker");
                }
                if (s.getServerConnection() != null && s.getServerConnection().isConnected()) {
                    return;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                if (this.serverWorker != null) {
                    this.serverWorker.kill();
                }
            }
            finally {
                this.serverWorker = null;
            }
        }
    }

    @Override
    public void clientOpened() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientClosed() {
        BControlPoint[] points = this.getPoints();
        BAbstractProxyExt[] exts = new BAbstractProxyExt[points.length];
        for (int i = 0; i < points.length; ++i) {
            exts[i] = points[i].getProxyExt();
        }
        Object object = this.stateLock;
        synchronized (object) {
            for (int i = 0; i < exts.length; ++i) {
                if (!(exts[i] instanceof BNiagaraProxyExt)) continue;
                ((BNiagaraProxyExt)exts[i]).sessionClosed();
            }
        }
    }

    @Override
    public void serverOpened() {
        this.startServerWorker();
    }

    @Override
    public void serverClosed() {
        this.stopServerWorker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerProxyExt(INiagaraProxyExt proxyExt) {
        Array<INiagaraProxyExt> array = this.proxyExtArray;
        synchronized (array) {
            this.proxyExtArray.add((Object)proxyExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterProxyExt(INiagaraProxyExt proxyExt) {
        Array<INiagaraProxyExt> array = this.proxyExtArray;
        synchronized (array) {
            this.proxyExtArray.remove((Object)proxyExt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public INiagaraProxyExt[] getProxyExtensions() {
        Array<INiagaraProxyExt> array = this.proxyExtArray;
        synchronized (array) {
            return (INiagaraProxyExt[])this.proxyExtArray.copy().trim();
        }
    }

    @Override
    public List<BNiagaraProxyExt> getDescendantNiagaraProxyExts() {
        ArrayList<BNiagaraProxyExt> list = new ArrayList<BNiagaraProxyExt>();
        BNiagaraPointDeviceExt.findNiagaraProxyExts((BComplex)this, list);
        return list;
    }

    static void findNiagaraProxyExts(BComplex comp, List<BNiagaraProxyExt> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(BNiagaraProxyExt.TYPE)) {
                list.add((BNiagaraProxyExt)kid);
                continue;
            }
            BNiagaraPointDeviceExt.findNiagaraProxyExts((BComplex)kid, list);
        }
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="R")
    public JSONObject discoverDeviceRoots(Context cx) throws Exception {
        BINavNode root = NiagaraLearnUtil.discoverPointRootsViaLocalExt((BDeviceExt)this, cx);
        return BINavSupport.encodeToJson((BINavNode)root, (BiFunction)BINavSupport.ENCODE_ALL_NAV_CHILDREN, (Context)cx);
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="R")
    public JSONObject loadNodesPartially(List<String> ordStrings, Context cx) throws Exception {
        BNiagaraStation localStation = NiagaraLearnUtil.getNiagaraStation((BDeviceExt)this);
        BOrd[] ordsToLoad = (BOrd[])ordStrings.stream().map(BOrd::make).toArray(BOrd[]::new);
        Map<BOrd, PointLearnNodeInfo> discoveredNodes = NiagaraLearnUtil.loadNodesPartiallyViaLocalStation(localStation, ordsToLoad, cx);
        JSONObject result = new JSONObject();
        for (Map.Entry<BOrd, PointLearnNodeInfo> entry : discoveredNodes.entrySet()) {
            result.put(entry.getKey().encodeToString(), (Object)entry.getValue().toJson());
        }
        return result;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="R")
    public String loadNodes(String ord, Context cx) throws Exception {
        BNiagaraStation localStation = NiagaraLearnUtil.getNiagaraStation((BDeviceExt)this);
        Map<BOrd, PointLearnNodeInfo> discoveredNodes = NiagaraLearnUtil.loadNodesViaLocalStation(localStation, BOrd.make((String)ord), cx);
        StringWriter stringWriter = new StringWriter();
        JSONWriter out = QuickJSONWriter.make((Appendable)stringWriter);
        out.object();
        for (Map.Entry<BOrd, PointLearnNodeInfo> entry : discoveredNodes.entrySet()) {
            out.key(entry.getKey().encodeToString()).value((Object)entry.getValue().toJson());
        }
        out.endObject();
        return stringWriter.toString();
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)}, permissions="R")
    public JSONObject bqlDiscover(String bqlQuery, Context cx) throws Exception {
        BITable table = (BITable)NiagaraLearnUtil.bqlDiscoverViaLocalExt((BDeviceExt)this, BOrd.make((String)bqlQuery));
        JSONObject schema = BOrdChannel.encodeTableSchema((BITable)table, (Context)cx);
        JSONArray contents = QuickJSONWriter.toJSONArray(out -> BOrdChannel.encodeTableContents((BITable)table, (JSONWriter)out, (Context)cx));
        JSONObject result = new JSONObject();
        result.put("schema", (Object)schema);
        result.put("contents", (Object)contents);
        return result;
    }

    public BOrd doForceUpdateNiagaraProxyPoints(Context cx) {
        return new BForceUpdateNiagaraPointsJob(this).submit(cx);
    }
}

