/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.point;

import com.tridium.nd.point.BINiagaraPointContainer;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.sys.service.ServiceManager;
import java.security.AccessController;
import java.util.List;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.status.BStatus;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;

@NiagaraType
@NiagaraProperty(name="containerDescription", type="String", defaultValue="", flags=7)
public class BForceUpdateNiagaraPointsJob
extends BSimpleJob {
    @Generated
    public static final Property containerDescription = BForceUpdateNiagaraPointsJob.newProperty((int)7, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BForceUpdateNiagaraPointsJob.class);
    public static BIcon icon = BIcon.std((String)"refresh.png");
    private static final int LOG_LIMIT = AccessController.doPrivileged(() -> Integer.getInteger("niagara.network.forceUpdateNiagaraPoints.logLimit", 500));
    private BINiagaraPointContainer container;

    @Generated
    public String getContainerDescription() {
        return this.getString(containerDescription);
    }

    @Generated
    public void setContainerDescription(String v) {
        this.setString(containerDescription, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BForceUpdateNiagaraPointsJob(BINiagaraPointContainer container) {
        this.container = container;
        String desc = container instanceof BComponent ? ((BComponent)container).toDisplayPathString(null) : container.toString();
        this.setContainerDescription(desc);
    }

    public BForceUpdateNiagaraPointsJob() {
    }

    public BOrd submit(Context cx) {
        BComponent jobService = (BComponent)BJobService.getService();
        BJob[] jobs = (BJob[])jobService.getChildren(BForceUpdateNiagaraPointsJob.class);
        if (jobs != null) {
            int disposeIndex = jobs.length - ServiceManager.jobMaxCountPerType;
            for (int i = jobs.length - 1; i >= 0; --i) {
                if (jobs[i].isAlive()) {
                    throw new LocalizableRuntimeException("niagaraDriver", "forceUpdateNiagaraPoints.jobAlreadyRunning");
                }
                if (i > disposeIndex) continue;
                jobs[i].dispose();
            }
        }
        return super.submit(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.container == null) {
            throw new IllegalStateException("Must submit through forceUpdateNiagaraProxyPoints() action");
        }
        int logLimit = LOG_LIMIT >= 5 ? LOG_LIMIT : 5;
        this.log().setLimit(logLimit);
        String path = this.getContainerDescription();
        String[] pathArg = new String[]{path};
        String tab = "        ";
        this.log().start("niagaraDriver", "forceUpdateNiagaraPoints.startJob", pathArg);
        List<BNiagaraProxyExt> proxyExts = this.container.getDescendantNiagaraProxyExts();
        int size = proxyExts.size();
        int batchSize = size / 10;
        if (batchSize < 1) {
            batchSize = 1;
        }
        BUser user = cx != null && cx.getUser() != null ? cx.getUser() : null;
        int numCompleted = 0;
        int numFailed = 0;
        int numSkipped = 0;
        Exception lastFailure = null;
        try {
            for (int i = 0; i < size; ++i) {
                if (i % batchSize == 0) {
                    this.progress((int)((double)i / (double)size * 100.0));
                }
                BNiagaraProxyExt ext = proxyExts.get(i);
                try {
                    BStatus extStatus;
                    if (user != null) {
                        user.checkInvoke((BComponent)ext, (Slot)BNiagaraProxyExt.forceUpdate);
                    }
                    if ((extStatus = ext.getStatus()).isDown() || extStatus.isDisabled() || extStatus.isFault()) {
                        ++numSkipped;
                        this.log().message("niagaraDriver", "forceUpdateNiagaraPoints.skipUnoperational", new String[]{tab, ext.toDisplayPathString(cx), '{' + extStatus.flagsToString(cx) + '}'});
                        continue;
                    }
                    this.log().start("niagaraDriver", "forceUpdateNiagaraPoints.invokeOnProxy", new String[]{tab, ext.toDisplayPathString(cx)});
                    ext.doForceUpdate(cx);
                    ++numCompleted;
                    this.log().endSuccess("baja", "success", null);
                }
                catch (PermissionException extStatus) {
                }
                catch (Exception e) {
                    ++numFailed;
                    lastFailure = e;
                    this.log().endFailed("baja", "failed", null, (Throwable)e);
                }
                if (this.getJobState() != BJobState.canceling) continue;
                throw new JobCancelException();
            }
            this.log().message("niagaraDriver", "forceUpdateNiagaraPoints.endJob", pathArg);
            if (lastFailure != null) {
                throw lastFailure;
            }
        }
        catch (Throwable throwable) {
            this.log().message("niagaraDriver", "forceUpdateNiagaraPoints.stats", new String[]{Integer.toString(numCompleted), Integer.toString(numSkipped), Integer.toString(numFailed), path});
            throw throwable;
        }
        this.log().message("niagaraDriver", "forceUpdateNiagaraPoints.stats", new String[]{Integer.toString(numCompleted), Integer.toString(numSkipped), Integer.toString(numFailed), path});
    }

    public String toString(Context cx) {
        String desc = this.getContainerDescription();
        if (desc.isEmpty()) {
            return super.toString(cx);
        }
        return super.toString(cx) + " - " + desc;
    }

    public BIcon getIcon() {
        return icon;
    }
}

