/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nd.history;

import com.tridium.driver.util.DrUtil;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.history.RecordInputCursor;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.nd.BNiagaraEdgeLiteStation;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.history.BNiagaraHistoryDeviceExt;
import com.tridium.sys.metrics.BISubLicenseable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.baja.driver.BDevice;
import javax.baja.driver.history.BHistoryImport;
import javax.baja.driver.util.BDescriptorState;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryQuery;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
public class BNiagaraHistoryImport
extends BHistoryImport
implements BFoxClientConnection.Interest,
BISubLicenseable {
    @Generated
    public static final Type TYPE = Sys.loadType(BNiagaraHistoryImport.class);
    final AtomicBoolean executeInProgress = new AtomicBoolean(false);

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected IFuture postExecute(Action action, BValue arg, Context cx) {
        if (execute == action && syncHistoryPoll == cx) {
            this.doExecute();
            return null;
        }
        BNiagaraStation station = (BNiagaraStation)this.getDevice();
        if (station != null) {
            station.getWorker().postAsync((Runnable)new Invocation((BComponent)this, action, arg, cx));
        }
        return null;
    }

    public boolean isUnoperational() {
        return this.isFatalFault() || this.isDisabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute() {
        if (this.executeInProgress.getAndSet(true)) {
            if (this.getState() == BDescriptorState.pending) {
                this.setState(BDescriptorState.idle);
            }
            return;
        }
        try {
            BHistoryDatabase db;
            BNiagaraHistoryDeviceExt devicelet;
            block34: {
                block33: {
                    this.executeInProgress();
                    devicelet = (BNiagaraHistoryDeviceExt)this.getDeviceExt();
                    try {
                        devicelet.getClientConnection().engageNoRetry((BFoxClientConnection.Interest)this);
                    }
                    catch (Exception e) {
                        this.executeFail(e);
                        if (devicelet.getClientConnection().isEngaged((BFoxClientConnection.Interest)this)) {
                            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                        }
                        this.executeInProgress.set(false);
                        return;
                    }
                    if (!this.getHistoryId().isNull()) break block33;
                    this.executeFail("History id is null.");
                    devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    return;
                }
                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                db = service.getDatabase();
                if (db != null) break block34;
                this.executeFail("Local history database not available.");
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                return;
            }
            try {
                BHistoryChannel channel = devicelet.getClientHistoryChannel();
                BHistoryId id = this.getHistoryId().fromShorthand(this.getDevice().getName());
                BHistoryConfig config = this.makeLocalConfig(channel.getConfig(id));
                try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                    if (!conn.exists(id)) {
                        conn.createHistory(config);
                    } else {
                        conn.reconfigureHistory(config);
                    }
                    BIHistory history = conn.getHistory(id);
                    BAbsTime lastTimestamp = conn.getLastTimestamp(history);
                    BAbsTime startTime = lastTimestamp.add(BRelTime.make((long)1L));
                    Cursor c = channel.timeQuery(id, startTime, null, this.getOnDemandPollEnabled() && this.updateHistorySubscriptionCount(0) > 0, HistoryQuery.makeExcludeArchiveDataContext(null));
                    ((RecordInputCursor)c).setHistoryVersion(this.getHistoryVersion());
                    while (c.next()) {
                        BHistoryRecord rec = (BHistoryRecord)c.get();
                        rec.setHistoryVersion(2);
                        conn.append(history, (BIHistoryRecordSet)rec);
                    }
                }
                this.executeOk();
            }
            catch (Exception e) {
                try {
                    this.executeFail(e);
                }
                catch (Throwable throwable) {
                    devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                    throw throwable;
                }
                devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
                this.executeInProgress.set(false);
                return;
            }
            devicelet.getClientConnection().disengage((BFoxClientConnection.Interest)this);
        }
        finally {
            this.executeInProgress.set(false);
        }
    }

    protected int getHistoryVersion() {
        BNiagaraStation ns = (BNiagaraStation)DrUtil.getParent((BComplex)this, (Type)BNiagaraStation.TYPE);
        return ns.getVersion().startsWith("3") ? 1 : 2;
    }

    public final String getLicenseKeyPrefix() {
        BDevice parentDevice = null;
        try {
            parentDevice = this.getDevice();
        }
        catch (Exception e) {
            parentDevice = (BDevice)DrUtil.getParent((BComplex)this, (Type)BDevice.TYPE);
        }
        if (BISubLicenseable.isSubLicenseable((BObject)parentDevice)) {
            if (parentDevice instanceof BNiagaraEdgeLiteStation) {
                return "edgeLite1";
            }
            return ((BISubLicenseable)parentDevice).getLicenseKeyPrefix();
        }
        return null;
    }
}

